// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.

// <auto-generated/>

#nullable disable

using System;
using System.ComponentModel;

namespace Azure.ResourceManager.DeviceUpdate.Models
{
    /// <summary> Authentication Type. </summary>
    public readonly partial struct DiagnosticStorageAuthenticationType : IEquatable<DiagnosticStorageAuthenticationType>
    {
        private readonly string _value;

        /// <summary> Initializes a new instance of <see cref="DiagnosticStorageAuthenticationType"/>. </summary>
        /// <exception cref="ArgumentNullException"> <paramref name="value"/> is null. </exception>
        public DiagnosticStorageAuthenticationType(string value)
        {
            _value = value ?? throw new ArgumentNullException(nameof(value));
        }

        private const string KeyBasedValue = "KeyBased";

        /// <summary> KeyBased. </summary>
        public static DiagnosticStorageAuthenticationType KeyBased { get; } = new DiagnosticStorageAuthenticationType(KeyBasedValue);
        /// <summary> Determines if two <see cref="DiagnosticStorageAuthenticationType"/> values are the same. </summary>
        public static bool operator ==(DiagnosticStorageAuthenticationType left, DiagnosticStorageAuthenticationType right) => left.Equals(right);
        /// <summary> Determines if two <see cref="DiagnosticStorageAuthenticationType"/> values are not the same. </summary>
        public static bool operator !=(DiagnosticStorageAuthenticationType left, DiagnosticStorageAuthenticationType right) => !left.Equals(right);
        /// <summary> Converts a <see cref="string"/> to a <see cref="DiagnosticStorageAuthenticationType"/>. </summary>
        public static implicit operator DiagnosticStorageAuthenticationType(string value) => new DiagnosticStorageAuthenticationType(value);

        /// <inheritdoc />
        [EditorBrowsable(EditorBrowsableState.Never)]
        public override bool Equals(object obj) => obj is DiagnosticStorageAuthenticationType other && Equals(other);
        /// <inheritdoc />
        public bool Equals(DiagnosticStorageAuthenticationType other) => string.Equals(_value, other._value, StringComparison.InvariantCultureIgnoreCase);

        /// <inheritdoc />
        [EditorBrowsable(EditorBrowsableState.Never)]
        public override int GetHashCode() => _value != null ? StringComparer.InvariantCultureIgnoreCase.GetHashCode(_value) : 0;
        /// <inheritdoc />
        public override string ToString() => _value;
    }
}
