// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.

// <auto-generated/>

#nullable disable

using System;
using System.ComponentModel;

namespace Azure.ResourceManager.DeviceUpdate.Models
{
    /// <summary> Device Update Sku. </summary>
    public readonly partial struct DeviceUpdateSku : IEquatable<DeviceUpdateSku>
    {
        private readonly string _value;

        /// <summary> Initializes a new instance of <see cref="DeviceUpdateSku"/>. </summary>
        /// <exception cref="ArgumentNullException"> <paramref name="value"/> is null. </exception>
        public DeviceUpdateSku(string value)
        {
            _value = value ?? throw new ArgumentNullException(nameof(value));
        }

        private const string FreeValue = "Free";
        private const string StandardValue = "Standard";

        /// <summary> Free. </summary>
        public static DeviceUpdateSku Free { get; } = new DeviceUpdateSku(FreeValue);
        /// <summary> Standard. </summary>
        public static DeviceUpdateSku Standard { get; } = new DeviceUpdateSku(StandardValue);
        /// <summary> Determines if two <see cref="DeviceUpdateSku"/> values are the same. </summary>
        public static bool operator ==(DeviceUpdateSku left, DeviceUpdateSku right) => left.Equals(right);
        /// <summary> Determines if two <see cref="DeviceUpdateSku"/> values are not the same. </summary>
        public static bool operator !=(DeviceUpdateSku left, DeviceUpdateSku right) => !left.Equals(right);
        /// <summary> Converts a <see cref="string"/> to a <see cref="DeviceUpdateSku"/>. </summary>
        public static implicit operator DeviceUpdateSku(string value) => new DeviceUpdateSku(value);

        /// <inheritdoc />
        [EditorBrowsable(EditorBrowsableState.Never)]
        public override bool Equals(object obj) => obj is DeviceUpdateSku other && Equals(other);
        /// <inheritdoc />
        public bool Equals(DeviceUpdateSku other) => string.Equals(_value, other._value, StringComparison.InvariantCultureIgnoreCase);

        /// <inheritdoc />
        [EditorBrowsable(EditorBrowsableState.Never)]
        public override int GetHashCode() => _value != null ? StringComparer.InvariantCultureIgnoreCase.GetHashCode(_value) : 0;
        /// <inheritdoc />
        public override string ToString() => _value;
    }
}
