// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.

// <auto-generated/>

#nullable disable

using System;
using System.Collections.Generic;
using Azure.Core;

namespace Azure.ResourceManager.DeviceUpdate.Models
{
    /// <summary> Remote private endpoint details. </summary>
    public partial class DeviceUpdateRemotePrivateEndpoint
    {
        /// <summary>
        /// Keeps track of any properties unknown to the library.
        /// <para>
        /// To assign an object to the value of this property use <see cref="BinaryData.FromObjectAsJson{T}(T, System.Text.Json.JsonSerializerOptions?)"/>.
        /// </para>
        /// <para>
        /// To assign an already formatted json string to this property use <see cref="BinaryData.FromString(string)"/>.
        /// </para>
        /// <para>
        /// Examples:
        /// <list type="bullet">
        /// <item>
        /// <term>BinaryData.FromObjectAsJson("foo")</term>
        /// <description>Creates a payload of "foo".</description>
        /// </item>
        /// <item>
        /// <term>BinaryData.FromString("\"foo\"")</term>
        /// <description>Creates a payload of "foo".</description>
        /// </item>
        /// <item>
        /// <term>BinaryData.FromObjectAsJson(new { key = "value" })</term>
        /// <description>Creates a payload of { "key": "value" }.</description>
        /// </item>
        /// <item>
        /// <term>BinaryData.FromString("{\"key\": \"value\"}")</term>
        /// <description>Creates a payload of { "key": "value" }.</description>
        /// </item>
        /// </list>
        /// </para>
        /// </summary>
        private IDictionary<string, BinaryData> _serializedAdditionalRawData;

        /// <summary> Initializes a new instance of <see cref="DeviceUpdateRemotePrivateEndpoint"/>. </summary>
        public DeviceUpdateRemotePrivateEndpoint()
        {
            ManualPrivateLinkServiceConnections = new ChangeTrackingList<DeviceUpdatePrivateLinkServiceConnection>();
            PrivateLinkServiceConnections = new ChangeTrackingList<DeviceUpdatePrivateLinkServiceConnection>();
            PrivateLinkServiceProxies = new ChangeTrackingList<DeviceUpdatePrivateLinkServiceProxy>();
            ConnectionDetails = new ChangeTrackingList<DeviceUpdatePrivateEndpointConnectionDetails>();
        }

        /// <summary> Initializes a new instance of <see cref="DeviceUpdateRemotePrivateEndpoint"/>. </summary>
        /// <param name="id"> Remote endpoint resource ID. </param>
        /// <param name="location"> ARM location of the remote private endpoint. </param>
        /// <param name="immutableSubscriptionId"> Original subscription ID needed by Microsoft.Network. </param>
        /// <param name="immutableResourceId"> Original resource ID needed by Microsoft.Network. </param>
        /// <param name="vnetTrafficTag"> Virtual network traffic tag. </param>
        /// <param name="manualPrivateLinkServiceConnections"> List of private link service connections that need manual approval. </param>
        /// <param name="privateLinkServiceConnections"> List of automatically approved private link service connections. </param>
        /// <param name="privateLinkServiceProxies"> List of private link service proxies. </param>
        /// <param name="connectionDetails"> List of connection details. </param>
        /// <param name="serializedAdditionalRawData"> Keeps track of any properties unknown to the library. </param>
        internal DeviceUpdateRemotePrivateEndpoint(ResourceIdentifier id, AzureLocation? location, string immutableSubscriptionId, ResourceIdentifier immutableResourceId, string vnetTrafficTag, IList<DeviceUpdatePrivateLinkServiceConnection> manualPrivateLinkServiceConnections, IList<DeviceUpdatePrivateLinkServiceConnection> privateLinkServiceConnections, IList<DeviceUpdatePrivateLinkServiceProxy> privateLinkServiceProxies, IList<DeviceUpdatePrivateEndpointConnectionDetails> connectionDetails, IDictionary<string, BinaryData> serializedAdditionalRawData)
        {
            Id = id;
            Location = location;
            ImmutableSubscriptionId = immutableSubscriptionId;
            ImmutableResourceId = immutableResourceId;
            VnetTrafficTag = vnetTrafficTag;
            ManualPrivateLinkServiceConnections = manualPrivateLinkServiceConnections;
            PrivateLinkServiceConnections = privateLinkServiceConnections;
            PrivateLinkServiceProxies = privateLinkServiceProxies;
            ConnectionDetails = connectionDetails;
            _serializedAdditionalRawData = serializedAdditionalRawData;
        }

        /// <summary> Remote endpoint resource ID. </summary>
        public ResourceIdentifier Id { get; set; }
        /// <summary> ARM location of the remote private endpoint. </summary>
        public AzureLocation? Location { get; set; }
        /// <summary> Original subscription ID needed by Microsoft.Network. </summary>
        public string ImmutableSubscriptionId { get; set; }
        /// <summary> Original resource ID needed by Microsoft.Network. </summary>
        public ResourceIdentifier ImmutableResourceId { get; set; }
        /// <summary> Virtual network traffic tag. </summary>
        public string VnetTrafficTag { get; set; }
        /// <summary> List of private link service connections that need manual approval. </summary>
        public IList<DeviceUpdatePrivateLinkServiceConnection> ManualPrivateLinkServiceConnections { get; }
        /// <summary> List of automatically approved private link service connections. </summary>
        public IList<DeviceUpdatePrivateLinkServiceConnection> PrivateLinkServiceConnections { get; }
        /// <summary> List of private link service proxies. </summary>
        public IList<DeviceUpdatePrivateLinkServiceProxy> PrivateLinkServiceProxies { get; }
        /// <summary> List of connection details. </summary>
        public IList<DeviceUpdatePrivateEndpointConnectionDetails> ConnectionDetails { get; }
    }
}
