// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.

// <auto-generated/>

#nullable disable

using System;
using System.ComponentModel;

namespace Azure.ResourceManager.DeviceUpdate.Models
{
    /// <summary> Whether or not public network access is allowed for the account. </summary>
    public readonly partial struct DeviceUpdatePublicNetworkAccess : IEquatable<DeviceUpdatePublicNetworkAccess>
    {
        private readonly string _value;

        /// <summary> Initializes a new instance of <see cref="DeviceUpdatePublicNetworkAccess"/>. </summary>
        /// <exception cref="ArgumentNullException"> <paramref name="value"/> is null. </exception>
        public DeviceUpdatePublicNetworkAccess(string value)
        {
            _value = value ?? throw new ArgumentNullException(nameof(value));
        }

        private const string EnabledValue = "Enabled";
        private const string DisabledValue = "Disabled";

        /// <summary> Enabled. </summary>
        public static DeviceUpdatePublicNetworkAccess Enabled { get; } = new DeviceUpdatePublicNetworkAccess(EnabledValue);
        /// <summary> Disabled. </summary>
        public static DeviceUpdatePublicNetworkAccess Disabled { get; } = new DeviceUpdatePublicNetworkAccess(DisabledValue);
        /// <summary> Determines if two <see cref="DeviceUpdatePublicNetworkAccess"/> values are the same. </summary>
        public static bool operator ==(DeviceUpdatePublicNetworkAccess left, DeviceUpdatePublicNetworkAccess right) => left.Equals(right);
        /// <summary> Determines if two <see cref="DeviceUpdatePublicNetworkAccess"/> values are not the same. </summary>
        public static bool operator !=(DeviceUpdatePublicNetworkAccess left, DeviceUpdatePublicNetworkAccess right) => !left.Equals(right);
        /// <summary> Converts a <see cref="string"/> to a <see cref="DeviceUpdatePublicNetworkAccess"/>. </summary>
        public static implicit operator DeviceUpdatePublicNetworkAccess(string value) => new DeviceUpdatePublicNetworkAccess(value);

        /// <inheritdoc />
        [EditorBrowsable(EditorBrowsableState.Never)]
        public override bool Equals(object obj) => obj is DeviceUpdatePublicNetworkAccess other && Equals(other);
        /// <inheritdoc />
        public bool Equals(DeviceUpdatePublicNetworkAccess other) => string.Equals(_value, other._value, StringComparison.InvariantCultureIgnoreCase);

        /// <inheritdoc />
        [EditorBrowsable(EditorBrowsableState.Never)]
        public override int GetHashCode() => _value != null ? StringComparer.InvariantCultureIgnoreCase.GetHashCode(_value) : 0;
        /// <inheritdoc />
        public override string ToString() => _value;
    }
}
