// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.

// <auto-generated/>

#nullable disable

using System;
using System.ComponentModel;

namespace Azure.ResourceManager.DeviceUpdate.Models
{
    /// <summary> Provisioning state. </summary>
    public readonly partial struct DeviceUpdateProvisioningState : IEquatable<DeviceUpdateProvisioningState>
    {
        private readonly string _value;

        /// <summary> Initializes a new instance of <see cref="DeviceUpdateProvisioningState"/>. </summary>
        /// <exception cref="ArgumentNullException"> <paramref name="value"/> is null. </exception>
        public DeviceUpdateProvisioningState(string value)
        {
            _value = value ?? throw new ArgumentNullException(nameof(value));
        }

        private const string SucceededValue = "Succeeded";
        private const string DeletedValue = "Deleted";
        private const string FailedValue = "Failed";
        private const string CanceledValue = "Canceled";
        private const string AcceptedValue = "Accepted";
        private const string CreatingValue = "Creating";

        /// <summary> Succeeded. </summary>
        public static DeviceUpdateProvisioningState Succeeded { get; } = new DeviceUpdateProvisioningState(SucceededValue);
        /// <summary> Deleted. </summary>
        public static DeviceUpdateProvisioningState Deleted { get; } = new DeviceUpdateProvisioningState(DeletedValue);
        /// <summary> Failed. </summary>
        public static DeviceUpdateProvisioningState Failed { get; } = new DeviceUpdateProvisioningState(FailedValue);
        /// <summary> Canceled. </summary>
        public static DeviceUpdateProvisioningState Canceled { get; } = new DeviceUpdateProvisioningState(CanceledValue);
        /// <summary> Accepted. </summary>
        public static DeviceUpdateProvisioningState Accepted { get; } = new DeviceUpdateProvisioningState(AcceptedValue);
        /// <summary> Creating. </summary>
        public static DeviceUpdateProvisioningState Creating { get; } = new DeviceUpdateProvisioningState(CreatingValue);
        /// <summary> Determines if two <see cref="DeviceUpdateProvisioningState"/> values are the same. </summary>
        public static bool operator ==(DeviceUpdateProvisioningState left, DeviceUpdateProvisioningState right) => left.Equals(right);
        /// <summary> Determines if two <see cref="DeviceUpdateProvisioningState"/> values are not the same. </summary>
        public static bool operator !=(DeviceUpdateProvisioningState left, DeviceUpdateProvisioningState right) => !left.Equals(right);
        /// <summary> Converts a <see cref="string"/> to a <see cref="DeviceUpdateProvisioningState"/>. </summary>
        public static implicit operator DeviceUpdateProvisioningState(string value) => new DeviceUpdateProvisioningState(value);

        /// <inheritdoc />
        [EditorBrowsable(EditorBrowsableState.Never)]
        public override bool Equals(object obj) => obj is DeviceUpdateProvisioningState other && Equals(other);
        /// <inheritdoc />
        public bool Equals(DeviceUpdateProvisioningState other) => string.Equals(_value, other._value, StringComparison.InvariantCultureIgnoreCase);

        /// <inheritdoc />
        [EditorBrowsable(EditorBrowsableState.Never)]
        public override int GetHashCode() => _value != null ? StringComparer.InvariantCultureIgnoreCase.GetHashCode(_value) : 0;
        /// <inheritdoc />
        public override string ToString() => _value;
    }
}
