// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.

// <auto-generated/>

#nullable disable

using System;
using System.ComponentModel;

namespace Azure.ResourceManager.DeviceUpdate.Models
{
    /// <summary> The provisioning state of private link group ID. </summary>
    public readonly partial struct DeviceUpdatePrivateLinkProvisioningState : IEquatable<DeviceUpdatePrivateLinkProvisioningState>
    {
        private readonly string _value;

        /// <summary> Initializes a new instance of <see cref="DeviceUpdatePrivateLinkProvisioningState"/>. </summary>
        /// <exception cref="ArgumentNullException"> <paramref name="value"/> is null. </exception>
        public DeviceUpdatePrivateLinkProvisioningState(string value)
        {
            _value = value ?? throw new ArgumentNullException(nameof(value));
        }

        private const string SucceededValue = "Succeeded";
        private const string FailedValue = "Failed";
        private const string CanceledValue = "Canceled";

        /// <summary> Succeeded. </summary>
        public static DeviceUpdatePrivateLinkProvisioningState Succeeded { get; } = new DeviceUpdatePrivateLinkProvisioningState(SucceededValue);
        /// <summary> Failed. </summary>
        public static DeviceUpdatePrivateLinkProvisioningState Failed { get; } = new DeviceUpdatePrivateLinkProvisioningState(FailedValue);
        /// <summary> Canceled. </summary>
        public static DeviceUpdatePrivateLinkProvisioningState Canceled { get; } = new DeviceUpdatePrivateLinkProvisioningState(CanceledValue);
        /// <summary> Determines if two <see cref="DeviceUpdatePrivateLinkProvisioningState"/> values are the same. </summary>
        public static bool operator ==(DeviceUpdatePrivateLinkProvisioningState left, DeviceUpdatePrivateLinkProvisioningState right) => left.Equals(right);
        /// <summary> Determines if two <see cref="DeviceUpdatePrivateLinkProvisioningState"/> values are not the same. </summary>
        public static bool operator !=(DeviceUpdatePrivateLinkProvisioningState left, DeviceUpdatePrivateLinkProvisioningState right) => !left.Equals(right);
        /// <summary> Converts a <see cref="string"/> to a <see cref="DeviceUpdatePrivateLinkProvisioningState"/>. </summary>
        public static implicit operator DeviceUpdatePrivateLinkProvisioningState(string value) => new DeviceUpdatePrivateLinkProvisioningState(value);

        /// <inheritdoc />
        [EditorBrowsable(EditorBrowsableState.Never)]
        public override bool Equals(object obj) => obj is DeviceUpdatePrivateLinkProvisioningState other && Equals(other);
        /// <inheritdoc />
        public bool Equals(DeviceUpdatePrivateLinkProvisioningState other) => string.Equals(_value, other._value, StringComparison.InvariantCultureIgnoreCase);

        /// <inheritdoc />
        [EditorBrowsable(EditorBrowsableState.Never)]
        public override int GetHashCode() => _value != null ? StringComparer.InvariantCultureIgnoreCase.GetHashCode(_value) : 0;
        /// <inheritdoc />
        public override string ToString() => _value;
    }
}
