// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.

// <auto-generated/>

#nullable disable

using System;
using System.ComponentModel;

namespace Azure.ResourceManager.DeviceUpdate.Models
{
    /// <summary> The private endpoint connection status. </summary>
    public readonly partial struct DeviceUpdatePrivateEndpointServiceConnectionStatus : IEquatable<DeviceUpdatePrivateEndpointServiceConnectionStatus>
    {
        private readonly string _value;

        /// <summary> Initializes a new instance of <see cref="DeviceUpdatePrivateEndpointServiceConnectionStatus"/>. </summary>
        /// <exception cref="ArgumentNullException"> <paramref name="value"/> is null. </exception>
        public DeviceUpdatePrivateEndpointServiceConnectionStatus(string value)
        {
            _value = value ?? throw new ArgumentNullException(nameof(value));
        }

        private const string PendingValue = "Pending";
        private const string ApprovedValue = "Approved";
        private const string RejectedValue = "Rejected";

        /// <summary> Pending. </summary>
        public static DeviceUpdatePrivateEndpointServiceConnectionStatus Pending { get; } = new DeviceUpdatePrivateEndpointServiceConnectionStatus(PendingValue);
        /// <summary> Approved. </summary>
        public static DeviceUpdatePrivateEndpointServiceConnectionStatus Approved { get; } = new DeviceUpdatePrivateEndpointServiceConnectionStatus(ApprovedValue);
        /// <summary> Rejected. </summary>
        public static DeviceUpdatePrivateEndpointServiceConnectionStatus Rejected { get; } = new DeviceUpdatePrivateEndpointServiceConnectionStatus(RejectedValue);
        /// <summary> Determines if two <see cref="DeviceUpdatePrivateEndpointServiceConnectionStatus"/> values are the same. </summary>
        public static bool operator ==(DeviceUpdatePrivateEndpointServiceConnectionStatus left, DeviceUpdatePrivateEndpointServiceConnectionStatus right) => left.Equals(right);
        /// <summary> Determines if two <see cref="DeviceUpdatePrivateEndpointServiceConnectionStatus"/> values are not the same. </summary>
        public static bool operator !=(DeviceUpdatePrivateEndpointServiceConnectionStatus left, DeviceUpdatePrivateEndpointServiceConnectionStatus right) => !left.Equals(right);
        /// <summary> Converts a <see cref="string"/> to a <see cref="DeviceUpdatePrivateEndpointServiceConnectionStatus"/>. </summary>
        public static implicit operator DeviceUpdatePrivateEndpointServiceConnectionStatus(string value) => new DeviceUpdatePrivateEndpointServiceConnectionStatus(value);

        /// <inheritdoc />
        [EditorBrowsable(EditorBrowsableState.Never)]
        public override bool Equals(object obj) => obj is DeviceUpdatePrivateEndpointServiceConnectionStatus other && Equals(other);
        /// <inheritdoc />
        public bool Equals(DeviceUpdatePrivateEndpointServiceConnectionStatus other) => string.Equals(_value, other._value, StringComparison.InvariantCultureIgnoreCase);

        /// <inheritdoc />
        [EditorBrowsable(EditorBrowsableState.Never)]
        public override int GetHashCode() => _value != null ? StringComparer.InvariantCultureIgnoreCase.GetHashCode(_value) : 0;
        /// <inheritdoc />
        public override string ToString() => _value;
    }
}
