// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.

// <auto-generated/>

#nullable disable

using System;
using System.ComponentModel;

namespace Azure.ResourceManager.DeviceUpdate.Models
{
    /// <summary> The current provisioning state. </summary>
    public readonly partial struct DeviceUpdatePrivateEndpointConnectionProxyProvisioningState : IEquatable<DeviceUpdatePrivateEndpointConnectionProxyProvisioningState>
    {
        private readonly string _value;

        /// <summary> Initializes a new instance of <see cref="DeviceUpdatePrivateEndpointConnectionProxyProvisioningState"/>. </summary>
        /// <exception cref="ArgumentNullException"> <paramref name="value"/> is null. </exception>
        public DeviceUpdatePrivateEndpointConnectionProxyProvisioningState(string value)
        {
            _value = value ?? throw new ArgumentNullException(nameof(value));
        }

        private const string SucceededValue = "Succeeded";
        private const string CreatingValue = "Creating";
        private const string DeletingValue = "Deleting";
        private const string FailedValue = "Failed";

        /// <summary> Succeeded. </summary>
        public static DeviceUpdatePrivateEndpointConnectionProxyProvisioningState Succeeded { get; } = new DeviceUpdatePrivateEndpointConnectionProxyProvisioningState(SucceededValue);
        /// <summary> Creating. </summary>
        public static DeviceUpdatePrivateEndpointConnectionProxyProvisioningState Creating { get; } = new DeviceUpdatePrivateEndpointConnectionProxyProvisioningState(CreatingValue);
        /// <summary> Deleting. </summary>
        public static DeviceUpdatePrivateEndpointConnectionProxyProvisioningState Deleting { get; } = new DeviceUpdatePrivateEndpointConnectionProxyProvisioningState(DeletingValue);
        /// <summary> Failed. </summary>
        public static DeviceUpdatePrivateEndpointConnectionProxyProvisioningState Failed { get; } = new DeviceUpdatePrivateEndpointConnectionProxyProvisioningState(FailedValue);
        /// <summary> Determines if two <see cref="DeviceUpdatePrivateEndpointConnectionProxyProvisioningState"/> values are the same. </summary>
        public static bool operator ==(DeviceUpdatePrivateEndpointConnectionProxyProvisioningState left, DeviceUpdatePrivateEndpointConnectionProxyProvisioningState right) => left.Equals(right);
        /// <summary> Determines if two <see cref="DeviceUpdatePrivateEndpointConnectionProxyProvisioningState"/> values are not the same. </summary>
        public static bool operator !=(DeviceUpdatePrivateEndpointConnectionProxyProvisioningState left, DeviceUpdatePrivateEndpointConnectionProxyProvisioningState right) => !left.Equals(right);
        /// <summary> Converts a <see cref="string"/> to a <see cref="DeviceUpdatePrivateEndpointConnectionProxyProvisioningState"/>. </summary>
        public static implicit operator DeviceUpdatePrivateEndpointConnectionProxyProvisioningState(string value) => new DeviceUpdatePrivateEndpointConnectionProxyProvisioningState(value);

        /// <inheritdoc />
        [EditorBrowsable(EditorBrowsableState.Never)]
        public override bool Equals(object obj) => obj is DeviceUpdatePrivateEndpointConnectionProxyProvisioningState other && Equals(other);
        /// <inheritdoc />
        public bool Equals(DeviceUpdatePrivateEndpointConnectionProxyProvisioningState other) => string.Equals(_value, other._value, StringComparison.InvariantCultureIgnoreCase);

        /// <inheritdoc />
        [EditorBrowsable(EditorBrowsableState.Never)]
        public override int GetHashCode() => _value != null ? StringComparer.InvariantCultureIgnoreCase.GetHashCode(_value) : 0;
        /// <inheritdoc />
        public override string ToString() => _value;
    }
}
