// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.

// <auto-generated/>

#nullable disable

using System;
using System.Collections.Generic;
using Azure.Core;

namespace Azure.ResourceManager.DeviceUpdate.Models
{
    /// <summary> The CMK encryption settings on the Device Update account. </summary>
    public partial class DeviceUpdateEncryption
    {
        /// <summary>
        /// Keeps track of any properties unknown to the library.
        /// <para>
        /// To assign an object to the value of this property use <see cref="BinaryData.FromObjectAsJson{T}(T, System.Text.Json.JsonSerializerOptions?)"/>.
        /// </para>
        /// <para>
        /// To assign an already formatted json string to this property use <see cref="BinaryData.FromString(string)"/>.
        /// </para>
        /// <para>
        /// Examples:
        /// <list type="bullet">
        /// <item>
        /// <term>BinaryData.FromObjectAsJson("foo")</term>
        /// <description>Creates a payload of "foo".</description>
        /// </item>
        /// <item>
        /// <term>BinaryData.FromString("\"foo\"")</term>
        /// <description>Creates a payload of "foo".</description>
        /// </item>
        /// <item>
        /// <term>BinaryData.FromObjectAsJson(new { key = "value" })</term>
        /// <description>Creates a payload of { "key": "value" }.</description>
        /// </item>
        /// <item>
        /// <term>BinaryData.FromString("{\"key\": \"value\"}")</term>
        /// <description>Creates a payload of { "key": "value" }.</description>
        /// </item>
        /// </list>
        /// </para>
        /// </summary>
        private IDictionary<string, BinaryData> _serializedAdditionalRawData;

        /// <summary> Initializes a new instance of <see cref="DeviceUpdateEncryption"/>. </summary>
        public DeviceUpdateEncryption()
        {
        }

        /// <summary> Initializes a new instance of <see cref="DeviceUpdateEncryption"/>. </summary>
        /// <param name="keyVaultKeyUri"> The URI of the key vault. </param>
        /// <param name="userAssignedIdentity"> The full resourceId of the user assigned identity to be used for key vault access. Identity has to be also assigned to the Account. </param>
        /// <param name="serializedAdditionalRawData"> Keeps track of any properties unknown to the library. </param>
        internal DeviceUpdateEncryption(Uri keyVaultKeyUri, ResourceIdentifier userAssignedIdentity, IDictionary<string, BinaryData> serializedAdditionalRawData)
        {
            KeyVaultKeyUri = keyVaultKeyUri;
            UserAssignedIdentity = userAssignedIdentity;
            _serializedAdditionalRawData = serializedAdditionalRawData;
        }

        /// <summary> The URI of the key vault. </summary>
        public Uri KeyVaultKeyUri { get; set; }
        /// <summary> The full resourceId of the user assigned identity to be used for key vault access. Identity has to be also assigned to the Account. </summary>
        public ResourceIdentifier UserAssignedIdentity { get; set; }
    }
}
