// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.

// <auto-generated/>

#nullable disable

using System.Text.Json;
using System.Threading;
using System.Threading.Tasks;
using Azure.Core;

namespace Azure.ResourceManager.DeviceUpdate
{
    internal class DeviceUpdatePrivateEndpointConnectionProxyOperationSource : IOperationSource<DeviceUpdatePrivateEndpointConnectionProxyResource>
    {
        private readonly ArmClient _client;

        internal DeviceUpdatePrivateEndpointConnectionProxyOperationSource(ArmClient client)
        {
            _client = client;
        }

        DeviceUpdatePrivateEndpointConnectionProxyResource IOperationSource<DeviceUpdatePrivateEndpointConnectionProxyResource>.CreateResult(Response response, CancellationToken cancellationToken)
        {
            using var document = JsonDocument.Parse(response.ContentStream);
            var data = DeviceUpdatePrivateEndpointConnectionProxyData.DeserializeDeviceUpdatePrivateEndpointConnectionProxyData(document.RootElement);
            return new DeviceUpdatePrivateEndpointConnectionProxyResource(_client, data);
        }

        async ValueTask<DeviceUpdatePrivateEndpointConnectionProxyResource> IOperationSource<DeviceUpdatePrivateEndpointConnectionProxyResource>.CreateResultAsync(Response response, CancellationToken cancellationToken)
        {
            using var document = await JsonDocument.ParseAsync(response.ContentStream, default, cancellationToken).ConfigureAwait(false);
            var data = DeviceUpdatePrivateEndpointConnectionProxyData.DeserializeDeviceUpdatePrivateEndpointConnectionProxyData(document.RootElement);
            return new DeviceUpdatePrivateEndpointConnectionProxyResource(_client, data);
        }
    }
}
