// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.

// <auto-generated/>

#nullable disable

using System.Text.Json;
using System.Threading;
using System.Threading.Tasks;
using Azure.Core;

namespace Azure.ResourceManager.DeviceUpdate
{
    internal class DeviceUpdatePrivateEndpointConnectionOperationSource : IOperationSource<DeviceUpdatePrivateEndpointConnectionResource>
    {
        private readonly ArmClient _client;

        internal DeviceUpdatePrivateEndpointConnectionOperationSource(ArmClient client)
        {
            _client = client;
        }

        DeviceUpdatePrivateEndpointConnectionResource IOperationSource<DeviceUpdatePrivateEndpointConnectionResource>.CreateResult(Response response, CancellationToken cancellationToken)
        {
            using var document = JsonDocument.Parse(response.ContentStream);
            var data = DeviceUpdatePrivateEndpointConnectionData.DeserializeDeviceUpdatePrivateEndpointConnectionData(document.RootElement);
            return new DeviceUpdatePrivateEndpointConnectionResource(_client, data);
        }

        async ValueTask<DeviceUpdatePrivateEndpointConnectionResource> IOperationSource<DeviceUpdatePrivateEndpointConnectionResource>.CreateResultAsync(Response response, CancellationToken cancellationToken)
        {
            using var document = await JsonDocument.ParseAsync(response.ContentStream, default, cancellationToken).ConfigureAwait(false);
            var data = DeviceUpdatePrivateEndpointConnectionData.DeserializeDeviceUpdatePrivateEndpointConnectionData(document.RootElement);
            return new DeviceUpdatePrivateEndpointConnectionResource(_client, data);
        }
    }
}
