// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.

// <auto-generated/>

#nullable disable

using System.Text.Json;
using System.Threading;
using System.Threading.Tasks;
using Azure.Core;

namespace Azure.ResourceManager.DeviceUpdate
{
    internal class DeviceUpdateInstanceOperationSource : IOperationSource<DeviceUpdateInstanceResource>
    {
        private readonly ArmClient _client;

        internal DeviceUpdateInstanceOperationSource(ArmClient client)
        {
            _client = client;
        }

        DeviceUpdateInstanceResource IOperationSource<DeviceUpdateInstanceResource>.CreateResult(Response response, CancellationToken cancellationToken)
        {
            using var document = JsonDocument.Parse(response.ContentStream);
            var data = DeviceUpdateInstanceData.DeserializeDeviceUpdateInstanceData(document.RootElement);
            return new DeviceUpdateInstanceResource(_client, data);
        }

        async ValueTask<DeviceUpdateInstanceResource> IOperationSource<DeviceUpdateInstanceResource>.CreateResultAsync(Response response, CancellationToken cancellationToken)
        {
            using var document = await JsonDocument.ParseAsync(response.ContentStream, default, cancellationToken).ConfigureAwait(false);
            var data = DeviceUpdateInstanceData.DeserializeDeviceUpdateInstanceData(document.RootElement);
            return new DeviceUpdateInstanceResource(_client, data);
        }
    }
}
