// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.

// <auto-generated/>

#nullable disable

using System.Text.Json;
using System.Threading;
using System.Threading.Tasks;
using Azure.Core;

namespace Azure.ResourceManager.DeviceUpdate
{
    internal class DeviceUpdateAccountOperationSource : IOperationSource<DeviceUpdateAccountResource>
    {
        private readonly ArmClient _client;

        internal DeviceUpdateAccountOperationSource(ArmClient client)
        {
            _client = client;
        }

        DeviceUpdateAccountResource IOperationSource<DeviceUpdateAccountResource>.CreateResult(Response response, CancellationToken cancellationToken)
        {
            using var document = JsonDocument.Parse(response.ContentStream);
            var data = DeviceUpdateAccountData.DeserializeDeviceUpdateAccountData(document.RootElement);
            return new DeviceUpdateAccountResource(_client, data);
        }

        async ValueTask<DeviceUpdateAccountResource> IOperationSource<DeviceUpdateAccountResource>.CreateResultAsync(Response response, CancellationToken cancellationToken)
        {
            using var document = await JsonDocument.ParseAsync(response.ContentStream, default, cancellationToken).ConfigureAwait(false);
            var data = DeviceUpdateAccountData.DeserializeDeviceUpdateAccountData(document.RootElement);
            return new DeviceUpdateAccountResource(_client, data);
        }
    }
}
