// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.

// <auto-generated/>

#nullable disable

using System;
using System.Collections.Generic;
using Azure.Core;
using Azure.ResourceManager.DeviceUpdate.Models;
using Azure.ResourceManager.Models;

namespace Azure.ResourceManager.DeviceUpdate
{
    /// <summary>
    /// A class representing the DeviceUpdatePrivateEndpointConnectionProxy data model.
    /// Private endpoint connection proxy details.
    /// </summary>
    public partial class DeviceUpdatePrivateEndpointConnectionProxyData : ResourceData
    {
        /// <summary>
        /// Keeps track of any properties unknown to the library.
        /// <para>
        /// To assign an object to the value of this property use <see cref="BinaryData.FromObjectAsJson{T}(T, System.Text.Json.JsonSerializerOptions?)"/>.
        /// </para>
        /// <para>
        /// To assign an already formatted json string to this property use <see cref="BinaryData.FromString(string)"/>.
        /// </para>
        /// <para>
        /// Examples:
        /// <list type="bullet">
        /// <item>
        /// <term>BinaryData.FromObjectAsJson("foo")</term>
        /// <description>Creates a payload of "foo".</description>
        /// </item>
        /// <item>
        /// <term>BinaryData.FromString("\"foo\"")</term>
        /// <description>Creates a payload of "foo".</description>
        /// </item>
        /// <item>
        /// <term>BinaryData.FromObjectAsJson(new { key = "value" })</term>
        /// <description>Creates a payload of { "key": "value" }.</description>
        /// </item>
        /// <item>
        /// <term>BinaryData.FromString("{\"key\": \"value\"}")</term>
        /// <description>Creates a payload of { "key": "value" }.</description>
        /// </item>
        /// </list>
        /// </para>
        /// </summary>
        private IDictionary<string, BinaryData> _serializedAdditionalRawData;

        /// <summary> Initializes a new instance of <see cref="DeviceUpdatePrivateEndpointConnectionProxyData"/>. </summary>
        public DeviceUpdatePrivateEndpointConnectionProxyData()
        {
        }

        /// <summary> Initializes a new instance of <see cref="DeviceUpdatePrivateEndpointConnectionProxyData"/>. </summary>
        /// <param name="id"> The id. </param>
        /// <param name="name"> The name. </param>
        /// <param name="resourceType"> The resourceType. </param>
        /// <param name="systemData"> The systemData. </param>
        /// <param name="provisioningState"> The provisioning state of the private endpoint connection proxy resource. </param>
        /// <param name="eTag"> ETag from NRP. </param>
        /// <param name="remotePrivateEndpoint"> Remote private endpoint details. </param>
        /// <param name="status"> Operation status. </param>
        /// <param name="serializedAdditionalRawData"> Keeps track of any properties unknown to the library. </param>
        internal DeviceUpdatePrivateEndpointConnectionProxyData(ResourceIdentifier id, string name, ResourceType resourceType, SystemData systemData, DeviceUpdatePrivateEndpointConnectionProxyProvisioningState? provisioningState, string eTag, DeviceUpdateRemotePrivateEndpoint remotePrivateEndpoint, string status, IDictionary<string, BinaryData> serializedAdditionalRawData) : base(id, name, resourceType, systemData)
        {
            ProvisioningState = provisioningState;
            ETag = eTag;
            RemotePrivateEndpoint = remotePrivateEndpoint;
            Status = status;
            _serializedAdditionalRawData = serializedAdditionalRawData;
        }

        /// <summary> The provisioning state of the private endpoint connection proxy resource. </summary>
        public DeviceUpdatePrivateEndpointConnectionProxyProvisioningState? ProvisioningState { get; }
        /// <summary> ETag from NRP. </summary>
        public string ETag { get; }
        /// <summary> Remote private endpoint details. </summary>
        public DeviceUpdateRemotePrivateEndpoint RemotePrivateEndpoint { get; set; }
        /// <summary> Operation status. </summary>
        public string Status { get; set; }
    }
}
