// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.

// <auto-generated/>

#nullable disable

using System;
using System.Text.Json;
using System.Threading.Tasks;
using Azure.Core;
using Azure.Identity;
using NUnit.Framework;

namespace Azure.IoT.DeviceUpdate.Samples
{
    public partial class Samples_DeviceUpdateClient
    {
        [Test]
        [Ignore("Only validating compilation of examples")]
        public void Example_GetUpdate_ShortVersion()
        {
            Uri endpoint = new Uri("<endpoint>");
            TokenCredential credential = new DefaultAzureCredential();
            DeviceUpdateClient client = new DeviceUpdateClient(endpoint, "<InstanceId>", credential);

            Response response = client.GetUpdate("<provider>", "<name>", "<version>");

            JsonElement result = JsonDocument.Parse(response.ContentStream).RootElement;
            Console.WriteLine(result.GetProperty("updateId").GetProperty("provider").ToString());
            Console.WriteLine(result.GetProperty("updateId").GetProperty("name").ToString());
            Console.WriteLine(result.GetProperty("updateId").GetProperty("version").ToString());
            Console.WriteLine(result.GetProperty("compatibility")[0].GetProperty("<key>").ToString());
            Console.WriteLine(result.GetProperty("manifestVersion").ToString());
            Console.WriteLine(result.GetProperty("importedDateTime").ToString());
            Console.WriteLine(result.GetProperty("createdDateTime").ToString());
        }

        [Test]
        [Ignore("Only validating compilation of examples")]
        public async Task Example_GetUpdate_ShortVersion_Async()
        {
            Uri endpoint = new Uri("<endpoint>");
            TokenCredential credential = new DefaultAzureCredential();
            DeviceUpdateClient client = new DeviceUpdateClient(endpoint, "<InstanceId>", credential);

            Response response = await client.GetUpdateAsync("<provider>", "<name>", "<version>");

            JsonElement result = JsonDocument.Parse(response.ContentStream).RootElement;
            Console.WriteLine(result.GetProperty("updateId").GetProperty("provider").ToString());
            Console.WriteLine(result.GetProperty("updateId").GetProperty("name").ToString());
            Console.WriteLine(result.GetProperty("updateId").GetProperty("version").ToString());
            Console.WriteLine(result.GetProperty("compatibility")[0].GetProperty("<key>").ToString());
            Console.WriteLine(result.GetProperty("manifestVersion").ToString());
            Console.WriteLine(result.GetProperty("importedDateTime").ToString());
            Console.WriteLine(result.GetProperty("createdDateTime").ToString());
        }

        [Test]
        [Ignore("Only validating compilation of examples")]
        public void Example_GetUpdate_AllParameters()
        {
            Uri endpoint = new Uri("<endpoint>");
            TokenCredential credential = new DefaultAzureCredential();
            DeviceUpdateClient client = new DeviceUpdateClient(endpoint, "<InstanceId>", credential);

            Response response = client.GetUpdate("<provider>", "<name>", "<version>", ifNoneMatch: new ETag("<ifNoneMatch>"));

            JsonElement result = JsonDocument.Parse(response.ContentStream).RootElement;
            Console.WriteLine(result.GetProperty("updateId").GetProperty("provider").ToString());
            Console.WriteLine(result.GetProperty("updateId").GetProperty("name").ToString());
            Console.WriteLine(result.GetProperty("updateId").GetProperty("version").ToString());
            Console.WriteLine(result.GetProperty("description").ToString());
            Console.WriteLine(result.GetProperty("friendlyName").ToString());
            Console.WriteLine(result.GetProperty("isDeployable").ToString());
            Console.WriteLine(result.GetProperty("updateType").ToString());
            Console.WriteLine(result.GetProperty("installedCriteria").ToString());
            Console.WriteLine(result.GetProperty("compatibility")[0].GetProperty("<key>").ToString());
            Console.WriteLine(result.GetProperty("instructions").GetProperty("steps")[0].GetProperty("type").ToString());
            Console.WriteLine(result.GetProperty("instructions").GetProperty("steps")[0].GetProperty("description").ToString());
            Console.WriteLine(result.GetProperty("instructions").GetProperty("steps")[0].GetProperty("handler").ToString());
            Console.WriteLine(result.GetProperty("instructions").GetProperty("steps")[0].GetProperty("handlerProperties").ToString());
            Console.WriteLine(result.GetProperty("instructions").GetProperty("steps")[0].GetProperty("files")[0].ToString());
            Console.WriteLine(result.GetProperty("instructions").GetProperty("steps")[0].GetProperty("updateId").GetProperty("provider").ToString());
            Console.WriteLine(result.GetProperty("instructions").GetProperty("steps")[0].GetProperty("updateId").GetProperty("name").ToString());
            Console.WriteLine(result.GetProperty("instructions").GetProperty("steps")[0].GetProperty("updateId").GetProperty("version").ToString());
            Console.WriteLine(result.GetProperty("referencedBy")[0].GetProperty("provider").ToString());
            Console.WriteLine(result.GetProperty("referencedBy")[0].GetProperty("name").ToString());
            Console.WriteLine(result.GetProperty("referencedBy")[0].GetProperty("version").ToString());
            Console.WriteLine(result.GetProperty("scanResult").ToString());
            Console.WriteLine(result.GetProperty("manifestVersion").ToString());
            Console.WriteLine(result.GetProperty("importedDateTime").ToString());
            Console.WriteLine(result.GetProperty("createdDateTime").ToString());
            Console.WriteLine(result.GetProperty("etag").ToString());
        }

        [Test]
        [Ignore("Only validating compilation of examples")]
        public async Task Example_GetUpdate_AllParameters_Async()
        {
            Uri endpoint = new Uri("<endpoint>");
            TokenCredential credential = new DefaultAzureCredential();
            DeviceUpdateClient client = new DeviceUpdateClient(endpoint, "<InstanceId>", credential);

            Response response = await client.GetUpdateAsync("<provider>", "<name>", "<version>", ifNoneMatch: new ETag("<ifNoneMatch>"));

            JsonElement result = JsonDocument.Parse(response.ContentStream).RootElement;
            Console.WriteLine(result.GetProperty("updateId").GetProperty("provider").ToString());
            Console.WriteLine(result.GetProperty("updateId").GetProperty("name").ToString());
            Console.WriteLine(result.GetProperty("updateId").GetProperty("version").ToString());
            Console.WriteLine(result.GetProperty("description").ToString());
            Console.WriteLine(result.GetProperty("friendlyName").ToString());
            Console.WriteLine(result.GetProperty("isDeployable").ToString());
            Console.WriteLine(result.GetProperty("updateType").ToString());
            Console.WriteLine(result.GetProperty("installedCriteria").ToString());
            Console.WriteLine(result.GetProperty("compatibility")[0].GetProperty("<key>").ToString());
            Console.WriteLine(result.GetProperty("instructions").GetProperty("steps")[0].GetProperty("type").ToString());
            Console.WriteLine(result.GetProperty("instructions").GetProperty("steps")[0].GetProperty("description").ToString());
            Console.WriteLine(result.GetProperty("instructions").GetProperty("steps")[0].GetProperty("handler").ToString());
            Console.WriteLine(result.GetProperty("instructions").GetProperty("steps")[0].GetProperty("handlerProperties").ToString());
            Console.WriteLine(result.GetProperty("instructions").GetProperty("steps")[0].GetProperty("files")[0].ToString());
            Console.WriteLine(result.GetProperty("instructions").GetProperty("steps")[0].GetProperty("updateId").GetProperty("provider").ToString());
            Console.WriteLine(result.GetProperty("instructions").GetProperty("steps")[0].GetProperty("updateId").GetProperty("name").ToString());
            Console.WriteLine(result.GetProperty("instructions").GetProperty("steps")[0].GetProperty("updateId").GetProperty("version").ToString());
            Console.WriteLine(result.GetProperty("referencedBy")[0].GetProperty("provider").ToString());
            Console.WriteLine(result.GetProperty("referencedBy")[0].GetProperty("name").ToString());
            Console.WriteLine(result.GetProperty("referencedBy")[0].GetProperty("version").ToString());
            Console.WriteLine(result.GetProperty("scanResult").ToString());
            Console.WriteLine(result.GetProperty("manifestVersion").ToString());
            Console.WriteLine(result.GetProperty("importedDateTime").ToString());
            Console.WriteLine(result.GetProperty("createdDateTime").ToString());
            Console.WriteLine(result.GetProperty("etag").ToString());
        }

        [Test]
        [Ignore("Only validating compilation of examples")]
        public void Example_GetFile_ShortVersion()
        {
            Uri endpoint = new Uri("<endpoint>");
            TokenCredential credential = new DefaultAzureCredential();
            DeviceUpdateClient client = new DeviceUpdateClient(endpoint, "<InstanceId>", credential);

            Response response = client.GetFile("<provider>", "<name>", "<version>", "<fileId>");

            JsonElement result = JsonDocument.Parse(response.ContentStream).RootElement;
            Console.WriteLine(result.GetProperty("fileId").ToString());
            Console.WriteLine(result.GetProperty("fileName").ToString());
            Console.WriteLine(result.GetProperty("sizeInBytes").ToString());
            Console.WriteLine(result.GetProperty("hashes").GetProperty("<key>").ToString());
        }

        [Test]
        [Ignore("Only validating compilation of examples")]
        public async Task Example_GetFile_ShortVersion_Async()
        {
            Uri endpoint = new Uri("<endpoint>");
            TokenCredential credential = new DefaultAzureCredential();
            DeviceUpdateClient client = new DeviceUpdateClient(endpoint, "<InstanceId>", credential);

            Response response = await client.GetFileAsync("<provider>", "<name>", "<version>", "<fileId>");

            JsonElement result = JsonDocument.Parse(response.ContentStream).RootElement;
            Console.WriteLine(result.GetProperty("fileId").ToString());
            Console.WriteLine(result.GetProperty("fileName").ToString());
            Console.WriteLine(result.GetProperty("sizeInBytes").ToString());
            Console.WriteLine(result.GetProperty("hashes").GetProperty("<key>").ToString());
        }

        [Test]
        [Ignore("Only validating compilation of examples")]
        public void Example_GetFile_AllParameters()
        {
            Uri endpoint = new Uri("<endpoint>");
            TokenCredential credential = new DefaultAzureCredential();
            DeviceUpdateClient client = new DeviceUpdateClient(endpoint, "<InstanceId>", credential);

            Response response = client.GetFile("<provider>", "<name>", "<version>", "<fileId>", ifNoneMatch: new ETag("<ifNoneMatch>"));

            JsonElement result = JsonDocument.Parse(response.ContentStream).RootElement;
            Console.WriteLine(result.GetProperty("fileId").ToString());
            Console.WriteLine(result.GetProperty("relatedFiles")[0].GetProperty("fileName").ToString());
            Console.WriteLine(result.GetProperty("relatedFiles")[0].GetProperty("sizeInBytes").ToString());
            Console.WriteLine(result.GetProperty("relatedFiles")[0].GetProperty("hashes").GetProperty("<key>").ToString());
            Console.WriteLine(result.GetProperty("relatedFiles")[0].GetProperty("mimeType").ToString());
            Console.WriteLine(result.GetProperty("relatedFiles")[0].GetProperty("scanResult").ToString());
            Console.WriteLine(result.GetProperty("relatedFiles")[0].GetProperty("scanDetails").ToString());
            Console.WriteLine(result.GetProperty("relatedFiles")[0].GetProperty("properties").GetProperty("<key>").ToString());
            Console.WriteLine(result.GetProperty("downloadHandler").GetProperty("id").ToString());
            Console.WriteLine(result.GetProperty("etag").ToString());
            Console.WriteLine(result.GetProperty("fileName").ToString());
            Console.WriteLine(result.GetProperty("sizeInBytes").ToString());
            Console.WriteLine(result.GetProperty("hashes").GetProperty("<key>").ToString());
            Console.WriteLine(result.GetProperty("mimeType").ToString());
            Console.WriteLine(result.GetProperty("scanResult").ToString());
            Console.WriteLine(result.GetProperty("scanDetails").ToString());
            Console.WriteLine(result.GetProperty("properties").GetProperty("<key>").ToString());
        }

        [Test]
        [Ignore("Only validating compilation of examples")]
        public async Task Example_GetFile_AllParameters_Async()
        {
            Uri endpoint = new Uri("<endpoint>");
            TokenCredential credential = new DefaultAzureCredential();
            DeviceUpdateClient client = new DeviceUpdateClient(endpoint, "<InstanceId>", credential);

            Response response = await client.GetFileAsync("<provider>", "<name>", "<version>", "<fileId>", ifNoneMatch: new ETag("<ifNoneMatch>"));

            JsonElement result = JsonDocument.Parse(response.ContentStream).RootElement;
            Console.WriteLine(result.GetProperty("fileId").ToString());
            Console.WriteLine(result.GetProperty("relatedFiles")[0].GetProperty("fileName").ToString());
            Console.WriteLine(result.GetProperty("relatedFiles")[0].GetProperty("sizeInBytes").ToString());
            Console.WriteLine(result.GetProperty("relatedFiles")[0].GetProperty("hashes").GetProperty("<key>").ToString());
            Console.WriteLine(result.GetProperty("relatedFiles")[0].GetProperty("mimeType").ToString());
            Console.WriteLine(result.GetProperty("relatedFiles")[0].GetProperty("scanResult").ToString());
            Console.WriteLine(result.GetProperty("relatedFiles")[0].GetProperty("scanDetails").ToString());
            Console.WriteLine(result.GetProperty("relatedFiles")[0].GetProperty("properties").GetProperty("<key>").ToString());
            Console.WriteLine(result.GetProperty("downloadHandler").GetProperty("id").ToString());
            Console.WriteLine(result.GetProperty("etag").ToString());
            Console.WriteLine(result.GetProperty("fileName").ToString());
            Console.WriteLine(result.GetProperty("sizeInBytes").ToString());
            Console.WriteLine(result.GetProperty("hashes").GetProperty("<key>").ToString());
            Console.WriteLine(result.GetProperty("mimeType").ToString());
            Console.WriteLine(result.GetProperty("scanResult").ToString());
            Console.WriteLine(result.GetProperty("scanDetails").ToString());
            Console.WriteLine(result.GetProperty("properties").GetProperty("<key>").ToString());
        }

        [Test]
        [Ignore("Only validating compilation of examples")]
        public void Example_GetOperationStatus_ShortVersion()
        {
            Uri endpoint = new Uri("<endpoint>");
            TokenCredential credential = new DefaultAzureCredential();
            DeviceUpdateClient client = new DeviceUpdateClient(endpoint, "<InstanceId>", credential);

            Response response = client.GetOperationStatus("<operationId>");

            JsonElement result = JsonDocument.Parse(response.ContentStream).RootElement;
            Console.WriteLine(result.GetProperty("operationId").ToString());
            Console.WriteLine(result.GetProperty("status").ToString());
            Console.WriteLine(result.GetProperty("lastActionDateTime").ToString());
            Console.WriteLine(result.GetProperty("createdDateTime").ToString());
        }

        [Test]
        [Ignore("Only validating compilation of examples")]
        public async Task Example_GetOperationStatus_ShortVersion_Async()
        {
            Uri endpoint = new Uri("<endpoint>");
            TokenCredential credential = new DefaultAzureCredential();
            DeviceUpdateClient client = new DeviceUpdateClient(endpoint, "<InstanceId>", credential);

            Response response = await client.GetOperationStatusAsync("<operationId>");

            JsonElement result = JsonDocument.Parse(response.ContentStream).RootElement;
            Console.WriteLine(result.GetProperty("operationId").ToString());
            Console.WriteLine(result.GetProperty("status").ToString());
            Console.WriteLine(result.GetProperty("lastActionDateTime").ToString());
            Console.WriteLine(result.GetProperty("createdDateTime").ToString());
        }

        [Test]
        [Ignore("Only validating compilation of examples")]
        public void Example_GetOperationStatus_AllParameters()
        {
            Uri endpoint = new Uri("<endpoint>");
            TokenCredential credential = new DefaultAzureCredential();
            DeviceUpdateClient client = new DeviceUpdateClient(endpoint, "<InstanceId>", credential);

            Response response = client.GetOperationStatus("<operationId>", ifNoneMatch: new ETag("<ifNoneMatch>"));

            JsonElement result = JsonDocument.Parse(response.ContentStream).RootElement;
            Console.WriteLine(result.GetProperty("operationId").ToString());
            Console.WriteLine(result.GetProperty("status").ToString());
            Console.WriteLine(result.GetProperty("update").GetProperty("updateId").GetProperty("provider").ToString());
            Console.WriteLine(result.GetProperty("update").GetProperty("updateId").GetProperty("name").ToString());
            Console.WriteLine(result.GetProperty("update").GetProperty("updateId").GetProperty("version").ToString());
            Console.WriteLine(result.GetProperty("update").GetProperty("description").ToString());
            Console.WriteLine(result.GetProperty("update").GetProperty("friendlyName").ToString());
            Console.WriteLine(result.GetProperty("resourceLocation").ToString());
            Console.WriteLine(result.GetProperty("error").GetProperty("code").ToString());
            Console.WriteLine(result.GetProperty("error").GetProperty("message").ToString());
            Console.WriteLine(result.GetProperty("error").GetProperty("target").ToString());
            Console.WriteLine(result.GetProperty("error").GetProperty("innererror").GetProperty("code").ToString());
            Console.WriteLine(result.GetProperty("error").GetProperty("innererror").GetProperty("message").ToString());
            Console.WriteLine(result.GetProperty("error").GetProperty("innererror").GetProperty("errorDetail").ToString());
            Console.WriteLine(result.GetProperty("error").GetProperty("occurredDateTime").ToString());
            Console.WriteLine(result.GetProperty("traceId").ToString());
            Console.WriteLine(result.GetProperty("lastActionDateTime").ToString());
            Console.WriteLine(result.GetProperty("createdDateTime").ToString());
            Console.WriteLine(result.GetProperty("etag").ToString());
        }

        [Test]
        [Ignore("Only validating compilation of examples")]
        public async Task Example_GetOperationStatus_AllParameters_Async()
        {
            Uri endpoint = new Uri("<endpoint>");
            TokenCredential credential = new DefaultAzureCredential();
            DeviceUpdateClient client = new DeviceUpdateClient(endpoint, "<InstanceId>", credential);

            Response response = await client.GetOperationStatusAsync("<operationId>", ifNoneMatch: new ETag("<ifNoneMatch>"));

            JsonElement result = JsonDocument.Parse(response.ContentStream).RootElement;
            Console.WriteLine(result.GetProperty("operationId").ToString());
            Console.WriteLine(result.GetProperty("status").ToString());
            Console.WriteLine(result.GetProperty("update").GetProperty("updateId").GetProperty("provider").ToString());
            Console.WriteLine(result.GetProperty("update").GetProperty("updateId").GetProperty("name").ToString());
            Console.WriteLine(result.GetProperty("update").GetProperty("updateId").GetProperty("version").ToString());
            Console.WriteLine(result.GetProperty("update").GetProperty("description").ToString());
            Console.WriteLine(result.GetProperty("update").GetProperty("friendlyName").ToString());
            Console.WriteLine(result.GetProperty("resourceLocation").ToString());
            Console.WriteLine(result.GetProperty("error").GetProperty("code").ToString());
            Console.WriteLine(result.GetProperty("error").GetProperty("message").ToString());
            Console.WriteLine(result.GetProperty("error").GetProperty("target").ToString());
            Console.WriteLine(result.GetProperty("error").GetProperty("innererror").GetProperty("code").ToString());
            Console.WriteLine(result.GetProperty("error").GetProperty("innererror").GetProperty("message").ToString());
            Console.WriteLine(result.GetProperty("error").GetProperty("innererror").GetProperty("errorDetail").ToString());
            Console.WriteLine(result.GetProperty("error").GetProperty("occurredDateTime").ToString());
            Console.WriteLine(result.GetProperty("traceId").ToString());
            Console.WriteLine(result.GetProperty("lastActionDateTime").ToString());
            Console.WriteLine(result.GetProperty("createdDateTime").ToString());
            Console.WriteLine(result.GetProperty("etag").ToString());
        }

        [Test]
        [Ignore("Only validating compilation of examples")]
        public void Example_GetUpdates_ShortVersion()
        {
            Uri endpoint = new Uri("<endpoint>");
            TokenCredential credential = new DefaultAzureCredential();
            DeviceUpdateClient client = new DeviceUpdateClient(endpoint, "<InstanceId>", credential);

            foreach (BinaryData item in client.GetUpdates())
            {
                JsonElement result = JsonDocument.Parse(item.ToStream()).RootElement;
                Console.WriteLine(result.GetProperty("updateId").GetProperty("provider").ToString());
                Console.WriteLine(result.GetProperty("updateId").GetProperty("name").ToString());
                Console.WriteLine(result.GetProperty("updateId").GetProperty("version").ToString());
                Console.WriteLine(result.GetProperty("compatibility")[0].GetProperty("<key>").ToString());
                Console.WriteLine(result.GetProperty("manifestVersion").ToString());
                Console.WriteLine(result.GetProperty("importedDateTime").ToString());
                Console.WriteLine(result.GetProperty("createdDateTime").ToString());
            }
        }

        [Test]
        [Ignore("Only validating compilation of examples")]
        public async Task Example_GetUpdates_ShortVersion_Async()
        {
            Uri endpoint = new Uri("<endpoint>");
            TokenCredential credential = new DefaultAzureCredential();
            DeviceUpdateClient client = new DeviceUpdateClient(endpoint, "<InstanceId>", credential);

            await foreach (BinaryData item in client.GetUpdatesAsync())
            {
                JsonElement result = JsonDocument.Parse(item.ToStream()).RootElement;
                Console.WriteLine(result.GetProperty("updateId").GetProperty("provider").ToString());
                Console.WriteLine(result.GetProperty("updateId").GetProperty("name").ToString());
                Console.WriteLine(result.GetProperty("updateId").GetProperty("version").ToString());
                Console.WriteLine(result.GetProperty("compatibility")[0].GetProperty("<key>").ToString());
                Console.WriteLine(result.GetProperty("manifestVersion").ToString());
                Console.WriteLine(result.GetProperty("importedDateTime").ToString());
                Console.WriteLine(result.GetProperty("createdDateTime").ToString());
            }
        }

        [Test]
        [Ignore("Only validating compilation of examples")]
        public void Example_GetUpdates_AllParameters()
        {
            Uri endpoint = new Uri("<endpoint>");
            TokenCredential credential = new DefaultAzureCredential();
            DeviceUpdateClient client = new DeviceUpdateClient(endpoint, "<InstanceId>", credential);

            foreach (BinaryData item in client.GetUpdates(search: "<search>", filter: "<filter>"))
            {
                JsonElement result = JsonDocument.Parse(item.ToStream()).RootElement;
                Console.WriteLine(result.GetProperty("updateId").GetProperty("provider").ToString());
                Console.WriteLine(result.GetProperty("updateId").GetProperty("name").ToString());
                Console.WriteLine(result.GetProperty("updateId").GetProperty("version").ToString());
                Console.WriteLine(result.GetProperty("description").ToString());
                Console.WriteLine(result.GetProperty("friendlyName").ToString());
                Console.WriteLine(result.GetProperty("isDeployable").ToString());
                Console.WriteLine(result.GetProperty("updateType").ToString());
                Console.WriteLine(result.GetProperty("installedCriteria").ToString());
                Console.WriteLine(result.GetProperty("compatibility")[0].GetProperty("<key>").ToString());
                Console.WriteLine(result.GetProperty("instructions").GetProperty("steps")[0].GetProperty("type").ToString());
                Console.WriteLine(result.GetProperty("instructions").GetProperty("steps")[0].GetProperty("description").ToString());
                Console.WriteLine(result.GetProperty("instructions").GetProperty("steps")[0].GetProperty("handler").ToString());
                Console.WriteLine(result.GetProperty("instructions").GetProperty("steps")[0].GetProperty("handlerProperties").ToString());
                Console.WriteLine(result.GetProperty("instructions").GetProperty("steps")[0].GetProperty("files")[0].ToString());
                Console.WriteLine(result.GetProperty("instructions").GetProperty("steps")[0].GetProperty("updateId").GetProperty("provider").ToString());
                Console.WriteLine(result.GetProperty("instructions").GetProperty("steps")[0].GetProperty("updateId").GetProperty("name").ToString());
                Console.WriteLine(result.GetProperty("instructions").GetProperty("steps")[0].GetProperty("updateId").GetProperty("version").ToString());
                Console.WriteLine(result.GetProperty("referencedBy")[0].GetProperty("provider").ToString());
                Console.WriteLine(result.GetProperty("referencedBy")[0].GetProperty("name").ToString());
                Console.WriteLine(result.GetProperty("referencedBy")[0].GetProperty("version").ToString());
                Console.WriteLine(result.GetProperty("scanResult").ToString());
                Console.WriteLine(result.GetProperty("manifestVersion").ToString());
                Console.WriteLine(result.GetProperty("importedDateTime").ToString());
                Console.WriteLine(result.GetProperty("createdDateTime").ToString());
                Console.WriteLine(result.GetProperty("etag").ToString());
            }
        }

        [Test]
        [Ignore("Only validating compilation of examples")]
        public async Task Example_GetUpdates_AllParameters_Async()
        {
            Uri endpoint = new Uri("<endpoint>");
            TokenCredential credential = new DefaultAzureCredential();
            DeviceUpdateClient client = new DeviceUpdateClient(endpoint, "<InstanceId>", credential);

            await foreach (BinaryData item in client.GetUpdatesAsync(search: "<search>", filter: "<filter>"))
            {
                JsonElement result = JsonDocument.Parse(item.ToStream()).RootElement;
                Console.WriteLine(result.GetProperty("updateId").GetProperty("provider").ToString());
                Console.WriteLine(result.GetProperty("updateId").GetProperty("name").ToString());
                Console.WriteLine(result.GetProperty("updateId").GetProperty("version").ToString());
                Console.WriteLine(result.GetProperty("description").ToString());
                Console.WriteLine(result.GetProperty("friendlyName").ToString());
                Console.WriteLine(result.GetProperty("isDeployable").ToString());
                Console.WriteLine(result.GetProperty("updateType").ToString());
                Console.WriteLine(result.GetProperty("installedCriteria").ToString());
                Console.WriteLine(result.GetProperty("compatibility")[0].GetProperty("<key>").ToString());
                Console.WriteLine(result.GetProperty("instructions").GetProperty("steps")[0].GetProperty("type").ToString());
                Console.WriteLine(result.GetProperty("instructions").GetProperty("steps")[0].GetProperty("description").ToString());
                Console.WriteLine(result.GetProperty("instructions").GetProperty("steps")[0].GetProperty("handler").ToString());
                Console.WriteLine(result.GetProperty("instructions").GetProperty("steps")[0].GetProperty("handlerProperties").ToString());
                Console.WriteLine(result.GetProperty("instructions").GetProperty("steps")[0].GetProperty("files")[0].ToString());
                Console.WriteLine(result.GetProperty("instructions").GetProperty("steps")[0].GetProperty("updateId").GetProperty("provider").ToString());
                Console.WriteLine(result.GetProperty("instructions").GetProperty("steps")[0].GetProperty("updateId").GetProperty("name").ToString());
                Console.WriteLine(result.GetProperty("instructions").GetProperty("steps")[0].GetProperty("updateId").GetProperty("version").ToString());
                Console.WriteLine(result.GetProperty("referencedBy")[0].GetProperty("provider").ToString());
                Console.WriteLine(result.GetProperty("referencedBy")[0].GetProperty("name").ToString());
                Console.WriteLine(result.GetProperty("referencedBy")[0].GetProperty("version").ToString());
                Console.WriteLine(result.GetProperty("scanResult").ToString());
                Console.WriteLine(result.GetProperty("manifestVersion").ToString());
                Console.WriteLine(result.GetProperty("importedDateTime").ToString());
                Console.WriteLine(result.GetProperty("createdDateTime").ToString());
                Console.WriteLine(result.GetProperty("etag").ToString());
            }
        }

        [Test]
        [Ignore("Only validating compilation of examples")]
        public void Example_GetProviders_ShortVersion()
        {
            Uri endpoint = new Uri("<endpoint>");
            TokenCredential credential = new DefaultAzureCredential();
            DeviceUpdateClient client = new DeviceUpdateClient(endpoint, "<InstanceId>", credential);

            foreach (BinaryData item in client.GetProviders())
            {
                JsonElement result = JsonDocument.Parse(item.ToStream()).RootElement;
                Console.WriteLine(result.ToString());
            }
        }

        [Test]
        [Ignore("Only validating compilation of examples")]
        public async Task Example_GetProviders_ShortVersion_Async()
        {
            Uri endpoint = new Uri("<endpoint>");
            TokenCredential credential = new DefaultAzureCredential();
            DeviceUpdateClient client = new DeviceUpdateClient(endpoint, "<InstanceId>", credential);

            await foreach (BinaryData item in client.GetProvidersAsync())
            {
                JsonElement result = JsonDocument.Parse(item.ToStream()).RootElement;
                Console.WriteLine(result.ToString());
            }
        }

        [Test]
        [Ignore("Only validating compilation of examples")]
        public void Example_GetProviders_AllParameters()
        {
            Uri endpoint = new Uri("<endpoint>");
            TokenCredential credential = new DefaultAzureCredential();
            DeviceUpdateClient client = new DeviceUpdateClient(endpoint, "<InstanceId>", credential);

            foreach (BinaryData item in client.GetProviders())
            {
                JsonElement result = JsonDocument.Parse(item.ToStream()).RootElement;
                Console.WriteLine(result.ToString());
            }
        }

        [Test]
        [Ignore("Only validating compilation of examples")]
        public async Task Example_GetProviders_AllParameters_Async()
        {
            Uri endpoint = new Uri("<endpoint>");
            TokenCredential credential = new DefaultAzureCredential();
            DeviceUpdateClient client = new DeviceUpdateClient(endpoint, "<InstanceId>", credential);

            await foreach (BinaryData item in client.GetProvidersAsync())
            {
                JsonElement result = JsonDocument.Parse(item.ToStream()).RootElement;
                Console.WriteLine(result.ToString());
            }
        }

        [Test]
        [Ignore("Only validating compilation of examples")]
        public void Example_GetNames_ShortVersion()
        {
            Uri endpoint = new Uri("<endpoint>");
            TokenCredential credential = new DefaultAzureCredential();
            DeviceUpdateClient client = new DeviceUpdateClient(endpoint, "<InstanceId>", credential);

            foreach (BinaryData item in client.GetNames("<provider>"))
            {
                JsonElement result = JsonDocument.Parse(item.ToStream()).RootElement;
                Console.WriteLine(result.ToString());
            }
        }

        [Test]
        [Ignore("Only validating compilation of examples")]
        public async Task Example_GetNames_ShortVersion_Async()
        {
            Uri endpoint = new Uri("<endpoint>");
            TokenCredential credential = new DefaultAzureCredential();
            DeviceUpdateClient client = new DeviceUpdateClient(endpoint, "<InstanceId>", credential);

            await foreach (BinaryData item in client.GetNamesAsync("<provider>"))
            {
                JsonElement result = JsonDocument.Parse(item.ToStream()).RootElement;
                Console.WriteLine(result.ToString());
            }
        }

        [Test]
        [Ignore("Only validating compilation of examples")]
        public void Example_GetNames_AllParameters()
        {
            Uri endpoint = new Uri("<endpoint>");
            TokenCredential credential = new DefaultAzureCredential();
            DeviceUpdateClient client = new DeviceUpdateClient(endpoint, "<InstanceId>", credential);

            foreach (BinaryData item in client.GetNames("<provider>"))
            {
                JsonElement result = JsonDocument.Parse(item.ToStream()).RootElement;
                Console.WriteLine(result.ToString());
            }
        }

        [Test]
        [Ignore("Only validating compilation of examples")]
        public async Task Example_GetNames_AllParameters_Async()
        {
            Uri endpoint = new Uri("<endpoint>");
            TokenCredential credential = new DefaultAzureCredential();
            DeviceUpdateClient client = new DeviceUpdateClient(endpoint, "<InstanceId>", credential);

            await foreach (BinaryData item in client.GetNamesAsync("<provider>"))
            {
                JsonElement result = JsonDocument.Parse(item.ToStream()).RootElement;
                Console.WriteLine(result.ToString());
            }
        }

        [Test]
        [Ignore("Only validating compilation of examples")]
        public void Example_GetVersions_ShortVersion()
        {
            Uri endpoint = new Uri("<endpoint>");
            TokenCredential credential = new DefaultAzureCredential();
            DeviceUpdateClient client = new DeviceUpdateClient(endpoint, "<InstanceId>", credential);

            foreach (BinaryData item in client.GetVersions("<provider>", "<name>"))
            {
                JsonElement result = JsonDocument.Parse(item.ToStream()).RootElement;
                Console.WriteLine(result.ToString());
            }
        }

        [Test]
        [Ignore("Only validating compilation of examples")]
        public async Task Example_GetVersions_ShortVersion_Async()
        {
            Uri endpoint = new Uri("<endpoint>");
            TokenCredential credential = new DefaultAzureCredential();
            DeviceUpdateClient client = new DeviceUpdateClient(endpoint, "<InstanceId>", credential);

            await foreach (BinaryData item in client.GetVersionsAsync("<provider>", "<name>"))
            {
                JsonElement result = JsonDocument.Parse(item.ToStream()).RootElement;
                Console.WriteLine(result.ToString());
            }
        }

        [Test]
        [Ignore("Only validating compilation of examples")]
        public void Example_GetVersions_AllParameters()
        {
            Uri endpoint = new Uri("<endpoint>");
            TokenCredential credential = new DefaultAzureCredential();
            DeviceUpdateClient client = new DeviceUpdateClient(endpoint, "<InstanceId>", credential);

            foreach (BinaryData item in client.GetVersions("<provider>", "<name>", filter: "<filter>"))
            {
                JsonElement result = JsonDocument.Parse(item.ToStream()).RootElement;
                Console.WriteLine(result.ToString());
            }
        }

        [Test]
        [Ignore("Only validating compilation of examples")]
        public async Task Example_GetVersions_AllParameters_Async()
        {
            Uri endpoint = new Uri("<endpoint>");
            TokenCredential credential = new DefaultAzureCredential();
            DeviceUpdateClient client = new DeviceUpdateClient(endpoint, "<InstanceId>", credential);

            await foreach (BinaryData item in client.GetVersionsAsync("<provider>", "<name>", filter: "<filter>"))
            {
                JsonElement result = JsonDocument.Parse(item.ToStream()).RootElement;
                Console.WriteLine(result.ToString());
            }
        }

        [Test]
        [Ignore("Only validating compilation of examples")]
        public void Example_GetFiles_ShortVersion()
        {
            Uri endpoint = new Uri("<endpoint>");
            TokenCredential credential = new DefaultAzureCredential();
            DeviceUpdateClient client = new DeviceUpdateClient(endpoint, "<InstanceId>", credential);

            foreach (BinaryData item in client.GetFiles("<provider>", "<name>", "<version>"))
            {
                JsonElement result = JsonDocument.Parse(item.ToStream()).RootElement;
                Console.WriteLine(result.ToString());
            }
        }

        [Test]
        [Ignore("Only validating compilation of examples")]
        public async Task Example_GetFiles_ShortVersion_Async()
        {
            Uri endpoint = new Uri("<endpoint>");
            TokenCredential credential = new DefaultAzureCredential();
            DeviceUpdateClient client = new DeviceUpdateClient(endpoint, "<InstanceId>", credential);

            await foreach (BinaryData item in client.GetFilesAsync("<provider>", "<name>", "<version>"))
            {
                JsonElement result = JsonDocument.Parse(item.ToStream()).RootElement;
                Console.WriteLine(result.ToString());
            }
        }

        [Test]
        [Ignore("Only validating compilation of examples")]
        public void Example_GetFiles_AllParameters()
        {
            Uri endpoint = new Uri("<endpoint>");
            TokenCredential credential = new DefaultAzureCredential();
            DeviceUpdateClient client = new DeviceUpdateClient(endpoint, "<InstanceId>", credential);

            foreach (BinaryData item in client.GetFiles("<provider>", "<name>", "<version>"))
            {
                JsonElement result = JsonDocument.Parse(item.ToStream()).RootElement;
                Console.WriteLine(result.ToString());
            }
        }

        [Test]
        [Ignore("Only validating compilation of examples")]
        public async Task Example_GetFiles_AllParameters_Async()
        {
            Uri endpoint = new Uri("<endpoint>");
            TokenCredential credential = new DefaultAzureCredential();
            DeviceUpdateClient client = new DeviceUpdateClient(endpoint, "<InstanceId>", credential);

            await foreach (BinaryData item in client.GetFilesAsync("<provider>", "<name>", "<version>"))
            {
                JsonElement result = JsonDocument.Parse(item.ToStream()).RootElement;
                Console.WriteLine(result.ToString());
            }
        }

        [Test]
        [Ignore("Only validating compilation of examples")]
        public void Example_GetOperationStatuses_ShortVersion()
        {
            Uri endpoint = new Uri("<endpoint>");
            TokenCredential credential = new DefaultAzureCredential();
            DeviceUpdateClient client = new DeviceUpdateClient(endpoint, "<InstanceId>", credential);

            foreach (BinaryData item in client.GetOperationStatuses())
            {
                JsonElement result = JsonDocument.Parse(item.ToStream()).RootElement;
                Console.WriteLine(result.GetProperty("operationId").ToString());
                Console.WriteLine(result.GetProperty("status").ToString());
                Console.WriteLine(result.GetProperty("lastActionDateTime").ToString());
                Console.WriteLine(result.GetProperty("createdDateTime").ToString());
            }
        }

        [Test]
        [Ignore("Only validating compilation of examples")]
        public async Task Example_GetOperationStatuses_ShortVersion_Async()
        {
            Uri endpoint = new Uri("<endpoint>");
            TokenCredential credential = new DefaultAzureCredential();
            DeviceUpdateClient client = new DeviceUpdateClient(endpoint, "<InstanceId>", credential);

            await foreach (BinaryData item in client.GetOperationStatusesAsync())
            {
                JsonElement result = JsonDocument.Parse(item.ToStream()).RootElement;
                Console.WriteLine(result.GetProperty("operationId").ToString());
                Console.WriteLine(result.GetProperty("status").ToString());
                Console.WriteLine(result.GetProperty("lastActionDateTime").ToString());
                Console.WriteLine(result.GetProperty("createdDateTime").ToString());
            }
        }

        [Test]
        [Ignore("Only validating compilation of examples")]
        public void Example_GetOperationStatuses_AllParameters()
        {
            Uri endpoint = new Uri("<endpoint>");
            TokenCredential credential = new DefaultAzureCredential();
            DeviceUpdateClient client = new DeviceUpdateClient(endpoint, "<InstanceId>", credential);

            foreach (BinaryData item in client.GetOperationStatuses(filter: "<filter>", top: 1234))
            {
                JsonElement result = JsonDocument.Parse(item.ToStream()).RootElement;
                Console.WriteLine(result.GetProperty("operationId").ToString());
                Console.WriteLine(result.GetProperty("status").ToString());
                Console.WriteLine(result.GetProperty("update").GetProperty("updateId").GetProperty("provider").ToString());
                Console.WriteLine(result.GetProperty("update").GetProperty("updateId").GetProperty("name").ToString());
                Console.WriteLine(result.GetProperty("update").GetProperty("updateId").GetProperty("version").ToString());
                Console.WriteLine(result.GetProperty("update").GetProperty("description").ToString());
                Console.WriteLine(result.GetProperty("update").GetProperty("friendlyName").ToString());
                Console.WriteLine(result.GetProperty("resourceLocation").ToString());
                Console.WriteLine(result.GetProperty("error").GetProperty("code").ToString());
                Console.WriteLine(result.GetProperty("error").GetProperty("message").ToString());
                Console.WriteLine(result.GetProperty("error").GetProperty("target").ToString());
                Console.WriteLine(result.GetProperty("error").GetProperty("innererror").GetProperty("code").ToString());
                Console.WriteLine(result.GetProperty("error").GetProperty("innererror").GetProperty("message").ToString());
                Console.WriteLine(result.GetProperty("error").GetProperty("innererror").GetProperty("errorDetail").ToString());
                Console.WriteLine(result.GetProperty("error").GetProperty("occurredDateTime").ToString());
                Console.WriteLine(result.GetProperty("traceId").ToString());
                Console.WriteLine(result.GetProperty("lastActionDateTime").ToString());
                Console.WriteLine(result.GetProperty("createdDateTime").ToString());
                Console.WriteLine(result.GetProperty("etag").ToString());
            }
        }

        [Test]
        [Ignore("Only validating compilation of examples")]
        public async Task Example_GetOperationStatuses_AllParameters_Async()
        {
            Uri endpoint = new Uri("<endpoint>");
            TokenCredential credential = new DefaultAzureCredential();
            DeviceUpdateClient client = new DeviceUpdateClient(endpoint, "<InstanceId>", credential);

            await foreach (BinaryData item in client.GetOperationStatusesAsync(filter: "<filter>", top: 1234))
            {
                JsonElement result = JsonDocument.Parse(item.ToStream()).RootElement;
                Console.WriteLine(result.GetProperty("operationId").ToString());
                Console.WriteLine(result.GetProperty("status").ToString());
                Console.WriteLine(result.GetProperty("update").GetProperty("updateId").GetProperty("provider").ToString());
                Console.WriteLine(result.GetProperty("update").GetProperty("updateId").GetProperty("name").ToString());
                Console.WriteLine(result.GetProperty("update").GetProperty("updateId").GetProperty("version").ToString());
                Console.WriteLine(result.GetProperty("update").GetProperty("description").ToString());
                Console.WriteLine(result.GetProperty("update").GetProperty("friendlyName").ToString());
                Console.WriteLine(result.GetProperty("resourceLocation").ToString());
                Console.WriteLine(result.GetProperty("error").GetProperty("code").ToString());
                Console.WriteLine(result.GetProperty("error").GetProperty("message").ToString());
                Console.WriteLine(result.GetProperty("error").GetProperty("target").ToString());
                Console.WriteLine(result.GetProperty("error").GetProperty("innererror").GetProperty("code").ToString());
                Console.WriteLine(result.GetProperty("error").GetProperty("innererror").GetProperty("message").ToString());
                Console.WriteLine(result.GetProperty("error").GetProperty("innererror").GetProperty("errorDetail").ToString());
                Console.WriteLine(result.GetProperty("error").GetProperty("occurredDateTime").ToString());
                Console.WriteLine(result.GetProperty("traceId").ToString());
                Console.WriteLine(result.GetProperty("lastActionDateTime").ToString());
                Console.WriteLine(result.GetProperty("createdDateTime").ToString());
                Console.WriteLine(result.GetProperty("etag").ToString());
            }
        }

        [Test]
        [Ignore("Only validating compilation of examples")]
        public void Example_DeleteUpdate_ShortVersion()
        {
            Uri endpoint = new Uri("<endpoint>");
            TokenCredential credential = new DefaultAzureCredential();
            DeviceUpdateClient client = new DeviceUpdateClient(endpoint, "<InstanceId>", credential);

            Operation operation = client.DeleteUpdate(WaitUntil.Completed, "<provider>", "<name>", "<version>");
        }

        [Test]
        [Ignore("Only validating compilation of examples")]
        public async Task Example_DeleteUpdate_ShortVersion_Async()
        {
            Uri endpoint = new Uri("<endpoint>");
            TokenCredential credential = new DefaultAzureCredential();
            DeviceUpdateClient client = new DeviceUpdateClient(endpoint, "<InstanceId>", credential);

            Operation operation = await client.DeleteUpdateAsync(WaitUntil.Completed, "<provider>", "<name>", "<version>");
        }

        [Test]
        [Ignore("Only validating compilation of examples")]
        public void Example_DeleteUpdate_AllParameters()
        {
            Uri endpoint = new Uri("<endpoint>");
            TokenCredential credential = new DefaultAzureCredential();
            DeviceUpdateClient client = new DeviceUpdateClient(endpoint, "<InstanceId>", credential);

            Operation operation = client.DeleteUpdate(WaitUntil.Completed, "<provider>", "<name>", "<version>");
        }

        [Test]
        [Ignore("Only validating compilation of examples")]
        public async Task Example_DeleteUpdate_AllParameters_Async()
        {
            Uri endpoint = new Uri("<endpoint>");
            TokenCredential credential = new DefaultAzureCredential();
            DeviceUpdateClient client = new DeviceUpdateClient(endpoint, "<InstanceId>", credential);

            Operation operation = await client.DeleteUpdateAsync(WaitUntil.Completed, "<provider>", "<name>", "<version>");
        }

        [Test]
        [Ignore("Only validating compilation of examples")]
        public void Example_StartImportUpdate_ShortVersion()
        {
            Uri endpoint = new Uri("<endpoint>");
            TokenCredential credential = new DefaultAzureCredential();
            DeviceUpdateClient client = new DeviceUpdateClient(endpoint, "<InstanceId>", credential);

            using RequestContent content = RequestContent.Create(new object[]
            {
new
{
importManifest = new
{
url = "<url>",
sizeInBytes = 1234L,
hashes = new
{
key = "<hashes>",
},
},
}
            });
            Operation operation = client.StartImportUpdate(WaitUntil.Completed, content);
        }

        [Test]
        [Ignore("Only validating compilation of examples")]
        public async Task Example_StartImportUpdate_ShortVersion_Async()
        {
            Uri endpoint = new Uri("<endpoint>");
            TokenCredential credential = new DefaultAzureCredential();
            DeviceUpdateClient client = new DeviceUpdateClient(endpoint, "<InstanceId>", credential);

            using RequestContent content = RequestContent.Create(new object[]
            {
new
{
importManifest = new
{
url = "<url>",
sizeInBytes = 1234L,
hashes = new
{
key = "<hashes>",
},
},
}
            });
            Operation operation = await client.StartImportUpdateAsync(WaitUntil.Completed, content);
        }

        [Test]
        [Ignore("Only validating compilation of examples")]
        public void Example_StartImportUpdate_AllParameters()
        {
            Uri endpoint = new Uri("<endpoint>");
            TokenCredential credential = new DefaultAzureCredential();
            DeviceUpdateClient client = new DeviceUpdateClient(endpoint, "<InstanceId>", credential);

            using RequestContent content = RequestContent.Create(new object[]
            {
new
{
importManifest = new
{
url = "<url>",
sizeInBytes = 1234L,
hashes = new
{
key = "<hashes>",
},
},
friendlyName = "<friendlyName>",
files = new object[]
{
new
{
filename = "<filename>",
url = "<url>",
}
},
}
            });
            Operation operation = client.StartImportUpdate(WaitUntil.Completed, content);
        }

        [Test]
        [Ignore("Only validating compilation of examples")]
        public async Task Example_StartImportUpdate_AllParameters_Async()
        {
            Uri endpoint = new Uri("<endpoint>");
            TokenCredential credential = new DefaultAzureCredential();
            DeviceUpdateClient client = new DeviceUpdateClient(endpoint, "<InstanceId>", credential);

            using RequestContent content = RequestContent.Create(new object[]
            {
new
{
importManifest = new
{
url = "<url>",
sizeInBytes = 1234L,
hashes = new
{
key = "<hashes>",
},
},
friendlyName = "<friendlyName>",
files = new object[]
{
new
{
filename = "<filename>",
url = "<url>",
}
},
}
            });
            Operation operation = await client.StartImportUpdateAsync(WaitUntil.Completed, content);
        }
    }
}
