// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.

// <auto-generated/>

#nullable disable

using System;
using System.Text.Json;
using System.Threading.Tasks;
using Azure.Core;
using Azure.Identity;
using NUnit.Framework;

namespace Azure.IoT.DeviceUpdate.Samples
{
    public partial class Samples_DeviceManagementClient
    {
        [Test]
        [Ignore("Only validating compilation of examples")]
        public void Example_GetDeviceClass_ShortVersion()
        {
            Uri endpoint = new Uri("<endpoint>");
            TokenCredential credential = new DefaultAzureCredential();
            DeviceManagementClient client = new DeviceManagementClient(endpoint, "<InstanceId>", credential);

            Response response = client.GetDeviceClass("<deviceClassId>");

            JsonElement result = JsonDocument.Parse(response.ContentStream).RootElement;
            Console.WriteLine(result.GetProperty("deviceClassId").ToString());
            Console.WriteLine(result.GetProperty("deviceClassProperties").GetProperty("compatProperties").GetProperty("<key>").ToString());
        }

        [Test]
        [Ignore("Only validating compilation of examples")]
        public async Task Example_GetDeviceClass_ShortVersion_Async()
        {
            Uri endpoint = new Uri("<endpoint>");
            TokenCredential credential = new DefaultAzureCredential();
            DeviceManagementClient client = new DeviceManagementClient(endpoint, "<InstanceId>", credential);

            Response response = await client.GetDeviceClassAsync("<deviceClassId>");

            JsonElement result = JsonDocument.Parse(response.ContentStream).RootElement;
            Console.WriteLine(result.GetProperty("deviceClassId").ToString());
            Console.WriteLine(result.GetProperty("deviceClassProperties").GetProperty("compatProperties").GetProperty("<key>").ToString());
        }

        [Test]
        [Ignore("Only validating compilation of examples")]
        public void Example_GetDeviceClass_AllParameters()
        {
            Uri endpoint = new Uri("<endpoint>");
            TokenCredential credential = new DefaultAzureCredential();
            DeviceManagementClient client = new DeviceManagementClient(endpoint, "<InstanceId>", credential);

            Response response = client.GetDeviceClass("<deviceClassId>");

            JsonElement result = JsonDocument.Parse(response.ContentStream).RootElement;
            Console.WriteLine(result.GetProperty("deviceClassId").ToString());
            Console.WriteLine(result.GetProperty("friendlyName").ToString());
            Console.WriteLine(result.GetProperty("deviceClassProperties").GetProperty("contractModel").GetProperty("id").ToString());
            Console.WriteLine(result.GetProperty("deviceClassProperties").GetProperty("contractModel").GetProperty("name").ToString());
            Console.WriteLine(result.GetProperty("deviceClassProperties").GetProperty("compatProperties").GetProperty("<key>").ToString());
            Console.WriteLine(result.GetProperty("bestCompatibleUpdate").GetProperty("updateId").GetProperty("provider").ToString());
            Console.WriteLine(result.GetProperty("bestCompatibleUpdate").GetProperty("updateId").GetProperty("name").ToString());
            Console.WriteLine(result.GetProperty("bestCompatibleUpdate").GetProperty("updateId").GetProperty("version").ToString());
            Console.WriteLine(result.GetProperty("bestCompatibleUpdate").GetProperty("description").ToString());
            Console.WriteLine(result.GetProperty("bestCompatibleUpdate").GetProperty("friendlyName").ToString());
        }

        [Test]
        [Ignore("Only validating compilation of examples")]
        public async Task Example_GetDeviceClass_AllParameters_Async()
        {
            Uri endpoint = new Uri("<endpoint>");
            TokenCredential credential = new DefaultAzureCredential();
            DeviceManagementClient client = new DeviceManagementClient(endpoint, "<InstanceId>", credential);

            Response response = await client.GetDeviceClassAsync("<deviceClassId>");

            JsonElement result = JsonDocument.Parse(response.ContentStream).RootElement;
            Console.WriteLine(result.GetProperty("deviceClassId").ToString());
            Console.WriteLine(result.GetProperty("friendlyName").ToString());
            Console.WriteLine(result.GetProperty("deviceClassProperties").GetProperty("contractModel").GetProperty("id").ToString());
            Console.WriteLine(result.GetProperty("deviceClassProperties").GetProperty("contractModel").GetProperty("name").ToString());
            Console.WriteLine(result.GetProperty("deviceClassProperties").GetProperty("compatProperties").GetProperty("<key>").ToString());
            Console.WriteLine(result.GetProperty("bestCompatibleUpdate").GetProperty("updateId").GetProperty("provider").ToString());
            Console.WriteLine(result.GetProperty("bestCompatibleUpdate").GetProperty("updateId").GetProperty("name").ToString());
            Console.WriteLine(result.GetProperty("bestCompatibleUpdate").GetProperty("updateId").GetProperty("version").ToString());
            Console.WriteLine(result.GetProperty("bestCompatibleUpdate").GetProperty("description").ToString());
            Console.WriteLine(result.GetProperty("bestCompatibleUpdate").GetProperty("friendlyName").ToString());
        }

        [Test]
        [Ignore("Only validating compilation of examples")]
        public void Example_UpdateDeviceClass_ShortVersion()
        {
            Uri endpoint = new Uri("<endpoint>");
            TokenCredential credential = new DefaultAzureCredential();
            DeviceManagementClient client = new DeviceManagementClient(endpoint, "<InstanceId>", credential);

            using RequestContent content = RequestContent.Create(new
            {
                friendlyName = "<friendlyName>",
            });
            Response response = client.UpdateDeviceClass("<deviceClassId>", content);

            JsonElement result = JsonDocument.Parse(response.ContentStream).RootElement;
            Console.WriteLine(result.GetProperty("deviceClassId").ToString());
            Console.WriteLine(result.GetProperty("deviceClassProperties").GetProperty("compatProperties").GetProperty("<key>").ToString());
        }

        [Test]
        [Ignore("Only validating compilation of examples")]
        public async Task Example_UpdateDeviceClass_ShortVersion_Async()
        {
            Uri endpoint = new Uri("<endpoint>");
            TokenCredential credential = new DefaultAzureCredential();
            DeviceManagementClient client = new DeviceManagementClient(endpoint, "<InstanceId>", credential);

            using RequestContent content = RequestContent.Create(new
            {
                friendlyName = "<friendlyName>",
            });
            Response response = await client.UpdateDeviceClassAsync("<deviceClassId>", content);

            JsonElement result = JsonDocument.Parse(response.ContentStream).RootElement;
            Console.WriteLine(result.GetProperty("deviceClassId").ToString());
            Console.WriteLine(result.GetProperty("deviceClassProperties").GetProperty("compatProperties").GetProperty("<key>").ToString());
        }

        [Test]
        [Ignore("Only validating compilation of examples")]
        public void Example_UpdateDeviceClass_AllParameters()
        {
            Uri endpoint = new Uri("<endpoint>");
            TokenCredential credential = new DefaultAzureCredential();
            DeviceManagementClient client = new DeviceManagementClient(endpoint, "<InstanceId>", credential);

            using RequestContent content = RequestContent.Create(new
            {
                friendlyName = "<friendlyName>",
            });
            Response response = client.UpdateDeviceClass("<deviceClassId>", content);

            JsonElement result = JsonDocument.Parse(response.ContentStream).RootElement;
            Console.WriteLine(result.GetProperty("deviceClassId").ToString());
            Console.WriteLine(result.GetProperty("friendlyName").ToString());
            Console.WriteLine(result.GetProperty("deviceClassProperties").GetProperty("contractModel").GetProperty("id").ToString());
            Console.WriteLine(result.GetProperty("deviceClassProperties").GetProperty("contractModel").GetProperty("name").ToString());
            Console.WriteLine(result.GetProperty("deviceClassProperties").GetProperty("compatProperties").GetProperty("<key>").ToString());
            Console.WriteLine(result.GetProperty("bestCompatibleUpdate").GetProperty("updateId").GetProperty("provider").ToString());
            Console.WriteLine(result.GetProperty("bestCompatibleUpdate").GetProperty("updateId").GetProperty("name").ToString());
            Console.WriteLine(result.GetProperty("bestCompatibleUpdate").GetProperty("updateId").GetProperty("version").ToString());
            Console.WriteLine(result.GetProperty("bestCompatibleUpdate").GetProperty("description").ToString());
            Console.WriteLine(result.GetProperty("bestCompatibleUpdate").GetProperty("friendlyName").ToString());
        }

        [Test]
        [Ignore("Only validating compilation of examples")]
        public async Task Example_UpdateDeviceClass_AllParameters_Async()
        {
            Uri endpoint = new Uri("<endpoint>");
            TokenCredential credential = new DefaultAzureCredential();
            DeviceManagementClient client = new DeviceManagementClient(endpoint, "<InstanceId>", credential);

            using RequestContent content = RequestContent.Create(new
            {
                friendlyName = "<friendlyName>",
            });
            Response response = await client.UpdateDeviceClassAsync("<deviceClassId>", content);

            JsonElement result = JsonDocument.Parse(response.ContentStream).RootElement;
            Console.WriteLine(result.GetProperty("deviceClassId").ToString());
            Console.WriteLine(result.GetProperty("friendlyName").ToString());
            Console.WriteLine(result.GetProperty("deviceClassProperties").GetProperty("contractModel").GetProperty("id").ToString());
            Console.WriteLine(result.GetProperty("deviceClassProperties").GetProperty("contractModel").GetProperty("name").ToString());
            Console.WriteLine(result.GetProperty("deviceClassProperties").GetProperty("compatProperties").GetProperty("<key>").ToString());
            Console.WriteLine(result.GetProperty("bestCompatibleUpdate").GetProperty("updateId").GetProperty("provider").ToString());
            Console.WriteLine(result.GetProperty("bestCompatibleUpdate").GetProperty("updateId").GetProperty("name").ToString());
            Console.WriteLine(result.GetProperty("bestCompatibleUpdate").GetProperty("updateId").GetProperty("version").ToString());
            Console.WriteLine(result.GetProperty("bestCompatibleUpdate").GetProperty("description").ToString());
            Console.WriteLine(result.GetProperty("bestCompatibleUpdate").GetProperty("friendlyName").ToString());
        }

        [Test]
        [Ignore("Only validating compilation of examples")]
        public void Example_DeleteDeviceClass_ShortVersion()
        {
            Uri endpoint = new Uri("<endpoint>");
            TokenCredential credential = new DefaultAzureCredential();
            DeviceManagementClient client = new DeviceManagementClient(endpoint, "<InstanceId>", credential);

            Response response = client.DeleteDeviceClass("<deviceClassId>");

            Console.WriteLine(response.Status);
        }

        [Test]
        [Ignore("Only validating compilation of examples")]
        public async Task Example_DeleteDeviceClass_ShortVersion_Async()
        {
            Uri endpoint = new Uri("<endpoint>");
            TokenCredential credential = new DefaultAzureCredential();
            DeviceManagementClient client = new DeviceManagementClient(endpoint, "<InstanceId>", credential);

            Response response = await client.DeleteDeviceClassAsync("<deviceClassId>");

            Console.WriteLine(response.Status);
        }

        [Test]
        [Ignore("Only validating compilation of examples")]
        public void Example_DeleteDeviceClass_AllParameters()
        {
            Uri endpoint = new Uri("<endpoint>");
            TokenCredential credential = new DefaultAzureCredential();
            DeviceManagementClient client = new DeviceManagementClient(endpoint, "<InstanceId>", credential);

            Response response = client.DeleteDeviceClass("<deviceClassId>");

            Console.WriteLine(response.Status);
        }

        [Test]
        [Ignore("Only validating compilation of examples")]
        public async Task Example_DeleteDeviceClass_AllParameters_Async()
        {
            Uri endpoint = new Uri("<endpoint>");
            TokenCredential credential = new DefaultAzureCredential();
            DeviceManagementClient client = new DeviceManagementClient(endpoint, "<InstanceId>", credential);

            Response response = await client.DeleteDeviceClassAsync("<deviceClassId>");

            Console.WriteLine(response.Status);
        }

        [Test]
        [Ignore("Only validating compilation of examples")]
        public void Example_GetDevice_ShortVersion()
        {
            Uri endpoint = new Uri("<endpoint>");
            TokenCredential credential = new DefaultAzureCredential();
            DeviceManagementClient client = new DeviceManagementClient(endpoint, "<InstanceId>", credential);

            Response response = client.GetDevice("<deviceId>");

            JsonElement result = JsonDocument.Parse(response.ContentStream).RootElement;
            Console.WriteLine(result.GetProperty("deviceId").ToString());
            Console.WriteLine(result.GetProperty("deviceClassId").ToString());
            Console.WriteLine(result.GetProperty("onLatestUpdate").ToString());
        }

        [Test]
        [Ignore("Only validating compilation of examples")]
        public async Task Example_GetDevice_ShortVersion_Async()
        {
            Uri endpoint = new Uri("<endpoint>");
            TokenCredential credential = new DefaultAzureCredential();
            DeviceManagementClient client = new DeviceManagementClient(endpoint, "<InstanceId>", credential);

            Response response = await client.GetDeviceAsync("<deviceId>");

            JsonElement result = JsonDocument.Parse(response.ContentStream).RootElement;
            Console.WriteLine(result.GetProperty("deviceId").ToString());
            Console.WriteLine(result.GetProperty("deviceClassId").ToString());
            Console.WriteLine(result.GetProperty("onLatestUpdate").ToString());
        }

        [Test]
        [Ignore("Only validating compilation of examples")]
        public void Example_GetDevice_AllParameters()
        {
            Uri endpoint = new Uri("<endpoint>");
            TokenCredential credential = new DefaultAzureCredential();
            DeviceManagementClient client = new DeviceManagementClient(endpoint, "<InstanceId>", credential);

            Response response = client.GetDevice("<deviceId>");

            JsonElement result = JsonDocument.Parse(response.ContentStream).RootElement;
            Console.WriteLine(result.GetProperty("deviceId").ToString());
            Console.WriteLine(result.GetProperty("moduleId").ToString());
            Console.WriteLine(result.GetProperty("deviceClassId").ToString());
            Console.WriteLine(result.GetProperty("groupId").ToString());
            Console.WriteLine(result.GetProperty("lastAttemptedUpdate").GetProperty("updateId").GetProperty("provider").ToString());
            Console.WriteLine(result.GetProperty("lastAttemptedUpdate").GetProperty("updateId").GetProperty("name").ToString());
            Console.WriteLine(result.GetProperty("lastAttemptedUpdate").GetProperty("updateId").GetProperty("version").ToString());
            Console.WriteLine(result.GetProperty("lastAttemptedUpdate").GetProperty("description").ToString());
            Console.WriteLine(result.GetProperty("lastAttemptedUpdate").GetProperty("friendlyName").ToString());
            Console.WriteLine(result.GetProperty("deploymentStatus").ToString());
            Console.WriteLine(result.GetProperty("installedUpdate").GetProperty("updateId").GetProperty("provider").ToString());
            Console.WriteLine(result.GetProperty("installedUpdate").GetProperty("updateId").GetProperty("name").ToString());
            Console.WriteLine(result.GetProperty("installedUpdate").GetProperty("updateId").GetProperty("version").ToString());
            Console.WriteLine(result.GetProperty("installedUpdate").GetProperty("description").ToString());
            Console.WriteLine(result.GetProperty("installedUpdate").GetProperty("friendlyName").ToString());
            Console.WriteLine(result.GetProperty("onLatestUpdate").ToString());
            Console.WriteLine(result.GetProperty("lastDeploymentId").ToString());
            Console.WriteLine(result.GetProperty("lastInstallResult").GetProperty("resultCode").ToString());
            Console.WriteLine(result.GetProperty("lastInstallResult").GetProperty("extendedResultCode").ToString());
            Console.WriteLine(result.GetProperty("lastInstallResult").GetProperty("resultDetails").ToString());
            Console.WriteLine(result.GetProperty("lastInstallResult").GetProperty("stepResults")[0].GetProperty("update").GetProperty("updateId").GetProperty("provider").ToString());
            Console.WriteLine(result.GetProperty("lastInstallResult").GetProperty("stepResults")[0].GetProperty("update").GetProperty("updateId").GetProperty("name").ToString());
            Console.WriteLine(result.GetProperty("lastInstallResult").GetProperty("stepResults")[0].GetProperty("update").GetProperty("updateId").GetProperty("version").ToString());
            Console.WriteLine(result.GetProperty("lastInstallResult").GetProperty("stepResults")[0].GetProperty("update").GetProperty("description").ToString());
            Console.WriteLine(result.GetProperty("lastInstallResult").GetProperty("stepResults")[0].GetProperty("update").GetProperty("friendlyName").ToString());
            Console.WriteLine(result.GetProperty("lastInstallResult").GetProperty("stepResults")[0].GetProperty("description").ToString());
            Console.WriteLine(result.GetProperty("lastInstallResult").GetProperty("stepResults")[0].GetProperty("resultCode").ToString());
            Console.WriteLine(result.GetProperty("lastInstallResult").GetProperty("stepResults")[0].GetProperty("extendedResultCode").ToString());
            Console.WriteLine(result.GetProperty("lastInstallResult").GetProperty("stepResults")[0].GetProperty("resultDetails").ToString());
        }

        [Test]
        [Ignore("Only validating compilation of examples")]
        public async Task Example_GetDevice_AllParameters_Async()
        {
            Uri endpoint = new Uri("<endpoint>");
            TokenCredential credential = new DefaultAzureCredential();
            DeviceManagementClient client = new DeviceManagementClient(endpoint, "<InstanceId>", credential);

            Response response = await client.GetDeviceAsync("<deviceId>");

            JsonElement result = JsonDocument.Parse(response.ContentStream).RootElement;
            Console.WriteLine(result.GetProperty("deviceId").ToString());
            Console.WriteLine(result.GetProperty("moduleId").ToString());
            Console.WriteLine(result.GetProperty("deviceClassId").ToString());
            Console.WriteLine(result.GetProperty("groupId").ToString());
            Console.WriteLine(result.GetProperty("lastAttemptedUpdate").GetProperty("updateId").GetProperty("provider").ToString());
            Console.WriteLine(result.GetProperty("lastAttemptedUpdate").GetProperty("updateId").GetProperty("name").ToString());
            Console.WriteLine(result.GetProperty("lastAttemptedUpdate").GetProperty("updateId").GetProperty("version").ToString());
            Console.WriteLine(result.GetProperty("lastAttemptedUpdate").GetProperty("description").ToString());
            Console.WriteLine(result.GetProperty("lastAttemptedUpdate").GetProperty("friendlyName").ToString());
            Console.WriteLine(result.GetProperty("deploymentStatus").ToString());
            Console.WriteLine(result.GetProperty("installedUpdate").GetProperty("updateId").GetProperty("provider").ToString());
            Console.WriteLine(result.GetProperty("installedUpdate").GetProperty("updateId").GetProperty("name").ToString());
            Console.WriteLine(result.GetProperty("installedUpdate").GetProperty("updateId").GetProperty("version").ToString());
            Console.WriteLine(result.GetProperty("installedUpdate").GetProperty("description").ToString());
            Console.WriteLine(result.GetProperty("installedUpdate").GetProperty("friendlyName").ToString());
            Console.WriteLine(result.GetProperty("onLatestUpdate").ToString());
            Console.WriteLine(result.GetProperty("lastDeploymentId").ToString());
            Console.WriteLine(result.GetProperty("lastInstallResult").GetProperty("resultCode").ToString());
            Console.WriteLine(result.GetProperty("lastInstallResult").GetProperty("extendedResultCode").ToString());
            Console.WriteLine(result.GetProperty("lastInstallResult").GetProperty("resultDetails").ToString());
            Console.WriteLine(result.GetProperty("lastInstallResult").GetProperty("stepResults")[0].GetProperty("update").GetProperty("updateId").GetProperty("provider").ToString());
            Console.WriteLine(result.GetProperty("lastInstallResult").GetProperty("stepResults")[0].GetProperty("update").GetProperty("updateId").GetProperty("name").ToString());
            Console.WriteLine(result.GetProperty("lastInstallResult").GetProperty("stepResults")[0].GetProperty("update").GetProperty("updateId").GetProperty("version").ToString());
            Console.WriteLine(result.GetProperty("lastInstallResult").GetProperty("stepResults")[0].GetProperty("update").GetProperty("description").ToString());
            Console.WriteLine(result.GetProperty("lastInstallResult").GetProperty("stepResults")[0].GetProperty("update").GetProperty("friendlyName").ToString());
            Console.WriteLine(result.GetProperty("lastInstallResult").GetProperty("stepResults")[0].GetProperty("description").ToString());
            Console.WriteLine(result.GetProperty("lastInstallResult").GetProperty("stepResults")[0].GetProperty("resultCode").ToString());
            Console.WriteLine(result.GetProperty("lastInstallResult").GetProperty("stepResults")[0].GetProperty("extendedResultCode").ToString());
            Console.WriteLine(result.GetProperty("lastInstallResult").GetProperty("stepResults")[0].GetProperty("resultDetails").ToString());
        }

        [Test]
        [Ignore("Only validating compilation of examples")]
        public void Example_GetDeviceModule_ShortVersion()
        {
            Uri endpoint = new Uri("<endpoint>");
            TokenCredential credential = new DefaultAzureCredential();
            DeviceManagementClient client = new DeviceManagementClient(endpoint, "<InstanceId>", credential);

            Response response = client.GetDeviceModule("<deviceId>", "<moduleId>");

            JsonElement result = JsonDocument.Parse(response.ContentStream).RootElement;
            Console.WriteLine(result.GetProperty("deviceId").ToString());
            Console.WriteLine(result.GetProperty("deviceClassId").ToString());
            Console.WriteLine(result.GetProperty("onLatestUpdate").ToString());
        }

        [Test]
        [Ignore("Only validating compilation of examples")]
        public async Task Example_GetDeviceModule_ShortVersion_Async()
        {
            Uri endpoint = new Uri("<endpoint>");
            TokenCredential credential = new DefaultAzureCredential();
            DeviceManagementClient client = new DeviceManagementClient(endpoint, "<InstanceId>", credential);

            Response response = await client.GetDeviceModuleAsync("<deviceId>", "<moduleId>");

            JsonElement result = JsonDocument.Parse(response.ContentStream).RootElement;
            Console.WriteLine(result.GetProperty("deviceId").ToString());
            Console.WriteLine(result.GetProperty("deviceClassId").ToString());
            Console.WriteLine(result.GetProperty("onLatestUpdate").ToString());
        }

        [Test]
        [Ignore("Only validating compilation of examples")]
        public void Example_GetDeviceModule_AllParameters()
        {
            Uri endpoint = new Uri("<endpoint>");
            TokenCredential credential = new DefaultAzureCredential();
            DeviceManagementClient client = new DeviceManagementClient(endpoint, "<InstanceId>", credential);

            Response response = client.GetDeviceModule("<deviceId>", "<moduleId>");

            JsonElement result = JsonDocument.Parse(response.ContentStream).RootElement;
            Console.WriteLine(result.GetProperty("deviceId").ToString());
            Console.WriteLine(result.GetProperty("moduleId").ToString());
            Console.WriteLine(result.GetProperty("deviceClassId").ToString());
            Console.WriteLine(result.GetProperty("groupId").ToString());
            Console.WriteLine(result.GetProperty("lastAttemptedUpdate").GetProperty("updateId").GetProperty("provider").ToString());
            Console.WriteLine(result.GetProperty("lastAttemptedUpdate").GetProperty("updateId").GetProperty("name").ToString());
            Console.WriteLine(result.GetProperty("lastAttemptedUpdate").GetProperty("updateId").GetProperty("version").ToString());
            Console.WriteLine(result.GetProperty("lastAttemptedUpdate").GetProperty("description").ToString());
            Console.WriteLine(result.GetProperty("lastAttemptedUpdate").GetProperty("friendlyName").ToString());
            Console.WriteLine(result.GetProperty("deploymentStatus").ToString());
            Console.WriteLine(result.GetProperty("installedUpdate").GetProperty("updateId").GetProperty("provider").ToString());
            Console.WriteLine(result.GetProperty("installedUpdate").GetProperty("updateId").GetProperty("name").ToString());
            Console.WriteLine(result.GetProperty("installedUpdate").GetProperty("updateId").GetProperty("version").ToString());
            Console.WriteLine(result.GetProperty("installedUpdate").GetProperty("description").ToString());
            Console.WriteLine(result.GetProperty("installedUpdate").GetProperty("friendlyName").ToString());
            Console.WriteLine(result.GetProperty("onLatestUpdate").ToString());
            Console.WriteLine(result.GetProperty("lastDeploymentId").ToString());
            Console.WriteLine(result.GetProperty("lastInstallResult").GetProperty("resultCode").ToString());
            Console.WriteLine(result.GetProperty("lastInstallResult").GetProperty("extendedResultCode").ToString());
            Console.WriteLine(result.GetProperty("lastInstallResult").GetProperty("resultDetails").ToString());
            Console.WriteLine(result.GetProperty("lastInstallResult").GetProperty("stepResults")[0].GetProperty("update").GetProperty("updateId").GetProperty("provider").ToString());
            Console.WriteLine(result.GetProperty("lastInstallResult").GetProperty("stepResults")[0].GetProperty("update").GetProperty("updateId").GetProperty("name").ToString());
            Console.WriteLine(result.GetProperty("lastInstallResult").GetProperty("stepResults")[0].GetProperty("update").GetProperty("updateId").GetProperty("version").ToString());
            Console.WriteLine(result.GetProperty("lastInstallResult").GetProperty("stepResults")[0].GetProperty("update").GetProperty("description").ToString());
            Console.WriteLine(result.GetProperty("lastInstallResult").GetProperty("stepResults")[0].GetProperty("update").GetProperty("friendlyName").ToString());
            Console.WriteLine(result.GetProperty("lastInstallResult").GetProperty("stepResults")[0].GetProperty("description").ToString());
            Console.WriteLine(result.GetProperty("lastInstallResult").GetProperty("stepResults")[0].GetProperty("resultCode").ToString());
            Console.WriteLine(result.GetProperty("lastInstallResult").GetProperty("stepResults")[0].GetProperty("extendedResultCode").ToString());
            Console.WriteLine(result.GetProperty("lastInstallResult").GetProperty("stepResults")[0].GetProperty("resultDetails").ToString());
        }

        [Test]
        [Ignore("Only validating compilation of examples")]
        public async Task Example_GetDeviceModule_AllParameters_Async()
        {
            Uri endpoint = new Uri("<endpoint>");
            TokenCredential credential = new DefaultAzureCredential();
            DeviceManagementClient client = new DeviceManagementClient(endpoint, "<InstanceId>", credential);

            Response response = await client.GetDeviceModuleAsync("<deviceId>", "<moduleId>");

            JsonElement result = JsonDocument.Parse(response.ContentStream).RootElement;
            Console.WriteLine(result.GetProperty("deviceId").ToString());
            Console.WriteLine(result.GetProperty("moduleId").ToString());
            Console.WriteLine(result.GetProperty("deviceClassId").ToString());
            Console.WriteLine(result.GetProperty("groupId").ToString());
            Console.WriteLine(result.GetProperty("lastAttemptedUpdate").GetProperty("updateId").GetProperty("provider").ToString());
            Console.WriteLine(result.GetProperty("lastAttemptedUpdate").GetProperty("updateId").GetProperty("name").ToString());
            Console.WriteLine(result.GetProperty("lastAttemptedUpdate").GetProperty("updateId").GetProperty("version").ToString());
            Console.WriteLine(result.GetProperty("lastAttemptedUpdate").GetProperty("description").ToString());
            Console.WriteLine(result.GetProperty("lastAttemptedUpdate").GetProperty("friendlyName").ToString());
            Console.WriteLine(result.GetProperty("deploymentStatus").ToString());
            Console.WriteLine(result.GetProperty("installedUpdate").GetProperty("updateId").GetProperty("provider").ToString());
            Console.WriteLine(result.GetProperty("installedUpdate").GetProperty("updateId").GetProperty("name").ToString());
            Console.WriteLine(result.GetProperty("installedUpdate").GetProperty("updateId").GetProperty("version").ToString());
            Console.WriteLine(result.GetProperty("installedUpdate").GetProperty("description").ToString());
            Console.WriteLine(result.GetProperty("installedUpdate").GetProperty("friendlyName").ToString());
            Console.WriteLine(result.GetProperty("onLatestUpdate").ToString());
            Console.WriteLine(result.GetProperty("lastDeploymentId").ToString());
            Console.WriteLine(result.GetProperty("lastInstallResult").GetProperty("resultCode").ToString());
            Console.WriteLine(result.GetProperty("lastInstallResult").GetProperty("extendedResultCode").ToString());
            Console.WriteLine(result.GetProperty("lastInstallResult").GetProperty("resultDetails").ToString());
            Console.WriteLine(result.GetProperty("lastInstallResult").GetProperty("stepResults")[0].GetProperty("update").GetProperty("updateId").GetProperty("provider").ToString());
            Console.WriteLine(result.GetProperty("lastInstallResult").GetProperty("stepResults")[0].GetProperty("update").GetProperty("updateId").GetProperty("name").ToString());
            Console.WriteLine(result.GetProperty("lastInstallResult").GetProperty("stepResults")[0].GetProperty("update").GetProperty("updateId").GetProperty("version").ToString());
            Console.WriteLine(result.GetProperty("lastInstallResult").GetProperty("stepResults")[0].GetProperty("update").GetProperty("description").ToString());
            Console.WriteLine(result.GetProperty("lastInstallResult").GetProperty("stepResults")[0].GetProperty("update").GetProperty("friendlyName").ToString());
            Console.WriteLine(result.GetProperty("lastInstallResult").GetProperty("stepResults")[0].GetProperty("description").ToString());
            Console.WriteLine(result.GetProperty("lastInstallResult").GetProperty("stepResults")[0].GetProperty("resultCode").ToString());
            Console.WriteLine(result.GetProperty("lastInstallResult").GetProperty("stepResults")[0].GetProperty("extendedResultCode").ToString());
            Console.WriteLine(result.GetProperty("lastInstallResult").GetProperty("stepResults")[0].GetProperty("resultDetails").ToString());
        }

        [Test]
        [Ignore("Only validating compilation of examples")]
        public void Example_GetUpdateCompliance_ShortVersion()
        {
            Uri endpoint = new Uri("<endpoint>");
            TokenCredential credential = new DefaultAzureCredential();
            DeviceManagementClient client = new DeviceManagementClient(endpoint, "<InstanceId>", credential);

            Response response = client.GetUpdateCompliance();

            JsonElement result = JsonDocument.Parse(response.ContentStream).RootElement;
            Console.WriteLine(result.GetProperty("totalDeviceCount").ToString());
            Console.WriteLine(result.GetProperty("onLatestUpdateDeviceCount").ToString());
            Console.WriteLine(result.GetProperty("newUpdatesAvailableDeviceCount").ToString());
            Console.WriteLine(result.GetProperty("updatesInProgressDeviceCount").ToString());
        }

        [Test]
        [Ignore("Only validating compilation of examples")]
        public async Task Example_GetUpdateCompliance_ShortVersion_Async()
        {
            Uri endpoint = new Uri("<endpoint>");
            TokenCredential credential = new DefaultAzureCredential();
            DeviceManagementClient client = new DeviceManagementClient(endpoint, "<InstanceId>", credential);

            Response response = await client.GetUpdateComplianceAsync();

            JsonElement result = JsonDocument.Parse(response.ContentStream).RootElement;
            Console.WriteLine(result.GetProperty("totalDeviceCount").ToString());
            Console.WriteLine(result.GetProperty("onLatestUpdateDeviceCount").ToString());
            Console.WriteLine(result.GetProperty("newUpdatesAvailableDeviceCount").ToString());
            Console.WriteLine(result.GetProperty("updatesInProgressDeviceCount").ToString());
        }

        [Test]
        [Ignore("Only validating compilation of examples")]
        public void Example_GetUpdateCompliance_AllParameters()
        {
            Uri endpoint = new Uri("<endpoint>");
            TokenCredential credential = new DefaultAzureCredential();
            DeviceManagementClient client = new DeviceManagementClient(endpoint, "<InstanceId>", credential);

            Response response = client.GetUpdateCompliance();

            JsonElement result = JsonDocument.Parse(response.ContentStream).RootElement;
            Console.WriteLine(result.GetProperty("totalDeviceCount").ToString());
            Console.WriteLine(result.GetProperty("onLatestUpdateDeviceCount").ToString());
            Console.WriteLine(result.GetProperty("newUpdatesAvailableDeviceCount").ToString());
            Console.WriteLine(result.GetProperty("updatesInProgressDeviceCount").ToString());
        }

        [Test]
        [Ignore("Only validating compilation of examples")]
        public async Task Example_GetUpdateCompliance_AllParameters_Async()
        {
            Uri endpoint = new Uri("<endpoint>");
            TokenCredential credential = new DefaultAzureCredential();
            DeviceManagementClient client = new DeviceManagementClient(endpoint, "<InstanceId>", credential);

            Response response = await client.GetUpdateComplianceAsync();

            JsonElement result = JsonDocument.Parse(response.ContentStream).RootElement;
            Console.WriteLine(result.GetProperty("totalDeviceCount").ToString());
            Console.WriteLine(result.GetProperty("onLatestUpdateDeviceCount").ToString());
            Console.WriteLine(result.GetProperty("newUpdatesAvailableDeviceCount").ToString());
            Console.WriteLine(result.GetProperty("updatesInProgressDeviceCount").ToString());
        }

        [Test]
        [Ignore("Only validating compilation of examples")]
        public void Example_GetGroup_ShortVersion()
        {
            Uri endpoint = new Uri("<endpoint>");
            TokenCredential credential = new DefaultAzureCredential();
            DeviceManagementClient client = new DeviceManagementClient(endpoint, "<InstanceId>", credential);

            Response response = client.GetGroup("<groupId>");

            JsonElement result = JsonDocument.Parse(response.ContentStream).RootElement;
            Console.WriteLine(result.GetProperty("groupId").ToString());
            Console.WriteLine(result.GetProperty("groupType").ToString());
            Console.WriteLine(result.GetProperty("createdDateTime").ToString());
        }

        [Test]
        [Ignore("Only validating compilation of examples")]
        public async Task Example_GetGroup_ShortVersion_Async()
        {
            Uri endpoint = new Uri("<endpoint>");
            TokenCredential credential = new DefaultAzureCredential();
            DeviceManagementClient client = new DeviceManagementClient(endpoint, "<InstanceId>", credential);

            Response response = await client.GetGroupAsync("<groupId>");

            JsonElement result = JsonDocument.Parse(response.ContentStream).RootElement;
            Console.WriteLine(result.GetProperty("groupId").ToString());
            Console.WriteLine(result.GetProperty("groupType").ToString());
            Console.WriteLine(result.GetProperty("createdDateTime").ToString());
        }

        [Test]
        [Ignore("Only validating compilation of examples")]
        public void Example_GetGroup_AllParameters()
        {
            Uri endpoint = new Uri("<endpoint>");
            TokenCredential credential = new DefaultAzureCredential();
            DeviceManagementClient client = new DeviceManagementClient(endpoint, "<InstanceId>", credential);

            Response response = client.GetGroup("<groupId>");

            JsonElement result = JsonDocument.Parse(response.ContentStream).RootElement;
            Console.WriteLine(result.GetProperty("groupId").ToString());
            Console.WriteLine(result.GetProperty("groupType").ToString());
            Console.WriteLine(result.GetProperty("createdDateTime").ToString());
            Console.WriteLine(result.GetProperty("deviceCount").ToString());
            Console.WriteLine(result.GetProperty("subgroupsWithNewUpdatesAvailableCount").ToString());
            Console.WriteLine(result.GetProperty("subgroupsWithUpdatesInProgressCount").ToString());
            Console.WriteLine(result.GetProperty("subgroupsWithOnLatestUpdateCount").ToString());
            Console.WriteLine(result.GetProperty("deployments")[0].ToString());
        }

        [Test]
        [Ignore("Only validating compilation of examples")]
        public async Task Example_GetGroup_AllParameters_Async()
        {
            Uri endpoint = new Uri("<endpoint>");
            TokenCredential credential = new DefaultAzureCredential();
            DeviceManagementClient client = new DeviceManagementClient(endpoint, "<InstanceId>", credential);

            Response response = await client.GetGroupAsync("<groupId>");

            JsonElement result = JsonDocument.Parse(response.ContentStream).RootElement;
            Console.WriteLine(result.GetProperty("groupId").ToString());
            Console.WriteLine(result.GetProperty("groupType").ToString());
            Console.WriteLine(result.GetProperty("createdDateTime").ToString());
            Console.WriteLine(result.GetProperty("deviceCount").ToString());
            Console.WriteLine(result.GetProperty("subgroupsWithNewUpdatesAvailableCount").ToString());
            Console.WriteLine(result.GetProperty("subgroupsWithUpdatesInProgressCount").ToString());
            Console.WriteLine(result.GetProperty("subgroupsWithOnLatestUpdateCount").ToString());
            Console.WriteLine(result.GetProperty("deployments")[0].ToString());
        }

        [Test]
        [Ignore("Only validating compilation of examples")]
        public void Example_DeleteGroup_ShortVersion()
        {
            Uri endpoint = new Uri("<endpoint>");
            TokenCredential credential = new DefaultAzureCredential();
            DeviceManagementClient client = new DeviceManagementClient(endpoint, "<InstanceId>", credential);

            Response response = client.DeleteGroup("<groupId>");

            Console.WriteLine(response.Status);
        }

        [Test]
        [Ignore("Only validating compilation of examples")]
        public async Task Example_DeleteGroup_ShortVersion_Async()
        {
            Uri endpoint = new Uri("<endpoint>");
            TokenCredential credential = new DefaultAzureCredential();
            DeviceManagementClient client = new DeviceManagementClient(endpoint, "<InstanceId>", credential);

            Response response = await client.DeleteGroupAsync("<groupId>");

            Console.WriteLine(response.Status);
        }

        [Test]
        [Ignore("Only validating compilation of examples")]
        public void Example_DeleteGroup_AllParameters()
        {
            Uri endpoint = new Uri("<endpoint>");
            TokenCredential credential = new DefaultAzureCredential();
            DeviceManagementClient client = new DeviceManagementClient(endpoint, "<InstanceId>", credential);

            Response response = client.DeleteGroup("<groupId>");

            Console.WriteLine(response.Status);
        }

        [Test]
        [Ignore("Only validating compilation of examples")]
        public async Task Example_DeleteGroup_AllParameters_Async()
        {
            Uri endpoint = new Uri("<endpoint>");
            TokenCredential credential = new DefaultAzureCredential();
            DeviceManagementClient client = new DeviceManagementClient(endpoint, "<InstanceId>", credential);

            Response response = await client.DeleteGroupAsync("<groupId>");

            Console.WriteLine(response.Status);
        }

        [Test]
        [Ignore("Only validating compilation of examples")]
        public void Example_GetUpdateComplianceForGroup_ShortVersion()
        {
            Uri endpoint = new Uri("<endpoint>");
            TokenCredential credential = new DefaultAzureCredential();
            DeviceManagementClient client = new DeviceManagementClient(endpoint, "<InstanceId>", credential);

            Response response = client.GetUpdateComplianceForGroup("<groupId>");

            JsonElement result = JsonDocument.Parse(response.ContentStream).RootElement;
            Console.WriteLine(result.GetProperty("totalDeviceCount").ToString());
            Console.WriteLine(result.GetProperty("onLatestUpdateDeviceCount").ToString());
            Console.WriteLine(result.GetProperty("newUpdatesAvailableDeviceCount").ToString());
            Console.WriteLine(result.GetProperty("updatesInProgressDeviceCount").ToString());
        }

        [Test]
        [Ignore("Only validating compilation of examples")]
        public async Task Example_GetUpdateComplianceForGroup_ShortVersion_Async()
        {
            Uri endpoint = new Uri("<endpoint>");
            TokenCredential credential = new DefaultAzureCredential();
            DeviceManagementClient client = new DeviceManagementClient(endpoint, "<InstanceId>", credential);

            Response response = await client.GetUpdateComplianceForGroupAsync("<groupId>");

            JsonElement result = JsonDocument.Parse(response.ContentStream).RootElement;
            Console.WriteLine(result.GetProperty("totalDeviceCount").ToString());
            Console.WriteLine(result.GetProperty("onLatestUpdateDeviceCount").ToString());
            Console.WriteLine(result.GetProperty("newUpdatesAvailableDeviceCount").ToString());
            Console.WriteLine(result.GetProperty("updatesInProgressDeviceCount").ToString());
        }

        [Test]
        [Ignore("Only validating compilation of examples")]
        public void Example_GetUpdateComplianceForGroup_AllParameters()
        {
            Uri endpoint = new Uri("<endpoint>");
            TokenCredential credential = new DefaultAzureCredential();
            DeviceManagementClient client = new DeviceManagementClient(endpoint, "<InstanceId>", credential);

            Response response = client.GetUpdateComplianceForGroup("<groupId>");

            JsonElement result = JsonDocument.Parse(response.ContentStream).RootElement;
            Console.WriteLine(result.GetProperty("totalDeviceCount").ToString());
            Console.WriteLine(result.GetProperty("onLatestUpdateDeviceCount").ToString());
            Console.WriteLine(result.GetProperty("newUpdatesAvailableDeviceCount").ToString());
            Console.WriteLine(result.GetProperty("updatesInProgressDeviceCount").ToString());
        }

        [Test]
        [Ignore("Only validating compilation of examples")]
        public async Task Example_GetUpdateComplianceForGroup_AllParameters_Async()
        {
            Uri endpoint = new Uri("<endpoint>");
            TokenCredential credential = new DefaultAzureCredential();
            DeviceManagementClient client = new DeviceManagementClient(endpoint, "<InstanceId>", credential);

            Response response = await client.GetUpdateComplianceForGroupAsync("<groupId>");

            JsonElement result = JsonDocument.Parse(response.ContentStream).RootElement;
            Console.WriteLine(result.GetProperty("totalDeviceCount").ToString());
            Console.WriteLine(result.GetProperty("onLatestUpdateDeviceCount").ToString());
            Console.WriteLine(result.GetProperty("newUpdatesAvailableDeviceCount").ToString());
            Console.WriteLine(result.GetProperty("updatesInProgressDeviceCount").ToString());
        }

        [Test]
        [Ignore("Only validating compilation of examples")]
        public void Example_GetDeployment_ShortVersion()
        {
            Uri endpoint = new Uri("<endpoint>");
            TokenCredential credential = new DefaultAzureCredential();
            DeviceManagementClient client = new DeviceManagementClient(endpoint, "<InstanceId>", credential);

            Response response = client.GetDeployment("<groupId>", "<deploymentId>");

            JsonElement result = JsonDocument.Parse(response.ContentStream).RootElement;
            Console.WriteLine(result.GetProperty("deploymentId").ToString());
            Console.WriteLine(result.GetProperty("startDateTime").ToString());
            Console.WriteLine(result.GetProperty("update").GetProperty("updateId").GetProperty("provider").ToString());
            Console.WriteLine(result.GetProperty("update").GetProperty("updateId").GetProperty("name").ToString());
            Console.WriteLine(result.GetProperty("update").GetProperty("updateId").GetProperty("version").ToString());
            Console.WriteLine(result.GetProperty("groupId").ToString());
        }

        [Test]
        [Ignore("Only validating compilation of examples")]
        public async Task Example_GetDeployment_ShortVersion_Async()
        {
            Uri endpoint = new Uri("<endpoint>");
            TokenCredential credential = new DefaultAzureCredential();
            DeviceManagementClient client = new DeviceManagementClient(endpoint, "<InstanceId>", credential);

            Response response = await client.GetDeploymentAsync("<groupId>", "<deploymentId>");

            JsonElement result = JsonDocument.Parse(response.ContentStream).RootElement;
            Console.WriteLine(result.GetProperty("deploymentId").ToString());
            Console.WriteLine(result.GetProperty("startDateTime").ToString());
            Console.WriteLine(result.GetProperty("update").GetProperty("updateId").GetProperty("provider").ToString());
            Console.WriteLine(result.GetProperty("update").GetProperty("updateId").GetProperty("name").ToString());
            Console.WriteLine(result.GetProperty("update").GetProperty("updateId").GetProperty("version").ToString());
            Console.WriteLine(result.GetProperty("groupId").ToString());
        }

        [Test]
        [Ignore("Only validating compilation of examples")]
        public void Example_GetDeployment_AllParameters()
        {
            Uri endpoint = new Uri("<endpoint>");
            TokenCredential credential = new DefaultAzureCredential();
            DeviceManagementClient client = new DeviceManagementClient(endpoint, "<InstanceId>", credential);

            Response response = client.GetDeployment("<groupId>", "<deploymentId>");

            JsonElement result = JsonDocument.Parse(response.ContentStream).RootElement;
            Console.WriteLine(result.GetProperty("deploymentId").ToString());
            Console.WriteLine(result.GetProperty("startDateTime").ToString());
            Console.WriteLine(result.GetProperty("update").GetProperty("updateId").GetProperty("provider").ToString());
            Console.WriteLine(result.GetProperty("update").GetProperty("updateId").GetProperty("name").ToString());
            Console.WriteLine(result.GetProperty("update").GetProperty("updateId").GetProperty("version").ToString());
            Console.WriteLine(result.GetProperty("update").GetProperty("description").ToString());
            Console.WriteLine(result.GetProperty("update").GetProperty("friendlyName").ToString());
            Console.WriteLine(result.GetProperty("groupId").ToString());
            Console.WriteLine(result.GetProperty("deviceClassSubgroups")[0].ToString());
            Console.WriteLine(result.GetProperty("isCanceled").ToString());
            Console.WriteLine(result.GetProperty("isRetried").ToString());
            Console.WriteLine(result.GetProperty("rollbackPolicy").GetProperty("update").GetProperty("updateId").GetProperty("provider").ToString());
            Console.WriteLine(result.GetProperty("rollbackPolicy").GetProperty("update").GetProperty("updateId").GetProperty("name").ToString());
            Console.WriteLine(result.GetProperty("rollbackPolicy").GetProperty("update").GetProperty("updateId").GetProperty("version").ToString());
            Console.WriteLine(result.GetProperty("rollbackPolicy").GetProperty("update").GetProperty("description").ToString());
            Console.WriteLine(result.GetProperty("rollbackPolicy").GetProperty("update").GetProperty("friendlyName").ToString());
            Console.WriteLine(result.GetProperty("rollbackPolicy").GetProperty("failure").GetProperty("devicesFailedPercentage").ToString());
            Console.WriteLine(result.GetProperty("rollbackPolicy").GetProperty("failure").GetProperty("devicesFailedCount").ToString());
            Console.WriteLine(result.GetProperty("isCloudInitiatedRollback").ToString());
        }

        [Test]
        [Ignore("Only validating compilation of examples")]
        public async Task Example_GetDeployment_AllParameters_Async()
        {
            Uri endpoint = new Uri("<endpoint>");
            TokenCredential credential = new DefaultAzureCredential();
            DeviceManagementClient client = new DeviceManagementClient(endpoint, "<InstanceId>", credential);

            Response response = await client.GetDeploymentAsync("<groupId>", "<deploymentId>");

            JsonElement result = JsonDocument.Parse(response.ContentStream).RootElement;
            Console.WriteLine(result.GetProperty("deploymentId").ToString());
            Console.WriteLine(result.GetProperty("startDateTime").ToString());
            Console.WriteLine(result.GetProperty("update").GetProperty("updateId").GetProperty("provider").ToString());
            Console.WriteLine(result.GetProperty("update").GetProperty("updateId").GetProperty("name").ToString());
            Console.WriteLine(result.GetProperty("update").GetProperty("updateId").GetProperty("version").ToString());
            Console.WriteLine(result.GetProperty("update").GetProperty("description").ToString());
            Console.WriteLine(result.GetProperty("update").GetProperty("friendlyName").ToString());
            Console.WriteLine(result.GetProperty("groupId").ToString());
            Console.WriteLine(result.GetProperty("deviceClassSubgroups")[0].ToString());
            Console.WriteLine(result.GetProperty("isCanceled").ToString());
            Console.WriteLine(result.GetProperty("isRetried").ToString());
            Console.WriteLine(result.GetProperty("rollbackPolicy").GetProperty("update").GetProperty("updateId").GetProperty("provider").ToString());
            Console.WriteLine(result.GetProperty("rollbackPolicy").GetProperty("update").GetProperty("updateId").GetProperty("name").ToString());
            Console.WriteLine(result.GetProperty("rollbackPolicy").GetProperty("update").GetProperty("updateId").GetProperty("version").ToString());
            Console.WriteLine(result.GetProperty("rollbackPolicy").GetProperty("update").GetProperty("description").ToString());
            Console.WriteLine(result.GetProperty("rollbackPolicy").GetProperty("update").GetProperty("friendlyName").ToString());
            Console.WriteLine(result.GetProperty("rollbackPolicy").GetProperty("failure").GetProperty("devicesFailedPercentage").ToString());
            Console.WriteLine(result.GetProperty("rollbackPolicy").GetProperty("failure").GetProperty("devicesFailedCount").ToString());
            Console.WriteLine(result.GetProperty("isCloudInitiatedRollback").ToString());
        }

        [Test]
        [Ignore("Only validating compilation of examples")]
        public void Example_CreateOrUpdateDeployment_ShortVersion()
        {
            Uri endpoint = new Uri("<endpoint>");
            TokenCredential credential = new DefaultAzureCredential();
            DeviceManagementClient client = new DeviceManagementClient(endpoint, "<InstanceId>", credential);

            using RequestContent content = RequestContent.Create(new
            {
                deploymentId = "<deploymentId>",
                startDateTime = "2022-05-10T18:57:31.2311892Z",
                update = new
                {
                    updateId = new
                    {
                        provider = "<provider>",
                        name = "<name>",
                        version = "<version>",
                    },
                },
                groupId = "<groupId>",
            });
            Response response = client.CreateOrUpdateDeployment("<groupId>", "<deploymentId>", content);

            JsonElement result = JsonDocument.Parse(response.ContentStream).RootElement;
            Console.WriteLine(result.GetProperty("deploymentId").ToString());
            Console.WriteLine(result.GetProperty("startDateTime").ToString());
            Console.WriteLine(result.GetProperty("update").GetProperty("updateId").GetProperty("provider").ToString());
            Console.WriteLine(result.GetProperty("update").GetProperty("updateId").GetProperty("name").ToString());
            Console.WriteLine(result.GetProperty("update").GetProperty("updateId").GetProperty("version").ToString());
            Console.WriteLine(result.GetProperty("groupId").ToString());
        }

        [Test]
        [Ignore("Only validating compilation of examples")]
        public async Task Example_CreateOrUpdateDeployment_ShortVersion_Async()
        {
            Uri endpoint = new Uri("<endpoint>");
            TokenCredential credential = new DefaultAzureCredential();
            DeviceManagementClient client = new DeviceManagementClient(endpoint, "<InstanceId>", credential);

            using RequestContent content = RequestContent.Create(new
            {
                deploymentId = "<deploymentId>",
                startDateTime = "2022-05-10T18:57:31.2311892Z",
                update = new
                {
                    updateId = new
                    {
                        provider = "<provider>",
                        name = "<name>",
                        version = "<version>",
                    },
                },
                groupId = "<groupId>",
            });
            Response response = await client.CreateOrUpdateDeploymentAsync("<groupId>", "<deploymentId>", content);

            JsonElement result = JsonDocument.Parse(response.ContentStream).RootElement;
            Console.WriteLine(result.GetProperty("deploymentId").ToString());
            Console.WriteLine(result.GetProperty("startDateTime").ToString());
            Console.WriteLine(result.GetProperty("update").GetProperty("updateId").GetProperty("provider").ToString());
            Console.WriteLine(result.GetProperty("update").GetProperty("updateId").GetProperty("name").ToString());
            Console.WriteLine(result.GetProperty("update").GetProperty("updateId").GetProperty("version").ToString());
            Console.WriteLine(result.GetProperty("groupId").ToString());
        }

        [Test]
        [Ignore("Only validating compilation of examples")]
        public void Example_CreateOrUpdateDeployment_AllParameters()
        {
            Uri endpoint = new Uri("<endpoint>");
            TokenCredential credential = new DefaultAzureCredential();
            DeviceManagementClient client = new DeviceManagementClient(endpoint, "<InstanceId>", credential);

            using RequestContent content = RequestContent.Create(new
            {
                deploymentId = "<deploymentId>",
                startDateTime = "2022-05-10T18:57:31.2311892Z",
                update = new
                {
                    updateId = new
                    {
                        provider = "<provider>",
                        name = "<name>",
                        version = "<version>",
                    },
                },
                groupId = "<groupId>",
                deviceClassSubgroups = new object[]
            {
"<deviceClassSubgroups>"
            },
                isCanceled = true,
                isRetried = true,
                rollbackPolicy = new
                {
                    failure = new
                    {
                        devicesFailedPercentage = 1234,
                        devicesFailedCount = 1234,
                    },
                },
                isCloudInitiatedRollback = true,
            });
            Response response = client.CreateOrUpdateDeployment("<groupId>", "<deploymentId>", content);

            JsonElement result = JsonDocument.Parse(response.ContentStream).RootElement;
            Console.WriteLine(result.GetProperty("deploymentId").ToString());
            Console.WriteLine(result.GetProperty("startDateTime").ToString());
            Console.WriteLine(result.GetProperty("update").GetProperty("updateId").GetProperty("provider").ToString());
            Console.WriteLine(result.GetProperty("update").GetProperty("updateId").GetProperty("name").ToString());
            Console.WriteLine(result.GetProperty("update").GetProperty("updateId").GetProperty("version").ToString());
            Console.WriteLine(result.GetProperty("update").GetProperty("description").ToString());
            Console.WriteLine(result.GetProperty("update").GetProperty("friendlyName").ToString());
            Console.WriteLine(result.GetProperty("groupId").ToString());
            Console.WriteLine(result.GetProperty("deviceClassSubgroups")[0].ToString());
            Console.WriteLine(result.GetProperty("isCanceled").ToString());
            Console.WriteLine(result.GetProperty("isRetried").ToString());
            Console.WriteLine(result.GetProperty("rollbackPolicy").GetProperty("update").GetProperty("updateId").GetProperty("provider").ToString());
            Console.WriteLine(result.GetProperty("rollbackPolicy").GetProperty("update").GetProperty("updateId").GetProperty("name").ToString());
            Console.WriteLine(result.GetProperty("rollbackPolicy").GetProperty("update").GetProperty("updateId").GetProperty("version").ToString());
            Console.WriteLine(result.GetProperty("rollbackPolicy").GetProperty("update").GetProperty("description").ToString());
            Console.WriteLine(result.GetProperty("rollbackPolicy").GetProperty("update").GetProperty("friendlyName").ToString());
            Console.WriteLine(result.GetProperty("rollbackPolicy").GetProperty("failure").GetProperty("devicesFailedPercentage").ToString());
            Console.WriteLine(result.GetProperty("rollbackPolicy").GetProperty("failure").GetProperty("devicesFailedCount").ToString());
            Console.WriteLine(result.GetProperty("isCloudInitiatedRollback").ToString());
        }

        [Test]
        [Ignore("Only validating compilation of examples")]
        public async Task Example_CreateOrUpdateDeployment_AllParameters_Async()
        {
            Uri endpoint = new Uri("<endpoint>");
            TokenCredential credential = new DefaultAzureCredential();
            DeviceManagementClient client = new DeviceManagementClient(endpoint, "<InstanceId>", credential);

            using RequestContent content = RequestContent.Create(new
            {
                deploymentId = "<deploymentId>",
                startDateTime = "2022-05-10T18:57:31.2311892Z",
                update = new
                {
                    updateId = new
                    {
                        provider = "<provider>",
                        name = "<name>",
                        version = "<version>",
                    },
                },
                groupId = "<groupId>",
                deviceClassSubgroups = new object[]
            {
"<deviceClassSubgroups>"
            },
                isCanceled = true,
                isRetried = true,
                rollbackPolicy = new
                {
                    failure = new
                    {
                        devicesFailedPercentage = 1234,
                        devicesFailedCount = 1234,
                    },
                },
                isCloudInitiatedRollback = true,
            });
            Response response = await client.CreateOrUpdateDeploymentAsync("<groupId>", "<deploymentId>", content);

            JsonElement result = JsonDocument.Parse(response.ContentStream).RootElement;
            Console.WriteLine(result.GetProperty("deploymentId").ToString());
            Console.WriteLine(result.GetProperty("startDateTime").ToString());
            Console.WriteLine(result.GetProperty("update").GetProperty("updateId").GetProperty("provider").ToString());
            Console.WriteLine(result.GetProperty("update").GetProperty("updateId").GetProperty("name").ToString());
            Console.WriteLine(result.GetProperty("update").GetProperty("updateId").GetProperty("version").ToString());
            Console.WriteLine(result.GetProperty("update").GetProperty("description").ToString());
            Console.WriteLine(result.GetProperty("update").GetProperty("friendlyName").ToString());
            Console.WriteLine(result.GetProperty("groupId").ToString());
            Console.WriteLine(result.GetProperty("deviceClassSubgroups")[0].ToString());
            Console.WriteLine(result.GetProperty("isCanceled").ToString());
            Console.WriteLine(result.GetProperty("isRetried").ToString());
            Console.WriteLine(result.GetProperty("rollbackPolicy").GetProperty("update").GetProperty("updateId").GetProperty("provider").ToString());
            Console.WriteLine(result.GetProperty("rollbackPolicy").GetProperty("update").GetProperty("updateId").GetProperty("name").ToString());
            Console.WriteLine(result.GetProperty("rollbackPolicy").GetProperty("update").GetProperty("updateId").GetProperty("version").ToString());
            Console.WriteLine(result.GetProperty("rollbackPolicy").GetProperty("update").GetProperty("description").ToString());
            Console.WriteLine(result.GetProperty("rollbackPolicy").GetProperty("update").GetProperty("friendlyName").ToString());
            Console.WriteLine(result.GetProperty("rollbackPolicy").GetProperty("failure").GetProperty("devicesFailedPercentage").ToString());
            Console.WriteLine(result.GetProperty("rollbackPolicy").GetProperty("failure").GetProperty("devicesFailedCount").ToString());
            Console.WriteLine(result.GetProperty("isCloudInitiatedRollback").ToString());
        }

        [Test]
        [Ignore("Only validating compilation of examples")]
        public void Example_DeleteDeployment_ShortVersion()
        {
            Uri endpoint = new Uri("<endpoint>");
            TokenCredential credential = new DefaultAzureCredential();
            DeviceManagementClient client = new DeviceManagementClient(endpoint, "<InstanceId>", credential);

            Response response = client.DeleteDeployment("<groupId>", "<deploymentId>");

            Console.WriteLine(response.Status);
        }

        [Test]
        [Ignore("Only validating compilation of examples")]
        public async Task Example_DeleteDeployment_ShortVersion_Async()
        {
            Uri endpoint = new Uri("<endpoint>");
            TokenCredential credential = new DefaultAzureCredential();
            DeviceManagementClient client = new DeviceManagementClient(endpoint, "<InstanceId>", credential);

            Response response = await client.DeleteDeploymentAsync("<groupId>", "<deploymentId>");

            Console.WriteLine(response.Status);
        }

        [Test]
        [Ignore("Only validating compilation of examples")]
        public void Example_DeleteDeployment_AllParameters()
        {
            Uri endpoint = new Uri("<endpoint>");
            TokenCredential credential = new DefaultAzureCredential();
            DeviceManagementClient client = new DeviceManagementClient(endpoint, "<InstanceId>", credential);

            Response response = client.DeleteDeployment("<groupId>", "<deploymentId>");

            Console.WriteLine(response.Status);
        }

        [Test]
        [Ignore("Only validating compilation of examples")]
        public async Task Example_DeleteDeployment_AllParameters_Async()
        {
            Uri endpoint = new Uri("<endpoint>");
            TokenCredential credential = new DefaultAzureCredential();
            DeviceManagementClient client = new DeviceManagementClient(endpoint, "<InstanceId>", credential);

            Response response = await client.DeleteDeploymentAsync("<groupId>", "<deploymentId>");

            Console.WriteLine(response.Status);
        }

        [Test]
        [Ignore("Only validating compilation of examples")]
        public void Example_GetDeploymentStatus_ShortVersion()
        {
            Uri endpoint = new Uri("<endpoint>");
            TokenCredential credential = new DefaultAzureCredential();
            DeviceManagementClient client = new DeviceManagementClient(endpoint, "<InstanceId>", credential);

            Response response = client.GetDeploymentStatus("<groupId>", "<deploymentId>");

            JsonElement result = JsonDocument.Parse(response.ContentStream).RootElement;
            Console.WriteLine(result.GetProperty("groupId").ToString());
            Console.WriteLine(result.GetProperty("deploymentState").ToString());
            Console.WriteLine(result.GetProperty("subgroupStatus")[0].GetProperty("groupId").ToString());
            Console.WriteLine(result.GetProperty("subgroupStatus")[0].GetProperty("deviceClassId").ToString());
            Console.WriteLine(result.GetProperty("subgroupStatus")[0].GetProperty("deploymentState").ToString());
        }

        [Test]
        [Ignore("Only validating compilation of examples")]
        public async Task Example_GetDeploymentStatus_ShortVersion_Async()
        {
            Uri endpoint = new Uri("<endpoint>");
            TokenCredential credential = new DefaultAzureCredential();
            DeviceManagementClient client = new DeviceManagementClient(endpoint, "<InstanceId>", credential);

            Response response = await client.GetDeploymentStatusAsync("<groupId>", "<deploymentId>");

            JsonElement result = JsonDocument.Parse(response.ContentStream).RootElement;
            Console.WriteLine(result.GetProperty("groupId").ToString());
            Console.WriteLine(result.GetProperty("deploymentState").ToString());
            Console.WriteLine(result.GetProperty("subgroupStatus")[0].GetProperty("groupId").ToString());
            Console.WriteLine(result.GetProperty("subgroupStatus")[0].GetProperty("deviceClassId").ToString());
            Console.WriteLine(result.GetProperty("subgroupStatus")[0].GetProperty("deploymentState").ToString());
        }

        [Test]
        [Ignore("Only validating compilation of examples")]
        public void Example_GetDeploymentStatus_AllParameters()
        {
            Uri endpoint = new Uri("<endpoint>");
            TokenCredential credential = new DefaultAzureCredential();
            DeviceManagementClient client = new DeviceManagementClient(endpoint, "<InstanceId>", credential);

            Response response = client.GetDeploymentStatus("<groupId>", "<deploymentId>");

            JsonElement result = JsonDocument.Parse(response.ContentStream).RootElement;
            Console.WriteLine(result.GetProperty("groupId").ToString());
            Console.WriteLine(result.GetProperty("deploymentState").ToString());
            Console.WriteLine(result.GetProperty("error").GetProperty("code").ToString());
            Console.WriteLine(result.GetProperty("error").GetProperty("message").ToString());
            Console.WriteLine(result.GetProperty("error").GetProperty("target").ToString());
            Console.WriteLine(result.GetProperty("error").GetProperty("innererror").GetProperty("code").ToString());
            Console.WriteLine(result.GetProperty("error").GetProperty("innererror").GetProperty("message").ToString());
            Console.WriteLine(result.GetProperty("error").GetProperty("innererror").GetProperty("errorDetail").ToString());
            Console.WriteLine(result.GetProperty("error").GetProperty("occurredDateTime").ToString());
            Console.WriteLine(result.GetProperty("subgroupStatus")[0].GetProperty("groupId").ToString());
            Console.WriteLine(result.GetProperty("subgroupStatus")[0].GetProperty("deviceClassId").ToString());
            Console.WriteLine(result.GetProperty("subgroupStatus")[0].GetProperty("deploymentState").ToString());
            Console.WriteLine(result.GetProperty("subgroupStatus")[0].GetProperty("error").GetProperty("code").ToString());
            Console.WriteLine(result.GetProperty("subgroupStatus")[0].GetProperty("error").GetProperty("message").ToString());
            Console.WriteLine(result.GetProperty("subgroupStatus")[0].GetProperty("error").GetProperty("target").ToString());
            Console.WriteLine(result.GetProperty("subgroupStatus")[0].GetProperty("error").GetProperty("innererror").GetProperty("code").ToString());
            Console.WriteLine(result.GetProperty("subgroupStatus")[0].GetProperty("error").GetProperty("innererror").GetProperty("message").ToString());
            Console.WriteLine(result.GetProperty("subgroupStatus")[0].GetProperty("error").GetProperty("innererror").GetProperty("errorDetail").ToString());
            Console.WriteLine(result.GetProperty("subgroupStatus")[0].GetProperty("error").GetProperty("occurredDateTime").ToString());
            Console.WriteLine(result.GetProperty("subgroupStatus")[0].GetProperty("totalDevices").ToString());
            Console.WriteLine(result.GetProperty("subgroupStatus")[0].GetProperty("devicesInProgressCount").ToString());
            Console.WriteLine(result.GetProperty("subgroupStatus")[0].GetProperty("devicesCompletedFailedCount").ToString());
            Console.WriteLine(result.GetProperty("subgroupStatus")[0].GetProperty("devicesCompletedSucceededCount").ToString());
            Console.WriteLine(result.GetProperty("subgroupStatus")[0].GetProperty("devicesCanceledCount").ToString());
        }

        [Test]
        [Ignore("Only validating compilation of examples")]
        public async Task Example_GetDeploymentStatus_AllParameters_Async()
        {
            Uri endpoint = new Uri("<endpoint>");
            TokenCredential credential = new DefaultAzureCredential();
            DeviceManagementClient client = new DeviceManagementClient(endpoint, "<InstanceId>", credential);

            Response response = await client.GetDeploymentStatusAsync("<groupId>", "<deploymentId>");

            JsonElement result = JsonDocument.Parse(response.ContentStream).RootElement;
            Console.WriteLine(result.GetProperty("groupId").ToString());
            Console.WriteLine(result.GetProperty("deploymentState").ToString());
            Console.WriteLine(result.GetProperty("error").GetProperty("code").ToString());
            Console.WriteLine(result.GetProperty("error").GetProperty("message").ToString());
            Console.WriteLine(result.GetProperty("error").GetProperty("target").ToString());
            Console.WriteLine(result.GetProperty("error").GetProperty("innererror").GetProperty("code").ToString());
            Console.WriteLine(result.GetProperty("error").GetProperty("innererror").GetProperty("message").ToString());
            Console.WriteLine(result.GetProperty("error").GetProperty("innererror").GetProperty("errorDetail").ToString());
            Console.WriteLine(result.GetProperty("error").GetProperty("occurredDateTime").ToString());
            Console.WriteLine(result.GetProperty("subgroupStatus")[0].GetProperty("groupId").ToString());
            Console.WriteLine(result.GetProperty("subgroupStatus")[0].GetProperty("deviceClassId").ToString());
            Console.WriteLine(result.GetProperty("subgroupStatus")[0].GetProperty("deploymentState").ToString());
            Console.WriteLine(result.GetProperty("subgroupStatus")[0].GetProperty("error").GetProperty("code").ToString());
            Console.WriteLine(result.GetProperty("subgroupStatus")[0].GetProperty("error").GetProperty("message").ToString());
            Console.WriteLine(result.GetProperty("subgroupStatus")[0].GetProperty("error").GetProperty("target").ToString());
            Console.WriteLine(result.GetProperty("subgroupStatus")[0].GetProperty("error").GetProperty("innererror").GetProperty("code").ToString());
            Console.WriteLine(result.GetProperty("subgroupStatus")[0].GetProperty("error").GetProperty("innererror").GetProperty("message").ToString());
            Console.WriteLine(result.GetProperty("subgroupStatus")[0].GetProperty("error").GetProperty("innererror").GetProperty("errorDetail").ToString());
            Console.WriteLine(result.GetProperty("subgroupStatus")[0].GetProperty("error").GetProperty("occurredDateTime").ToString());
            Console.WriteLine(result.GetProperty("subgroupStatus")[0].GetProperty("totalDevices").ToString());
            Console.WriteLine(result.GetProperty("subgroupStatus")[0].GetProperty("devicesInProgressCount").ToString());
            Console.WriteLine(result.GetProperty("subgroupStatus")[0].GetProperty("devicesCompletedFailedCount").ToString());
            Console.WriteLine(result.GetProperty("subgroupStatus")[0].GetProperty("devicesCompletedSucceededCount").ToString());
            Console.WriteLine(result.GetProperty("subgroupStatus")[0].GetProperty("devicesCanceledCount").ToString());
        }

        [Test]
        [Ignore("Only validating compilation of examples")]
        public void Example_GetDeviceClassSubgroup_ShortVersion()
        {
            Uri endpoint = new Uri("<endpoint>");
            TokenCredential credential = new DefaultAzureCredential();
            DeviceManagementClient client = new DeviceManagementClient(endpoint, "<InstanceId>", credential);

            Response response = client.GetDeviceClassSubgroup("<groupId>", "<deviceClassId>");

            JsonElement result = JsonDocument.Parse(response.ContentStream).RootElement;
            Console.WriteLine(result.GetProperty("deviceClassId").ToString());
            Console.WriteLine(result.GetProperty("groupId").ToString());
            Console.WriteLine(result.GetProperty("createdDateTime").ToString());
        }

        [Test]
        [Ignore("Only validating compilation of examples")]
        public async Task Example_GetDeviceClassSubgroup_ShortVersion_Async()
        {
            Uri endpoint = new Uri("<endpoint>");
            TokenCredential credential = new DefaultAzureCredential();
            DeviceManagementClient client = new DeviceManagementClient(endpoint, "<InstanceId>", credential);

            Response response = await client.GetDeviceClassSubgroupAsync("<groupId>", "<deviceClassId>");

            JsonElement result = JsonDocument.Parse(response.ContentStream).RootElement;
            Console.WriteLine(result.GetProperty("deviceClassId").ToString());
            Console.WriteLine(result.GetProperty("groupId").ToString());
            Console.WriteLine(result.GetProperty("createdDateTime").ToString());
        }

        [Test]
        [Ignore("Only validating compilation of examples")]
        public void Example_GetDeviceClassSubgroup_AllParameters()
        {
            Uri endpoint = new Uri("<endpoint>");
            TokenCredential credential = new DefaultAzureCredential();
            DeviceManagementClient client = new DeviceManagementClient(endpoint, "<InstanceId>", credential);

            Response response = client.GetDeviceClassSubgroup("<groupId>", "<deviceClassId>");

            JsonElement result = JsonDocument.Parse(response.ContentStream).RootElement;
            Console.WriteLine(result.GetProperty("deviceClassId").ToString());
            Console.WriteLine(result.GetProperty("groupId").ToString());
            Console.WriteLine(result.GetProperty("createdDateTime").ToString());
            Console.WriteLine(result.GetProperty("deviceCount").ToString());
            Console.WriteLine(result.GetProperty("deploymentId").ToString());
        }

        [Test]
        [Ignore("Only validating compilation of examples")]
        public async Task Example_GetDeviceClassSubgroup_AllParameters_Async()
        {
            Uri endpoint = new Uri("<endpoint>");
            TokenCredential credential = new DefaultAzureCredential();
            DeviceManagementClient client = new DeviceManagementClient(endpoint, "<InstanceId>", credential);

            Response response = await client.GetDeviceClassSubgroupAsync("<groupId>", "<deviceClassId>");

            JsonElement result = JsonDocument.Parse(response.ContentStream).RootElement;
            Console.WriteLine(result.GetProperty("deviceClassId").ToString());
            Console.WriteLine(result.GetProperty("groupId").ToString());
            Console.WriteLine(result.GetProperty("createdDateTime").ToString());
            Console.WriteLine(result.GetProperty("deviceCount").ToString());
            Console.WriteLine(result.GetProperty("deploymentId").ToString());
        }

        [Test]
        [Ignore("Only validating compilation of examples")]
        public void Example_DeleteDeviceClassSubgroup_ShortVersion()
        {
            Uri endpoint = new Uri("<endpoint>");
            TokenCredential credential = new DefaultAzureCredential();
            DeviceManagementClient client = new DeviceManagementClient(endpoint, "<InstanceId>", credential);

            Response response = client.DeleteDeviceClassSubgroup("<groupId>", "<deviceClassId>");

            Console.WriteLine(response.Status);
        }

        [Test]
        [Ignore("Only validating compilation of examples")]
        public async Task Example_DeleteDeviceClassSubgroup_ShortVersion_Async()
        {
            Uri endpoint = new Uri("<endpoint>");
            TokenCredential credential = new DefaultAzureCredential();
            DeviceManagementClient client = new DeviceManagementClient(endpoint, "<InstanceId>", credential);

            Response response = await client.DeleteDeviceClassSubgroupAsync("<groupId>", "<deviceClassId>");

            Console.WriteLine(response.Status);
        }

        [Test]
        [Ignore("Only validating compilation of examples")]
        public void Example_DeleteDeviceClassSubgroup_AllParameters()
        {
            Uri endpoint = new Uri("<endpoint>");
            TokenCredential credential = new DefaultAzureCredential();
            DeviceManagementClient client = new DeviceManagementClient(endpoint, "<InstanceId>", credential);

            Response response = client.DeleteDeviceClassSubgroup("<groupId>", "<deviceClassId>");

            Console.WriteLine(response.Status);
        }

        [Test]
        [Ignore("Only validating compilation of examples")]
        public async Task Example_DeleteDeviceClassSubgroup_AllParameters_Async()
        {
            Uri endpoint = new Uri("<endpoint>");
            TokenCredential credential = new DefaultAzureCredential();
            DeviceManagementClient client = new DeviceManagementClient(endpoint, "<InstanceId>", credential);

            Response response = await client.DeleteDeviceClassSubgroupAsync("<groupId>", "<deviceClassId>");

            Console.WriteLine(response.Status);
        }

        [Test]
        [Ignore("Only validating compilation of examples")]
        public void Example_GetDeviceClassSubgroupUpdateCompliance_ShortVersion()
        {
            Uri endpoint = new Uri("<endpoint>");
            TokenCredential credential = new DefaultAzureCredential();
            DeviceManagementClient client = new DeviceManagementClient(endpoint, "<InstanceId>", credential);

            Response response = client.GetDeviceClassSubgroupUpdateCompliance("<groupId>", "<deviceClassId>");

            JsonElement result = JsonDocument.Parse(response.ContentStream).RootElement;
            Console.WriteLine(result.GetProperty("totalDeviceCount").ToString());
            Console.WriteLine(result.GetProperty("onLatestUpdateDeviceCount").ToString());
            Console.WriteLine(result.GetProperty("newUpdatesAvailableDeviceCount").ToString());
            Console.WriteLine(result.GetProperty("updatesInProgressDeviceCount").ToString());
        }

        [Test]
        [Ignore("Only validating compilation of examples")]
        public async Task Example_GetDeviceClassSubgroupUpdateCompliance_ShortVersion_Async()
        {
            Uri endpoint = new Uri("<endpoint>");
            TokenCredential credential = new DefaultAzureCredential();
            DeviceManagementClient client = new DeviceManagementClient(endpoint, "<InstanceId>", credential);

            Response response = await client.GetDeviceClassSubgroupUpdateComplianceAsync("<groupId>", "<deviceClassId>");

            JsonElement result = JsonDocument.Parse(response.ContentStream).RootElement;
            Console.WriteLine(result.GetProperty("totalDeviceCount").ToString());
            Console.WriteLine(result.GetProperty("onLatestUpdateDeviceCount").ToString());
            Console.WriteLine(result.GetProperty("newUpdatesAvailableDeviceCount").ToString());
            Console.WriteLine(result.GetProperty("updatesInProgressDeviceCount").ToString());
        }

        [Test]
        [Ignore("Only validating compilation of examples")]
        public void Example_GetDeviceClassSubgroupUpdateCompliance_AllParameters()
        {
            Uri endpoint = new Uri("<endpoint>");
            TokenCredential credential = new DefaultAzureCredential();
            DeviceManagementClient client = new DeviceManagementClient(endpoint, "<InstanceId>", credential);

            Response response = client.GetDeviceClassSubgroupUpdateCompliance("<groupId>", "<deviceClassId>");

            JsonElement result = JsonDocument.Parse(response.ContentStream).RootElement;
            Console.WriteLine(result.GetProperty("totalDeviceCount").ToString());
            Console.WriteLine(result.GetProperty("onLatestUpdateDeviceCount").ToString());
            Console.WriteLine(result.GetProperty("newUpdatesAvailableDeviceCount").ToString());
            Console.WriteLine(result.GetProperty("updatesInProgressDeviceCount").ToString());
        }

        [Test]
        [Ignore("Only validating compilation of examples")]
        public async Task Example_GetDeviceClassSubgroupUpdateCompliance_AllParameters_Async()
        {
            Uri endpoint = new Uri("<endpoint>");
            TokenCredential credential = new DefaultAzureCredential();
            DeviceManagementClient client = new DeviceManagementClient(endpoint, "<InstanceId>", credential);

            Response response = await client.GetDeviceClassSubgroupUpdateComplianceAsync("<groupId>", "<deviceClassId>");

            JsonElement result = JsonDocument.Parse(response.ContentStream).RootElement;
            Console.WriteLine(result.GetProperty("totalDeviceCount").ToString());
            Console.WriteLine(result.GetProperty("onLatestUpdateDeviceCount").ToString());
            Console.WriteLine(result.GetProperty("newUpdatesAvailableDeviceCount").ToString());
            Console.WriteLine(result.GetProperty("updatesInProgressDeviceCount").ToString());
        }

        [Test]
        [Ignore("Only validating compilation of examples")]
        public void Example_GetBestUpdatesForDeviceClassSubgroup_ShortVersion()
        {
            Uri endpoint = new Uri("<endpoint>");
            TokenCredential credential = new DefaultAzureCredential();
            DeviceManagementClient client = new DeviceManagementClient(endpoint, "<InstanceId>", credential);

            Response response = client.GetBestUpdatesForDeviceClassSubgroup("<groupId>", "<deviceClassId>");

            JsonElement result = JsonDocument.Parse(response.ContentStream).RootElement;
            Console.WriteLine(result.GetProperty("groupId").ToString());
            Console.WriteLine(result.GetProperty("deviceClassId").ToString());
            Console.WriteLine(result.GetProperty("update").GetProperty("updateId").GetProperty("provider").ToString());
            Console.WriteLine(result.GetProperty("update").GetProperty("updateId").GetProperty("name").ToString());
            Console.WriteLine(result.GetProperty("update").GetProperty("updateId").GetProperty("version").ToString());
            Console.WriteLine(result.GetProperty("deviceCount").ToString());
        }

        [Test]
        [Ignore("Only validating compilation of examples")]
        public async Task Example_GetBestUpdatesForDeviceClassSubgroup_ShortVersion_Async()
        {
            Uri endpoint = new Uri("<endpoint>");
            TokenCredential credential = new DefaultAzureCredential();
            DeviceManagementClient client = new DeviceManagementClient(endpoint, "<InstanceId>", credential);

            Response response = await client.GetBestUpdatesForDeviceClassSubgroupAsync("<groupId>", "<deviceClassId>");

            JsonElement result = JsonDocument.Parse(response.ContentStream).RootElement;
            Console.WriteLine(result.GetProperty("groupId").ToString());
            Console.WriteLine(result.GetProperty("deviceClassId").ToString());
            Console.WriteLine(result.GetProperty("update").GetProperty("updateId").GetProperty("provider").ToString());
            Console.WriteLine(result.GetProperty("update").GetProperty("updateId").GetProperty("name").ToString());
            Console.WriteLine(result.GetProperty("update").GetProperty("updateId").GetProperty("version").ToString());
            Console.WriteLine(result.GetProperty("deviceCount").ToString());
        }

        [Test]
        [Ignore("Only validating compilation of examples")]
        public void Example_GetBestUpdatesForDeviceClassSubgroup_AllParameters()
        {
            Uri endpoint = new Uri("<endpoint>");
            TokenCredential credential = new DefaultAzureCredential();
            DeviceManagementClient client = new DeviceManagementClient(endpoint, "<InstanceId>", credential);

            Response response = client.GetBestUpdatesForDeviceClassSubgroup("<groupId>", "<deviceClassId>");

            JsonElement result = JsonDocument.Parse(response.ContentStream).RootElement;
            Console.WriteLine(result.GetProperty("groupId").ToString());
            Console.WriteLine(result.GetProperty("deviceClassId").ToString());
            Console.WriteLine(result.GetProperty("update").GetProperty("updateId").GetProperty("provider").ToString());
            Console.WriteLine(result.GetProperty("update").GetProperty("updateId").GetProperty("name").ToString());
            Console.WriteLine(result.GetProperty("update").GetProperty("updateId").GetProperty("version").ToString());
            Console.WriteLine(result.GetProperty("update").GetProperty("description").ToString());
            Console.WriteLine(result.GetProperty("update").GetProperty("friendlyName").ToString());
            Console.WriteLine(result.GetProperty("deviceCount").ToString());
        }

        [Test]
        [Ignore("Only validating compilation of examples")]
        public async Task Example_GetBestUpdatesForDeviceClassSubgroup_AllParameters_Async()
        {
            Uri endpoint = new Uri("<endpoint>");
            TokenCredential credential = new DefaultAzureCredential();
            DeviceManagementClient client = new DeviceManagementClient(endpoint, "<InstanceId>", credential);

            Response response = await client.GetBestUpdatesForDeviceClassSubgroupAsync("<groupId>", "<deviceClassId>");

            JsonElement result = JsonDocument.Parse(response.ContentStream).RootElement;
            Console.WriteLine(result.GetProperty("groupId").ToString());
            Console.WriteLine(result.GetProperty("deviceClassId").ToString());
            Console.WriteLine(result.GetProperty("update").GetProperty("updateId").GetProperty("provider").ToString());
            Console.WriteLine(result.GetProperty("update").GetProperty("updateId").GetProperty("name").ToString());
            Console.WriteLine(result.GetProperty("update").GetProperty("updateId").GetProperty("version").ToString());
            Console.WriteLine(result.GetProperty("update").GetProperty("description").ToString());
            Console.WriteLine(result.GetProperty("update").GetProperty("friendlyName").ToString());
            Console.WriteLine(result.GetProperty("deviceCount").ToString());
        }

        [Test]
        [Ignore("Only validating compilation of examples")]
        public void Example_GetDeploymentForDeviceClassSubgroup_ShortVersion()
        {
            Uri endpoint = new Uri("<endpoint>");
            TokenCredential credential = new DefaultAzureCredential();
            DeviceManagementClient client = new DeviceManagementClient(endpoint, "<InstanceId>", credential);

            Response response = client.GetDeploymentForDeviceClassSubgroup("<groupId>", "<deviceClassId>", "<deploymentId>");

            JsonElement result = JsonDocument.Parse(response.ContentStream).RootElement;
            Console.WriteLine(result.GetProperty("deploymentId").ToString());
            Console.WriteLine(result.GetProperty("startDateTime").ToString());
            Console.WriteLine(result.GetProperty("update").GetProperty("updateId").GetProperty("provider").ToString());
            Console.WriteLine(result.GetProperty("update").GetProperty("updateId").GetProperty("name").ToString());
            Console.WriteLine(result.GetProperty("update").GetProperty("updateId").GetProperty("version").ToString());
            Console.WriteLine(result.GetProperty("groupId").ToString());
        }

        [Test]
        [Ignore("Only validating compilation of examples")]
        public async Task Example_GetDeploymentForDeviceClassSubgroup_ShortVersion_Async()
        {
            Uri endpoint = new Uri("<endpoint>");
            TokenCredential credential = new DefaultAzureCredential();
            DeviceManagementClient client = new DeviceManagementClient(endpoint, "<InstanceId>", credential);

            Response response = await client.GetDeploymentForDeviceClassSubgroupAsync("<groupId>", "<deviceClassId>", "<deploymentId>");

            JsonElement result = JsonDocument.Parse(response.ContentStream).RootElement;
            Console.WriteLine(result.GetProperty("deploymentId").ToString());
            Console.WriteLine(result.GetProperty("startDateTime").ToString());
            Console.WriteLine(result.GetProperty("update").GetProperty("updateId").GetProperty("provider").ToString());
            Console.WriteLine(result.GetProperty("update").GetProperty("updateId").GetProperty("name").ToString());
            Console.WriteLine(result.GetProperty("update").GetProperty("updateId").GetProperty("version").ToString());
            Console.WriteLine(result.GetProperty("groupId").ToString());
        }

        [Test]
        [Ignore("Only validating compilation of examples")]
        public void Example_GetDeploymentForDeviceClassSubgroup_AllParameters()
        {
            Uri endpoint = new Uri("<endpoint>");
            TokenCredential credential = new DefaultAzureCredential();
            DeviceManagementClient client = new DeviceManagementClient(endpoint, "<InstanceId>", credential);

            Response response = client.GetDeploymentForDeviceClassSubgroup("<groupId>", "<deviceClassId>", "<deploymentId>");

            JsonElement result = JsonDocument.Parse(response.ContentStream).RootElement;
            Console.WriteLine(result.GetProperty("deploymentId").ToString());
            Console.WriteLine(result.GetProperty("startDateTime").ToString());
            Console.WriteLine(result.GetProperty("update").GetProperty("updateId").GetProperty("provider").ToString());
            Console.WriteLine(result.GetProperty("update").GetProperty("updateId").GetProperty("name").ToString());
            Console.WriteLine(result.GetProperty("update").GetProperty("updateId").GetProperty("version").ToString());
            Console.WriteLine(result.GetProperty("update").GetProperty("description").ToString());
            Console.WriteLine(result.GetProperty("update").GetProperty("friendlyName").ToString());
            Console.WriteLine(result.GetProperty("groupId").ToString());
            Console.WriteLine(result.GetProperty("deviceClassSubgroups")[0].ToString());
            Console.WriteLine(result.GetProperty("isCanceled").ToString());
            Console.WriteLine(result.GetProperty("isRetried").ToString());
            Console.WriteLine(result.GetProperty("rollbackPolicy").GetProperty("update").GetProperty("updateId").GetProperty("provider").ToString());
            Console.WriteLine(result.GetProperty("rollbackPolicy").GetProperty("update").GetProperty("updateId").GetProperty("name").ToString());
            Console.WriteLine(result.GetProperty("rollbackPolicy").GetProperty("update").GetProperty("updateId").GetProperty("version").ToString());
            Console.WriteLine(result.GetProperty("rollbackPolicy").GetProperty("update").GetProperty("description").ToString());
            Console.WriteLine(result.GetProperty("rollbackPolicy").GetProperty("update").GetProperty("friendlyName").ToString());
            Console.WriteLine(result.GetProperty("rollbackPolicy").GetProperty("failure").GetProperty("devicesFailedPercentage").ToString());
            Console.WriteLine(result.GetProperty("rollbackPolicy").GetProperty("failure").GetProperty("devicesFailedCount").ToString());
            Console.WriteLine(result.GetProperty("isCloudInitiatedRollback").ToString());
        }

        [Test]
        [Ignore("Only validating compilation of examples")]
        public async Task Example_GetDeploymentForDeviceClassSubgroup_AllParameters_Async()
        {
            Uri endpoint = new Uri("<endpoint>");
            TokenCredential credential = new DefaultAzureCredential();
            DeviceManagementClient client = new DeviceManagementClient(endpoint, "<InstanceId>", credential);

            Response response = await client.GetDeploymentForDeviceClassSubgroupAsync("<groupId>", "<deviceClassId>", "<deploymentId>");

            JsonElement result = JsonDocument.Parse(response.ContentStream).RootElement;
            Console.WriteLine(result.GetProperty("deploymentId").ToString());
            Console.WriteLine(result.GetProperty("startDateTime").ToString());
            Console.WriteLine(result.GetProperty("update").GetProperty("updateId").GetProperty("provider").ToString());
            Console.WriteLine(result.GetProperty("update").GetProperty("updateId").GetProperty("name").ToString());
            Console.WriteLine(result.GetProperty("update").GetProperty("updateId").GetProperty("version").ToString());
            Console.WriteLine(result.GetProperty("update").GetProperty("description").ToString());
            Console.WriteLine(result.GetProperty("update").GetProperty("friendlyName").ToString());
            Console.WriteLine(result.GetProperty("groupId").ToString());
            Console.WriteLine(result.GetProperty("deviceClassSubgroups")[0].ToString());
            Console.WriteLine(result.GetProperty("isCanceled").ToString());
            Console.WriteLine(result.GetProperty("isRetried").ToString());
            Console.WriteLine(result.GetProperty("rollbackPolicy").GetProperty("update").GetProperty("updateId").GetProperty("provider").ToString());
            Console.WriteLine(result.GetProperty("rollbackPolicy").GetProperty("update").GetProperty("updateId").GetProperty("name").ToString());
            Console.WriteLine(result.GetProperty("rollbackPolicy").GetProperty("update").GetProperty("updateId").GetProperty("version").ToString());
            Console.WriteLine(result.GetProperty("rollbackPolicy").GetProperty("update").GetProperty("description").ToString());
            Console.WriteLine(result.GetProperty("rollbackPolicy").GetProperty("update").GetProperty("friendlyName").ToString());
            Console.WriteLine(result.GetProperty("rollbackPolicy").GetProperty("failure").GetProperty("devicesFailedPercentage").ToString());
            Console.WriteLine(result.GetProperty("rollbackPolicy").GetProperty("failure").GetProperty("devicesFailedCount").ToString());
            Console.WriteLine(result.GetProperty("isCloudInitiatedRollback").ToString());
        }

        [Test]
        [Ignore("Only validating compilation of examples")]
        public void Example_DeleteDeploymentForDeviceClassSubgroup_ShortVersion()
        {
            Uri endpoint = new Uri("<endpoint>");
            TokenCredential credential = new DefaultAzureCredential();
            DeviceManagementClient client = new DeviceManagementClient(endpoint, "<InstanceId>", credential);

            Response response = client.DeleteDeploymentForDeviceClassSubgroup("<groupId>", "<deviceClassId>", "<deploymentId>");

            Console.WriteLine(response.Status);
        }

        [Test]
        [Ignore("Only validating compilation of examples")]
        public async Task Example_DeleteDeploymentForDeviceClassSubgroup_ShortVersion_Async()
        {
            Uri endpoint = new Uri("<endpoint>");
            TokenCredential credential = new DefaultAzureCredential();
            DeviceManagementClient client = new DeviceManagementClient(endpoint, "<InstanceId>", credential);

            Response response = await client.DeleteDeploymentForDeviceClassSubgroupAsync("<groupId>", "<deviceClassId>", "<deploymentId>");

            Console.WriteLine(response.Status);
        }

        [Test]
        [Ignore("Only validating compilation of examples")]
        public void Example_DeleteDeploymentForDeviceClassSubgroup_AllParameters()
        {
            Uri endpoint = new Uri("<endpoint>");
            TokenCredential credential = new DefaultAzureCredential();
            DeviceManagementClient client = new DeviceManagementClient(endpoint, "<InstanceId>", credential);

            Response response = client.DeleteDeploymentForDeviceClassSubgroup("<groupId>", "<deviceClassId>", "<deploymentId>");

            Console.WriteLine(response.Status);
        }

        [Test]
        [Ignore("Only validating compilation of examples")]
        public async Task Example_DeleteDeploymentForDeviceClassSubgroup_AllParameters_Async()
        {
            Uri endpoint = new Uri("<endpoint>");
            TokenCredential credential = new DefaultAzureCredential();
            DeviceManagementClient client = new DeviceManagementClient(endpoint, "<InstanceId>", credential);

            Response response = await client.DeleteDeploymentForDeviceClassSubgroupAsync("<groupId>", "<deviceClassId>", "<deploymentId>");

            Console.WriteLine(response.Status);
        }

        [Test]
        [Ignore("Only validating compilation of examples")]
        public void Example_StopDeployment_ShortVersion()
        {
            Uri endpoint = new Uri("<endpoint>");
            TokenCredential credential = new DefaultAzureCredential();
            DeviceManagementClient client = new DeviceManagementClient(endpoint, "<InstanceId>", credential);

            Response response = client.StopDeployment("<groupId>", "<deviceClassId>", "<deploymentId>");

            JsonElement result = JsonDocument.Parse(response.ContentStream).RootElement;
            Console.WriteLine(result.GetProperty("deploymentId").ToString());
            Console.WriteLine(result.GetProperty("startDateTime").ToString());
            Console.WriteLine(result.GetProperty("update").GetProperty("updateId").GetProperty("provider").ToString());
            Console.WriteLine(result.GetProperty("update").GetProperty("updateId").GetProperty("name").ToString());
            Console.WriteLine(result.GetProperty("update").GetProperty("updateId").GetProperty("version").ToString());
            Console.WriteLine(result.GetProperty("groupId").ToString());
        }

        [Test]
        [Ignore("Only validating compilation of examples")]
        public async Task Example_StopDeployment_ShortVersion_Async()
        {
            Uri endpoint = new Uri("<endpoint>");
            TokenCredential credential = new DefaultAzureCredential();
            DeviceManagementClient client = new DeviceManagementClient(endpoint, "<InstanceId>", credential);

            Response response = await client.StopDeploymentAsync("<groupId>", "<deviceClassId>", "<deploymentId>");

            JsonElement result = JsonDocument.Parse(response.ContentStream).RootElement;
            Console.WriteLine(result.GetProperty("deploymentId").ToString());
            Console.WriteLine(result.GetProperty("startDateTime").ToString());
            Console.WriteLine(result.GetProperty("update").GetProperty("updateId").GetProperty("provider").ToString());
            Console.WriteLine(result.GetProperty("update").GetProperty("updateId").GetProperty("name").ToString());
            Console.WriteLine(result.GetProperty("update").GetProperty("updateId").GetProperty("version").ToString());
            Console.WriteLine(result.GetProperty("groupId").ToString());
        }

        [Test]
        [Ignore("Only validating compilation of examples")]
        public void Example_StopDeployment_AllParameters()
        {
            Uri endpoint = new Uri("<endpoint>");
            TokenCredential credential = new DefaultAzureCredential();
            DeviceManagementClient client = new DeviceManagementClient(endpoint, "<InstanceId>", credential);

            Response response = client.StopDeployment("<groupId>", "<deviceClassId>", "<deploymentId>");

            JsonElement result = JsonDocument.Parse(response.ContentStream).RootElement;
            Console.WriteLine(result.GetProperty("deploymentId").ToString());
            Console.WriteLine(result.GetProperty("startDateTime").ToString());
            Console.WriteLine(result.GetProperty("update").GetProperty("updateId").GetProperty("provider").ToString());
            Console.WriteLine(result.GetProperty("update").GetProperty("updateId").GetProperty("name").ToString());
            Console.WriteLine(result.GetProperty("update").GetProperty("updateId").GetProperty("version").ToString());
            Console.WriteLine(result.GetProperty("update").GetProperty("description").ToString());
            Console.WriteLine(result.GetProperty("update").GetProperty("friendlyName").ToString());
            Console.WriteLine(result.GetProperty("groupId").ToString());
            Console.WriteLine(result.GetProperty("deviceClassSubgroups")[0].ToString());
            Console.WriteLine(result.GetProperty("isCanceled").ToString());
            Console.WriteLine(result.GetProperty("isRetried").ToString());
            Console.WriteLine(result.GetProperty("rollbackPolicy").GetProperty("update").GetProperty("updateId").GetProperty("provider").ToString());
            Console.WriteLine(result.GetProperty("rollbackPolicy").GetProperty("update").GetProperty("updateId").GetProperty("name").ToString());
            Console.WriteLine(result.GetProperty("rollbackPolicy").GetProperty("update").GetProperty("updateId").GetProperty("version").ToString());
            Console.WriteLine(result.GetProperty("rollbackPolicy").GetProperty("update").GetProperty("description").ToString());
            Console.WriteLine(result.GetProperty("rollbackPolicy").GetProperty("update").GetProperty("friendlyName").ToString());
            Console.WriteLine(result.GetProperty("rollbackPolicy").GetProperty("failure").GetProperty("devicesFailedPercentage").ToString());
            Console.WriteLine(result.GetProperty("rollbackPolicy").GetProperty("failure").GetProperty("devicesFailedCount").ToString());
            Console.WriteLine(result.GetProperty("isCloudInitiatedRollback").ToString());
        }

        [Test]
        [Ignore("Only validating compilation of examples")]
        public async Task Example_StopDeployment_AllParameters_Async()
        {
            Uri endpoint = new Uri("<endpoint>");
            TokenCredential credential = new DefaultAzureCredential();
            DeviceManagementClient client = new DeviceManagementClient(endpoint, "<InstanceId>", credential);

            Response response = await client.StopDeploymentAsync("<groupId>", "<deviceClassId>", "<deploymentId>");

            JsonElement result = JsonDocument.Parse(response.ContentStream).RootElement;
            Console.WriteLine(result.GetProperty("deploymentId").ToString());
            Console.WriteLine(result.GetProperty("startDateTime").ToString());
            Console.WriteLine(result.GetProperty("update").GetProperty("updateId").GetProperty("provider").ToString());
            Console.WriteLine(result.GetProperty("update").GetProperty("updateId").GetProperty("name").ToString());
            Console.WriteLine(result.GetProperty("update").GetProperty("updateId").GetProperty("version").ToString());
            Console.WriteLine(result.GetProperty("update").GetProperty("description").ToString());
            Console.WriteLine(result.GetProperty("update").GetProperty("friendlyName").ToString());
            Console.WriteLine(result.GetProperty("groupId").ToString());
            Console.WriteLine(result.GetProperty("deviceClassSubgroups")[0].ToString());
            Console.WriteLine(result.GetProperty("isCanceled").ToString());
            Console.WriteLine(result.GetProperty("isRetried").ToString());
            Console.WriteLine(result.GetProperty("rollbackPolicy").GetProperty("update").GetProperty("updateId").GetProperty("provider").ToString());
            Console.WriteLine(result.GetProperty("rollbackPolicy").GetProperty("update").GetProperty("updateId").GetProperty("name").ToString());
            Console.WriteLine(result.GetProperty("rollbackPolicy").GetProperty("update").GetProperty("updateId").GetProperty("version").ToString());
            Console.WriteLine(result.GetProperty("rollbackPolicy").GetProperty("update").GetProperty("description").ToString());
            Console.WriteLine(result.GetProperty("rollbackPolicy").GetProperty("update").GetProperty("friendlyName").ToString());
            Console.WriteLine(result.GetProperty("rollbackPolicy").GetProperty("failure").GetProperty("devicesFailedPercentage").ToString());
            Console.WriteLine(result.GetProperty("rollbackPolicy").GetProperty("failure").GetProperty("devicesFailedCount").ToString());
            Console.WriteLine(result.GetProperty("isCloudInitiatedRollback").ToString());
        }

        [Test]
        [Ignore("Only validating compilation of examples")]
        public void Example_RetryDeployment_ShortVersion()
        {
            Uri endpoint = new Uri("<endpoint>");
            TokenCredential credential = new DefaultAzureCredential();
            DeviceManagementClient client = new DeviceManagementClient(endpoint, "<InstanceId>", credential);

            Response response = client.RetryDeployment("<groupId>", "<deviceClassId>", "<deploymentId>");

            JsonElement result = JsonDocument.Parse(response.ContentStream).RootElement;
            Console.WriteLine(result.GetProperty("deploymentId").ToString());
            Console.WriteLine(result.GetProperty("startDateTime").ToString());
            Console.WriteLine(result.GetProperty("update").GetProperty("updateId").GetProperty("provider").ToString());
            Console.WriteLine(result.GetProperty("update").GetProperty("updateId").GetProperty("name").ToString());
            Console.WriteLine(result.GetProperty("update").GetProperty("updateId").GetProperty("version").ToString());
            Console.WriteLine(result.GetProperty("groupId").ToString());
        }

        [Test]
        [Ignore("Only validating compilation of examples")]
        public async Task Example_RetryDeployment_ShortVersion_Async()
        {
            Uri endpoint = new Uri("<endpoint>");
            TokenCredential credential = new DefaultAzureCredential();
            DeviceManagementClient client = new DeviceManagementClient(endpoint, "<InstanceId>", credential);

            Response response = await client.RetryDeploymentAsync("<groupId>", "<deviceClassId>", "<deploymentId>");

            JsonElement result = JsonDocument.Parse(response.ContentStream).RootElement;
            Console.WriteLine(result.GetProperty("deploymentId").ToString());
            Console.WriteLine(result.GetProperty("startDateTime").ToString());
            Console.WriteLine(result.GetProperty("update").GetProperty("updateId").GetProperty("provider").ToString());
            Console.WriteLine(result.GetProperty("update").GetProperty("updateId").GetProperty("name").ToString());
            Console.WriteLine(result.GetProperty("update").GetProperty("updateId").GetProperty("version").ToString());
            Console.WriteLine(result.GetProperty("groupId").ToString());
        }

        [Test]
        [Ignore("Only validating compilation of examples")]
        public void Example_RetryDeployment_AllParameters()
        {
            Uri endpoint = new Uri("<endpoint>");
            TokenCredential credential = new DefaultAzureCredential();
            DeviceManagementClient client = new DeviceManagementClient(endpoint, "<InstanceId>", credential);

            Response response = client.RetryDeployment("<groupId>", "<deviceClassId>", "<deploymentId>");

            JsonElement result = JsonDocument.Parse(response.ContentStream).RootElement;
            Console.WriteLine(result.GetProperty("deploymentId").ToString());
            Console.WriteLine(result.GetProperty("startDateTime").ToString());
            Console.WriteLine(result.GetProperty("update").GetProperty("updateId").GetProperty("provider").ToString());
            Console.WriteLine(result.GetProperty("update").GetProperty("updateId").GetProperty("name").ToString());
            Console.WriteLine(result.GetProperty("update").GetProperty("updateId").GetProperty("version").ToString());
            Console.WriteLine(result.GetProperty("update").GetProperty("description").ToString());
            Console.WriteLine(result.GetProperty("update").GetProperty("friendlyName").ToString());
            Console.WriteLine(result.GetProperty("groupId").ToString());
            Console.WriteLine(result.GetProperty("deviceClassSubgroups")[0].ToString());
            Console.WriteLine(result.GetProperty("isCanceled").ToString());
            Console.WriteLine(result.GetProperty("isRetried").ToString());
            Console.WriteLine(result.GetProperty("rollbackPolicy").GetProperty("update").GetProperty("updateId").GetProperty("provider").ToString());
            Console.WriteLine(result.GetProperty("rollbackPolicy").GetProperty("update").GetProperty("updateId").GetProperty("name").ToString());
            Console.WriteLine(result.GetProperty("rollbackPolicy").GetProperty("update").GetProperty("updateId").GetProperty("version").ToString());
            Console.WriteLine(result.GetProperty("rollbackPolicy").GetProperty("update").GetProperty("description").ToString());
            Console.WriteLine(result.GetProperty("rollbackPolicy").GetProperty("update").GetProperty("friendlyName").ToString());
            Console.WriteLine(result.GetProperty("rollbackPolicy").GetProperty("failure").GetProperty("devicesFailedPercentage").ToString());
            Console.WriteLine(result.GetProperty("rollbackPolicy").GetProperty("failure").GetProperty("devicesFailedCount").ToString());
            Console.WriteLine(result.GetProperty("isCloudInitiatedRollback").ToString());
        }

        [Test]
        [Ignore("Only validating compilation of examples")]
        public async Task Example_RetryDeployment_AllParameters_Async()
        {
            Uri endpoint = new Uri("<endpoint>");
            TokenCredential credential = new DefaultAzureCredential();
            DeviceManagementClient client = new DeviceManagementClient(endpoint, "<InstanceId>", credential);

            Response response = await client.RetryDeploymentAsync("<groupId>", "<deviceClassId>", "<deploymentId>");

            JsonElement result = JsonDocument.Parse(response.ContentStream).RootElement;
            Console.WriteLine(result.GetProperty("deploymentId").ToString());
            Console.WriteLine(result.GetProperty("startDateTime").ToString());
            Console.WriteLine(result.GetProperty("update").GetProperty("updateId").GetProperty("provider").ToString());
            Console.WriteLine(result.GetProperty("update").GetProperty("updateId").GetProperty("name").ToString());
            Console.WriteLine(result.GetProperty("update").GetProperty("updateId").GetProperty("version").ToString());
            Console.WriteLine(result.GetProperty("update").GetProperty("description").ToString());
            Console.WriteLine(result.GetProperty("update").GetProperty("friendlyName").ToString());
            Console.WriteLine(result.GetProperty("groupId").ToString());
            Console.WriteLine(result.GetProperty("deviceClassSubgroups")[0].ToString());
            Console.WriteLine(result.GetProperty("isCanceled").ToString());
            Console.WriteLine(result.GetProperty("isRetried").ToString());
            Console.WriteLine(result.GetProperty("rollbackPolicy").GetProperty("update").GetProperty("updateId").GetProperty("provider").ToString());
            Console.WriteLine(result.GetProperty("rollbackPolicy").GetProperty("update").GetProperty("updateId").GetProperty("name").ToString());
            Console.WriteLine(result.GetProperty("rollbackPolicy").GetProperty("update").GetProperty("updateId").GetProperty("version").ToString());
            Console.WriteLine(result.GetProperty("rollbackPolicy").GetProperty("update").GetProperty("description").ToString());
            Console.WriteLine(result.GetProperty("rollbackPolicy").GetProperty("update").GetProperty("friendlyName").ToString());
            Console.WriteLine(result.GetProperty("rollbackPolicy").GetProperty("failure").GetProperty("devicesFailedPercentage").ToString());
            Console.WriteLine(result.GetProperty("rollbackPolicy").GetProperty("failure").GetProperty("devicesFailedCount").ToString());
            Console.WriteLine(result.GetProperty("isCloudInitiatedRollback").ToString());
        }

        [Test]
        [Ignore("Only validating compilation of examples")]
        public void Example_GetDeviceClassSubgroupDeploymentStatus_ShortVersion()
        {
            Uri endpoint = new Uri("<endpoint>");
            TokenCredential credential = new DefaultAzureCredential();
            DeviceManagementClient client = new DeviceManagementClient(endpoint, "<InstanceId>", credential);

            Response response = client.GetDeviceClassSubgroupDeploymentStatus("<groupId>", "<deviceClassId>", "<deploymentId>");

            JsonElement result = JsonDocument.Parse(response.ContentStream).RootElement;
            Console.WriteLine(result.GetProperty("groupId").ToString());
            Console.WriteLine(result.GetProperty("deviceClassId").ToString());
            Console.WriteLine(result.GetProperty("deploymentState").ToString());
        }

        [Test]
        [Ignore("Only validating compilation of examples")]
        public async Task Example_GetDeviceClassSubgroupDeploymentStatus_ShortVersion_Async()
        {
            Uri endpoint = new Uri("<endpoint>");
            TokenCredential credential = new DefaultAzureCredential();
            DeviceManagementClient client = new DeviceManagementClient(endpoint, "<InstanceId>", credential);

            Response response = await client.GetDeviceClassSubgroupDeploymentStatusAsync("<groupId>", "<deviceClassId>", "<deploymentId>");

            JsonElement result = JsonDocument.Parse(response.ContentStream).RootElement;
            Console.WriteLine(result.GetProperty("groupId").ToString());
            Console.WriteLine(result.GetProperty("deviceClassId").ToString());
            Console.WriteLine(result.GetProperty("deploymentState").ToString());
        }

        [Test]
        [Ignore("Only validating compilation of examples")]
        public void Example_GetDeviceClassSubgroupDeploymentStatus_AllParameters()
        {
            Uri endpoint = new Uri("<endpoint>");
            TokenCredential credential = new DefaultAzureCredential();
            DeviceManagementClient client = new DeviceManagementClient(endpoint, "<InstanceId>", credential);

            Response response = client.GetDeviceClassSubgroupDeploymentStatus("<groupId>", "<deviceClassId>", "<deploymentId>");

            JsonElement result = JsonDocument.Parse(response.ContentStream).RootElement;
            Console.WriteLine(result.GetProperty("groupId").ToString());
            Console.WriteLine(result.GetProperty("deviceClassId").ToString());
            Console.WriteLine(result.GetProperty("deploymentState").ToString());
            Console.WriteLine(result.GetProperty("error").GetProperty("code").ToString());
            Console.WriteLine(result.GetProperty("error").GetProperty("message").ToString());
            Console.WriteLine(result.GetProperty("error").GetProperty("target").ToString());
            Console.WriteLine(result.GetProperty("error").GetProperty("innererror").GetProperty("code").ToString());
            Console.WriteLine(result.GetProperty("error").GetProperty("innererror").GetProperty("message").ToString());
            Console.WriteLine(result.GetProperty("error").GetProperty("innererror").GetProperty("errorDetail").ToString());
            Console.WriteLine(result.GetProperty("error").GetProperty("occurredDateTime").ToString());
            Console.WriteLine(result.GetProperty("totalDevices").ToString());
            Console.WriteLine(result.GetProperty("devicesInProgressCount").ToString());
            Console.WriteLine(result.GetProperty("devicesCompletedFailedCount").ToString());
            Console.WriteLine(result.GetProperty("devicesCompletedSucceededCount").ToString());
            Console.WriteLine(result.GetProperty("devicesCanceledCount").ToString());
        }

        [Test]
        [Ignore("Only validating compilation of examples")]
        public async Task Example_GetDeviceClassSubgroupDeploymentStatus_AllParameters_Async()
        {
            Uri endpoint = new Uri("<endpoint>");
            TokenCredential credential = new DefaultAzureCredential();
            DeviceManagementClient client = new DeviceManagementClient(endpoint, "<InstanceId>", credential);

            Response response = await client.GetDeviceClassSubgroupDeploymentStatusAsync("<groupId>", "<deviceClassId>", "<deploymentId>");

            JsonElement result = JsonDocument.Parse(response.ContentStream).RootElement;
            Console.WriteLine(result.GetProperty("groupId").ToString());
            Console.WriteLine(result.GetProperty("deviceClassId").ToString());
            Console.WriteLine(result.GetProperty("deploymentState").ToString());
            Console.WriteLine(result.GetProperty("error").GetProperty("code").ToString());
            Console.WriteLine(result.GetProperty("error").GetProperty("message").ToString());
            Console.WriteLine(result.GetProperty("error").GetProperty("target").ToString());
            Console.WriteLine(result.GetProperty("error").GetProperty("innererror").GetProperty("code").ToString());
            Console.WriteLine(result.GetProperty("error").GetProperty("innererror").GetProperty("message").ToString());
            Console.WriteLine(result.GetProperty("error").GetProperty("innererror").GetProperty("errorDetail").ToString());
            Console.WriteLine(result.GetProperty("error").GetProperty("occurredDateTime").ToString());
            Console.WriteLine(result.GetProperty("totalDevices").ToString());
            Console.WriteLine(result.GetProperty("devicesInProgressCount").ToString());
            Console.WriteLine(result.GetProperty("devicesCompletedFailedCount").ToString());
            Console.WriteLine(result.GetProperty("devicesCompletedSucceededCount").ToString());
            Console.WriteLine(result.GetProperty("devicesCanceledCount").ToString());
        }

        [Test]
        [Ignore("Only validating compilation of examples")]
        public void Example_GetOperationStatus_ShortVersion()
        {
            Uri endpoint = new Uri("<endpoint>");
            TokenCredential credential = new DefaultAzureCredential();
            DeviceManagementClient client = new DeviceManagementClient(endpoint, "<InstanceId>", credential);

            Response response = client.GetOperationStatus("<operationId>");

            JsonElement result = JsonDocument.Parse(response.ContentStream).RootElement;
            Console.WriteLine(result.GetProperty("operationId").ToString());
            Console.WriteLine(result.GetProperty("status").ToString());
            Console.WriteLine(result.GetProperty("lastActionDateTime").ToString());
            Console.WriteLine(result.GetProperty("createdDateTime").ToString());
        }

        [Test]
        [Ignore("Only validating compilation of examples")]
        public async Task Example_GetOperationStatus_ShortVersion_Async()
        {
            Uri endpoint = new Uri("<endpoint>");
            TokenCredential credential = new DefaultAzureCredential();
            DeviceManagementClient client = new DeviceManagementClient(endpoint, "<InstanceId>", credential);

            Response response = await client.GetOperationStatusAsync("<operationId>");

            JsonElement result = JsonDocument.Parse(response.ContentStream).RootElement;
            Console.WriteLine(result.GetProperty("operationId").ToString());
            Console.WriteLine(result.GetProperty("status").ToString());
            Console.WriteLine(result.GetProperty("lastActionDateTime").ToString());
            Console.WriteLine(result.GetProperty("createdDateTime").ToString());
        }

        [Test]
        [Ignore("Only validating compilation of examples")]
        public void Example_GetOperationStatus_AllParameters()
        {
            Uri endpoint = new Uri("<endpoint>");
            TokenCredential credential = new DefaultAzureCredential();
            DeviceManagementClient client = new DeviceManagementClient(endpoint, "<InstanceId>", credential);

            Response response = client.GetOperationStatus("<operationId>", ifNoneMatch: new ETag("<ifNoneMatch>"));

            JsonElement result = JsonDocument.Parse(response.ContentStream).RootElement;
            Console.WriteLine(result.GetProperty("operationId").ToString());
            Console.WriteLine(result.GetProperty("status").ToString());
            Console.WriteLine(result.GetProperty("error").GetProperty("code").ToString());
            Console.WriteLine(result.GetProperty("error").GetProperty("message").ToString());
            Console.WriteLine(result.GetProperty("error").GetProperty("target").ToString());
            Console.WriteLine(result.GetProperty("error").GetProperty("innererror").GetProperty("code").ToString());
            Console.WriteLine(result.GetProperty("error").GetProperty("innererror").GetProperty("message").ToString());
            Console.WriteLine(result.GetProperty("error").GetProperty("innererror").GetProperty("errorDetail").ToString());
            Console.WriteLine(result.GetProperty("error").GetProperty("occurredDateTime").ToString());
            Console.WriteLine(result.GetProperty("traceId").ToString());
            Console.WriteLine(result.GetProperty("lastActionDateTime").ToString());
            Console.WriteLine(result.GetProperty("createdDateTime").ToString());
            Console.WriteLine(result.GetProperty("etag").ToString());
        }

        [Test]
        [Ignore("Only validating compilation of examples")]
        public async Task Example_GetOperationStatus_AllParameters_Async()
        {
            Uri endpoint = new Uri("<endpoint>");
            TokenCredential credential = new DefaultAzureCredential();
            DeviceManagementClient client = new DeviceManagementClient(endpoint, "<InstanceId>", credential);

            Response response = await client.GetOperationStatusAsync("<operationId>", ifNoneMatch: new ETag("<ifNoneMatch>"));

            JsonElement result = JsonDocument.Parse(response.ContentStream).RootElement;
            Console.WriteLine(result.GetProperty("operationId").ToString());
            Console.WriteLine(result.GetProperty("status").ToString());
            Console.WriteLine(result.GetProperty("error").GetProperty("code").ToString());
            Console.WriteLine(result.GetProperty("error").GetProperty("message").ToString());
            Console.WriteLine(result.GetProperty("error").GetProperty("target").ToString());
            Console.WriteLine(result.GetProperty("error").GetProperty("innererror").GetProperty("code").ToString());
            Console.WriteLine(result.GetProperty("error").GetProperty("innererror").GetProperty("message").ToString());
            Console.WriteLine(result.GetProperty("error").GetProperty("innererror").GetProperty("errorDetail").ToString());
            Console.WriteLine(result.GetProperty("error").GetProperty("occurredDateTime").ToString());
            Console.WriteLine(result.GetProperty("traceId").ToString());
            Console.WriteLine(result.GetProperty("lastActionDateTime").ToString());
            Console.WriteLine(result.GetProperty("createdDateTime").ToString());
            Console.WriteLine(result.GetProperty("etag").ToString());
        }

        [Test]
        [Ignore("Only validating compilation of examples")]
        public void Example_StartLogCollection_ShortVersion()
        {
            Uri endpoint = new Uri("<endpoint>");
            TokenCredential credential = new DefaultAzureCredential();
            DeviceManagementClient client = new DeviceManagementClient(endpoint, "<InstanceId>", credential);

            using RequestContent content = RequestContent.Create(new
            {
                deviceList = new object[]
            {
new
{
deviceId = "<deviceId>",
}
            },
            });
            Response response = client.StartLogCollection("<logCollectionId>", content);

            JsonElement result = JsonDocument.Parse(response.ContentStream).RootElement;
            Console.WriteLine(result.GetProperty("deviceList")[0].GetProperty("deviceId").ToString());
        }

        [Test]
        [Ignore("Only validating compilation of examples")]
        public async Task Example_StartLogCollection_ShortVersion_Async()
        {
            Uri endpoint = new Uri("<endpoint>");
            TokenCredential credential = new DefaultAzureCredential();
            DeviceManagementClient client = new DeviceManagementClient(endpoint, "<InstanceId>", credential);

            using RequestContent content = RequestContent.Create(new
            {
                deviceList = new object[]
            {
new
{
deviceId = "<deviceId>",
}
            },
            });
            Response response = await client.StartLogCollectionAsync("<logCollectionId>", content);

            JsonElement result = JsonDocument.Parse(response.ContentStream).RootElement;
            Console.WriteLine(result.GetProperty("deviceList")[0].GetProperty("deviceId").ToString());
        }

        [Test]
        [Ignore("Only validating compilation of examples")]
        public void Example_StartLogCollection_AllParameters()
        {
            Uri endpoint = new Uri("<endpoint>");
            TokenCredential credential = new DefaultAzureCredential();
            DeviceManagementClient client = new DeviceManagementClient(endpoint, "<InstanceId>", credential);

            using RequestContent content = RequestContent.Create(new
            {
                operationId = "<operationId>",
                deviceList = new object[]
            {
new
{
deviceId = "<deviceId>",
moduleId = "<moduleId>",
}
            },
                description = "<description>",
            });
            Response response = client.StartLogCollection("<logCollectionId>", content);

            JsonElement result = JsonDocument.Parse(response.ContentStream).RootElement;
            Console.WriteLine(result.GetProperty("operationId").ToString());
            Console.WriteLine(result.GetProperty("deviceList")[0].GetProperty("deviceId").ToString());
            Console.WriteLine(result.GetProperty("deviceList")[0].GetProperty("moduleId").ToString());
            Console.WriteLine(result.GetProperty("description").ToString());
            Console.WriteLine(result.GetProperty("createdDateTime").ToString());
            Console.WriteLine(result.GetProperty("lastActionDateTime").ToString());
            Console.WriteLine(result.GetProperty("status").ToString());
        }

        [Test]
        [Ignore("Only validating compilation of examples")]
        public async Task Example_StartLogCollection_AllParameters_Async()
        {
            Uri endpoint = new Uri("<endpoint>");
            TokenCredential credential = new DefaultAzureCredential();
            DeviceManagementClient client = new DeviceManagementClient(endpoint, "<InstanceId>", credential);

            using RequestContent content = RequestContent.Create(new
            {
                operationId = "<operationId>",
                deviceList = new object[]
            {
new
{
deviceId = "<deviceId>",
moduleId = "<moduleId>",
}
            },
                description = "<description>",
            });
            Response response = await client.StartLogCollectionAsync("<logCollectionId>", content);

            JsonElement result = JsonDocument.Parse(response.ContentStream).RootElement;
            Console.WriteLine(result.GetProperty("operationId").ToString());
            Console.WriteLine(result.GetProperty("deviceList")[0].GetProperty("deviceId").ToString());
            Console.WriteLine(result.GetProperty("deviceList")[0].GetProperty("moduleId").ToString());
            Console.WriteLine(result.GetProperty("description").ToString());
            Console.WriteLine(result.GetProperty("createdDateTime").ToString());
            Console.WriteLine(result.GetProperty("lastActionDateTime").ToString());
            Console.WriteLine(result.GetProperty("status").ToString());
        }

        [Test]
        [Ignore("Only validating compilation of examples")]
        public void Example_GetLogCollection_ShortVersion()
        {
            Uri endpoint = new Uri("<endpoint>");
            TokenCredential credential = new DefaultAzureCredential();
            DeviceManagementClient client = new DeviceManagementClient(endpoint, "<InstanceId>", credential);

            Response response = client.GetLogCollection("<logCollectionId>");

            JsonElement result = JsonDocument.Parse(response.ContentStream).RootElement;
            Console.WriteLine(result.GetProperty("deviceList")[0].GetProperty("deviceId").ToString());
        }

        [Test]
        [Ignore("Only validating compilation of examples")]
        public async Task Example_GetLogCollection_ShortVersion_Async()
        {
            Uri endpoint = new Uri("<endpoint>");
            TokenCredential credential = new DefaultAzureCredential();
            DeviceManagementClient client = new DeviceManagementClient(endpoint, "<InstanceId>", credential);

            Response response = await client.GetLogCollectionAsync("<logCollectionId>");

            JsonElement result = JsonDocument.Parse(response.ContentStream).RootElement;
            Console.WriteLine(result.GetProperty("deviceList")[0].GetProperty("deviceId").ToString());
        }

        [Test]
        [Ignore("Only validating compilation of examples")]
        public void Example_GetLogCollection_AllParameters()
        {
            Uri endpoint = new Uri("<endpoint>");
            TokenCredential credential = new DefaultAzureCredential();
            DeviceManagementClient client = new DeviceManagementClient(endpoint, "<InstanceId>", credential);

            Response response = client.GetLogCollection("<logCollectionId>");

            JsonElement result = JsonDocument.Parse(response.ContentStream).RootElement;
            Console.WriteLine(result.GetProperty("operationId").ToString());
            Console.WriteLine(result.GetProperty("deviceList")[0].GetProperty("deviceId").ToString());
            Console.WriteLine(result.GetProperty("deviceList")[0].GetProperty("moduleId").ToString());
            Console.WriteLine(result.GetProperty("description").ToString());
            Console.WriteLine(result.GetProperty("createdDateTime").ToString());
            Console.WriteLine(result.GetProperty("lastActionDateTime").ToString());
            Console.WriteLine(result.GetProperty("status").ToString());
        }

        [Test]
        [Ignore("Only validating compilation of examples")]
        public async Task Example_GetLogCollection_AllParameters_Async()
        {
            Uri endpoint = new Uri("<endpoint>");
            TokenCredential credential = new DefaultAzureCredential();
            DeviceManagementClient client = new DeviceManagementClient(endpoint, "<InstanceId>", credential);

            Response response = await client.GetLogCollectionAsync("<logCollectionId>");

            JsonElement result = JsonDocument.Parse(response.ContentStream).RootElement;
            Console.WriteLine(result.GetProperty("operationId").ToString());
            Console.WriteLine(result.GetProperty("deviceList")[0].GetProperty("deviceId").ToString());
            Console.WriteLine(result.GetProperty("deviceList")[0].GetProperty("moduleId").ToString());
            Console.WriteLine(result.GetProperty("description").ToString());
            Console.WriteLine(result.GetProperty("createdDateTime").ToString());
            Console.WriteLine(result.GetProperty("lastActionDateTime").ToString());
            Console.WriteLine(result.GetProperty("status").ToString());
        }

        [Test]
        [Ignore("Only validating compilation of examples")]
        public void Example_GetLogCollectionDetailedStatus_ShortVersion()
        {
            Uri endpoint = new Uri("<endpoint>");
            TokenCredential credential = new DefaultAzureCredential();
            DeviceManagementClient client = new DeviceManagementClient(endpoint, "<InstanceId>", credential);

            Response response = client.GetLogCollectionDetailedStatus("<logCollectionId>");

            JsonElement result = JsonDocument.Parse(response.ContentStream).RootElement;
            Console.WriteLine(result.ToString());
        }

        [Test]
        [Ignore("Only validating compilation of examples")]
        public async Task Example_GetLogCollectionDetailedStatus_ShortVersion_Async()
        {
            Uri endpoint = new Uri("<endpoint>");
            TokenCredential credential = new DefaultAzureCredential();
            DeviceManagementClient client = new DeviceManagementClient(endpoint, "<InstanceId>", credential);

            Response response = await client.GetLogCollectionDetailedStatusAsync("<logCollectionId>");

            JsonElement result = JsonDocument.Parse(response.ContentStream).RootElement;
            Console.WriteLine(result.ToString());
        }

        [Test]
        [Ignore("Only validating compilation of examples")]
        public void Example_GetLogCollectionDetailedStatus_AllParameters()
        {
            Uri endpoint = new Uri("<endpoint>");
            TokenCredential credential = new DefaultAzureCredential();
            DeviceManagementClient client = new DeviceManagementClient(endpoint, "<InstanceId>", credential);

            Response response = client.GetLogCollectionDetailedStatus("<logCollectionId>");

            JsonElement result = JsonDocument.Parse(response.ContentStream).RootElement;
            Console.WriteLine(result.GetProperty("operationId").ToString());
            Console.WriteLine(result.GetProperty("createdDateTime").ToString());
            Console.WriteLine(result.GetProperty("lastActionDateTime").ToString());
            Console.WriteLine(result.GetProperty("status").ToString());
            Console.WriteLine(result.GetProperty("deviceStatus")[0].GetProperty("deviceId").ToString());
            Console.WriteLine(result.GetProperty("deviceStatus")[0].GetProperty("moduleId").ToString());
            Console.WriteLine(result.GetProperty("deviceStatus")[0].GetProperty("status").ToString());
            Console.WriteLine(result.GetProperty("deviceStatus")[0].GetProperty("resultCode").ToString());
            Console.WriteLine(result.GetProperty("deviceStatus")[0].GetProperty("extendedResultCode").ToString());
            Console.WriteLine(result.GetProperty("deviceStatus")[0].GetProperty("logLocation").ToString());
            Console.WriteLine(result.GetProperty("description").ToString());
        }

        [Test]
        [Ignore("Only validating compilation of examples")]
        public async Task Example_GetLogCollectionDetailedStatus_AllParameters_Async()
        {
            Uri endpoint = new Uri("<endpoint>");
            TokenCredential credential = new DefaultAzureCredential();
            DeviceManagementClient client = new DeviceManagementClient(endpoint, "<InstanceId>", credential);

            Response response = await client.GetLogCollectionDetailedStatusAsync("<logCollectionId>");

            JsonElement result = JsonDocument.Parse(response.ContentStream).RootElement;
            Console.WriteLine(result.GetProperty("operationId").ToString());
            Console.WriteLine(result.GetProperty("createdDateTime").ToString());
            Console.WriteLine(result.GetProperty("lastActionDateTime").ToString());
            Console.WriteLine(result.GetProperty("status").ToString());
            Console.WriteLine(result.GetProperty("deviceStatus")[0].GetProperty("deviceId").ToString());
            Console.WriteLine(result.GetProperty("deviceStatus")[0].GetProperty("moduleId").ToString());
            Console.WriteLine(result.GetProperty("deviceStatus")[0].GetProperty("status").ToString());
            Console.WriteLine(result.GetProperty("deviceStatus")[0].GetProperty("resultCode").ToString());
            Console.WriteLine(result.GetProperty("deviceStatus")[0].GetProperty("extendedResultCode").ToString());
            Console.WriteLine(result.GetProperty("deviceStatus")[0].GetProperty("logLocation").ToString());
            Console.WriteLine(result.GetProperty("description").ToString());
        }

        [Test]
        [Ignore("Only validating compilation of examples")]
        public void Example_GetDeviceClasses_ShortVersion()
        {
            Uri endpoint = new Uri("<endpoint>");
            TokenCredential credential = new DefaultAzureCredential();
            DeviceManagementClient client = new DeviceManagementClient(endpoint, "<InstanceId>", credential);

            foreach (BinaryData item in client.GetDeviceClasses())
            {
                JsonElement result = JsonDocument.Parse(item.ToStream()).RootElement;
                Console.WriteLine(result.GetProperty("deviceClassId").ToString());
                Console.WriteLine(result.GetProperty("deviceClassProperties").GetProperty("compatProperties").GetProperty("<key>").ToString());
            }
        }

        [Test]
        [Ignore("Only validating compilation of examples")]
        public async Task Example_GetDeviceClasses_ShortVersion_Async()
        {
            Uri endpoint = new Uri("<endpoint>");
            TokenCredential credential = new DefaultAzureCredential();
            DeviceManagementClient client = new DeviceManagementClient(endpoint, "<InstanceId>", credential);

            await foreach (BinaryData item in client.GetDeviceClassesAsync())
            {
                JsonElement result = JsonDocument.Parse(item.ToStream()).RootElement;
                Console.WriteLine(result.GetProperty("deviceClassId").ToString());
                Console.WriteLine(result.GetProperty("deviceClassProperties").GetProperty("compatProperties").GetProperty("<key>").ToString());
            }
        }

        [Test]
        [Ignore("Only validating compilation of examples")]
        public void Example_GetDeviceClasses_AllParameters()
        {
            Uri endpoint = new Uri("<endpoint>");
            TokenCredential credential = new DefaultAzureCredential();
            DeviceManagementClient client = new DeviceManagementClient(endpoint, "<InstanceId>", credential);

            foreach (BinaryData item in client.GetDeviceClasses(filter: "<filter>"))
            {
                JsonElement result = JsonDocument.Parse(item.ToStream()).RootElement;
                Console.WriteLine(result.GetProperty("deviceClassId").ToString());
                Console.WriteLine(result.GetProperty("friendlyName").ToString());
                Console.WriteLine(result.GetProperty("deviceClassProperties").GetProperty("contractModel").GetProperty("id").ToString());
                Console.WriteLine(result.GetProperty("deviceClassProperties").GetProperty("contractModel").GetProperty("name").ToString());
                Console.WriteLine(result.GetProperty("deviceClassProperties").GetProperty("compatProperties").GetProperty("<key>").ToString());
                Console.WriteLine(result.GetProperty("bestCompatibleUpdate").GetProperty("updateId").GetProperty("provider").ToString());
                Console.WriteLine(result.GetProperty("bestCompatibleUpdate").GetProperty("updateId").GetProperty("name").ToString());
                Console.WriteLine(result.GetProperty("bestCompatibleUpdate").GetProperty("updateId").GetProperty("version").ToString());
                Console.WriteLine(result.GetProperty("bestCompatibleUpdate").GetProperty("description").ToString());
                Console.WriteLine(result.GetProperty("bestCompatibleUpdate").GetProperty("friendlyName").ToString());
            }
        }

        [Test]
        [Ignore("Only validating compilation of examples")]
        public async Task Example_GetDeviceClasses_AllParameters_Async()
        {
            Uri endpoint = new Uri("<endpoint>");
            TokenCredential credential = new DefaultAzureCredential();
            DeviceManagementClient client = new DeviceManagementClient(endpoint, "<InstanceId>", credential);

            await foreach (BinaryData item in client.GetDeviceClassesAsync(filter: "<filter>"))
            {
                JsonElement result = JsonDocument.Parse(item.ToStream()).RootElement;
                Console.WriteLine(result.GetProperty("deviceClassId").ToString());
                Console.WriteLine(result.GetProperty("friendlyName").ToString());
                Console.WriteLine(result.GetProperty("deviceClassProperties").GetProperty("contractModel").GetProperty("id").ToString());
                Console.WriteLine(result.GetProperty("deviceClassProperties").GetProperty("contractModel").GetProperty("name").ToString());
                Console.WriteLine(result.GetProperty("deviceClassProperties").GetProperty("compatProperties").GetProperty("<key>").ToString());
                Console.WriteLine(result.GetProperty("bestCompatibleUpdate").GetProperty("updateId").GetProperty("provider").ToString());
                Console.WriteLine(result.GetProperty("bestCompatibleUpdate").GetProperty("updateId").GetProperty("name").ToString());
                Console.WriteLine(result.GetProperty("bestCompatibleUpdate").GetProperty("updateId").GetProperty("version").ToString());
                Console.WriteLine(result.GetProperty("bestCompatibleUpdate").GetProperty("description").ToString());
                Console.WriteLine(result.GetProperty("bestCompatibleUpdate").GetProperty("friendlyName").ToString());
            }
        }

        [Test]
        [Ignore("Only validating compilation of examples")]
        public void Example_GetInstallableUpdatesForDeviceClasses_ShortVersion()
        {
            Uri endpoint = new Uri("<endpoint>");
            TokenCredential credential = new DefaultAzureCredential();
            DeviceManagementClient client = new DeviceManagementClient(endpoint, "<InstanceId>", credential);

            foreach (BinaryData item in client.GetInstallableUpdatesForDeviceClasses("<deviceClassId>"))
            {
                JsonElement result = JsonDocument.Parse(item.ToStream()).RootElement;
                Console.WriteLine(result.GetProperty("updateId").GetProperty("provider").ToString());
                Console.WriteLine(result.GetProperty("updateId").GetProperty("name").ToString());
                Console.WriteLine(result.GetProperty("updateId").GetProperty("version").ToString());
            }
        }

        [Test]
        [Ignore("Only validating compilation of examples")]
        public async Task Example_GetInstallableUpdatesForDeviceClasses_ShortVersion_Async()
        {
            Uri endpoint = new Uri("<endpoint>");
            TokenCredential credential = new DefaultAzureCredential();
            DeviceManagementClient client = new DeviceManagementClient(endpoint, "<InstanceId>", credential);

            await foreach (BinaryData item in client.GetInstallableUpdatesForDeviceClassesAsync("<deviceClassId>"))
            {
                JsonElement result = JsonDocument.Parse(item.ToStream()).RootElement;
                Console.WriteLine(result.GetProperty("updateId").GetProperty("provider").ToString());
                Console.WriteLine(result.GetProperty("updateId").GetProperty("name").ToString());
                Console.WriteLine(result.GetProperty("updateId").GetProperty("version").ToString());
            }
        }

        [Test]
        [Ignore("Only validating compilation of examples")]
        public void Example_GetInstallableUpdatesForDeviceClasses_AllParameters()
        {
            Uri endpoint = new Uri("<endpoint>");
            TokenCredential credential = new DefaultAzureCredential();
            DeviceManagementClient client = new DeviceManagementClient(endpoint, "<InstanceId>", credential);

            foreach (BinaryData item in client.GetInstallableUpdatesForDeviceClasses("<deviceClassId>"))
            {
                JsonElement result = JsonDocument.Parse(item.ToStream()).RootElement;
                Console.WriteLine(result.GetProperty("updateId").GetProperty("provider").ToString());
                Console.WriteLine(result.GetProperty("updateId").GetProperty("name").ToString());
                Console.WriteLine(result.GetProperty("updateId").GetProperty("version").ToString());
                Console.WriteLine(result.GetProperty("description").ToString());
                Console.WriteLine(result.GetProperty("friendlyName").ToString());
            }
        }

        [Test]
        [Ignore("Only validating compilation of examples")]
        public async Task Example_GetInstallableUpdatesForDeviceClasses_AllParameters_Async()
        {
            Uri endpoint = new Uri("<endpoint>");
            TokenCredential credential = new DefaultAzureCredential();
            DeviceManagementClient client = new DeviceManagementClient(endpoint, "<InstanceId>", credential);

            await foreach (BinaryData item in client.GetInstallableUpdatesForDeviceClassesAsync("<deviceClassId>"))
            {
                JsonElement result = JsonDocument.Parse(item.ToStream()).RootElement;
                Console.WriteLine(result.GetProperty("updateId").GetProperty("provider").ToString());
                Console.WriteLine(result.GetProperty("updateId").GetProperty("name").ToString());
                Console.WriteLine(result.GetProperty("updateId").GetProperty("version").ToString());
                Console.WriteLine(result.GetProperty("description").ToString());
                Console.WriteLine(result.GetProperty("friendlyName").ToString());
            }
        }

        [Test]
        [Ignore("Only validating compilation of examples")]
        public void Example_GetDevices_ShortVersion()
        {
            Uri endpoint = new Uri("<endpoint>");
            TokenCredential credential = new DefaultAzureCredential();
            DeviceManagementClient client = new DeviceManagementClient(endpoint, "<InstanceId>", credential);

            foreach (BinaryData item in client.GetDevices())
            {
                JsonElement result = JsonDocument.Parse(item.ToStream()).RootElement;
                Console.WriteLine(result.GetProperty("deviceId").ToString());
                Console.WriteLine(result.GetProperty("deviceClassId").ToString());
                Console.WriteLine(result.GetProperty("onLatestUpdate").ToString());
            }
        }

        [Test]
        [Ignore("Only validating compilation of examples")]
        public async Task Example_GetDevices_ShortVersion_Async()
        {
            Uri endpoint = new Uri("<endpoint>");
            TokenCredential credential = new DefaultAzureCredential();
            DeviceManagementClient client = new DeviceManagementClient(endpoint, "<InstanceId>", credential);

            await foreach (BinaryData item in client.GetDevicesAsync())
            {
                JsonElement result = JsonDocument.Parse(item.ToStream()).RootElement;
                Console.WriteLine(result.GetProperty("deviceId").ToString());
                Console.WriteLine(result.GetProperty("deviceClassId").ToString());
                Console.WriteLine(result.GetProperty("onLatestUpdate").ToString());
            }
        }

        [Test]
        [Ignore("Only validating compilation of examples")]
        public void Example_GetDevices_AllParameters()
        {
            Uri endpoint = new Uri("<endpoint>");
            TokenCredential credential = new DefaultAzureCredential();
            DeviceManagementClient client = new DeviceManagementClient(endpoint, "<InstanceId>", credential);

            foreach (BinaryData item in client.GetDevices(filter: "<filter>"))
            {
                JsonElement result = JsonDocument.Parse(item.ToStream()).RootElement;
                Console.WriteLine(result.GetProperty("deviceId").ToString());
                Console.WriteLine(result.GetProperty("moduleId").ToString());
                Console.WriteLine(result.GetProperty("deviceClassId").ToString());
                Console.WriteLine(result.GetProperty("groupId").ToString());
                Console.WriteLine(result.GetProperty("lastAttemptedUpdate").GetProperty("updateId").GetProperty("provider").ToString());
                Console.WriteLine(result.GetProperty("lastAttemptedUpdate").GetProperty("updateId").GetProperty("name").ToString());
                Console.WriteLine(result.GetProperty("lastAttemptedUpdate").GetProperty("updateId").GetProperty("version").ToString());
                Console.WriteLine(result.GetProperty("lastAttemptedUpdate").GetProperty("description").ToString());
                Console.WriteLine(result.GetProperty("lastAttemptedUpdate").GetProperty("friendlyName").ToString());
                Console.WriteLine(result.GetProperty("deploymentStatus").ToString());
                Console.WriteLine(result.GetProperty("installedUpdate").GetProperty("updateId").GetProperty("provider").ToString());
                Console.WriteLine(result.GetProperty("installedUpdate").GetProperty("updateId").GetProperty("name").ToString());
                Console.WriteLine(result.GetProperty("installedUpdate").GetProperty("updateId").GetProperty("version").ToString());
                Console.WriteLine(result.GetProperty("installedUpdate").GetProperty("description").ToString());
                Console.WriteLine(result.GetProperty("installedUpdate").GetProperty("friendlyName").ToString());
                Console.WriteLine(result.GetProperty("onLatestUpdate").ToString());
                Console.WriteLine(result.GetProperty("lastDeploymentId").ToString());
                Console.WriteLine(result.GetProperty("lastInstallResult").GetProperty("resultCode").ToString());
                Console.WriteLine(result.GetProperty("lastInstallResult").GetProperty("extendedResultCode").ToString());
                Console.WriteLine(result.GetProperty("lastInstallResult").GetProperty("resultDetails").ToString());
                Console.WriteLine(result.GetProperty("lastInstallResult").GetProperty("stepResults")[0].GetProperty("update").GetProperty("updateId").GetProperty("provider").ToString());
                Console.WriteLine(result.GetProperty("lastInstallResult").GetProperty("stepResults")[0].GetProperty("update").GetProperty("updateId").GetProperty("name").ToString());
                Console.WriteLine(result.GetProperty("lastInstallResult").GetProperty("stepResults")[0].GetProperty("update").GetProperty("updateId").GetProperty("version").ToString());
                Console.WriteLine(result.GetProperty("lastInstallResult").GetProperty("stepResults")[0].GetProperty("update").GetProperty("description").ToString());
                Console.WriteLine(result.GetProperty("lastInstallResult").GetProperty("stepResults")[0].GetProperty("update").GetProperty("friendlyName").ToString());
                Console.WriteLine(result.GetProperty("lastInstallResult").GetProperty("stepResults")[0].GetProperty("description").ToString());
                Console.WriteLine(result.GetProperty("lastInstallResult").GetProperty("stepResults")[0].GetProperty("resultCode").ToString());
                Console.WriteLine(result.GetProperty("lastInstallResult").GetProperty("stepResults")[0].GetProperty("extendedResultCode").ToString());
                Console.WriteLine(result.GetProperty("lastInstallResult").GetProperty("stepResults")[0].GetProperty("resultDetails").ToString());
            }
        }

        [Test]
        [Ignore("Only validating compilation of examples")]
        public async Task Example_GetDevices_AllParameters_Async()
        {
            Uri endpoint = new Uri("<endpoint>");
            TokenCredential credential = new DefaultAzureCredential();
            DeviceManagementClient client = new DeviceManagementClient(endpoint, "<InstanceId>", credential);

            await foreach (BinaryData item in client.GetDevicesAsync(filter: "<filter>"))
            {
                JsonElement result = JsonDocument.Parse(item.ToStream()).RootElement;
                Console.WriteLine(result.GetProperty("deviceId").ToString());
                Console.WriteLine(result.GetProperty("moduleId").ToString());
                Console.WriteLine(result.GetProperty("deviceClassId").ToString());
                Console.WriteLine(result.GetProperty("groupId").ToString());
                Console.WriteLine(result.GetProperty("lastAttemptedUpdate").GetProperty("updateId").GetProperty("provider").ToString());
                Console.WriteLine(result.GetProperty("lastAttemptedUpdate").GetProperty("updateId").GetProperty("name").ToString());
                Console.WriteLine(result.GetProperty("lastAttemptedUpdate").GetProperty("updateId").GetProperty("version").ToString());
                Console.WriteLine(result.GetProperty("lastAttemptedUpdate").GetProperty("description").ToString());
                Console.WriteLine(result.GetProperty("lastAttemptedUpdate").GetProperty("friendlyName").ToString());
                Console.WriteLine(result.GetProperty("deploymentStatus").ToString());
                Console.WriteLine(result.GetProperty("installedUpdate").GetProperty("updateId").GetProperty("provider").ToString());
                Console.WriteLine(result.GetProperty("installedUpdate").GetProperty("updateId").GetProperty("name").ToString());
                Console.WriteLine(result.GetProperty("installedUpdate").GetProperty("updateId").GetProperty("version").ToString());
                Console.WriteLine(result.GetProperty("installedUpdate").GetProperty("description").ToString());
                Console.WriteLine(result.GetProperty("installedUpdate").GetProperty("friendlyName").ToString());
                Console.WriteLine(result.GetProperty("onLatestUpdate").ToString());
                Console.WriteLine(result.GetProperty("lastDeploymentId").ToString());
                Console.WriteLine(result.GetProperty("lastInstallResult").GetProperty("resultCode").ToString());
                Console.WriteLine(result.GetProperty("lastInstallResult").GetProperty("extendedResultCode").ToString());
                Console.WriteLine(result.GetProperty("lastInstallResult").GetProperty("resultDetails").ToString());
                Console.WriteLine(result.GetProperty("lastInstallResult").GetProperty("stepResults")[0].GetProperty("update").GetProperty("updateId").GetProperty("provider").ToString());
                Console.WriteLine(result.GetProperty("lastInstallResult").GetProperty("stepResults")[0].GetProperty("update").GetProperty("updateId").GetProperty("name").ToString());
                Console.WriteLine(result.GetProperty("lastInstallResult").GetProperty("stepResults")[0].GetProperty("update").GetProperty("updateId").GetProperty("version").ToString());
                Console.WriteLine(result.GetProperty("lastInstallResult").GetProperty("stepResults")[0].GetProperty("update").GetProperty("description").ToString());
                Console.WriteLine(result.GetProperty("lastInstallResult").GetProperty("stepResults")[0].GetProperty("update").GetProperty("friendlyName").ToString());
                Console.WriteLine(result.GetProperty("lastInstallResult").GetProperty("stepResults")[0].GetProperty("description").ToString());
                Console.WriteLine(result.GetProperty("lastInstallResult").GetProperty("stepResults")[0].GetProperty("resultCode").ToString());
                Console.WriteLine(result.GetProperty("lastInstallResult").GetProperty("stepResults")[0].GetProperty("extendedResultCode").ToString());
                Console.WriteLine(result.GetProperty("lastInstallResult").GetProperty("stepResults")[0].GetProperty("resultDetails").ToString());
            }
        }

        [Test]
        [Ignore("Only validating compilation of examples")]
        public void Example_GetGroups_ShortVersion()
        {
            Uri endpoint = new Uri("<endpoint>");
            TokenCredential credential = new DefaultAzureCredential();
            DeviceManagementClient client = new DeviceManagementClient(endpoint, "<InstanceId>", credential);

            foreach (BinaryData item in client.GetGroups())
            {
                JsonElement result = JsonDocument.Parse(item.ToStream()).RootElement;
                Console.WriteLine(result.GetProperty("groupId").ToString());
                Console.WriteLine(result.GetProperty("groupType").ToString());
                Console.WriteLine(result.GetProperty("createdDateTime").ToString());
            }
        }

        [Test]
        [Ignore("Only validating compilation of examples")]
        public async Task Example_GetGroups_ShortVersion_Async()
        {
            Uri endpoint = new Uri("<endpoint>");
            TokenCredential credential = new DefaultAzureCredential();
            DeviceManagementClient client = new DeviceManagementClient(endpoint, "<InstanceId>", credential);

            await foreach (BinaryData item in client.GetGroupsAsync())
            {
                JsonElement result = JsonDocument.Parse(item.ToStream()).RootElement;
                Console.WriteLine(result.GetProperty("groupId").ToString());
                Console.WriteLine(result.GetProperty("groupType").ToString());
                Console.WriteLine(result.GetProperty("createdDateTime").ToString());
            }
        }

        [Test]
        [Ignore("Only validating compilation of examples")]
        public void Example_GetGroups_AllParameters()
        {
            Uri endpoint = new Uri("<endpoint>");
            TokenCredential credential = new DefaultAzureCredential();
            DeviceManagementClient client = new DeviceManagementClient(endpoint, "<InstanceId>", credential);

            foreach (BinaryData item in client.GetGroups(orderBy: "<orderBy>"))
            {
                JsonElement result = JsonDocument.Parse(item.ToStream()).RootElement;
                Console.WriteLine(result.GetProperty("groupId").ToString());
                Console.WriteLine(result.GetProperty("groupType").ToString());
                Console.WriteLine(result.GetProperty("createdDateTime").ToString());
                Console.WriteLine(result.GetProperty("deviceCount").ToString());
                Console.WriteLine(result.GetProperty("subgroupsWithNewUpdatesAvailableCount").ToString());
                Console.WriteLine(result.GetProperty("subgroupsWithUpdatesInProgressCount").ToString());
                Console.WriteLine(result.GetProperty("subgroupsWithOnLatestUpdateCount").ToString());
                Console.WriteLine(result.GetProperty("deployments")[0].ToString());
            }
        }

        [Test]
        [Ignore("Only validating compilation of examples")]
        public async Task Example_GetGroups_AllParameters_Async()
        {
            Uri endpoint = new Uri("<endpoint>");
            TokenCredential credential = new DefaultAzureCredential();
            DeviceManagementClient client = new DeviceManagementClient(endpoint, "<InstanceId>", credential);

            await foreach (BinaryData item in client.GetGroupsAsync(orderBy: "<orderBy>"))
            {
                JsonElement result = JsonDocument.Parse(item.ToStream()).RootElement;
                Console.WriteLine(result.GetProperty("groupId").ToString());
                Console.WriteLine(result.GetProperty("groupType").ToString());
                Console.WriteLine(result.GetProperty("createdDateTime").ToString());
                Console.WriteLine(result.GetProperty("deviceCount").ToString());
                Console.WriteLine(result.GetProperty("subgroupsWithNewUpdatesAvailableCount").ToString());
                Console.WriteLine(result.GetProperty("subgroupsWithUpdatesInProgressCount").ToString());
                Console.WriteLine(result.GetProperty("subgroupsWithOnLatestUpdateCount").ToString());
                Console.WriteLine(result.GetProperty("deployments")[0].ToString());
            }
        }

        [Test]
        [Ignore("Only validating compilation of examples")]
        public void Example_GetBestUpdatesForGroups_ShortVersion()
        {
            Uri endpoint = new Uri("<endpoint>");
            TokenCredential credential = new DefaultAzureCredential();
            DeviceManagementClient client = new DeviceManagementClient(endpoint, "<InstanceId>", credential);

            foreach (BinaryData item in client.GetBestUpdatesForGroups("<groupId>"))
            {
                JsonElement result = JsonDocument.Parse(item.ToStream()).RootElement;
                Console.WriteLine(result.GetProperty("groupId").ToString());
                Console.WriteLine(result.GetProperty("deviceClassId").ToString());
                Console.WriteLine(result.GetProperty("update").GetProperty("updateId").GetProperty("provider").ToString());
                Console.WriteLine(result.GetProperty("update").GetProperty("updateId").GetProperty("name").ToString());
                Console.WriteLine(result.GetProperty("update").GetProperty("updateId").GetProperty("version").ToString());
                Console.WriteLine(result.GetProperty("deviceCount").ToString());
            }
        }

        [Test]
        [Ignore("Only validating compilation of examples")]
        public async Task Example_GetBestUpdatesForGroups_ShortVersion_Async()
        {
            Uri endpoint = new Uri("<endpoint>");
            TokenCredential credential = new DefaultAzureCredential();
            DeviceManagementClient client = new DeviceManagementClient(endpoint, "<InstanceId>", credential);

            await foreach (BinaryData item in client.GetBestUpdatesForGroupsAsync("<groupId>"))
            {
                JsonElement result = JsonDocument.Parse(item.ToStream()).RootElement;
                Console.WriteLine(result.GetProperty("groupId").ToString());
                Console.WriteLine(result.GetProperty("deviceClassId").ToString());
                Console.WriteLine(result.GetProperty("update").GetProperty("updateId").GetProperty("provider").ToString());
                Console.WriteLine(result.GetProperty("update").GetProperty("updateId").GetProperty("name").ToString());
                Console.WriteLine(result.GetProperty("update").GetProperty("updateId").GetProperty("version").ToString());
                Console.WriteLine(result.GetProperty("deviceCount").ToString());
            }
        }

        [Test]
        [Ignore("Only validating compilation of examples")]
        public void Example_GetBestUpdatesForGroups_AllParameters()
        {
            Uri endpoint = new Uri("<endpoint>");
            TokenCredential credential = new DefaultAzureCredential();
            DeviceManagementClient client = new DeviceManagementClient(endpoint, "<InstanceId>", credential);

            foreach (BinaryData item in client.GetBestUpdatesForGroups("<groupId>"))
            {
                JsonElement result = JsonDocument.Parse(item.ToStream()).RootElement;
                Console.WriteLine(result.GetProperty("groupId").ToString());
                Console.WriteLine(result.GetProperty("deviceClassId").ToString());
                Console.WriteLine(result.GetProperty("update").GetProperty("updateId").GetProperty("provider").ToString());
                Console.WriteLine(result.GetProperty("update").GetProperty("updateId").GetProperty("name").ToString());
                Console.WriteLine(result.GetProperty("update").GetProperty("updateId").GetProperty("version").ToString());
                Console.WriteLine(result.GetProperty("update").GetProperty("description").ToString());
                Console.WriteLine(result.GetProperty("update").GetProperty("friendlyName").ToString());
                Console.WriteLine(result.GetProperty("deviceCount").ToString());
            }
        }

        [Test]
        [Ignore("Only validating compilation of examples")]
        public async Task Example_GetBestUpdatesForGroups_AllParameters_Async()
        {
            Uri endpoint = new Uri("<endpoint>");
            TokenCredential credential = new DefaultAzureCredential();
            DeviceManagementClient client = new DeviceManagementClient(endpoint, "<InstanceId>", credential);

            await foreach (BinaryData item in client.GetBestUpdatesForGroupsAsync("<groupId>"))
            {
                JsonElement result = JsonDocument.Parse(item.ToStream()).RootElement;
                Console.WriteLine(result.GetProperty("groupId").ToString());
                Console.WriteLine(result.GetProperty("deviceClassId").ToString());
                Console.WriteLine(result.GetProperty("update").GetProperty("updateId").GetProperty("provider").ToString());
                Console.WriteLine(result.GetProperty("update").GetProperty("updateId").GetProperty("name").ToString());
                Console.WriteLine(result.GetProperty("update").GetProperty("updateId").GetProperty("version").ToString());
                Console.WriteLine(result.GetProperty("update").GetProperty("description").ToString());
                Console.WriteLine(result.GetProperty("update").GetProperty("friendlyName").ToString());
                Console.WriteLine(result.GetProperty("deviceCount").ToString());
            }
        }

        [Test]
        [Ignore("Only validating compilation of examples")]
        public void Example_GetDeploymentsForGroups_ShortVersion()
        {
            Uri endpoint = new Uri("<endpoint>");
            TokenCredential credential = new DefaultAzureCredential();
            DeviceManagementClient client = new DeviceManagementClient(endpoint, "<InstanceId>", credential);

            foreach (BinaryData item in client.GetDeploymentsForGroups("<groupId>"))
            {
                JsonElement result = JsonDocument.Parse(item.ToStream()).RootElement;
                Console.WriteLine(result.GetProperty("deploymentId").ToString());
                Console.WriteLine(result.GetProperty("startDateTime").ToString());
                Console.WriteLine(result.GetProperty("update").GetProperty("updateId").GetProperty("provider").ToString());
                Console.WriteLine(result.GetProperty("update").GetProperty("updateId").GetProperty("name").ToString());
                Console.WriteLine(result.GetProperty("update").GetProperty("updateId").GetProperty("version").ToString());
                Console.WriteLine(result.GetProperty("groupId").ToString());
            }
        }

        [Test]
        [Ignore("Only validating compilation of examples")]
        public async Task Example_GetDeploymentsForGroups_ShortVersion_Async()
        {
            Uri endpoint = new Uri("<endpoint>");
            TokenCredential credential = new DefaultAzureCredential();
            DeviceManagementClient client = new DeviceManagementClient(endpoint, "<InstanceId>", credential);

            await foreach (BinaryData item in client.GetDeploymentsForGroupsAsync("<groupId>"))
            {
                JsonElement result = JsonDocument.Parse(item.ToStream()).RootElement;
                Console.WriteLine(result.GetProperty("deploymentId").ToString());
                Console.WriteLine(result.GetProperty("startDateTime").ToString());
                Console.WriteLine(result.GetProperty("update").GetProperty("updateId").GetProperty("provider").ToString());
                Console.WriteLine(result.GetProperty("update").GetProperty("updateId").GetProperty("name").ToString());
                Console.WriteLine(result.GetProperty("update").GetProperty("updateId").GetProperty("version").ToString());
                Console.WriteLine(result.GetProperty("groupId").ToString());
            }
        }

        [Test]
        [Ignore("Only validating compilation of examples")]
        public void Example_GetDeploymentsForGroups_AllParameters()
        {
            Uri endpoint = new Uri("<endpoint>");
            TokenCredential credential = new DefaultAzureCredential();
            DeviceManagementClient client = new DeviceManagementClient(endpoint, "<InstanceId>", credential);

            foreach (BinaryData item in client.GetDeploymentsForGroups("<groupId>", orderBy: "<orderBy>"))
            {
                JsonElement result = JsonDocument.Parse(item.ToStream()).RootElement;
                Console.WriteLine(result.GetProperty("deploymentId").ToString());
                Console.WriteLine(result.GetProperty("startDateTime").ToString());
                Console.WriteLine(result.GetProperty("update").GetProperty("updateId").GetProperty("provider").ToString());
                Console.WriteLine(result.GetProperty("update").GetProperty("updateId").GetProperty("name").ToString());
                Console.WriteLine(result.GetProperty("update").GetProperty("updateId").GetProperty("version").ToString());
                Console.WriteLine(result.GetProperty("update").GetProperty("description").ToString());
                Console.WriteLine(result.GetProperty("update").GetProperty("friendlyName").ToString());
                Console.WriteLine(result.GetProperty("groupId").ToString());
                Console.WriteLine(result.GetProperty("deviceClassSubgroups")[0].ToString());
                Console.WriteLine(result.GetProperty("isCanceled").ToString());
                Console.WriteLine(result.GetProperty("isRetried").ToString());
                Console.WriteLine(result.GetProperty("rollbackPolicy").GetProperty("update").GetProperty("updateId").GetProperty("provider").ToString());
                Console.WriteLine(result.GetProperty("rollbackPolicy").GetProperty("update").GetProperty("updateId").GetProperty("name").ToString());
                Console.WriteLine(result.GetProperty("rollbackPolicy").GetProperty("update").GetProperty("updateId").GetProperty("version").ToString());
                Console.WriteLine(result.GetProperty("rollbackPolicy").GetProperty("update").GetProperty("description").ToString());
                Console.WriteLine(result.GetProperty("rollbackPolicy").GetProperty("update").GetProperty("friendlyName").ToString());
                Console.WriteLine(result.GetProperty("rollbackPolicy").GetProperty("failure").GetProperty("devicesFailedPercentage").ToString());
                Console.WriteLine(result.GetProperty("rollbackPolicy").GetProperty("failure").GetProperty("devicesFailedCount").ToString());
                Console.WriteLine(result.GetProperty("isCloudInitiatedRollback").ToString());
            }
        }

        [Test]
        [Ignore("Only validating compilation of examples")]
        public async Task Example_GetDeploymentsForGroups_AllParameters_Async()
        {
            Uri endpoint = new Uri("<endpoint>");
            TokenCredential credential = new DefaultAzureCredential();
            DeviceManagementClient client = new DeviceManagementClient(endpoint, "<InstanceId>", credential);

            await foreach (BinaryData item in client.GetDeploymentsForGroupsAsync("<groupId>", orderBy: "<orderBy>"))
            {
                JsonElement result = JsonDocument.Parse(item.ToStream()).RootElement;
                Console.WriteLine(result.GetProperty("deploymentId").ToString());
                Console.WriteLine(result.GetProperty("startDateTime").ToString());
                Console.WriteLine(result.GetProperty("update").GetProperty("updateId").GetProperty("provider").ToString());
                Console.WriteLine(result.GetProperty("update").GetProperty("updateId").GetProperty("name").ToString());
                Console.WriteLine(result.GetProperty("update").GetProperty("updateId").GetProperty("version").ToString());
                Console.WriteLine(result.GetProperty("update").GetProperty("description").ToString());
                Console.WriteLine(result.GetProperty("update").GetProperty("friendlyName").ToString());
                Console.WriteLine(result.GetProperty("groupId").ToString());
                Console.WriteLine(result.GetProperty("deviceClassSubgroups")[0].ToString());
                Console.WriteLine(result.GetProperty("isCanceled").ToString());
                Console.WriteLine(result.GetProperty("isRetried").ToString());
                Console.WriteLine(result.GetProperty("rollbackPolicy").GetProperty("update").GetProperty("updateId").GetProperty("provider").ToString());
                Console.WriteLine(result.GetProperty("rollbackPolicy").GetProperty("update").GetProperty("updateId").GetProperty("name").ToString());
                Console.WriteLine(result.GetProperty("rollbackPolicy").GetProperty("update").GetProperty("updateId").GetProperty("version").ToString());
                Console.WriteLine(result.GetProperty("rollbackPolicy").GetProperty("update").GetProperty("description").ToString());
                Console.WriteLine(result.GetProperty("rollbackPolicy").GetProperty("update").GetProperty("friendlyName").ToString());
                Console.WriteLine(result.GetProperty("rollbackPolicy").GetProperty("failure").GetProperty("devicesFailedPercentage").ToString());
                Console.WriteLine(result.GetProperty("rollbackPolicy").GetProperty("failure").GetProperty("devicesFailedCount").ToString());
                Console.WriteLine(result.GetProperty("isCloudInitiatedRollback").ToString());
            }
        }

        [Test]
        [Ignore("Only validating compilation of examples")]
        public void Example_GetDeviceClassSubgroupsForGroups_ShortVersion()
        {
            Uri endpoint = new Uri("<endpoint>");
            TokenCredential credential = new DefaultAzureCredential();
            DeviceManagementClient client = new DeviceManagementClient(endpoint, "<InstanceId>", credential);

            foreach (BinaryData item in client.GetDeviceClassSubgroupsForGroups("<groupId>"))
            {
                JsonElement result = JsonDocument.Parse(item.ToStream()).RootElement;
                Console.WriteLine(result.GetProperty("deviceClassId").ToString());
                Console.WriteLine(result.GetProperty("groupId").ToString());
                Console.WriteLine(result.GetProperty("createdDateTime").ToString());
            }
        }

        [Test]
        [Ignore("Only validating compilation of examples")]
        public async Task Example_GetDeviceClassSubgroupsForGroups_ShortVersion_Async()
        {
            Uri endpoint = new Uri("<endpoint>");
            TokenCredential credential = new DefaultAzureCredential();
            DeviceManagementClient client = new DeviceManagementClient(endpoint, "<InstanceId>", credential);

            await foreach (BinaryData item in client.GetDeviceClassSubgroupsForGroupsAsync("<groupId>"))
            {
                JsonElement result = JsonDocument.Parse(item.ToStream()).RootElement;
                Console.WriteLine(result.GetProperty("deviceClassId").ToString());
                Console.WriteLine(result.GetProperty("groupId").ToString());
                Console.WriteLine(result.GetProperty("createdDateTime").ToString());
            }
        }

        [Test]
        [Ignore("Only validating compilation of examples")]
        public void Example_GetDeviceClassSubgroupsForGroups_AllParameters()
        {
            Uri endpoint = new Uri("<endpoint>");
            TokenCredential credential = new DefaultAzureCredential();
            DeviceManagementClient client = new DeviceManagementClient(endpoint, "<InstanceId>", credential);

            foreach (BinaryData item in client.GetDeviceClassSubgroupsForGroups("<groupId>", filter: "<filter>"))
            {
                JsonElement result = JsonDocument.Parse(item.ToStream()).RootElement;
                Console.WriteLine(result.GetProperty("deviceClassId").ToString());
                Console.WriteLine(result.GetProperty("groupId").ToString());
                Console.WriteLine(result.GetProperty("createdDateTime").ToString());
                Console.WriteLine(result.GetProperty("deviceCount").ToString());
                Console.WriteLine(result.GetProperty("deploymentId").ToString());
            }
        }

        [Test]
        [Ignore("Only validating compilation of examples")]
        public async Task Example_GetDeviceClassSubgroupsForGroups_AllParameters_Async()
        {
            Uri endpoint = new Uri("<endpoint>");
            TokenCredential credential = new DefaultAzureCredential();
            DeviceManagementClient client = new DeviceManagementClient(endpoint, "<InstanceId>", credential);

            await foreach (BinaryData item in client.GetDeviceClassSubgroupsForGroupsAsync("<groupId>", filter: "<filter>"))
            {
                JsonElement result = JsonDocument.Parse(item.ToStream()).RootElement;
                Console.WriteLine(result.GetProperty("deviceClassId").ToString());
                Console.WriteLine(result.GetProperty("groupId").ToString());
                Console.WriteLine(result.GetProperty("createdDateTime").ToString());
                Console.WriteLine(result.GetProperty("deviceCount").ToString());
                Console.WriteLine(result.GetProperty("deploymentId").ToString());
            }
        }

        [Test]
        [Ignore("Only validating compilation of examples")]
        public void Example_GetDeploymentsForDeviceClassSubgroups_ShortVersion()
        {
            Uri endpoint = new Uri("<endpoint>");
            TokenCredential credential = new DefaultAzureCredential();
            DeviceManagementClient client = new DeviceManagementClient(endpoint, "<InstanceId>", credential);

            foreach (BinaryData item in client.GetDeploymentsForDeviceClassSubgroups("<groupId>", "<deviceClassId>"))
            {
                JsonElement result = JsonDocument.Parse(item.ToStream()).RootElement;
                Console.WriteLine(result.GetProperty("deploymentId").ToString());
                Console.WriteLine(result.GetProperty("startDateTime").ToString());
                Console.WriteLine(result.GetProperty("update").GetProperty("updateId").GetProperty("provider").ToString());
                Console.WriteLine(result.GetProperty("update").GetProperty("updateId").GetProperty("name").ToString());
                Console.WriteLine(result.GetProperty("update").GetProperty("updateId").GetProperty("version").ToString());
                Console.WriteLine(result.GetProperty("groupId").ToString());
            }
        }

        [Test]
        [Ignore("Only validating compilation of examples")]
        public async Task Example_GetDeploymentsForDeviceClassSubgroups_ShortVersion_Async()
        {
            Uri endpoint = new Uri("<endpoint>");
            TokenCredential credential = new DefaultAzureCredential();
            DeviceManagementClient client = new DeviceManagementClient(endpoint, "<InstanceId>", credential);

            await foreach (BinaryData item in client.GetDeploymentsForDeviceClassSubgroupsAsync("<groupId>", "<deviceClassId>"))
            {
                JsonElement result = JsonDocument.Parse(item.ToStream()).RootElement;
                Console.WriteLine(result.GetProperty("deploymentId").ToString());
                Console.WriteLine(result.GetProperty("startDateTime").ToString());
                Console.WriteLine(result.GetProperty("update").GetProperty("updateId").GetProperty("provider").ToString());
                Console.WriteLine(result.GetProperty("update").GetProperty("updateId").GetProperty("name").ToString());
                Console.WriteLine(result.GetProperty("update").GetProperty("updateId").GetProperty("version").ToString());
                Console.WriteLine(result.GetProperty("groupId").ToString());
            }
        }

        [Test]
        [Ignore("Only validating compilation of examples")]
        public void Example_GetDeploymentsForDeviceClassSubgroups_AllParameters()
        {
            Uri endpoint = new Uri("<endpoint>");
            TokenCredential credential = new DefaultAzureCredential();
            DeviceManagementClient client = new DeviceManagementClient(endpoint, "<InstanceId>", credential);

            foreach (BinaryData item in client.GetDeploymentsForDeviceClassSubgroups("<groupId>", "<deviceClassId>", orderBy: "<orderBy>"))
            {
                JsonElement result = JsonDocument.Parse(item.ToStream()).RootElement;
                Console.WriteLine(result.GetProperty("deploymentId").ToString());
                Console.WriteLine(result.GetProperty("startDateTime").ToString());
                Console.WriteLine(result.GetProperty("update").GetProperty("updateId").GetProperty("provider").ToString());
                Console.WriteLine(result.GetProperty("update").GetProperty("updateId").GetProperty("name").ToString());
                Console.WriteLine(result.GetProperty("update").GetProperty("updateId").GetProperty("version").ToString());
                Console.WriteLine(result.GetProperty("update").GetProperty("description").ToString());
                Console.WriteLine(result.GetProperty("update").GetProperty("friendlyName").ToString());
                Console.WriteLine(result.GetProperty("groupId").ToString());
                Console.WriteLine(result.GetProperty("deviceClassSubgroups")[0].ToString());
                Console.WriteLine(result.GetProperty("isCanceled").ToString());
                Console.WriteLine(result.GetProperty("isRetried").ToString());
                Console.WriteLine(result.GetProperty("rollbackPolicy").GetProperty("update").GetProperty("updateId").GetProperty("provider").ToString());
                Console.WriteLine(result.GetProperty("rollbackPolicy").GetProperty("update").GetProperty("updateId").GetProperty("name").ToString());
                Console.WriteLine(result.GetProperty("rollbackPolicy").GetProperty("update").GetProperty("updateId").GetProperty("version").ToString());
                Console.WriteLine(result.GetProperty("rollbackPolicy").GetProperty("update").GetProperty("description").ToString());
                Console.WriteLine(result.GetProperty("rollbackPolicy").GetProperty("update").GetProperty("friendlyName").ToString());
                Console.WriteLine(result.GetProperty("rollbackPolicy").GetProperty("failure").GetProperty("devicesFailedPercentage").ToString());
                Console.WriteLine(result.GetProperty("rollbackPolicy").GetProperty("failure").GetProperty("devicesFailedCount").ToString());
                Console.WriteLine(result.GetProperty("isCloudInitiatedRollback").ToString());
            }
        }

        [Test]
        [Ignore("Only validating compilation of examples")]
        public async Task Example_GetDeploymentsForDeviceClassSubgroups_AllParameters_Async()
        {
            Uri endpoint = new Uri("<endpoint>");
            TokenCredential credential = new DefaultAzureCredential();
            DeviceManagementClient client = new DeviceManagementClient(endpoint, "<InstanceId>", credential);

            await foreach (BinaryData item in client.GetDeploymentsForDeviceClassSubgroupsAsync("<groupId>", "<deviceClassId>", orderBy: "<orderBy>"))
            {
                JsonElement result = JsonDocument.Parse(item.ToStream()).RootElement;
                Console.WriteLine(result.GetProperty("deploymentId").ToString());
                Console.WriteLine(result.GetProperty("startDateTime").ToString());
                Console.WriteLine(result.GetProperty("update").GetProperty("updateId").GetProperty("provider").ToString());
                Console.WriteLine(result.GetProperty("update").GetProperty("updateId").GetProperty("name").ToString());
                Console.WriteLine(result.GetProperty("update").GetProperty("updateId").GetProperty("version").ToString());
                Console.WriteLine(result.GetProperty("update").GetProperty("description").ToString());
                Console.WriteLine(result.GetProperty("update").GetProperty("friendlyName").ToString());
                Console.WriteLine(result.GetProperty("groupId").ToString());
                Console.WriteLine(result.GetProperty("deviceClassSubgroups")[0].ToString());
                Console.WriteLine(result.GetProperty("isCanceled").ToString());
                Console.WriteLine(result.GetProperty("isRetried").ToString());
                Console.WriteLine(result.GetProperty("rollbackPolicy").GetProperty("update").GetProperty("updateId").GetProperty("provider").ToString());
                Console.WriteLine(result.GetProperty("rollbackPolicy").GetProperty("update").GetProperty("updateId").GetProperty("name").ToString());
                Console.WriteLine(result.GetProperty("rollbackPolicy").GetProperty("update").GetProperty("updateId").GetProperty("version").ToString());
                Console.WriteLine(result.GetProperty("rollbackPolicy").GetProperty("update").GetProperty("description").ToString());
                Console.WriteLine(result.GetProperty("rollbackPolicy").GetProperty("update").GetProperty("friendlyName").ToString());
                Console.WriteLine(result.GetProperty("rollbackPolicy").GetProperty("failure").GetProperty("devicesFailedPercentage").ToString());
                Console.WriteLine(result.GetProperty("rollbackPolicy").GetProperty("failure").GetProperty("devicesFailedCount").ToString());
                Console.WriteLine(result.GetProperty("isCloudInitiatedRollback").ToString());
            }
        }

        [Test]
        [Ignore("Only validating compilation of examples")]
        public void Example_GetDeviceStatesForDeviceClassSubgroupDeployments_ShortVersion()
        {
            Uri endpoint = new Uri("<endpoint>");
            TokenCredential credential = new DefaultAzureCredential();
            DeviceManagementClient client = new DeviceManagementClient(endpoint, "<InstanceId>", credential);

            foreach (BinaryData item in client.GetDeviceStatesForDeviceClassSubgroupDeployments("<groupId>", "<deviceClassId>", "<deploymentId>"))
            {
                JsonElement result = JsonDocument.Parse(item.ToStream()).RootElement;
                Console.WriteLine(result.GetProperty("deviceId").ToString());
                Console.WriteLine(result.GetProperty("retryCount").ToString());
                Console.WriteLine(result.GetProperty("movedOnToNewDeployment").ToString());
                Console.WriteLine(result.GetProperty("deviceState").ToString());
            }
        }

        [Test]
        [Ignore("Only validating compilation of examples")]
        public async Task Example_GetDeviceStatesForDeviceClassSubgroupDeployments_ShortVersion_Async()
        {
            Uri endpoint = new Uri("<endpoint>");
            TokenCredential credential = new DefaultAzureCredential();
            DeviceManagementClient client = new DeviceManagementClient(endpoint, "<InstanceId>", credential);

            await foreach (BinaryData item in client.GetDeviceStatesForDeviceClassSubgroupDeploymentsAsync("<groupId>", "<deviceClassId>", "<deploymentId>"))
            {
                JsonElement result = JsonDocument.Parse(item.ToStream()).RootElement;
                Console.WriteLine(result.GetProperty("deviceId").ToString());
                Console.WriteLine(result.GetProperty("retryCount").ToString());
                Console.WriteLine(result.GetProperty("movedOnToNewDeployment").ToString());
                Console.WriteLine(result.GetProperty("deviceState").ToString());
            }
        }

        [Test]
        [Ignore("Only validating compilation of examples")]
        public void Example_GetDeviceStatesForDeviceClassSubgroupDeployments_AllParameters()
        {
            Uri endpoint = new Uri("<endpoint>");
            TokenCredential credential = new DefaultAzureCredential();
            DeviceManagementClient client = new DeviceManagementClient(endpoint, "<InstanceId>", credential);

            foreach (BinaryData item in client.GetDeviceStatesForDeviceClassSubgroupDeployments("<groupId>", "<deviceClassId>", "<deploymentId>", filter: "<filter>"))
            {
                JsonElement result = JsonDocument.Parse(item.ToStream()).RootElement;
                Console.WriteLine(result.GetProperty("deviceId").ToString());
                Console.WriteLine(result.GetProperty("moduleId").ToString());
                Console.WriteLine(result.GetProperty("retryCount").ToString());
                Console.WriteLine(result.GetProperty("movedOnToNewDeployment").ToString());
                Console.WriteLine(result.GetProperty("deviceState").ToString());
            }
        }

        [Test]
        [Ignore("Only validating compilation of examples")]
        public async Task Example_GetDeviceStatesForDeviceClassSubgroupDeployments_AllParameters_Async()
        {
            Uri endpoint = new Uri("<endpoint>");
            TokenCredential credential = new DefaultAzureCredential();
            DeviceManagementClient client = new DeviceManagementClient(endpoint, "<InstanceId>", credential);

            await foreach (BinaryData item in client.GetDeviceStatesForDeviceClassSubgroupDeploymentsAsync("<groupId>", "<deviceClassId>", "<deploymentId>", filter: "<filter>"))
            {
                JsonElement result = JsonDocument.Parse(item.ToStream()).RootElement;
                Console.WriteLine(result.GetProperty("deviceId").ToString());
                Console.WriteLine(result.GetProperty("moduleId").ToString());
                Console.WriteLine(result.GetProperty("retryCount").ToString());
                Console.WriteLine(result.GetProperty("movedOnToNewDeployment").ToString());
                Console.WriteLine(result.GetProperty("deviceState").ToString());
            }
        }

        [Test]
        [Ignore("Only validating compilation of examples")]
        public void Example_GetOperationStatuses_ShortVersion()
        {
            Uri endpoint = new Uri("<endpoint>");
            TokenCredential credential = new DefaultAzureCredential();
            DeviceManagementClient client = new DeviceManagementClient(endpoint, "<InstanceId>", credential);

            foreach (BinaryData item in client.GetOperationStatuses())
            {
                JsonElement result = JsonDocument.Parse(item.ToStream()).RootElement;
                Console.WriteLine(result.GetProperty("operationId").ToString());
                Console.WriteLine(result.GetProperty("status").ToString());
                Console.WriteLine(result.GetProperty("lastActionDateTime").ToString());
                Console.WriteLine(result.GetProperty("createdDateTime").ToString());
            }
        }

        [Test]
        [Ignore("Only validating compilation of examples")]
        public async Task Example_GetOperationStatuses_ShortVersion_Async()
        {
            Uri endpoint = new Uri("<endpoint>");
            TokenCredential credential = new DefaultAzureCredential();
            DeviceManagementClient client = new DeviceManagementClient(endpoint, "<InstanceId>", credential);

            await foreach (BinaryData item in client.GetOperationStatusesAsync())
            {
                JsonElement result = JsonDocument.Parse(item.ToStream()).RootElement;
                Console.WriteLine(result.GetProperty("operationId").ToString());
                Console.WriteLine(result.GetProperty("status").ToString());
                Console.WriteLine(result.GetProperty("lastActionDateTime").ToString());
                Console.WriteLine(result.GetProperty("createdDateTime").ToString());
            }
        }

        [Test]
        [Ignore("Only validating compilation of examples")]
        public void Example_GetOperationStatuses_AllParameters()
        {
            Uri endpoint = new Uri("<endpoint>");
            TokenCredential credential = new DefaultAzureCredential();
            DeviceManagementClient client = new DeviceManagementClient(endpoint, "<InstanceId>", credential);

            foreach (BinaryData item in client.GetOperationStatuses(filter: "<filter>", top: 1234))
            {
                JsonElement result = JsonDocument.Parse(item.ToStream()).RootElement;
                Console.WriteLine(result.GetProperty("operationId").ToString());
                Console.WriteLine(result.GetProperty("status").ToString());
                Console.WriteLine(result.GetProperty("error").GetProperty("code").ToString());
                Console.WriteLine(result.GetProperty("error").GetProperty("message").ToString());
                Console.WriteLine(result.GetProperty("error").GetProperty("target").ToString());
                Console.WriteLine(result.GetProperty("error").GetProperty("innererror").GetProperty("code").ToString());
                Console.WriteLine(result.GetProperty("error").GetProperty("innererror").GetProperty("message").ToString());
                Console.WriteLine(result.GetProperty("error").GetProperty("innererror").GetProperty("errorDetail").ToString());
                Console.WriteLine(result.GetProperty("error").GetProperty("occurredDateTime").ToString());
                Console.WriteLine(result.GetProperty("traceId").ToString());
                Console.WriteLine(result.GetProperty("lastActionDateTime").ToString());
                Console.WriteLine(result.GetProperty("createdDateTime").ToString());
                Console.WriteLine(result.GetProperty("etag").ToString());
            }
        }

        [Test]
        [Ignore("Only validating compilation of examples")]
        public async Task Example_GetOperationStatuses_AllParameters_Async()
        {
            Uri endpoint = new Uri("<endpoint>");
            TokenCredential credential = new DefaultAzureCredential();
            DeviceManagementClient client = new DeviceManagementClient(endpoint, "<InstanceId>", credential);

            await foreach (BinaryData item in client.GetOperationStatusesAsync(filter: "<filter>", top: 1234))
            {
                JsonElement result = JsonDocument.Parse(item.ToStream()).RootElement;
                Console.WriteLine(result.GetProperty("operationId").ToString());
                Console.WriteLine(result.GetProperty("status").ToString());
                Console.WriteLine(result.GetProperty("error").GetProperty("code").ToString());
                Console.WriteLine(result.GetProperty("error").GetProperty("message").ToString());
                Console.WriteLine(result.GetProperty("error").GetProperty("target").ToString());
                Console.WriteLine(result.GetProperty("error").GetProperty("innererror").GetProperty("code").ToString());
                Console.WriteLine(result.GetProperty("error").GetProperty("innererror").GetProperty("message").ToString());
                Console.WriteLine(result.GetProperty("error").GetProperty("innererror").GetProperty("errorDetail").ToString());
                Console.WriteLine(result.GetProperty("error").GetProperty("occurredDateTime").ToString());
                Console.WriteLine(result.GetProperty("traceId").ToString());
                Console.WriteLine(result.GetProperty("lastActionDateTime").ToString());
                Console.WriteLine(result.GetProperty("createdDateTime").ToString());
                Console.WriteLine(result.GetProperty("etag").ToString());
            }
        }

        [Test]
        [Ignore("Only validating compilation of examples")]
        public void Example_GetLogCollections_ShortVersion()
        {
            Uri endpoint = new Uri("<endpoint>");
            TokenCredential credential = new DefaultAzureCredential();
            DeviceManagementClient client = new DeviceManagementClient(endpoint, "<InstanceId>", credential);

            foreach (BinaryData item in client.GetLogCollections())
            {
                JsonElement result = JsonDocument.Parse(item.ToStream()).RootElement;
                Console.WriteLine(result.GetProperty("deviceList")[0].GetProperty("deviceId").ToString());
            }
        }

        [Test]
        [Ignore("Only validating compilation of examples")]
        public async Task Example_GetLogCollections_ShortVersion_Async()
        {
            Uri endpoint = new Uri("<endpoint>");
            TokenCredential credential = new DefaultAzureCredential();
            DeviceManagementClient client = new DeviceManagementClient(endpoint, "<InstanceId>", credential);

            await foreach (BinaryData item in client.GetLogCollectionsAsync())
            {
                JsonElement result = JsonDocument.Parse(item.ToStream()).RootElement;
                Console.WriteLine(result.GetProperty("deviceList")[0].GetProperty("deviceId").ToString());
            }
        }

        [Test]
        [Ignore("Only validating compilation of examples")]
        public void Example_GetLogCollections_AllParameters()
        {
            Uri endpoint = new Uri("<endpoint>");
            TokenCredential credential = new DefaultAzureCredential();
            DeviceManagementClient client = new DeviceManagementClient(endpoint, "<InstanceId>", credential);

            foreach (BinaryData item in client.GetLogCollections())
            {
                JsonElement result = JsonDocument.Parse(item.ToStream()).RootElement;
                Console.WriteLine(result.GetProperty("operationId").ToString());
                Console.WriteLine(result.GetProperty("deviceList")[0].GetProperty("deviceId").ToString());
                Console.WriteLine(result.GetProperty("deviceList")[0].GetProperty("moduleId").ToString());
                Console.WriteLine(result.GetProperty("description").ToString());
                Console.WriteLine(result.GetProperty("createdDateTime").ToString());
                Console.WriteLine(result.GetProperty("lastActionDateTime").ToString());
                Console.WriteLine(result.GetProperty("status").ToString());
            }
        }

        [Test]
        [Ignore("Only validating compilation of examples")]
        public async Task Example_GetLogCollections_AllParameters_Async()
        {
            Uri endpoint = new Uri("<endpoint>");
            TokenCredential credential = new DefaultAzureCredential();
            DeviceManagementClient client = new DeviceManagementClient(endpoint, "<InstanceId>", credential);

            await foreach (BinaryData item in client.GetLogCollectionsAsync())
            {
                JsonElement result = JsonDocument.Parse(item.ToStream()).RootElement;
                Console.WriteLine(result.GetProperty("operationId").ToString());
                Console.WriteLine(result.GetProperty("deviceList")[0].GetProperty("deviceId").ToString());
                Console.WriteLine(result.GetProperty("deviceList")[0].GetProperty("moduleId").ToString());
                Console.WriteLine(result.GetProperty("description").ToString());
                Console.WriteLine(result.GetProperty("createdDateTime").ToString());
                Console.WriteLine(result.GetProperty("lastActionDateTime").ToString());
                Console.WriteLine(result.GetProperty("status").ToString());
            }
        }

        [Test]
        [Ignore("Only validating compilation of examples")]
        public void Example_GetHealthOfDevices_ShortVersion()
        {
            Uri endpoint = new Uri("<endpoint>");
            TokenCredential credential = new DefaultAzureCredential();
            DeviceManagementClient client = new DeviceManagementClient(endpoint, "<InstanceId>", credential);

            foreach (BinaryData item in client.GetHealthOfDevices("<filter>"))
            {
                JsonElement result = JsonDocument.Parse(item.ToStream()).RootElement;
                Console.WriteLine(result.GetProperty("deviceId").ToString());
                Console.WriteLine(result.GetProperty("state").ToString());
                Console.WriteLine(result.GetProperty("healthChecks")[0].ToString());
            }
        }

        [Test]
        [Ignore("Only validating compilation of examples")]
        public async Task Example_GetHealthOfDevices_ShortVersion_Async()
        {
            Uri endpoint = new Uri("<endpoint>");
            TokenCredential credential = new DefaultAzureCredential();
            DeviceManagementClient client = new DeviceManagementClient(endpoint, "<InstanceId>", credential);

            await foreach (BinaryData item in client.GetHealthOfDevicesAsync("<filter>"))
            {
                JsonElement result = JsonDocument.Parse(item.ToStream()).RootElement;
                Console.WriteLine(result.GetProperty("deviceId").ToString());
                Console.WriteLine(result.GetProperty("state").ToString());
                Console.WriteLine(result.GetProperty("healthChecks")[0].ToString());
            }
        }

        [Test]
        [Ignore("Only validating compilation of examples")]
        public void Example_GetHealthOfDevices_AllParameters()
        {
            Uri endpoint = new Uri("<endpoint>");
            TokenCredential credential = new DefaultAzureCredential();
            DeviceManagementClient client = new DeviceManagementClient(endpoint, "<InstanceId>", credential);

            foreach (BinaryData item in client.GetHealthOfDevices("<filter>"))
            {
                JsonElement result = JsonDocument.Parse(item.ToStream()).RootElement;
                Console.WriteLine(result.GetProperty("deviceId").ToString());
                Console.WriteLine(result.GetProperty("moduleId").ToString());
                Console.WriteLine(result.GetProperty("state").ToString());
                Console.WriteLine(result.GetProperty("digitalTwinModelId").ToString());
                Console.WriteLine(result.GetProperty("healthChecks")[0].GetProperty("name").ToString());
                Console.WriteLine(result.GetProperty("healthChecks")[0].GetProperty("result").ToString());
            }
        }

        [Test]
        [Ignore("Only validating compilation of examples")]
        public async Task Example_GetHealthOfDevices_AllParameters_Async()
        {
            Uri endpoint = new Uri("<endpoint>");
            TokenCredential credential = new DefaultAzureCredential();
            DeviceManagementClient client = new DeviceManagementClient(endpoint, "<InstanceId>", credential);

            await foreach (BinaryData item in client.GetHealthOfDevicesAsync("<filter>"))
            {
                JsonElement result = JsonDocument.Parse(item.ToStream()).RootElement;
                Console.WriteLine(result.GetProperty("deviceId").ToString());
                Console.WriteLine(result.GetProperty("moduleId").ToString());
                Console.WriteLine(result.GetProperty("state").ToString());
                Console.WriteLine(result.GetProperty("digitalTwinModelId").ToString());
                Console.WriteLine(result.GetProperty("healthChecks")[0].GetProperty("name").ToString());
                Console.WriteLine(result.GetProperty("healthChecks")[0].GetProperty("result").ToString());
            }
        }

        [Test]
        [Ignore("Only validating compilation of examples")]
        public void Example_ImportDevices_ShortVersion()
        {
            Uri endpoint = new Uri("<endpoint>");
            TokenCredential credential = new DefaultAzureCredential();
            DeviceManagementClient client = new DeviceManagementClient(endpoint, "<InstanceId>", credential);

            using RequestContent content = RequestContent.Create("Devices");
            Operation operation = client.ImportDevices(WaitUntil.Completed, content);
        }

        [Test]
        [Ignore("Only validating compilation of examples")]
        public async Task Example_ImportDevices_ShortVersion_Async()
        {
            Uri endpoint = new Uri("<endpoint>");
            TokenCredential credential = new DefaultAzureCredential();
            DeviceManagementClient client = new DeviceManagementClient(endpoint, "<InstanceId>", credential);

            using RequestContent content = RequestContent.Create("Devices");
            Operation operation = await client.ImportDevicesAsync(WaitUntil.Completed, content);
        }

        [Test]
        [Ignore("Only validating compilation of examples")]
        public void Example_ImportDevices_AllParameters()
        {
            Uri endpoint = new Uri("<endpoint>");
            TokenCredential credential = new DefaultAzureCredential();
            DeviceManagementClient client = new DeviceManagementClient(endpoint, "<InstanceId>", credential);

            using RequestContent content = RequestContent.Create("Devices");
            Operation operation = client.ImportDevices(WaitUntil.Completed, content);
        }

        [Test]
        [Ignore("Only validating compilation of examples")]
        public async Task Example_ImportDevices_AllParameters_Async()
        {
            Uri endpoint = new Uri("<endpoint>");
            TokenCredential credential = new DefaultAzureCredential();
            DeviceManagementClient client = new DeviceManagementClient(endpoint, "<InstanceId>", credential);

            using RequestContent content = RequestContent.Create("Devices");
            Operation operation = await client.ImportDevicesAsync(WaitUntil.Completed, content);
        }
    }
}
