// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.

// <auto-generated/>

#nullable disable

using System;
using System.ClientModel.Primitives;
using System.Collections.Generic;
using System.Text.Json;
using Azure.Core;

namespace Azure.ResourceManager.DeviceRegistry.Models
{
    public partial class UsernamePasswordCredentialsUpdate : IUtf8JsonSerializable, IJsonModel<UsernamePasswordCredentialsUpdate>
    {
        void IUtf8JsonSerializable.Write(Utf8JsonWriter writer) => ((IJsonModel<UsernamePasswordCredentialsUpdate>)this).Write(writer, ModelSerializationExtensions.WireOptions);

        void IJsonModel<UsernamePasswordCredentialsUpdate>.Write(Utf8JsonWriter writer, ModelReaderWriterOptions options)
        {
            writer.WriteStartObject();
            JsonModelWriteCore(writer, options);
            writer.WriteEndObject();
        }

        /// <param name="writer"> The JSON writer. </param>
        /// <param name="options"> The client options for reading and writing models. </param>
        protected virtual void JsonModelWriteCore(Utf8JsonWriter writer, ModelReaderWriterOptions options)
        {
            var format = options.Format == "W" ? ((IPersistableModel<UsernamePasswordCredentialsUpdate>)this).GetFormatFromOptions(options) : options.Format;
            if (format != "J")
            {
                throw new FormatException($"The model {nameof(UsernamePasswordCredentialsUpdate)} does not support writing '{format}' format.");
            }

            if (Optional.IsDefined(UsernameReference))
            {
                writer.WritePropertyName("usernameReference"u8);
                writer.WriteStringValue(UsernameReference);
            }
            if (Optional.IsDefined(PasswordReference))
            {
                writer.WritePropertyName("passwordReference"u8);
                writer.WriteStringValue(PasswordReference);
            }
            if (options.Format != "W" && _serializedAdditionalRawData != null)
            {
                foreach (var item in _serializedAdditionalRawData)
                {
                    writer.WritePropertyName(item.Key);
#if NET6_0_OR_GREATER
				writer.WriteRawValue(item.Value);
#else
                    using (JsonDocument document = JsonDocument.Parse(item.Value))
                    {
                        JsonSerializer.Serialize(writer, document.RootElement);
                    }
#endif
                }
            }
        }

        UsernamePasswordCredentialsUpdate IJsonModel<UsernamePasswordCredentialsUpdate>.Create(ref Utf8JsonReader reader, ModelReaderWriterOptions options)
        {
            var format = options.Format == "W" ? ((IPersistableModel<UsernamePasswordCredentialsUpdate>)this).GetFormatFromOptions(options) : options.Format;
            if (format != "J")
            {
                throw new FormatException($"The model {nameof(UsernamePasswordCredentialsUpdate)} does not support reading '{format}' format.");
            }

            using JsonDocument document = JsonDocument.ParseValue(ref reader);
            return DeserializeUsernamePasswordCredentialsUpdate(document.RootElement, options);
        }

        internal static UsernamePasswordCredentialsUpdate DeserializeUsernamePasswordCredentialsUpdate(JsonElement element, ModelReaderWriterOptions options = null)
        {
            options ??= ModelSerializationExtensions.WireOptions;

            if (element.ValueKind == JsonValueKind.Null)
            {
                return null;
            }
            string usernameReference = default;
            string passwordReference = default;
            IDictionary<string, BinaryData> serializedAdditionalRawData = default;
            Dictionary<string, BinaryData> rawDataDictionary = new Dictionary<string, BinaryData>();
            foreach (var property in element.EnumerateObject())
            {
                if (property.NameEquals("usernameReference"u8))
                {
                    usernameReference = property.Value.GetString();
                    continue;
                }
                if (property.NameEquals("passwordReference"u8))
                {
                    passwordReference = property.Value.GetString();
                    continue;
                }
                if (options.Format != "W")
                {
                    rawDataDictionary.Add(property.Name, BinaryData.FromString(property.Value.GetRawText()));
                }
            }
            serializedAdditionalRawData = rawDataDictionary;
            return new UsernamePasswordCredentialsUpdate(usernameReference, passwordReference, serializedAdditionalRawData);
        }

        BinaryData IPersistableModel<UsernamePasswordCredentialsUpdate>.Write(ModelReaderWriterOptions options)
        {
            var format = options.Format == "W" ? ((IPersistableModel<UsernamePasswordCredentialsUpdate>)this).GetFormatFromOptions(options) : options.Format;

            switch (format)
            {
                case "J":
                    return ModelReaderWriter.Write(this, options);
                default:
                    throw new FormatException($"The model {nameof(UsernamePasswordCredentialsUpdate)} does not support writing '{options.Format}' format.");
            }
        }

        UsernamePasswordCredentialsUpdate IPersistableModel<UsernamePasswordCredentialsUpdate>.Create(BinaryData data, ModelReaderWriterOptions options)
        {
            var format = options.Format == "W" ? ((IPersistableModel<UsernamePasswordCredentialsUpdate>)this).GetFormatFromOptions(options) : options.Format;

            switch (format)
            {
                case "J":
                    {
                        using JsonDocument document = JsonDocument.Parse(data);
                        return DeserializeUsernamePasswordCredentialsUpdate(document.RootElement, options);
                    }
                default:
                    throw new FormatException($"The model {nameof(UsernamePasswordCredentialsUpdate)} does not support reading '{options.Format}' format.");
            }
        }

        string IPersistableModel<UsernamePasswordCredentialsUpdate>.GetFormatFromOptions(ModelReaderWriterOptions options) => "J";
    }
}
