// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.

// <auto-generated/>

#nullable disable

using System;
using System.Collections.Generic;

namespace Azure.ResourceManager.DeviceRegistry.Models
{
    /// <summary> The credentials for authentication mode UsernamePassword. </summary>
    public partial class UsernamePasswordCredentials
    {
        /// <summary>
        /// Keeps track of any properties unknown to the library.
        /// <para>
        /// To assign an object to the value of this property use <see cref="BinaryData.FromObjectAsJson{T}(T, System.Text.Json.JsonSerializerOptions?)"/>.
        /// </para>
        /// <para>
        /// To assign an already formatted json string to this property use <see cref="BinaryData.FromString(string)"/>.
        /// </para>
        /// <para>
        /// Examples:
        /// <list type="bullet">
        /// <item>
        /// <term>BinaryData.FromObjectAsJson("foo")</term>
        /// <description>Creates a payload of "foo".</description>
        /// </item>
        /// <item>
        /// <term>BinaryData.FromString("\"foo\"")</term>
        /// <description>Creates a payload of "foo".</description>
        /// </item>
        /// <item>
        /// <term>BinaryData.FromObjectAsJson(new { key = "value" })</term>
        /// <description>Creates a payload of { "key": "value" }.</description>
        /// </item>
        /// <item>
        /// <term>BinaryData.FromString("{\"key\": \"value\"}")</term>
        /// <description>Creates a payload of { "key": "value" }.</description>
        /// </item>
        /// </list>
        /// </para>
        /// </summary>
        private IDictionary<string, BinaryData> _serializedAdditionalRawData;

        /// <summary> Initializes a new instance of <see cref="UsernamePasswordCredentials"/>. </summary>
        /// <param name="usernameReference"> A reference to secret containing the username. </param>
        /// <param name="passwordReference"> A reference to secret containing the password. </param>
        /// <exception cref="ArgumentNullException"> <paramref name="usernameReference"/> or <paramref name="passwordReference"/> is null. </exception>
        public UsernamePasswordCredentials(string usernameReference, string passwordReference)
        {
            Argument.AssertNotNull(usernameReference, nameof(usernameReference));
            Argument.AssertNotNull(passwordReference, nameof(passwordReference));

            UsernameReference = usernameReference;
            PasswordReference = passwordReference;
        }

        /// <summary> Initializes a new instance of <see cref="UsernamePasswordCredentials"/>. </summary>
        /// <param name="usernameReference"> A reference to secret containing the username. </param>
        /// <param name="passwordReference"> A reference to secret containing the password. </param>
        /// <param name="serializedAdditionalRawData"> Keeps track of any properties unknown to the library. </param>
        internal UsernamePasswordCredentials(string usernameReference, string passwordReference, IDictionary<string, BinaryData> serializedAdditionalRawData)
        {
            UsernameReference = usernameReference;
            PasswordReference = passwordReference;
            _serializedAdditionalRawData = serializedAdditionalRawData;
        }

        /// <summary> Initializes a new instance of <see cref="UsernamePasswordCredentials"/> for deserialization. </summary>
        internal UsernamePasswordCredentials()
        {
        }

        /// <summary> A reference to secret containing the username. </summary>
        public string UsernameReference { get; set; }
        /// <summary> A reference to secret containing the password. </summary>
        public string PasswordReference { get; set; }
    }
}
