// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.

// <auto-generated/>

#nullable disable

using System;
using System.ClientModel.Primitives;
using System.Collections.Generic;
using System.Text.Json;
using Azure.Core;

namespace Azure.ResourceManager.DeviceRegistry.Models
{
    public partial class UsernamePasswordCredentials : IUtf8JsonSerializable, IJsonModel<UsernamePasswordCredentials>
    {
        void IUtf8JsonSerializable.Write(Utf8JsonWriter writer) => ((IJsonModel<UsernamePasswordCredentials>)this).Write(writer, ModelSerializationExtensions.WireOptions);

        void IJsonModel<UsernamePasswordCredentials>.Write(Utf8JsonWriter writer, ModelReaderWriterOptions options)
        {
            writer.WriteStartObject();
            JsonModelWriteCore(writer, options);
            writer.WriteEndObject();
        }

        /// <param name="writer"> The JSON writer. </param>
        /// <param name="options"> The client options for reading and writing models. </param>
        protected virtual void JsonModelWriteCore(Utf8JsonWriter writer, ModelReaderWriterOptions options)
        {
            var format = options.Format == "W" ? ((IPersistableModel<UsernamePasswordCredentials>)this).GetFormatFromOptions(options) : options.Format;
            if (format != "J")
            {
                throw new FormatException($"The model {nameof(UsernamePasswordCredentials)} does not support writing '{format}' format.");
            }

            writer.WritePropertyName("usernameReference"u8);
            writer.WriteStringValue(UsernameReference);
            writer.WritePropertyName("passwordReference"u8);
            writer.WriteStringValue(PasswordReference);
            if (options.Format != "W" && _serializedAdditionalRawData != null)
            {
                foreach (var item in _serializedAdditionalRawData)
                {
                    writer.WritePropertyName(item.Key);
#if NET6_0_OR_GREATER
				writer.WriteRawValue(item.Value);
#else
                    using (JsonDocument document = JsonDocument.Parse(item.Value))
                    {
                        JsonSerializer.Serialize(writer, document.RootElement);
                    }
#endif
                }
            }
        }

        UsernamePasswordCredentials IJsonModel<UsernamePasswordCredentials>.Create(ref Utf8JsonReader reader, ModelReaderWriterOptions options)
        {
            var format = options.Format == "W" ? ((IPersistableModel<UsernamePasswordCredentials>)this).GetFormatFromOptions(options) : options.Format;
            if (format != "J")
            {
                throw new FormatException($"The model {nameof(UsernamePasswordCredentials)} does not support reading '{format}' format.");
            }

            using JsonDocument document = JsonDocument.ParseValue(ref reader);
            return DeserializeUsernamePasswordCredentials(document.RootElement, options);
        }

        internal static UsernamePasswordCredentials DeserializeUsernamePasswordCredentials(JsonElement element, ModelReaderWriterOptions options = null)
        {
            options ??= ModelSerializationExtensions.WireOptions;

            if (element.ValueKind == JsonValueKind.Null)
            {
                return null;
            }
            string usernameReference = default;
            string passwordReference = default;
            IDictionary<string, BinaryData> serializedAdditionalRawData = default;
            Dictionary<string, BinaryData> rawDataDictionary = new Dictionary<string, BinaryData>();
            foreach (var property in element.EnumerateObject())
            {
                if (property.NameEquals("usernameReference"u8))
                {
                    usernameReference = property.Value.GetString();
                    continue;
                }
                if (property.NameEquals("passwordReference"u8))
                {
                    passwordReference = property.Value.GetString();
                    continue;
                }
                if (options.Format != "W")
                {
                    rawDataDictionary.Add(property.Name, BinaryData.FromString(property.Value.GetRawText()));
                }
            }
            serializedAdditionalRawData = rawDataDictionary;
            return new UsernamePasswordCredentials(usernameReference, passwordReference, serializedAdditionalRawData);
        }

        BinaryData IPersistableModel<UsernamePasswordCredentials>.Write(ModelReaderWriterOptions options)
        {
            var format = options.Format == "W" ? ((IPersistableModel<UsernamePasswordCredentials>)this).GetFormatFromOptions(options) : options.Format;

            switch (format)
            {
                case "J":
                    return ModelReaderWriter.Write(this, options);
                default:
                    throw new FormatException($"The model {nameof(UsernamePasswordCredentials)} does not support writing '{options.Format}' format.");
            }
        }

        UsernamePasswordCredentials IPersistableModel<UsernamePasswordCredentials>.Create(BinaryData data, ModelReaderWriterOptions options)
        {
            var format = options.Format == "W" ? ((IPersistableModel<UsernamePasswordCredentials>)this).GetFormatFromOptions(options) : options.Format;

            switch (format)
            {
                case "J":
                    {
                        using JsonDocument document = JsonDocument.Parse(data);
                        return DeserializeUsernamePasswordCredentials(document.RootElement, options);
                    }
                default:
                    throw new FormatException($"The model {nameof(UsernamePasswordCredentials)} does not support reading '{options.Format}' format.");
            }
        }

        string IPersistableModel<UsernamePasswordCredentials>.GetFormatFromOptions(ModelReaderWriterOptions options) => "J";
    }
}
