// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.

// <auto-generated/>

#nullable disable

using System;
using System.ComponentModel;

namespace Azure.ResourceManager.DeviceRegistry.Models
{
    /// <summary> Defines the mode to authenticate the user of the client at the server. </summary>
    public readonly partial struct UserAuthenticationMode : IEquatable<UserAuthenticationMode>
    {
        private readonly string _value;

        /// <summary> Initializes a new instance of <see cref="UserAuthenticationMode"/>. </summary>
        /// <exception cref="ArgumentNullException"> <paramref name="value"/> is null. </exception>
        public UserAuthenticationMode(string value)
        {
            _value = value ?? throw new ArgumentNullException(nameof(value));
        }

        private const string AnonymousValue = "Anonymous";
        private const string CertificateValue = "Certificate";
        private const string UsernamePasswordValue = "UsernamePassword";

        /// <summary> The user authentication mode is anonymous. </summary>
        public static UserAuthenticationMode Anonymous { get; } = new UserAuthenticationMode(AnonymousValue);
        /// <summary> The user authentication mode is an x509 certificate. </summary>
        public static UserAuthenticationMode Certificate { get; } = new UserAuthenticationMode(CertificateValue);
        /// <summary> The user authentication mode is a username and password. </summary>
        public static UserAuthenticationMode UsernamePassword { get; } = new UserAuthenticationMode(UsernamePasswordValue);
        /// <summary> Determines if two <see cref="UserAuthenticationMode"/> values are the same. </summary>
        public static bool operator ==(UserAuthenticationMode left, UserAuthenticationMode right) => left.Equals(right);
        /// <summary> Determines if two <see cref="UserAuthenticationMode"/> values are not the same. </summary>
        public static bool operator !=(UserAuthenticationMode left, UserAuthenticationMode right) => !left.Equals(right);
        /// <summary> Converts a <see cref="string"/> to a <see cref="UserAuthenticationMode"/>. </summary>
        public static implicit operator UserAuthenticationMode(string value) => new UserAuthenticationMode(value);

        /// <inheritdoc />
        [EditorBrowsable(EditorBrowsableState.Never)]
        public override bool Equals(object obj) => obj is UserAuthenticationMode other && Equals(other);
        /// <inheritdoc />
        public bool Equals(UserAuthenticationMode other) => string.Equals(_value, other._value, StringComparison.InvariantCultureIgnoreCase);

        /// <inheritdoc />
        [EditorBrowsable(EditorBrowsableState.Never)]
        public override int GetHashCode() => _value != null ? StringComparer.InvariantCultureIgnoreCase.GetHashCode(_value) : 0;
        /// <inheritdoc />
        public override string ToString() => _value;
    }
}
