// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.

// <auto-generated/>

#nullable disable

using System;
using System.Collections.Generic;

namespace Azure.ResourceManager.DeviceRegistry.Models
{
    /// <summary> Definition of the client authentication mechanism to the server. </summary>
    public partial class UserAuthentication
    {
        /// <summary>
        /// Keeps track of any properties unknown to the library.
        /// <para>
        /// To assign an object to the value of this property use <see cref="BinaryData.FromObjectAsJson{T}(T, System.Text.Json.JsonSerializerOptions?)"/>.
        /// </para>
        /// <para>
        /// To assign an already formatted json string to this property use <see cref="BinaryData.FromString(string)"/>.
        /// </para>
        /// <para>
        /// Examples:
        /// <list type="bullet">
        /// <item>
        /// <term>BinaryData.FromObjectAsJson("foo")</term>
        /// <description>Creates a payload of "foo".</description>
        /// </item>
        /// <item>
        /// <term>BinaryData.FromString("\"foo\"")</term>
        /// <description>Creates a payload of "foo".</description>
        /// </item>
        /// <item>
        /// <term>BinaryData.FromObjectAsJson(new { key = "value" })</term>
        /// <description>Creates a payload of { "key": "value" }.</description>
        /// </item>
        /// <item>
        /// <term>BinaryData.FromString("{\"key\": \"value\"}")</term>
        /// <description>Creates a payload of { "key": "value" }.</description>
        /// </item>
        /// </list>
        /// </para>
        /// </summary>
        private IDictionary<string, BinaryData> _serializedAdditionalRawData;

        /// <summary> Initializes a new instance of <see cref="UserAuthentication"/>. </summary>
        /// <param name="mode"> Defines the mode to authenticate the user of the client at the server. </param>
        public UserAuthentication(UserAuthenticationMode mode)
        {
            Mode = mode;
        }

        /// <summary> Initializes a new instance of <see cref="UserAuthentication"/>. </summary>
        /// <param name="mode"> Defines the mode to authenticate the user of the client at the server. </param>
        /// <param name="usernamePasswordCredentials"> Defines the username and password references when UsernamePassword user authentication mode is selected. </param>
        /// <param name="x509Credentials"> Defines the certificate reference when Certificate user authentication mode is selected. </param>
        /// <param name="serializedAdditionalRawData"> Keeps track of any properties unknown to the library. </param>
        internal UserAuthentication(UserAuthenticationMode mode, UsernamePasswordCredentials usernamePasswordCredentials, X509Credentials x509Credentials, IDictionary<string, BinaryData> serializedAdditionalRawData)
        {
            Mode = mode;
            UsernamePasswordCredentials = usernamePasswordCredentials;
            X509Credentials = x509Credentials;
            _serializedAdditionalRawData = serializedAdditionalRawData;
        }

        /// <summary> Initializes a new instance of <see cref="UserAuthentication"/> for deserialization. </summary>
        internal UserAuthentication()
        {
        }

        /// <summary> Defines the mode to authenticate the user of the client at the server. </summary>
        public UserAuthenticationMode Mode { get; set; }
        /// <summary> Defines the username and password references when UsernamePassword user authentication mode is selected. </summary>
        public UsernamePasswordCredentials UsernamePasswordCredentials { get; set; }
        /// <summary> Defines the certificate reference when Certificate user authentication mode is selected. </summary>
        internal X509Credentials X509Credentials { get; set; }
        /// <summary> A reference to secret containing the certificate and private key (e.g. stored as .der/.pem or .der/.pfx). </summary>
        public string X509CredentialsCertificateReference
        {
            get => X509Credentials is null ? default : X509Credentials.CertificateReference;
            set => X509Credentials = new X509Credentials(value);
        }
    }
}
