// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.

// <auto-generated/>

#nullable disable

using System;
using System.Collections.Generic;
using System.Linq;

namespace Azure.ResourceManager.DeviceRegistry.Models
{
    /// <summary> Definition of the authentication mechanism for the southbound connector. </summary>
    internal partial class TransportAuthentication
    {
        /// <summary>
        /// Keeps track of any properties unknown to the library.
        /// <para>
        /// To assign an object to the value of this property use <see cref="BinaryData.FromObjectAsJson{T}(T, System.Text.Json.JsonSerializerOptions?)"/>.
        /// </para>
        /// <para>
        /// To assign an already formatted json string to this property use <see cref="BinaryData.FromString(string)"/>.
        /// </para>
        /// <para>
        /// Examples:
        /// <list type="bullet">
        /// <item>
        /// <term>BinaryData.FromObjectAsJson("foo")</term>
        /// <description>Creates a payload of "foo".</description>
        /// </item>
        /// <item>
        /// <term>BinaryData.FromString("\"foo\"")</term>
        /// <description>Creates a payload of "foo".</description>
        /// </item>
        /// <item>
        /// <term>BinaryData.FromObjectAsJson(new { key = "value" })</term>
        /// <description>Creates a payload of { "key": "value" }.</description>
        /// </item>
        /// <item>
        /// <term>BinaryData.FromString("{\"key\": \"value\"}")</term>
        /// <description>Creates a payload of { "key": "value" }.</description>
        /// </item>
        /// </list>
        /// </para>
        /// </summary>
        private IDictionary<string, BinaryData> _serializedAdditionalRawData;

        /// <summary> Initializes a new instance of <see cref="TransportAuthentication"/>. </summary>
        /// <param name="ownCertificates"> Defines a reference to a secret which contains all certificates and private keys that can be used by the southbound connector connecting to the shop floor/OT device. The accepted extensions are .der for certificates and .pfx/.pem for private keys. </param>
        /// <exception cref="ArgumentNullException"> <paramref name="ownCertificates"/> is null. </exception>
        public TransportAuthentication(IEnumerable<OwnCertificate> ownCertificates)
        {
            Argument.AssertNotNull(ownCertificates, nameof(ownCertificates));

            OwnCertificates = ownCertificates.ToList();
        }

        /// <summary> Initializes a new instance of <see cref="TransportAuthentication"/>. </summary>
        /// <param name="ownCertificates"> Defines a reference to a secret which contains all certificates and private keys that can be used by the southbound connector connecting to the shop floor/OT device. The accepted extensions are .der for certificates and .pfx/.pem for private keys. </param>
        /// <param name="serializedAdditionalRawData"> Keeps track of any properties unknown to the library. </param>
        internal TransportAuthentication(IList<OwnCertificate> ownCertificates, IDictionary<string, BinaryData> serializedAdditionalRawData)
        {
            OwnCertificates = ownCertificates;
            _serializedAdditionalRawData = serializedAdditionalRawData;
        }

        /// <summary> Initializes a new instance of <see cref="TransportAuthentication"/> for deserialization. </summary>
        internal TransportAuthentication()
        {
        }

        /// <summary> Defines a reference to a secret which contains all certificates and private keys that can be used by the southbound connector connecting to the shop floor/OT device. The accepted extensions are .der for certificates and .pfx/.pem for private keys. </summary>
        public IList<OwnCertificate> OwnCertificates { get; }
    }
}
