// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.

// <auto-generated/>

#nullable disable

using System;
using System.Collections.Generic;

namespace Azure.ResourceManager.DeviceRegistry.Models
{
    /// <summary> Certificate or private key that can be used by the southbound connector connecting to the shop floor/OT device. The accepted extensions are .der for certificates and .pfx/.pem for private keys. </summary>
    public partial class OwnCertificate
    {
        /// <summary>
        /// Keeps track of any properties unknown to the library.
        /// <para>
        /// To assign an object to the value of this property use <see cref="BinaryData.FromObjectAsJson{T}(T, System.Text.Json.JsonSerializerOptions?)"/>.
        /// </para>
        /// <para>
        /// To assign an already formatted json string to this property use <see cref="BinaryData.FromString(string)"/>.
        /// </para>
        /// <para>
        /// Examples:
        /// <list type="bullet">
        /// <item>
        /// <term>BinaryData.FromObjectAsJson("foo")</term>
        /// <description>Creates a payload of "foo".</description>
        /// </item>
        /// <item>
        /// <term>BinaryData.FromString("\"foo\"")</term>
        /// <description>Creates a payload of "foo".</description>
        /// </item>
        /// <item>
        /// <term>BinaryData.FromObjectAsJson(new { key = "value" })</term>
        /// <description>Creates a payload of { "key": "value" }.</description>
        /// </item>
        /// <item>
        /// <term>BinaryData.FromString("{\"key\": \"value\"}")</term>
        /// <description>Creates a payload of { "key": "value" }.</description>
        /// </item>
        /// </list>
        /// </para>
        /// </summary>
        private IDictionary<string, BinaryData> _serializedAdditionalRawData;

        /// <summary> Initializes a new instance of <see cref="OwnCertificate"/>. </summary>
        public OwnCertificate()
        {
        }

        /// <summary> Initializes a new instance of <see cref="OwnCertificate"/>. </summary>
        /// <param name="certThumbprint"> Certificate thumbprint. </param>
        /// <param name="certSecretReference"> Secret Reference name (cert and private key). </param>
        /// <param name="certPasswordReference"> Secret Reference Name (Pfx or Pem password). </param>
        /// <param name="serializedAdditionalRawData"> Keeps track of any properties unknown to the library. </param>
        internal OwnCertificate(string certThumbprint, string certSecretReference, string certPasswordReference, IDictionary<string, BinaryData> serializedAdditionalRawData)
        {
            CertThumbprint = certThumbprint;
            CertSecretReference = certSecretReference;
            CertPasswordReference = certPasswordReference;
            _serializedAdditionalRawData = serializedAdditionalRawData;
        }

        /// <summary> Certificate thumbprint. </summary>
        public string CertThumbprint { get; set; }
        /// <summary> Secret Reference name (cert and private key). </summary>
        public string CertSecretReference { get; set; }
        /// <summary> Secret Reference Name (Pfx or Pem password). </summary>
        public string CertPasswordReference { get; set; }
    }
}
