// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.

// <auto-generated/>

#nullable disable

using System;
using System.ClientModel.Primitives;
using System.Collections.Generic;
using System.Text.Json;
using Azure.Core;

namespace Azure.ResourceManager.DeviceRegistry.Models
{
    public partial class OwnCertificate : IUtf8JsonSerializable, IJsonModel<OwnCertificate>
    {
        void IUtf8JsonSerializable.Write(Utf8JsonWriter writer) => ((IJsonModel<OwnCertificate>)this).Write(writer, ModelSerializationExtensions.WireOptions);

        void IJsonModel<OwnCertificate>.Write(Utf8JsonWriter writer, ModelReaderWriterOptions options)
        {
            writer.WriteStartObject();
            JsonModelWriteCore(writer, options);
            writer.WriteEndObject();
        }

        /// <param name="writer"> The JSON writer. </param>
        /// <param name="options"> The client options for reading and writing models. </param>
        protected virtual void JsonModelWriteCore(Utf8JsonWriter writer, ModelReaderWriterOptions options)
        {
            var format = options.Format == "W" ? ((IPersistableModel<OwnCertificate>)this).GetFormatFromOptions(options) : options.Format;
            if (format != "J")
            {
                throw new FormatException($"The model {nameof(OwnCertificate)} does not support writing '{format}' format.");
            }

            if (Optional.IsDefined(CertThumbprint))
            {
                writer.WritePropertyName("certThumbprint"u8);
                writer.WriteStringValue(CertThumbprint);
            }
            if (Optional.IsDefined(CertSecretReference))
            {
                writer.WritePropertyName("certSecretReference"u8);
                writer.WriteStringValue(CertSecretReference);
            }
            if (Optional.IsDefined(CertPasswordReference))
            {
                writer.WritePropertyName("certPasswordReference"u8);
                writer.WriteStringValue(CertPasswordReference);
            }
            if (options.Format != "W" && _serializedAdditionalRawData != null)
            {
                foreach (var item in _serializedAdditionalRawData)
                {
                    writer.WritePropertyName(item.Key);
#if NET6_0_OR_GREATER
				writer.WriteRawValue(item.Value);
#else
                    using (JsonDocument document = JsonDocument.Parse(item.Value))
                    {
                        JsonSerializer.Serialize(writer, document.RootElement);
                    }
#endif
                }
            }
        }

        OwnCertificate IJsonModel<OwnCertificate>.Create(ref Utf8JsonReader reader, ModelReaderWriterOptions options)
        {
            var format = options.Format == "W" ? ((IPersistableModel<OwnCertificate>)this).GetFormatFromOptions(options) : options.Format;
            if (format != "J")
            {
                throw new FormatException($"The model {nameof(OwnCertificate)} does not support reading '{format}' format.");
            }

            using JsonDocument document = JsonDocument.ParseValue(ref reader);
            return DeserializeOwnCertificate(document.RootElement, options);
        }

        internal static OwnCertificate DeserializeOwnCertificate(JsonElement element, ModelReaderWriterOptions options = null)
        {
            options ??= ModelSerializationExtensions.WireOptions;

            if (element.ValueKind == JsonValueKind.Null)
            {
                return null;
            }
            string certThumbprint = default;
            string certSecretReference = default;
            string certPasswordReference = default;
            IDictionary<string, BinaryData> serializedAdditionalRawData = default;
            Dictionary<string, BinaryData> rawDataDictionary = new Dictionary<string, BinaryData>();
            foreach (var property in element.EnumerateObject())
            {
                if (property.NameEquals("certThumbprint"u8))
                {
                    certThumbprint = property.Value.GetString();
                    continue;
                }
                if (property.NameEquals("certSecretReference"u8))
                {
                    certSecretReference = property.Value.GetString();
                    continue;
                }
                if (property.NameEquals("certPasswordReference"u8))
                {
                    certPasswordReference = property.Value.GetString();
                    continue;
                }
                if (options.Format != "W")
                {
                    rawDataDictionary.Add(property.Name, BinaryData.FromString(property.Value.GetRawText()));
                }
            }
            serializedAdditionalRawData = rawDataDictionary;
            return new OwnCertificate(certThumbprint, certSecretReference, certPasswordReference, serializedAdditionalRawData);
        }

        BinaryData IPersistableModel<OwnCertificate>.Write(ModelReaderWriterOptions options)
        {
            var format = options.Format == "W" ? ((IPersistableModel<OwnCertificate>)this).GetFormatFromOptions(options) : options.Format;

            switch (format)
            {
                case "J":
                    return ModelReaderWriter.Write(this, options);
                default:
                    throw new FormatException($"The model {nameof(OwnCertificate)} does not support writing '{options.Format}' format.");
            }
        }

        OwnCertificate IPersistableModel<OwnCertificate>.Create(BinaryData data, ModelReaderWriterOptions options)
        {
            var format = options.Format == "W" ? ((IPersistableModel<OwnCertificate>)this).GetFormatFromOptions(options) : options.Format;

            switch (format)
            {
                case "J":
                    {
                        using JsonDocument document = JsonDocument.Parse(data);
                        return DeserializeOwnCertificate(document.RootElement, options);
                    }
                default:
                    throw new FormatException($"The model {nameof(OwnCertificate)} does not support reading '{options.Format}' format.");
            }
        }

        string IPersistableModel<OwnCertificate>.GetFormatFromOptions(ModelReaderWriterOptions options) => "J";
    }
}
