// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.

// <auto-generated/>

#nullable disable

using System;
using System.ComponentModel;

namespace Azure.ResourceManager.DeviceRegistry.Models
{
    /// <summary> An indication of how the event should be mapped to OpenTelemetry. </summary>
    public readonly partial struct EventsObservabilityMode : IEquatable<EventsObservabilityMode>
    {
        private readonly string _value;

        /// <summary> Initializes a new instance of <see cref="EventsObservabilityMode"/>. </summary>
        /// <exception cref="ArgumentNullException"> <paramref name="value"/> is null. </exception>
        public EventsObservabilityMode(string value)
        {
            _value = value ?? throw new ArgumentNullException(nameof(value));
        }

        private const string NoneValue = "none";
        private const string LogValue = "log";

        /// <summary> No mapping to OpenTelemetry. </summary>
        public static EventsObservabilityMode None { get; } = new EventsObservabilityMode(NoneValue);
        /// <summary> Map as log to OpenTelemetry. </summary>
        public static EventsObservabilityMode Log { get; } = new EventsObservabilityMode(LogValue);
        /// <summary> Determines if two <see cref="EventsObservabilityMode"/> values are the same. </summary>
        public static bool operator ==(EventsObservabilityMode left, EventsObservabilityMode right) => left.Equals(right);
        /// <summary> Determines if two <see cref="EventsObservabilityMode"/> values are not the same. </summary>
        public static bool operator !=(EventsObservabilityMode left, EventsObservabilityMode right) => !left.Equals(right);
        /// <summary> Converts a <see cref="string"/> to a <see cref="EventsObservabilityMode"/>. </summary>
        public static implicit operator EventsObservabilityMode(string value) => new EventsObservabilityMode(value);

        /// <inheritdoc />
        [EditorBrowsable(EditorBrowsableState.Never)]
        public override bool Equals(object obj) => obj is EventsObservabilityMode other && Equals(other);
        /// <inheritdoc />
        public bool Equals(EventsObservabilityMode other) => string.Equals(_value, other._value, StringComparison.InvariantCultureIgnoreCase);

        /// <inheritdoc />
        [EditorBrowsable(EditorBrowsableState.Never)]
        public override int GetHashCode() => _value != null ? StringComparer.InvariantCultureIgnoreCase.GetHashCode(_value) : 0;
        /// <inheritdoc />
        public override string ToString() => _value;
    }
}
