// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.

// <auto-generated/>

#nullable disable

using System;
using System.ComponentModel;

namespace Azure.ResourceManager.DeviceRegistry.Models
{
    /// <summary> The provisioning status of the resource. </summary>
    public readonly partial struct DeviceRegistryProvisioningState : IEquatable<DeviceRegistryProvisioningState>
    {
        private readonly string _value;

        /// <summary> Initializes a new instance of <see cref="DeviceRegistryProvisioningState"/>. </summary>
        /// <exception cref="ArgumentNullException"> <paramref name="value"/> is null. </exception>
        public DeviceRegistryProvisioningState(string value)
        {
            _value = value ?? throw new ArgumentNullException(nameof(value));
        }

        private const string SucceededValue = "Succeeded";
        private const string FailedValue = "Failed";
        private const string CanceledValue = "Canceled";
        private const string AcceptedValue = "Accepted";

        /// <summary> Resource has been created. </summary>
        public static DeviceRegistryProvisioningState Succeeded { get; } = new DeviceRegistryProvisioningState(SucceededValue);
        /// <summary> Resource creation failed. </summary>
        public static DeviceRegistryProvisioningState Failed { get; } = new DeviceRegistryProvisioningState(FailedValue);
        /// <summary> Resource creation was canceled. </summary>
        public static DeviceRegistryProvisioningState Canceled { get; } = new DeviceRegistryProvisioningState(CanceledValue);
        /// <summary> Resource has been accepted by the server. </summary>
        public static DeviceRegistryProvisioningState Accepted { get; } = new DeviceRegistryProvisioningState(AcceptedValue);
        /// <summary> Determines if two <see cref="DeviceRegistryProvisioningState"/> values are the same. </summary>
        public static bool operator ==(DeviceRegistryProvisioningState left, DeviceRegistryProvisioningState right) => left.Equals(right);
        /// <summary> Determines if two <see cref="DeviceRegistryProvisioningState"/> values are not the same. </summary>
        public static bool operator !=(DeviceRegistryProvisioningState left, DeviceRegistryProvisioningState right) => !left.Equals(right);
        /// <summary> Converts a <see cref="string"/> to a <see cref="DeviceRegistryProvisioningState"/>. </summary>
        public static implicit operator DeviceRegistryProvisioningState(string value) => new DeviceRegistryProvisioningState(value);

        /// <inheritdoc />
        [EditorBrowsable(EditorBrowsableState.Never)]
        public override bool Equals(object obj) => obj is DeviceRegistryProvisioningState other && Equals(other);
        /// <inheritdoc />
        public bool Equals(DeviceRegistryProvisioningState other) => string.Equals(_value, other._value, StringComparison.InvariantCultureIgnoreCase);

        /// <inheritdoc />
        [EditorBrowsable(EditorBrowsableState.Never)]
        public override int GetHashCode() => _value != null ? StringComparer.InvariantCultureIgnoreCase.GetHashCode(_value) : 0;
        /// <inheritdoc />
        public override string ToString() => _value;
    }
}
