// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.

// <auto-generated/>

#nullable disable

using System;
using System.Collections.Generic;

namespace Azure.ResourceManager.DeviceRegistry.Models
{
    /// <summary> The extended location. </summary>
    public partial class DeviceRegistryExtendedLocation
    {
        /// <summary>
        /// Keeps track of any properties unknown to the library.
        /// <para>
        /// To assign an object to the value of this property use <see cref="BinaryData.FromObjectAsJson{T}(T, System.Text.Json.JsonSerializerOptions?)"/>.
        /// </para>
        /// <para>
        /// To assign an already formatted json string to this property use <see cref="BinaryData.FromString(string)"/>.
        /// </para>
        /// <para>
        /// Examples:
        /// <list type="bullet">
        /// <item>
        /// <term>BinaryData.FromObjectAsJson("foo")</term>
        /// <description>Creates a payload of "foo".</description>
        /// </item>
        /// <item>
        /// <term>BinaryData.FromString("\"foo\"")</term>
        /// <description>Creates a payload of "foo".</description>
        /// </item>
        /// <item>
        /// <term>BinaryData.FromObjectAsJson(new { key = "value" })</term>
        /// <description>Creates a payload of { "key": "value" }.</description>
        /// </item>
        /// <item>
        /// <term>BinaryData.FromString("{\"key\": \"value\"}")</term>
        /// <description>Creates a payload of { "key": "value" }.</description>
        /// </item>
        /// </list>
        /// </para>
        /// </summary>
        private IDictionary<string, BinaryData> _serializedAdditionalRawData;

        /// <summary> Initializes a new instance of <see cref="DeviceRegistryExtendedLocation"/>. </summary>
        /// <param name="extendedLocationType"> The extended location type. </param>
        /// <param name="name"> The extended location name. </param>
        /// <exception cref="ArgumentNullException"> <paramref name="extendedLocationType"/> or <paramref name="name"/> is null. </exception>
        public DeviceRegistryExtendedLocation(string extendedLocationType, string name)
        {
            Argument.AssertNotNull(extendedLocationType, nameof(extendedLocationType));
            Argument.AssertNotNull(name, nameof(name));

            ExtendedLocationType = extendedLocationType;
            Name = name;
        }

        /// <summary> Initializes a new instance of <see cref="DeviceRegistryExtendedLocation"/>. </summary>
        /// <param name="extendedLocationType"> The extended location type. </param>
        /// <param name="name"> The extended location name. </param>
        /// <param name="serializedAdditionalRawData"> Keeps track of any properties unknown to the library. </param>
        internal DeviceRegistryExtendedLocation(string extendedLocationType, string name, IDictionary<string, BinaryData> serializedAdditionalRawData)
        {
            ExtendedLocationType = extendedLocationType;
            Name = name;
            _serializedAdditionalRawData = serializedAdditionalRawData;
        }

        /// <summary> Initializes a new instance of <see cref="DeviceRegistryExtendedLocation"/> for deserialization. </summary>
        internal DeviceRegistryExtendedLocation()
        {
        }

        /// <summary> The extended location type. </summary>
        public string ExtendedLocationType { get; set; }
        /// <summary> The extended location name. </summary>
        public string Name { get; set; }
    }
}
