// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.

// <auto-generated/>

#nullable disable

using System;
using System.Collections.Generic;

namespace Azure.ResourceManager.DeviceRegistry.Models
{
    /// <summary> The type used for update operations of the Asset. </summary>
    public partial class DeviceRegistryAssetPatch
    {
        /// <summary>
        /// Keeps track of any properties unknown to the library.
        /// <para>
        /// To assign an object to the value of this property use <see cref="BinaryData.FromObjectAsJson{T}(T, System.Text.Json.JsonSerializerOptions?)"/>.
        /// </para>
        /// <para>
        /// To assign an already formatted json string to this property use <see cref="BinaryData.FromString(string)"/>.
        /// </para>
        /// <para>
        /// Examples:
        /// <list type="bullet">
        /// <item>
        /// <term>BinaryData.FromObjectAsJson("foo")</term>
        /// <description>Creates a payload of "foo".</description>
        /// </item>
        /// <item>
        /// <term>BinaryData.FromString("\"foo\"")</term>
        /// <description>Creates a payload of "foo".</description>
        /// </item>
        /// <item>
        /// <term>BinaryData.FromObjectAsJson(new { key = "value" })</term>
        /// <description>Creates a payload of { "key": "value" }.</description>
        /// </item>
        /// <item>
        /// <term>BinaryData.FromString("{\"key\": \"value\"}")</term>
        /// <description>Creates a payload of { "key": "value" }.</description>
        /// </item>
        /// </list>
        /// </para>
        /// </summary>
        private IDictionary<string, BinaryData> _serializedAdditionalRawData;

        /// <summary> Initializes a new instance of <see cref="DeviceRegistryAssetPatch"/>. </summary>
        public DeviceRegistryAssetPatch()
        {
            Tags = new ChangeTrackingDictionary<string, string>();
            Attributes = new ChangeTrackingDictionary<string, BinaryData>();
            DataPoints = new ChangeTrackingList<DataPoint>();
            Events = new ChangeTrackingList<AssetEvent>();
        }

        /// <summary> Initializes a new instance of <see cref="DeviceRegistryAssetPatch"/>. </summary>
        /// <param name="tags"> Resource tags. </param>
        /// <param name="assetType"> Resource path to asset type (model) definition. </param>
        /// <param name="enabled"> Enabled/Disabled status of the asset. </param>
        /// <param name="displayName"> Human-readable display name. </param>
        /// <param name="description"> Human-readable description of the asset. </param>
        /// <param name="manufacturer"> Asset manufacturer name. </param>
        /// <param name="manufacturerUri"> Asset manufacturer URI. </param>
        /// <param name="model"> Asset model name. </param>
        /// <param name="productCode"> Asset product code. </param>
        /// <param name="hardwareRevision"> Revision number of the hardware. </param>
        /// <param name="softwareRevision"> Revision number of the software. </param>
        /// <param name="documentationUri"> Reference to the documentation. </param>
        /// <param name="serialNumber"> Asset serial number. </param>
        /// <param name="attributes"> A set of key-value pairs that contain custom attributes set by the customer. </param>
        /// <param name="defaultDataPointsConfiguration"> Protocol-specific default configuration for all data points. Each data point can have its own configuration that overrides the default settings here. This assumes that each asset instance has one protocol. </param>
        /// <param name="defaultEventsConfiguration"> Protocol-specific default configuration for all events. Each event can have its own configuration that overrides the default settings here. This assumes that each asset instance has one protocol. </param>
        /// <param name="dataPoints"> Array of data points that are part of the asset. Each data point can reference an asset type capability and have per-data point configuration. See below for more details for the definition of the dataPoints element. </param>
        /// <param name="events"> Array of events that are part of the asset. Each event can reference an asset type capability and have per-event configuration. See below for more details about the definition of the events element. </param>
        /// <param name="serializedAdditionalRawData"> Keeps track of any properties unknown to the library. </param>
        internal DeviceRegistryAssetPatch(IDictionary<string, string> tags, string assetType, bool? enabled, string displayName, string description, string manufacturer, Uri manufacturerUri, string model, string productCode, string hardwareRevision, string softwareRevision, Uri documentationUri, string serialNumber, IDictionary<string, BinaryData> attributes, string defaultDataPointsConfiguration, string defaultEventsConfiguration, IList<DataPoint> dataPoints, IList<AssetEvent> events, IDictionary<string, BinaryData> serializedAdditionalRawData)
        {
            Tags = tags;
            AssetType = assetType;
            Enabled = enabled;
            DisplayName = displayName;
            Description = description;
            Manufacturer = manufacturer;
            ManufacturerUri = manufacturerUri;
            Model = model;
            ProductCode = productCode;
            HardwareRevision = hardwareRevision;
            SoftwareRevision = softwareRevision;
            DocumentationUri = documentationUri;
            SerialNumber = serialNumber;
            Attributes = attributes;
            DefaultDataPointsConfiguration = defaultDataPointsConfiguration;
            DefaultEventsConfiguration = defaultEventsConfiguration;
            DataPoints = dataPoints;
            Events = events;
            _serializedAdditionalRawData = serializedAdditionalRawData;
        }

        /// <summary> Resource tags. </summary>
        public IDictionary<string, string> Tags { get; }
        /// <summary> Resource path to asset type (model) definition. </summary>
        public string AssetType { get; set; }
        /// <summary> Enabled/Disabled status of the asset. </summary>
        public bool? Enabled { get; set; }
        /// <summary> Human-readable display name. </summary>
        public string DisplayName { get; set; }
        /// <summary> Human-readable description of the asset. </summary>
        public string Description { get; set; }
        /// <summary> Asset manufacturer name. </summary>
        public string Manufacturer { get; set; }
        /// <summary> Asset manufacturer URI. </summary>
        public Uri ManufacturerUri { get; set; }
        /// <summary> Asset model name. </summary>
        public string Model { get; set; }
        /// <summary> Asset product code. </summary>
        public string ProductCode { get; set; }
        /// <summary> Revision number of the hardware. </summary>
        public string HardwareRevision { get; set; }
        /// <summary> Revision number of the software. </summary>
        public string SoftwareRevision { get; set; }
        /// <summary> Reference to the documentation. </summary>
        public Uri DocumentationUri { get; set; }
        /// <summary> Asset serial number. </summary>
        public string SerialNumber { get; set; }
        /// <summary>
        /// A set of key-value pairs that contain custom attributes set by the customer.
        /// <para>
        /// To assign an object to the value of this property use <see cref="BinaryData.FromObjectAsJson{T}(T, System.Text.Json.JsonSerializerOptions?)"/>.
        /// </para>
        /// <para>
        /// To assign an already formatted json string to this property use <see cref="BinaryData.FromString(string)"/>.
        /// </para>
        /// <para>
        /// Examples:
        /// <list type="bullet">
        /// <item>
        /// <term>BinaryData.FromObjectAsJson("foo")</term>
        /// <description>Creates a payload of "foo".</description>
        /// </item>
        /// <item>
        /// <term>BinaryData.FromString("\"foo\"")</term>
        /// <description>Creates a payload of "foo".</description>
        /// </item>
        /// <item>
        /// <term>BinaryData.FromObjectAsJson(new { key = "value" })</term>
        /// <description>Creates a payload of { "key": "value" }.</description>
        /// </item>
        /// <item>
        /// <term>BinaryData.FromString("{\"key\": \"value\"}")</term>
        /// <description>Creates a payload of { "key": "value" }.</description>
        /// </item>
        /// </list>
        /// </para>
        /// </summary>
        public IDictionary<string, BinaryData> Attributes { get; }
        /// <summary> Protocol-specific default configuration for all data points. Each data point can have its own configuration that overrides the default settings here. This assumes that each asset instance has one protocol. </summary>
        public string DefaultDataPointsConfiguration { get; set; }
        /// <summary> Protocol-specific default configuration for all events. Each event can have its own configuration that overrides the default settings here. This assumes that each asset instance has one protocol. </summary>
        public string DefaultEventsConfiguration { get; set; }
        /// <summary> Array of data points that are part of the asset. Each data point can reference an asset type capability and have per-data point configuration. See below for more details for the definition of the dataPoints element. </summary>
        public IList<DataPoint> DataPoints { get; }
        /// <summary> Array of events that are part of the asset. Each event can reference an asset type capability and have per-event configuration. See below for more details about the definition of the events element. </summary>
        public IList<AssetEvent> Events { get; }
    }
}
