// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.

// <auto-generated/>

#nullable disable

using System;
using System.Collections.Generic;

namespace Azure.ResourceManager.DeviceRegistry.Models
{
    /// <summary> The type used for update operations of the AssetEndpointProfile. </summary>
    public partial class DeviceRegistryAssetEndpointProfilePatch
    {
        /// <summary>
        /// Keeps track of any properties unknown to the library.
        /// <para>
        /// To assign an object to the value of this property use <see cref="BinaryData.FromObjectAsJson{T}(T, System.Text.Json.JsonSerializerOptions?)"/>.
        /// </para>
        /// <para>
        /// To assign an already formatted json string to this property use <see cref="BinaryData.FromString(string)"/>.
        /// </para>
        /// <para>
        /// Examples:
        /// <list type="bullet">
        /// <item>
        /// <term>BinaryData.FromObjectAsJson("foo")</term>
        /// <description>Creates a payload of "foo".</description>
        /// </item>
        /// <item>
        /// <term>BinaryData.FromString("\"foo\"")</term>
        /// <description>Creates a payload of "foo".</description>
        /// </item>
        /// <item>
        /// <term>BinaryData.FromObjectAsJson(new { key = "value" })</term>
        /// <description>Creates a payload of { "key": "value" }.</description>
        /// </item>
        /// <item>
        /// <term>BinaryData.FromString("{\"key\": \"value\"}")</term>
        /// <description>Creates a payload of { "key": "value" }.</description>
        /// </item>
        /// </list>
        /// </para>
        /// </summary>
        private IDictionary<string, BinaryData> _serializedAdditionalRawData;

        /// <summary> Initializes a new instance of <see cref="DeviceRegistryAssetEndpointProfilePatch"/>. </summary>
        public DeviceRegistryAssetEndpointProfilePatch()
        {
            Tags = new ChangeTrackingDictionary<string, string>();
        }

        /// <summary> Initializes a new instance of <see cref="DeviceRegistryAssetEndpointProfilePatch"/>. </summary>
        /// <param name="tags"> Resource tags. </param>
        /// <param name="targetAddress"> The local valid URI specifying the network address/DNS name of a southbound device. The scheme part of the targetAddress URI specifies the type of the device. The additionalConfiguration field holds further connector type specific configuration. </param>
        /// <param name="userAuthentication"> Defines the client authentication mechanism to the server. </param>
        /// <param name="transportAuthentication"> Defines the authentication mechanism for the southbound connector connecting to the shop floor/OT device. </param>
        /// <param name="additionalConfiguration"> Contains connectivity type specific further configuration (e.g. OPC UA, Modbus, ONVIF). </param>
        /// <param name="serializedAdditionalRawData"> Keeps track of any properties unknown to the library. </param>
        internal DeviceRegistryAssetEndpointProfilePatch(IDictionary<string, string> tags, Uri targetAddress, UserAuthenticationUpdate userAuthentication, TransportAuthenticationUpdate transportAuthentication, string additionalConfiguration, IDictionary<string, BinaryData> serializedAdditionalRawData)
        {
            Tags = tags;
            TargetAddress = targetAddress;
            UserAuthentication = userAuthentication;
            TransportAuthentication = transportAuthentication;
            AdditionalConfiguration = additionalConfiguration;
            _serializedAdditionalRawData = serializedAdditionalRawData;
        }

        /// <summary> Resource tags. </summary>
        public IDictionary<string, string> Tags { get; }
        /// <summary> The local valid URI specifying the network address/DNS name of a southbound device. The scheme part of the targetAddress URI specifies the type of the device. The additionalConfiguration field holds further connector type specific configuration. </summary>
        public Uri TargetAddress { get; set; }
        /// <summary> Defines the client authentication mechanism to the server. </summary>
        public UserAuthenticationUpdate UserAuthentication { get; set; }
        /// <summary> Defines the authentication mechanism for the southbound connector connecting to the shop floor/OT device. </summary>
        internal TransportAuthenticationUpdate TransportAuthentication { get; set; }
        /// <summary> Defines a reference to a secret which contains all certificates and private keys that can be used by the southbound connector connecting to the shop floor/OT device. The accepted extensions are .der for certificates and .pfx/.pem for private keys. </summary>
        public IList<OwnCertificate> TransportAuthenticationOwnCertificates
        {
            get
            {
                if (TransportAuthentication is null)
                    TransportAuthentication = new TransportAuthenticationUpdate();
                return TransportAuthentication.OwnCertificates;
            }
        }

        /// <summary> Contains connectivity type specific further configuration (e.g. OPC UA, Modbus, ONVIF). </summary>
        public string AdditionalConfiguration { get; set; }
    }
}
