// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.

// <auto-generated/>

#nullable disable

using System;
using System.Collections.Generic;

namespace Azure.ResourceManager.DeviceRegistry.Models
{
    /// <summary> Defines the event properties. </summary>
    public partial class AssetEvent
    {
        /// <summary>
        /// Keeps track of any properties unknown to the library.
        /// <para>
        /// To assign an object to the value of this property use <see cref="BinaryData.FromObjectAsJson{T}(T, System.Text.Json.JsonSerializerOptions?)"/>.
        /// </para>
        /// <para>
        /// To assign an already formatted json string to this property use <see cref="BinaryData.FromString(string)"/>.
        /// </para>
        /// <para>
        /// Examples:
        /// <list type="bullet">
        /// <item>
        /// <term>BinaryData.FromObjectAsJson("foo")</term>
        /// <description>Creates a payload of "foo".</description>
        /// </item>
        /// <item>
        /// <term>BinaryData.FromString("\"foo\"")</term>
        /// <description>Creates a payload of "foo".</description>
        /// </item>
        /// <item>
        /// <term>BinaryData.FromObjectAsJson(new { key = "value" })</term>
        /// <description>Creates a payload of { "key": "value" }.</description>
        /// </item>
        /// <item>
        /// <term>BinaryData.FromString("{\"key\": \"value\"}")</term>
        /// <description>Creates a payload of { "key": "value" }.</description>
        /// </item>
        /// </list>
        /// </para>
        /// </summary>
        private IDictionary<string, BinaryData> _serializedAdditionalRawData;

        /// <summary> Initializes a new instance of <see cref="AssetEvent"/>. </summary>
        /// <param name="eventNotifier"> The address of the notifier of the event in the asset (e.g. URL) so that a client can access the event on the asset. </param>
        /// <exception cref="ArgumentNullException"> <paramref name="eventNotifier"/> is null. </exception>
        public AssetEvent(string eventNotifier)
        {
            Argument.AssertNotNull(eventNotifier, nameof(eventNotifier));

            EventNotifier = eventNotifier;
        }

        /// <summary> Initializes a new instance of <see cref="AssetEvent"/>. </summary>
        /// <param name="name"> The name of the event. </param>
        /// <param name="eventNotifier"> The address of the notifier of the event in the asset (e.g. URL) so that a client can access the event on the asset. </param>
        /// <param name="capabilityId"> The path to the type definition of the capability (e.g. DTMI, OPC UA information model node id, etc.), for example dtmi:com:example:Robot:_contents:__prop1;1. </param>
        /// <param name="observabilityMode"> An indication of how the event should be mapped to OpenTelemetry. </param>
        /// <param name="eventConfiguration"> Protocol-specific configuration for the event. For OPC UA, this could include configuration like, publishingInterval, samplingInterval, and queueSize. </param>
        /// <param name="serializedAdditionalRawData"> Keeps track of any properties unknown to the library. </param>
        internal AssetEvent(string name, string eventNotifier, string capabilityId, EventsObservabilityMode? observabilityMode, string eventConfiguration, IDictionary<string, BinaryData> serializedAdditionalRawData)
        {
            Name = name;
            EventNotifier = eventNotifier;
            CapabilityId = capabilityId;
            ObservabilityMode = observabilityMode;
            EventConfiguration = eventConfiguration;
            _serializedAdditionalRawData = serializedAdditionalRawData;
        }

        /// <summary> Initializes a new instance of <see cref="AssetEvent"/> for deserialization. </summary>
        internal AssetEvent()
        {
        }

        /// <summary> The name of the event. </summary>
        public string Name { get; set; }
        /// <summary> The address of the notifier of the event in the asset (e.g. URL) so that a client can access the event on the asset. </summary>
        public string EventNotifier { get; set; }
        /// <summary> The path to the type definition of the capability (e.g. DTMI, OPC UA information model node id, etc.), for example dtmi:com:example:Robot:_contents:__prop1;1. </summary>
        public string CapabilityId { get; set; }
        /// <summary> An indication of how the event should be mapped to OpenTelemetry. </summary>
        public EventsObservabilityMode? ObservabilityMode { get; set; }
        /// <summary> Protocol-specific configuration for the event. For OPC UA, this could include configuration like, publishingInterval, samplingInterval, and queueSize. </summary>
        public string EventConfiguration { get; set; }
    }
}
