// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.

// <auto-generated/>

#nullable disable

using System.Text.Json;
using System.Threading;
using System.Threading.Tasks;
using Azure.Core;

namespace Azure.ResourceManager.DeviceRegistry
{
    internal class DeviceRegistryAssetOperationSource : IOperationSource<DeviceRegistryAssetResource>
    {
        private readonly ArmClient _client;

        internal DeviceRegistryAssetOperationSource(ArmClient client)
        {
            _client = client;
        }

        DeviceRegistryAssetResource IOperationSource<DeviceRegistryAssetResource>.CreateResult(Response response, CancellationToken cancellationToken)
        {
            using var document = JsonDocument.Parse(response.ContentStream);
            var data = DeviceRegistryAssetData.DeserializeDeviceRegistryAssetData(document.RootElement);
            return new DeviceRegistryAssetResource(_client, data);
        }

        async ValueTask<DeviceRegistryAssetResource> IOperationSource<DeviceRegistryAssetResource>.CreateResultAsync(Response response, CancellationToken cancellationToken)
        {
            using var document = await JsonDocument.ParseAsync(response.ContentStream, default, cancellationToken).ConfigureAwait(false);
            var data = DeviceRegistryAssetData.DeserializeDeviceRegistryAssetData(document.RootElement);
            return new DeviceRegistryAssetResource(_client, data);
        }
    }
}
