// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.

// <auto-generated/>

#nullable disable

using System;
using System.Threading;
using System.Threading.Tasks;
using Azure.Core;

namespace Azure.ResourceManager.DeviceRegistry.Mocking
{
    /// <summary> A class to add extension methods to ResourceGroupResource. </summary>
    public partial class MockableDeviceRegistryResourceGroupResource : ArmResource
    {
        /// <summary> Initializes a new instance of the <see cref="MockableDeviceRegistryResourceGroupResource"/> class for mocking. </summary>
        protected MockableDeviceRegistryResourceGroupResource()
        {
        }

        /// <summary> Initializes a new instance of the <see cref="MockableDeviceRegistryResourceGroupResource"/> class. </summary>
        /// <param name="client"> The client parameters to use in these operations. </param>
        /// <param name="id"> The identifier of the resource that is the target of operations. </param>
        internal MockableDeviceRegistryResourceGroupResource(ArmClient client, ResourceIdentifier id) : base(client, id)
        {
        }

        private string GetApiVersionOrNull(ResourceType resourceType)
        {
            TryGetApiVersion(resourceType, out string apiVersion);
            return apiVersion;
        }

        /// <summary> Gets a collection of DeviceRegistryAssetEndpointProfileResources in the ResourceGroupResource. </summary>
        /// <returns> An object representing collection of DeviceRegistryAssetEndpointProfileResources and their operations over a DeviceRegistryAssetEndpointProfileResource. </returns>
        public virtual DeviceRegistryAssetEndpointProfileCollection GetDeviceRegistryAssetEndpointProfiles()
        {
            return GetCachedClient(client => new DeviceRegistryAssetEndpointProfileCollection(client, Id));
        }

        /// <summary>
        /// Get a AssetEndpointProfile
        /// <list type="bullet">
        /// <item>
        /// <term>Request Path</term>
        /// <description>/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.DeviceRegistry/assetEndpointProfiles/{assetEndpointProfileName}</description>
        /// </item>
        /// <item>
        /// <term>Operation Id</term>
        /// <description>AssetEndpointProfiles_Get</description>
        /// </item>
        /// <item>
        /// <term>Default Api Version</term>
        /// <description>2023-11-01-preview</description>
        /// </item>
        /// <item>
        /// <term>Resource</term>
        /// <description><see cref="DeviceRegistryAssetEndpointProfileResource"/></description>
        /// </item>
        /// </list>
        /// </summary>
        /// <param name="assetEndpointProfileName"> Asset Endpoint Profile name parameter. </param>
        /// <param name="cancellationToken"> The cancellation token to use. </param>
        /// <exception cref="ArgumentNullException"> <paramref name="assetEndpointProfileName"/> is null. </exception>
        /// <exception cref="ArgumentException"> <paramref name="assetEndpointProfileName"/> is an empty string, and was expected to be non-empty. </exception>
        [ForwardsClientCalls]
        public virtual async Task<Response<DeviceRegistryAssetEndpointProfileResource>> GetDeviceRegistryAssetEndpointProfileAsync(string assetEndpointProfileName, CancellationToken cancellationToken = default)
        {
            return await GetDeviceRegistryAssetEndpointProfiles().GetAsync(assetEndpointProfileName, cancellationToken).ConfigureAwait(false);
        }

        /// <summary>
        /// Get a AssetEndpointProfile
        /// <list type="bullet">
        /// <item>
        /// <term>Request Path</term>
        /// <description>/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.DeviceRegistry/assetEndpointProfiles/{assetEndpointProfileName}</description>
        /// </item>
        /// <item>
        /// <term>Operation Id</term>
        /// <description>AssetEndpointProfiles_Get</description>
        /// </item>
        /// <item>
        /// <term>Default Api Version</term>
        /// <description>2023-11-01-preview</description>
        /// </item>
        /// <item>
        /// <term>Resource</term>
        /// <description><see cref="DeviceRegistryAssetEndpointProfileResource"/></description>
        /// </item>
        /// </list>
        /// </summary>
        /// <param name="assetEndpointProfileName"> Asset Endpoint Profile name parameter. </param>
        /// <param name="cancellationToken"> The cancellation token to use. </param>
        /// <exception cref="ArgumentNullException"> <paramref name="assetEndpointProfileName"/> is null. </exception>
        /// <exception cref="ArgumentException"> <paramref name="assetEndpointProfileName"/> is an empty string, and was expected to be non-empty. </exception>
        [ForwardsClientCalls]
        public virtual Response<DeviceRegistryAssetEndpointProfileResource> GetDeviceRegistryAssetEndpointProfile(string assetEndpointProfileName, CancellationToken cancellationToken = default)
        {
            return GetDeviceRegistryAssetEndpointProfiles().Get(assetEndpointProfileName, cancellationToken);
        }

        /// <summary> Gets a collection of DeviceRegistryAssetResources in the ResourceGroupResource. </summary>
        /// <returns> An object representing collection of DeviceRegistryAssetResources and their operations over a DeviceRegistryAssetResource. </returns>
        public virtual DeviceRegistryAssetCollection GetDeviceRegistryAssets()
        {
            return GetCachedClient(client => new DeviceRegistryAssetCollection(client, Id));
        }

        /// <summary>
        /// Get a Asset
        /// <list type="bullet">
        /// <item>
        /// <term>Request Path</term>
        /// <description>/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.DeviceRegistry/assets/{assetName}</description>
        /// </item>
        /// <item>
        /// <term>Operation Id</term>
        /// <description>Assets_Get</description>
        /// </item>
        /// <item>
        /// <term>Default Api Version</term>
        /// <description>2023-11-01-preview</description>
        /// </item>
        /// <item>
        /// <term>Resource</term>
        /// <description><see cref="DeviceRegistryAssetResource"/></description>
        /// </item>
        /// </list>
        /// </summary>
        /// <param name="assetName"> Asset name parameter. </param>
        /// <param name="cancellationToken"> The cancellation token to use. </param>
        /// <exception cref="ArgumentNullException"> <paramref name="assetName"/> is null. </exception>
        /// <exception cref="ArgumentException"> <paramref name="assetName"/> is an empty string, and was expected to be non-empty. </exception>
        [ForwardsClientCalls]
        public virtual async Task<Response<DeviceRegistryAssetResource>> GetDeviceRegistryAssetAsync(string assetName, CancellationToken cancellationToken = default)
        {
            return await GetDeviceRegistryAssets().GetAsync(assetName, cancellationToken).ConfigureAwait(false);
        }

        /// <summary>
        /// Get a Asset
        /// <list type="bullet">
        /// <item>
        /// <term>Request Path</term>
        /// <description>/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.DeviceRegistry/assets/{assetName}</description>
        /// </item>
        /// <item>
        /// <term>Operation Id</term>
        /// <description>Assets_Get</description>
        /// </item>
        /// <item>
        /// <term>Default Api Version</term>
        /// <description>2023-11-01-preview</description>
        /// </item>
        /// <item>
        /// <term>Resource</term>
        /// <description><see cref="DeviceRegistryAssetResource"/></description>
        /// </item>
        /// </list>
        /// </summary>
        /// <param name="assetName"> Asset name parameter. </param>
        /// <param name="cancellationToken"> The cancellation token to use. </param>
        /// <exception cref="ArgumentNullException"> <paramref name="assetName"/> is null. </exception>
        /// <exception cref="ArgumentException"> <paramref name="assetName"/> is an empty string, and was expected to be non-empty. </exception>
        [ForwardsClientCalls]
        public virtual Response<DeviceRegistryAssetResource> GetDeviceRegistryAsset(string assetName, CancellationToken cancellationToken = default)
        {
            return GetDeviceRegistryAssets().Get(assetName, cancellationToken);
        }
    }
}
