// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.

// <auto-generated/>

#nullable disable

using Azure.Core;

namespace Azure.ResourceManager.DeviceRegistry.Mocking
{
    /// <summary> A class to add extension methods to ArmClient. </summary>
    public partial class MockableDeviceRegistryArmClient : ArmResource
    {
        /// <summary> Initializes a new instance of the <see cref="MockableDeviceRegistryArmClient"/> class for mocking. </summary>
        protected MockableDeviceRegistryArmClient()
        {
        }

        /// <summary> Initializes a new instance of the <see cref="MockableDeviceRegistryArmClient"/> class. </summary>
        /// <param name="client"> The client parameters to use in these operations. </param>
        /// <param name="id"> The identifier of the resource that is the target of operations. </param>
        internal MockableDeviceRegistryArmClient(ArmClient client, ResourceIdentifier id) : base(client, id)
        {
        }

        internal MockableDeviceRegistryArmClient(ArmClient client) : this(client, ResourceIdentifier.Root)
        {
        }

        private string GetApiVersionOrNull(ResourceType resourceType)
        {
            TryGetApiVersion(resourceType, out string apiVersion);
            return apiVersion;
        }

        /// <summary>
        /// Gets an object representing a <see cref="DeviceRegistryAssetEndpointProfileResource"/> along with the instance operations that can be performed on it but with no data.
        /// You can use <see cref="DeviceRegistryAssetEndpointProfileResource.CreateResourceIdentifier" /> to create a <see cref="DeviceRegistryAssetEndpointProfileResource"/> <see cref="ResourceIdentifier"/> from its components.
        /// </summary>
        /// <param name="id"> The resource ID of the resource to get. </param>
        /// <returns> Returns a <see cref="DeviceRegistryAssetEndpointProfileResource"/> object. </returns>
        public virtual DeviceRegistryAssetEndpointProfileResource GetDeviceRegistryAssetEndpointProfileResource(ResourceIdentifier id)
        {
            DeviceRegistryAssetEndpointProfileResource.ValidateResourceId(id);
            return new DeviceRegistryAssetEndpointProfileResource(Client, id);
        }

        /// <summary>
        /// Gets an object representing a <see cref="DeviceRegistryAssetResource"/> along with the instance operations that can be performed on it but with no data.
        /// You can use <see cref="DeviceRegistryAssetResource.CreateResourceIdentifier" /> to create a <see cref="DeviceRegistryAssetResource"/> <see cref="ResourceIdentifier"/> from its components.
        /// </summary>
        /// <param name="id"> The resource ID of the resource to get. </param>
        /// <returns> Returns a <see cref="DeviceRegistryAssetResource"/> object. </returns>
        public virtual DeviceRegistryAssetResource GetDeviceRegistryAssetResource(ResourceIdentifier id)
        {
            DeviceRegistryAssetResource.ValidateResourceId(id);
            return new DeviceRegistryAssetResource(Client, id);
        }
    }
}
