// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.

// <auto-generated/>

#nullable disable

using System;
using System.Collections;
using System.Collections.Generic;
using System.Globalization;
using System.Threading;
using System.Threading.Tasks;
using Autorest.CSharp.Core;
using Azure.Core;
using Azure.Core.Pipeline;
using Azure.ResourceManager.Resources;

namespace Azure.ResourceManager.DeviceRegistry
{
    /// <summary>
    /// A class representing a collection of <see cref="DeviceRegistryAssetEndpointProfileResource"/> and their operations.
    /// Each <see cref="DeviceRegistryAssetEndpointProfileResource"/> in the collection will belong to the same instance of <see cref="ResourceGroupResource"/>.
    /// To get a <see cref="DeviceRegistryAssetEndpointProfileCollection"/> instance call the GetDeviceRegistryAssetEndpointProfiles method from an instance of <see cref="ResourceGroupResource"/>.
    /// </summary>
    public partial class DeviceRegistryAssetEndpointProfileCollection : ArmCollection, IEnumerable<DeviceRegistryAssetEndpointProfileResource>, IAsyncEnumerable<DeviceRegistryAssetEndpointProfileResource>
    {
        private readonly ClientDiagnostics _deviceRegistryAssetEndpointProfileAssetEndpointProfilesClientDiagnostics;
        private readonly AssetEndpointProfilesRestOperations _deviceRegistryAssetEndpointProfileAssetEndpointProfilesRestClient;

        /// <summary> Initializes a new instance of the <see cref="DeviceRegistryAssetEndpointProfileCollection"/> class for mocking. </summary>
        protected DeviceRegistryAssetEndpointProfileCollection()
        {
        }

        /// <summary> Initializes a new instance of the <see cref="DeviceRegistryAssetEndpointProfileCollection"/> class. </summary>
        /// <param name="client"> The client parameters to use in these operations. </param>
        /// <param name="id"> The identifier of the parent resource that is the target of operations. </param>
        internal DeviceRegistryAssetEndpointProfileCollection(ArmClient client, ResourceIdentifier id) : base(client, id)
        {
            _deviceRegistryAssetEndpointProfileAssetEndpointProfilesClientDiagnostics = new ClientDiagnostics("Azure.ResourceManager.DeviceRegistry", DeviceRegistryAssetEndpointProfileResource.ResourceType.Namespace, Diagnostics);
            TryGetApiVersion(DeviceRegistryAssetEndpointProfileResource.ResourceType, out string deviceRegistryAssetEndpointProfileAssetEndpointProfilesApiVersion);
            _deviceRegistryAssetEndpointProfileAssetEndpointProfilesRestClient = new AssetEndpointProfilesRestOperations(Pipeline, Diagnostics.ApplicationId, Endpoint, deviceRegistryAssetEndpointProfileAssetEndpointProfilesApiVersion);
#if DEBUG
			ValidateResourceId(Id);
#endif
        }

        internal static void ValidateResourceId(ResourceIdentifier id)
        {
            if (id.ResourceType != ResourceGroupResource.ResourceType)
                throw new ArgumentException(string.Format(CultureInfo.CurrentCulture, "Invalid resource type {0} expected {1}", id.ResourceType, ResourceGroupResource.ResourceType), nameof(id));
        }

        /// <summary>
        /// Create a AssetEndpointProfile
        /// <list type="bullet">
        /// <item>
        /// <term>Request Path</term>
        /// <description>/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.DeviceRegistry/assetEndpointProfiles/{assetEndpointProfileName}</description>
        /// </item>
        /// <item>
        /// <term>Operation Id</term>
        /// <description>AssetEndpointProfiles_CreateOrReplace</description>
        /// </item>
        /// <item>
        /// <term>Default Api Version</term>
        /// <description>2023-11-01-preview</description>
        /// </item>
        /// <item>
        /// <term>Resource</term>
        /// <description><see cref="DeviceRegistryAssetEndpointProfileResource"/></description>
        /// </item>
        /// </list>
        /// </summary>
        /// <param name="waitUntil"> <see cref="WaitUntil.Completed"/> if the method should wait to return until the long-running operation has completed on the service; <see cref="WaitUntil.Started"/> if it should return after starting the operation. For more information on long-running operations, please see <see href="https://github.com/Azure/azure-sdk-for-net/blob/main/sdk/core/Azure.Core/samples/LongRunningOperations.md"> Azure.Core Long-Running Operation samples</see>. </param>
        /// <param name="assetEndpointProfileName"> Asset Endpoint Profile name parameter. </param>
        /// <param name="data"> Resource create parameters. </param>
        /// <param name="cancellationToken"> The cancellation token to use. </param>
        /// <exception cref="ArgumentException"> <paramref name="assetEndpointProfileName"/> is an empty string, and was expected to be non-empty. </exception>
        /// <exception cref="ArgumentNullException"> <paramref name="assetEndpointProfileName"/> or <paramref name="data"/> is null. </exception>
        public virtual async Task<ArmOperation<DeviceRegistryAssetEndpointProfileResource>> CreateOrUpdateAsync(WaitUntil waitUntil, string assetEndpointProfileName, DeviceRegistryAssetEndpointProfileData data, CancellationToken cancellationToken = default)
        {
            Argument.AssertNotNullOrEmpty(assetEndpointProfileName, nameof(assetEndpointProfileName));
            Argument.AssertNotNull(data, nameof(data));

            using var scope = _deviceRegistryAssetEndpointProfileAssetEndpointProfilesClientDiagnostics.CreateScope("DeviceRegistryAssetEndpointProfileCollection.CreateOrUpdate");
            scope.Start();
            try
            {
                var response = await _deviceRegistryAssetEndpointProfileAssetEndpointProfilesRestClient.CreateOrReplaceAsync(Id.SubscriptionId, Id.ResourceGroupName, assetEndpointProfileName, data, cancellationToken).ConfigureAwait(false);
                var operation = new DeviceRegistryArmOperation<DeviceRegistryAssetEndpointProfileResource>(new DeviceRegistryAssetEndpointProfileOperationSource(Client), _deviceRegistryAssetEndpointProfileAssetEndpointProfilesClientDiagnostics, Pipeline, _deviceRegistryAssetEndpointProfileAssetEndpointProfilesRestClient.CreateCreateOrReplaceRequest(Id.SubscriptionId, Id.ResourceGroupName, assetEndpointProfileName, data).Request, response, OperationFinalStateVia.AzureAsyncOperation);
                if (waitUntil == WaitUntil.Completed)
                    await operation.WaitForCompletionAsync(cancellationToken).ConfigureAwait(false);
                return operation;
            }
            catch (Exception e)
            {
                scope.Failed(e);
                throw;
            }
        }

        /// <summary>
        /// Create a AssetEndpointProfile
        /// <list type="bullet">
        /// <item>
        /// <term>Request Path</term>
        /// <description>/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.DeviceRegistry/assetEndpointProfiles/{assetEndpointProfileName}</description>
        /// </item>
        /// <item>
        /// <term>Operation Id</term>
        /// <description>AssetEndpointProfiles_CreateOrReplace</description>
        /// </item>
        /// <item>
        /// <term>Default Api Version</term>
        /// <description>2023-11-01-preview</description>
        /// </item>
        /// <item>
        /// <term>Resource</term>
        /// <description><see cref="DeviceRegistryAssetEndpointProfileResource"/></description>
        /// </item>
        /// </list>
        /// </summary>
        /// <param name="waitUntil"> <see cref="WaitUntil.Completed"/> if the method should wait to return until the long-running operation has completed on the service; <see cref="WaitUntil.Started"/> if it should return after starting the operation. For more information on long-running operations, please see <see href="https://github.com/Azure/azure-sdk-for-net/blob/main/sdk/core/Azure.Core/samples/LongRunningOperations.md"> Azure.Core Long-Running Operation samples</see>. </param>
        /// <param name="assetEndpointProfileName"> Asset Endpoint Profile name parameter. </param>
        /// <param name="data"> Resource create parameters. </param>
        /// <param name="cancellationToken"> The cancellation token to use. </param>
        /// <exception cref="ArgumentException"> <paramref name="assetEndpointProfileName"/> is an empty string, and was expected to be non-empty. </exception>
        /// <exception cref="ArgumentNullException"> <paramref name="assetEndpointProfileName"/> or <paramref name="data"/> is null. </exception>
        public virtual ArmOperation<DeviceRegistryAssetEndpointProfileResource> CreateOrUpdate(WaitUntil waitUntil, string assetEndpointProfileName, DeviceRegistryAssetEndpointProfileData data, CancellationToken cancellationToken = default)
        {
            Argument.AssertNotNullOrEmpty(assetEndpointProfileName, nameof(assetEndpointProfileName));
            Argument.AssertNotNull(data, nameof(data));

            using var scope = _deviceRegistryAssetEndpointProfileAssetEndpointProfilesClientDiagnostics.CreateScope("DeviceRegistryAssetEndpointProfileCollection.CreateOrUpdate");
            scope.Start();
            try
            {
                var response = _deviceRegistryAssetEndpointProfileAssetEndpointProfilesRestClient.CreateOrReplace(Id.SubscriptionId, Id.ResourceGroupName, assetEndpointProfileName, data, cancellationToken);
                var operation = new DeviceRegistryArmOperation<DeviceRegistryAssetEndpointProfileResource>(new DeviceRegistryAssetEndpointProfileOperationSource(Client), _deviceRegistryAssetEndpointProfileAssetEndpointProfilesClientDiagnostics, Pipeline, _deviceRegistryAssetEndpointProfileAssetEndpointProfilesRestClient.CreateCreateOrReplaceRequest(Id.SubscriptionId, Id.ResourceGroupName, assetEndpointProfileName, data).Request, response, OperationFinalStateVia.AzureAsyncOperation);
                if (waitUntil == WaitUntil.Completed)
                    operation.WaitForCompletion(cancellationToken);
                return operation;
            }
            catch (Exception e)
            {
                scope.Failed(e);
                throw;
            }
        }

        /// <summary>
        /// Get a AssetEndpointProfile
        /// <list type="bullet">
        /// <item>
        /// <term>Request Path</term>
        /// <description>/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.DeviceRegistry/assetEndpointProfiles/{assetEndpointProfileName}</description>
        /// </item>
        /// <item>
        /// <term>Operation Id</term>
        /// <description>AssetEndpointProfiles_Get</description>
        /// </item>
        /// <item>
        /// <term>Default Api Version</term>
        /// <description>2023-11-01-preview</description>
        /// </item>
        /// <item>
        /// <term>Resource</term>
        /// <description><see cref="DeviceRegistryAssetEndpointProfileResource"/></description>
        /// </item>
        /// </list>
        /// </summary>
        /// <param name="assetEndpointProfileName"> Asset Endpoint Profile name parameter. </param>
        /// <param name="cancellationToken"> The cancellation token to use. </param>
        /// <exception cref="ArgumentException"> <paramref name="assetEndpointProfileName"/> is an empty string, and was expected to be non-empty. </exception>
        /// <exception cref="ArgumentNullException"> <paramref name="assetEndpointProfileName"/> is null. </exception>
        public virtual async Task<Response<DeviceRegistryAssetEndpointProfileResource>> GetAsync(string assetEndpointProfileName, CancellationToken cancellationToken = default)
        {
            Argument.AssertNotNullOrEmpty(assetEndpointProfileName, nameof(assetEndpointProfileName));

            using var scope = _deviceRegistryAssetEndpointProfileAssetEndpointProfilesClientDiagnostics.CreateScope("DeviceRegistryAssetEndpointProfileCollection.Get");
            scope.Start();
            try
            {
                var response = await _deviceRegistryAssetEndpointProfileAssetEndpointProfilesRestClient.GetAsync(Id.SubscriptionId, Id.ResourceGroupName, assetEndpointProfileName, cancellationToken).ConfigureAwait(false);
                if (response.Value == null)
                    throw new RequestFailedException(response.GetRawResponse());
                return Response.FromValue(new DeviceRegistryAssetEndpointProfileResource(Client, response.Value), response.GetRawResponse());
            }
            catch (Exception e)
            {
                scope.Failed(e);
                throw;
            }
        }

        /// <summary>
        /// Get a AssetEndpointProfile
        /// <list type="bullet">
        /// <item>
        /// <term>Request Path</term>
        /// <description>/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.DeviceRegistry/assetEndpointProfiles/{assetEndpointProfileName}</description>
        /// </item>
        /// <item>
        /// <term>Operation Id</term>
        /// <description>AssetEndpointProfiles_Get</description>
        /// </item>
        /// <item>
        /// <term>Default Api Version</term>
        /// <description>2023-11-01-preview</description>
        /// </item>
        /// <item>
        /// <term>Resource</term>
        /// <description><see cref="DeviceRegistryAssetEndpointProfileResource"/></description>
        /// </item>
        /// </list>
        /// </summary>
        /// <param name="assetEndpointProfileName"> Asset Endpoint Profile name parameter. </param>
        /// <param name="cancellationToken"> The cancellation token to use. </param>
        /// <exception cref="ArgumentException"> <paramref name="assetEndpointProfileName"/> is an empty string, and was expected to be non-empty. </exception>
        /// <exception cref="ArgumentNullException"> <paramref name="assetEndpointProfileName"/> is null. </exception>
        public virtual Response<DeviceRegistryAssetEndpointProfileResource> Get(string assetEndpointProfileName, CancellationToken cancellationToken = default)
        {
            Argument.AssertNotNullOrEmpty(assetEndpointProfileName, nameof(assetEndpointProfileName));

            using var scope = _deviceRegistryAssetEndpointProfileAssetEndpointProfilesClientDiagnostics.CreateScope("DeviceRegistryAssetEndpointProfileCollection.Get");
            scope.Start();
            try
            {
                var response = _deviceRegistryAssetEndpointProfileAssetEndpointProfilesRestClient.Get(Id.SubscriptionId, Id.ResourceGroupName, assetEndpointProfileName, cancellationToken);
                if (response.Value == null)
                    throw new RequestFailedException(response.GetRawResponse());
                return Response.FromValue(new DeviceRegistryAssetEndpointProfileResource(Client, response.Value), response.GetRawResponse());
            }
            catch (Exception e)
            {
                scope.Failed(e);
                throw;
            }
        }

        /// <summary>
        /// List AssetEndpointProfile resources by resource group
        /// <list type="bullet">
        /// <item>
        /// <term>Request Path</term>
        /// <description>/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.DeviceRegistry/assetEndpointProfiles</description>
        /// </item>
        /// <item>
        /// <term>Operation Id</term>
        /// <description>AssetEndpointProfiles_ListByResourceGroup</description>
        /// </item>
        /// <item>
        /// <term>Default Api Version</term>
        /// <description>2023-11-01-preview</description>
        /// </item>
        /// <item>
        /// <term>Resource</term>
        /// <description><see cref="DeviceRegistryAssetEndpointProfileResource"/></description>
        /// </item>
        /// </list>
        /// </summary>
        /// <param name="cancellationToken"> The cancellation token to use. </param>
        /// <returns> An async collection of <see cref="DeviceRegistryAssetEndpointProfileResource"/> that may take multiple service requests to iterate over. </returns>
        public virtual AsyncPageable<DeviceRegistryAssetEndpointProfileResource> GetAllAsync(CancellationToken cancellationToken = default)
        {
            HttpMessage FirstPageRequest(int? pageSizeHint) => _deviceRegistryAssetEndpointProfileAssetEndpointProfilesRestClient.CreateListByResourceGroupRequest(Id.SubscriptionId, Id.ResourceGroupName);
            HttpMessage NextPageRequest(int? pageSizeHint, string nextLink) => _deviceRegistryAssetEndpointProfileAssetEndpointProfilesRestClient.CreateListByResourceGroupNextPageRequest(nextLink, Id.SubscriptionId, Id.ResourceGroupName);
            return GeneratorPageableHelpers.CreateAsyncPageable(FirstPageRequest, NextPageRequest, e => new DeviceRegistryAssetEndpointProfileResource(Client, DeviceRegistryAssetEndpointProfileData.DeserializeDeviceRegistryAssetEndpointProfileData(e)), _deviceRegistryAssetEndpointProfileAssetEndpointProfilesClientDiagnostics, Pipeline, "DeviceRegistryAssetEndpointProfileCollection.GetAll", "value", "nextLink", cancellationToken);
        }

        /// <summary>
        /// List AssetEndpointProfile resources by resource group
        /// <list type="bullet">
        /// <item>
        /// <term>Request Path</term>
        /// <description>/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.DeviceRegistry/assetEndpointProfiles</description>
        /// </item>
        /// <item>
        /// <term>Operation Id</term>
        /// <description>AssetEndpointProfiles_ListByResourceGroup</description>
        /// </item>
        /// <item>
        /// <term>Default Api Version</term>
        /// <description>2023-11-01-preview</description>
        /// </item>
        /// <item>
        /// <term>Resource</term>
        /// <description><see cref="DeviceRegistryAssetEndpointProfileResource"/></description>
        /// </item>
        /// </list>
        /// </summary>
        /// <param name="cancellationToken"> The cancellation token to use. </param>
        /// <returns> A collection of <see cref="DeviceRegistryAssetEndpointProfileResource"/> that may take multiple service requests to iterate over. </returns>
        public virtual Pageable<DeviceRegistryAssetEndpointProfileResource> GetAll(CancellationToken cancellationToken = default)
        {
            HttpMessage FirstPageRequest(int? pageSizeHint) => _deviceRegistryAssetEndpointProfileAssetEndpointProfilesRestClient.CreateListByResourceGroupRequest(Id.SubscriptionId, Id.ResourceGroupName);
            HttpMessage NextPageRequest(int? pageSizeHint, string nextLink) => _deviceRegistryAssetEndpointProfileAssetEndpointProfilesRestClient.CreateListByResourceGroupNextPageRequest(nextLink, Id.SubscriptionId, Id.ResourceGroupName);
            return GeneratorPageableHelpers.CreatePageable(FirstPageRequest, NextPageRequest, e => new DeviceRegistryAssetEndpointProfileResource(Client, DeviceRegistryAssetEndpointProfileData.DeserializeDeviceRegistryAssetEndpointProfileData(e)), _deviceRegistryAssetEndpointProfileAssetEndpointProfilesClientDiagnostics, Pipeline, "DeviceRegistryAssetEndpointProfileCollection.GetAll", "value", "nextLink", cancellationToken);
        }

        /// <summary>
        /// Checks to see if the resource exists in azure.
        /// <list type="bullet">
        /// <item>
        /// <term>Request Path</term>
        /// <description>/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.DeviceRegistry/assetEndpointProfiles/{assetEndpointProfileName}</description>
        /// </item>
        /// <item>
        /// <term>Operation Id</term>
        /// <description>AssetEndpointProfiles_Get</description>
        /// </item>
        /// <item>
        /// <term>Default Api Version</term>
        /// <description>2023-11-01-preview</description>
        /// </item>
        /// <item>
        /// <term>Resource</term>
        /// <description><see cref="DeviceRegistryAssetEndpointProfileResource"/></description>
        /// </item>
        /// </list>
        /// </summary>
        /// <param name="assetEndpointProfileName"> Asset Endpoint Profile name parameter. </param>
        /// <param name="cancellationToken"> The cancellation token to use. </param>
        /// <exception cref="ArgumentException"> <paramref name="assetEndpointProfileName"/> is an empty string, and was expected to be non-empty. </exception>
        /// <exception cref="ArgumentNullException"> <paramref name="assetEndpointProfileName"/> is null. </exception>
        public virtual async Task<Response<bool>> ExistsAsync(string assetEndpointProfileName, CancellationToken cancellationToken = default)
        {
            Argument.AssertNotNullOrEmpty(assetEndpointProfileName, nameof(assetEndpointProfileName));

            using var scope = _deviceRegistryAssetEndpointProfileAssetEndpointProfilesClientDiagnostics.CreateScope("DeviceRegistryAssetEndpointProfileCollection.Exists");
            scope.Start();
            try
            {
                var response = await _deviceRegistryAssetEndpointProfileAssetEndpointProfilesRestClient.GetAsync(Id.SubscriptionId, Id.ResourceGroupName, assetEndpointProfileName, cancellationToken: cancellationToken).ConfigureAwait(false);
                return Response.FromValue(response.Value != null, response.GetRawResponse());
            }
            catch (Exception e)
            {
                scope.Failed(e);
                throw;
            }
        }

        /// <summary>
        /// Checks to see if the resource exists in azure.
        /// <list type="bullet">
        /// <item>
        /// <term>Request Path</term>
        /// <description>/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.DeviceRegistry/assetEndpointProfiles/{assetEndpointProfileName}</description>
        /// </item>
        /// <item>
        /// <term>Operation Id</term>
        /// <description>AssetEndpointProfiles_Get</description>
        /// </item>
        /// <item>
        /// <term>Default Api Version</term>
        /// <description>2023-11-01-preview</description>
        /// </item>
        /// <item>
        /// <term>Resource</term>
        /// <description><see cref="DeviceRegistryAssetEndpointProfileResource"/></description>
        /// </item>
        /// </list>
        /// </summary>
        /// <param name="assetEndpointProfileName"> Asset Endpoint Profile name parameter. </param>
        /// <param name="cancellationToken"> The cancellation token to use. </param>
        /// <exception cref="ArgumentException"> <paramref name="assetEndpointProfileName"/> is an empty string, and was expected to be non-empty. </exception>
        /// <exception cref="ArgumentNullException"> <paramref name="assetEndpointProfileName"/> is null. </exception>
        public virtual Response<bool> Exists(string assetEndpointProfileName, CancellationToken cancellationToken = default)
        {
            Argument.AssertNotNullOrEmpty(assetEndpointProfileName, nameof(assetEndpointProfileName));

            using var scope = _deviceRegistryAssetEndpointProfileAssetEndpointProfilesClientDiagnostics.CreateScope("DeviceRegistryAssetEndpointProfileCollection.Exists");
            scope.Start();
            try
            {
                var response = _deviceRegistryAssetEndpointProfileAssetEndpointProfilesRestClient.Get(Id.SubscriptionId, Id.ResourceGroupName, assetEndpointProfileName, cancellationToken: cancellationToken);
                return Response.FromValue(response.Value != null, response.GetRawResponse());
            }
            catch (Exception e)
            {
                scope.Failed(e);
                throw;
            }
        }

        /// <summary>
        /// Tries to get details for this resource from the service.
        /// <list type="bullet">
        /// <item>
        /// <term>Request Path</term>
        /// <description>/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.DeviceRegistry/assetEndpointProfiles/{assetEndpointProfileName}</description>
        /// </item>
        /// <item>
        /// <term>Operation Id</term>
        /// <description>AssetEndpointProfiles_Get</description>
        /// </item>
        /// <item>
        /// <term>Default Api Version</term>
        /// <description>2023-11-01-preview</description>
        /// </item>
        /// <item>
        /// <term>Resource</term>
        /// <description><see cref="DeviceRegistryAssetEndpointProfileResource"/></description>
        /// </item>
        /// </list>
        /// </summary>
        /// <param name="assetEndpointProfileName"> Asset Endpoint Profile name parameter. </param>
        /// <param name="cancellationToken"> The cancellation token to use. </param>
        /// <exception cref="ArgumentException"> <paramref name="assetEndpointProfileName"/> is an empty string, and was expected to be non-empty. </exception>
        /// <exception cref="ArgumentNullException"> <paramref name="assetEndpointProfileName"/> is null. </exception>
        public virtual async Task<NullableResponse<DeviceRegistryAssetEndpointProfileResource>> GetIfExistsAsync(string assetEndpointProfileName, CancellationToken cancellationToken = default)
        {
            Argument.AssertNotNullOrEmpty(assetEndpointProfileName, nameof(assetEndpointProfileName));

            using var scope = _deviceRegistryAssetEndpointProfileAssetEndpointProfilesClientDiagnostics.CreateScope("DeviceRegistryAssetEndpointProfileCollection.GetIfExists");
            scope.Start();
            try
            {
                var response = await _deviceRegistryAssetEndpointProfileAssetEndpointProfilesRestClient.GetAsync(Id.SubscriptionId, Id.ResourceGroupName, assetEndpointProfileName, cancellationToken: cancellationToken).ConfigureAwait(false);
                if (response.Value == null)
                    return new NoValueResponse<DeviceRegistryAssetEndpointProfileResource>(response.GetRawResponse());
                return Response.FromValue(new DeviceRegistryAssetEndpointProfileResource(Client, response.Value), response.GetRawResponse());
            }
            catch (Exception e)
            {
                scope.Failed(e);
                throw;
            }
        }

        /// <summary>
        /// Tries to get details for this resource from the service.
        /// <list type="bullet">
        /// <item>
        /// <term>Request Path</term>
        /// <description>/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.DeviceRegistry/assetEndpointProfiles/{assetEndpointProfileName}</description>
        /// </item>
        /// <item>
        /// <term>Operation Id</term>
        /// <description>AssetEndpointProfiles_Get</description>
        /// </item>
        /// <item>
        /// <term>Default Api Version</term>
        /// <description>2023-11-01-preview</description>
        /// </item>
        /// <item>
        /// <term>Resource</term>
        /// <description><see cref="DeviceRegistryAssetEndpointProfileResource"/></description>
        /// </item>
        /// </list>
        /// </summary>
        /// <param name="assetEndpointProfileName"> Asset Endpoint Profile name parameter. </param>
        /// <param name="cancellationToken"> The cancellation token to use. </param>
        /// <exception cref="ArgumentException"> <paramref name="assetEndpointProfileName"/> is an empty string, and was expected to be non-empty. </exception>
        /// <exception cref="ArgumentNullException"> <paramref name="assetEndpointProfileName"/> is null. </exception>
        public virtual NullableResponse<DeviceRegistryAssetEndpointProfileResource> GetIfExists(string assetEndpointProfileName, CancellationToken cancellationToken = default)
        {
            Argument.AssertNotNullOrEmpty(assetEndpointProfileName, nameof(assetEndpointProfileName));

            using var scope = _deviceRegistryAssetEndpointProfileAssetEndpointProfilesClientDiagnostics.CreateScope("DeviceRegistryAssetEndpointProfileCollection.GetIfExists");
            scope.Start();
            try
            {
                var response = _deviceRegistryAssetEndpointProfileAssetEndpointProfilesRestClient.Get(Id.SubscriptionId, Id.ResourceGroupName, assetEndpointProfileName, cancellationToken: cancellationToken);
                if (response.Value == null)
                    return new NoValueResponse<DeviceRegistryAssetEndpointProfileResource>(response.GetRawResponse());
                return Response.FromValue(new DeviceRegistryAssetEndpointProfileResource(Client, response.Value), response.GetRawResponse());
            }
            catch (Exception e)
            {
                scope.Failed(e);
                throw;
            }
        }

        IEnumerator<DeviceRegistryAssetEndpointProfileResource> IEnumerable<DeviceRegistryAssetEndpointProfileResource>.GetEnumerator()
        {
            return GetAll().GetEnumerator();
        }

        IEnumerator IEnumerable.GetEnumerator()
        {
            return GetAll().GetEnumerator();
        }

        IAsyncEnumerator<DeviceRegistryAssetEndpointProfileResource> IAsyncEnumerable<DeviceRegistryAssetEndpointProfileResource>.GetAsyncEnumerator(CancellationToken cancellationToken)
        {
            return GetAllAsync(cancellationToken: cancellationToken).GetAsyncEnumerator(cancellationToken);
        }
    }
}
