// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.

// <auto-generated/>

#nullable disable

using System;
using System.Collections.Generic;
using System.Linq;
using Azure.Core;
using Azure.ResourceManager.Models;

namespace Azure.ResourceManager.DeviceRegistry.Models
{
    /// <summary> Model factory for models. </summary>
    public static partial class ArmDeviceRegistryModelFactory
    {
        /// <summary> Initializes a new instance of <see cref="DeviceRegistry.DeviceRegistryAssetEndpointProfileData"/>. </summary>
        /// <param name="id"> The id. </param>
        /// <param name="name"> The name. </param>
        /// <param name="resourceType"> The resourceType. </param>
        /// <param name="systemData"> The systemData. </param>
        /// <param name="tags"> The tags. </param>
        /// <param name="location"> The location. </param>
        /// <param name="extendedLocation"> The extended location. </param>
        /// <param name="uuid"> Globally unique, immutable, non-reusable id. </param>
        /// <param name="targetAddress"> The local valid URI specifying the network address/DNS name of a southbound device. The scheme part of the targetAddress URI specifies the type of the device. The additionalConfiguration field holds further connector type specific configuration. </param>
        /// <param name="userAuthentication"> Defines the client authentication mechanism to the server. </param>
        /// <param name="transportAuthenticationOwnCertificates"> Defines the authentication mechanism for the southbound connector connecting to the shop floor/OT device. </param>
        /// <param name="additionalConfiguration"> Contains connectivity type specific further configuration (e.g. OPC UA, Modbus, ONVIF). </param>
        /// <param name="provisioningState"> Provisioning state of the resource. </param>
        /// <returns> A new <see cref="DeviceRegistry.DeviceRegistryAssetEndpointProfileData"/> instance for mocking. </returns>
        public static DeviceRegistryAssetEndpointProfileData DeviceRegistryAssetEndpointProfileData(ResourceIdentifier id = null, string name = null, ResourceType resourceType = default, SystemData systemData = null, IDictionary<string, string> tags = null, AzureLocation location = default, DeviceRegistryExtendedLocation extendedLocation = null, string uuid = null, Uri targetAddress = null, UserAuthentication userAuthentication = null, IEnumerable<OwnCertificate> transportAuthenticationOwnCertificates = null, string additionalConfiguration = null, DeviceRegistryProvisioningState? provisioningState = null)
        {
            tags ??= new Dictionary<string, string>();
            transportAuthenticationOwnCertificates ??= new List<OwnCertificate>();

            return new DeviceRegistryAssetEndpointProfileData(
                id,
                name,
                resourceType,
                systemData,
                tags,
                location,
                extendedLocation,
                uuid,
                targetAddress,
                userAuthentication,
                transportAuthenticationOwnCertificates != null ? new TransportAuthentication(transportAuthenticationOwnCertificates?.ToList(), serializedAdditionalRawData: null) : null,
                additionalConfiguration,
                provisioningState,
                serializedAdditionalRawData: null);
        }

        /// <summary> Initializes a new instance of <see cref="DeviceRegistry.DeviceRegistryAssetData"/>. </summary>
        /// <param name="id"> The id. </param>
        /// <param name="name"> The name. </param>
        /// <param name="resourceType"> The resourceType. </param>
        /// <param name="systemData"> The systemData. </param>
        /// <param name="tags"> The tags. </param>
        /// <param name="location"> The location. </param>
        /// <param name="extendedLocation"> The extended location. </param>
        /// <param name="uuid"> Globally unique, immutable, non-reusable id. </param>
        /// <param name="assetType"> Resource path to asset type (model) definition. </param>
        /// <param name="enabled"> Enabled/Disabled status of the asset. </param>
        /// <param name="externalAssetId"> Asset id provided by the customer. </param>
        /// <param name="displayName"> Human-readable display name. </param>
        /// <param name="description"> Human-readable description of the asset. </param>
        /// <param name="assetEndpointProfileUri"> A reference to the asset endpoint profile (connection information) used by brokers to connect to an endpoint that provides data points for this asset. Must have the format &lt;ModuleCR.metadata.namespace&gt;/&lt;ModuleCR.metadata.name&gt;. </param>
        /// <param name="version"> An integer that is incremented each time the resource is modified. </param>
        /// <param name="manufacturer"> Asset manufacturer name. </param>
        /// <param name="manufacturerUri"> Asset manufacturer URI. </param>
        /// <param name="model"> Asset model name. </param>
        /// <param name="productCode"> Asset product code. </param>
        /// <param name="hardwareRevision"> Revision number of the hardware. </param>
        /// <param name="softwareRevision"> Revision number of the software. </param>
        /// <param name="documentationUri"> Reference to the documentation. </param>
        /// <param name="serialNumber"> Asset serial number. </param>
        /// <param name="attributes"> A set of key-value pairs that contain custom attributes set by the customer. </param>
        /// <param name="defaultDataPointsConfiguration"> Protocol-specific default configuration for all data points. Each data point can have its own configuration that overrides the default settings here. This assumes that each asset instance has one protocol. </param>
        /// <param name="defaultEventsConfiguration"> Protocol-specific default configuration for all events. Each event can have its own configuration that overrides the default settings here. This assumes that each asset instance has one protocol. </param>
        /// <param name="dataPoints"> Array of data points that are part of the asset. Each data point can reference an asset type capability and have per-data point configuration. See below for more details for the definition of the dataPoints element. </param>
        /// <param name="events"> Array of events that are part of the asset. Each event can reference an asset type capability and have per-event configuration. See below for more details about the definition of the events element. </param>
        /// <param name="status"> Read only object to reflect changes that have occurred on the Edge. Similar to Kubernetes status property for custom resources. </param>
        /// <param name="provisioningState"> Provisioning state of the resource. </param>
        /// <returns> A new <see cref="DeviceRegistry.DeviceRegistryAssetData"/> instance for mocking. </returns>
        public static DeviceRegistryAssetData DeviceRegistryAssetData(ResourceIdentifier id = null, string name = null, ResourceType resourceType = default, SystemData systemData = null, IDictionary<string, string> tags = null, AzureLocation location = default, DeviceRegistryExtendedLocation extendedLocation = null, string uuid = null, string assetType = null, bool? enabled = null, string externalAssetId = null, string displayName = null, string description = null, Uri assetEndpointProfileUri = null, int? version = null, string manufacturer = null, Uri manufacturerUri = null, string model = null, string productCode = null, string hardwareRevision = null, string softwareRevision = null, Uri documentationUri = null, string serialNumber = null, IDictionary<string, BinaryData> attributes = null, string defaultDataPointsConfiguration = null, string defaultEventsConfiguration = null, IEnumerable<DataPoint> dataPoints = null, IEnumerable<AssetEvent> events = null, AssetStatus status = null, DeviceRegistryProvisioningState? provisioningState = null)
        {
            tags ??= new Dictionary<string, string>();
            attributes ??= new Dictionary<string, BinaryData>();
            dataPoints ??= new List<DataPoint>();
            events ??= new List<AssetEvent>();

            return new DeviceRegistryAssetData(
                id,
                name,
                resourceType,
                systemData,
                tags,
                location,
                extendedLocation,
                uuid,
                assetType,
                enabled,
                externalAssetId,
                displayName,
                description,
                assetEndpointProfileUri,
                version,
                manufacturer,
                manufacturerUri,
                model,
                productCode,
                hardwareRevision,
                softwareRevision,
                documentationUri,
                serialNumber,
                attributes,
                defaultDataPointsConfiguration,
                defaultEventsConfiguration,
                dataPoints?.ToList(),
                events?.ToList(),
                status,
                provisioningState,
                serializedAdditionalRawData: null);
        }

        /// <summary> Initializes a new instance of <see cref="Models.AssetStatus"/>. </summary>
        /// <param name="errors"> Array object to transfer and persist errors that originate from the Edge. </param>
        /// <param name="version"> A read only incremental counter indicating the number of times the configuration has been modified from the perspective of the current actual (Edge) state of the Asset. Edge would be the only writer of this value and would sync back up to the cloud. In steady state, this should equal version. </param>
        /// <returns> A new <see cref="Models.AssetStatus"/> instance for mocking. </returns>
        public static AssetStatus AssetStatus(IEnumerable<AssetStatusError> errors = null, int? version = null)
        {
            errors ??= new List<AssetStatusError>();

            return new AssetStatus(errors?.ToList(), version, serializedAdditionalRawData: null);
        }

        /// <summary> Initializes a new instance of <see cref="Models.AssetStatusError"/>. </summary>
        /// <param name="code"> Error code for classification of errors (ex: 400, 404, 500, etc.). </param>
        /// <param name="message"> Human readable helpful error message to provide additional context for error (ex: “capability Id 'foo' does not exist”). </param>
        /// <returns> A new <see cref="Models.AssetStatusError"/> instance for mocking. </returns>
        public static AssetStatusError AssetStatusError(int? code = null, string message = null)
        {
            return new AssetStatusError(code, message, serializedAdditionalRawData: null);
        }
    }
}
