// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.

// <auto-generated/>

#nullable disable

using System;
using System.Text.Json;
using System.Threading;
using System.Threading.Tasks;
using Azure.Core;
using Azure.Core.Pipeline;
using Azure.ResourceManager.DeviceProvisioningServices.Models;

namespace Azure.ResourceManager.DeviceProvisioningServices
{
    internal partial class DpsCertificateRestOperations
    {
        private readonly TelemetryDetails _userAgent;
        private readonly HttpPipeline _pipeline;
        private readonly Uri _endpoint;
        private readonly string _apiVersion;

        /// <summary> Initializes a new instance of DpsCertificateRestOperations. </summary>
        /// <param name="pipeline"> The HTTP pipeline for sending and receiving REST requests and responses. </param>
        /// <param name="applicationId"> The application id to use for user agent. </param>
        /// <param name="endpoint"> server parameter. </param>
        /// <param name="apiVersion"> Api Version. </param>
        /// <exception cref="ArgumentNullException"> <paramref name="pipeline"/> or <paramref name="apiVersion"/> is null. </exception>
        public DpsCertificateRestOperations(HttpPipeline pipeline, string applicationId, Uri endpoint = null, string apiVersion = default)
        {
            _pipeline = pipeline ?? throw new ArgumentNullException(nameof(pipeline));
            _endpoint = endpoint ?? new Uri("https://management.azure.com");
            _apiVersion = apiVersion ?? "2022-02-05";
            _userAgent = new TelemetryDetails(GetType().Assembly, applicationId);
        }

        internal RequestUriBuilder CreateGetRequestUri(string subscriptionId, string resourceGroupName, string provisioningServiceName, string certificateName, string ifMatch)
        {
            var uri = new RawRequestUriBuilder();
            uri.Reset(_endpoint);
            uri.AppendPath("/subscriptions/", false);
            uri.AppendPath(subscriptionId, true);
            uri.AppendPath("/resourceGroups/", false);
            uri.AppendPath(resourceGroupName, true);
            uri.AppendPath("/providers/Microsoft.Devices/provisioningServices/", false);
            uri.AppendPath(provisioningServiceName, true);
            uri.AppendPath("/certificates/", false);
            uri.AppendPath(certificateName, true);
            uri.AppendQuery("api-version", _apiVersion, true);
            return uri;
        }

        internal HttpMessage CreateGetRequest(string subscriptionId, string resourceGroupName, string provisioningServiceName, string certificateName, string ifMatch)
        {
            var message = _pipeline.CreateMessage();
            var request = message.Request;
            request.Method = RequestMethod.Get;
            var uri = new RawRequestUriBuilder();
            uri.Reset(_endpoint);
            uri.AppendPath("/subscriptions/", false);
            uri.AppendPath(subscriptionId, true);
            uri.AppendPath("/resourceGroups/", false);
            uri.AppendPath(resourceGroupName, true);
            uri.AppendPath("/providers/Microsoft.Devices/provisioningServices/", false);
            uri.AppendPath(provisioningServiceName, true);
            uri.AppendPath("/certificates/", false);
            uri.AppendPath(certificateName, true);
            uri.AppendQuery("api-version", _apiVersion, true);
            request.Uri = uri;
            if (ifMatch != null)
            {
                request.Headers.Add("If-Match", ifMatch);
            }
            request.Headers.Add("Accept", "application/json");
            _userAgent.Apply(message);
            return message;
        }

        /// <summary> Get the certificate from the provisioning service. </summary>
        /// <param name="subscriptionId"> The subscription identifier. </param>
        /// <param name="resourceGroupName"> Resource group identifier. </param>
        /// <param name="provisioningServiceName"> Name of the provisioning service the certificate is associated with. </param>
        /// <param name="certificateName"> Name of the certificate to retrieve. </param>
        /// <param name="ifMatch"> ETag of the certificate. </param>
        /// <param name="cancellationToken"> The cancellation token to use. </param>
        /// <exception cref="ArgumentNullException"> <paramref name="subscriptionId"/>, <paramref name="resourceGroupName"/>, <paramref name="provisioningServiceName"/> or <paramref name="certificateName"/> is null. </exception>
        /// <exception cref="ArgumentException"> <paramref name="subscriptionId"/>, <paramref name="resourceGroupName"/>, <paramref name="provisioningServiceName"/> or <paramref name="certificateName"/> is an empty string, and was expected to be non-empty. </exception>
        public async Task<Response<DeviceProvisioningServicesCertificateData>> GetAsync(string subscriptionId, string resourceGroupName, string provisioningServiceName, string certificateName, string ifMatch = null, CancellationToken cancellationToken = default)
        {
            Argument.AssertNotNullOrEmpty(subscriptionId, nameof(subscriptionId));
            Argument.AssertNotNullOrEmpty(resourceGroupName, nameof(resourceGroupName));
            Argument.AssertNotNullOrEmpty(provisioningServiceName, nameof(provisioningServiceName));
            Argument.AssertNotNullOrEmpty(certificateName, nameof(certificateName));

            using var message = CreateGetRequest(subscriptionId, resourceGroupName, provisioningServiceName, certificateName, ifMatch);
            await _pipeline.SendAsync(message, cancellationToken).ConfigureAwait(false);
            switch (message.Response.Status)
            {
                case 200:
                    {
                        DeviceProvisioningServicesCertificateData value = default;
                        using var document = await JsonDocument.ParseAsync(message.Response.ContentStream, default, cancellationToken).ConfigureAwait(false);
                        value = DeviceProvisioningServicesCertificateData.DeserializeDeviceProvisioningServicesCertificateData(document.RootElement);
                        return Response.FromValue(value, message.Response);
                    }
                case 404:
                    return Response.FromValue((DeviceProvisioningServicesCertificateData)null, message.Response);
                default:
                    throw new RequestFailedException(message.Response);
            }
        }

        /// <summary> Get the certificate from the provisioning service. </summary>
        /// <param name="subscriptionId"> The subscription identifier. </param>
        /// <param name="resourceGroupName"> Resource group identifier. </param>
        /// <param name="provisioningServiceName"> Name of the provisioning service the certificate is associated with. </param>
        /// <param name="certificateName"> Name of the certificate to retrieve. </param>
        /// <param name="ifMatch"> ETag of the certificate. </param>
        /// <param name="cancellationToken"> The cancellation token to use. </param>
        /// <exception cref="ArgumentNullException"> <paramref name="subscriptionId"/>, <paramref name="resourceGroupName"/>, <paramref name="provisioningServiceName"/> or <paramref name="certificateName"/> is null. </exception>
        /// <exception cref="ArgumentException"> <paramref name="subscriptionId"/>, <paramref name="resourceGroupName"/>, <paramref name="provisioningServiceName"/> or <paramref name="certificateName"/> is an empty string, and was expected to be non-empty. </exception>
        public Response<DeviceProvisioningServicesCertificateData> Get(string subscriptionId, string resourceGroupName, string provisioningServiceName, string certificateName, string ifMatch = null, CancellationToken cancellationToken = default)
        {
            Argument.AssertNotNullOrEmpty(subscriptionId, nameof(subscriptionId));
            Argument.AssertNotNullOrEmpty(resourceGroupName, nameof(resourceGroupName));
            Argument.AssertNotNullOrEmpty(provisioningServiceName, nameof(provisioningServiceName));
            Argument.AssertNotNullOrEmpty(certificateName, nameof(certificateName));

            using var message = CreateGetRequest(subscriptionId, resourceGroupName, provisioningServiceName, certificateName, ifMatch);
            _pipeline.Send(message, cancellationToken);
            switch (message.Response.Status)
            {
                case 200:
                    {
                        DeviceProvisioningServicesCertificateData value = default;
                        using var document = JsonDocument.Parse(message.Response.ContentStream);
                        value = DeviceProvisioningServicesCertificateData.DeserializeDeviceProvisioningServicesCertificateData(document.RootElement);
                        return Response.FromValue(value, message.Response);
                    }
                case 404:
                    return Response.FromValue((DeviceProvisioningServicesCertificateData)null, message.Response);
                default:
                    throw new RequestFailedException(message.Response);
            }
        }

        internal RequestUriBuilder CreateCreateOrUpdateRequestUri(string subscriptionId, string resourceGroupName, string provisioningServiceName, string certificateName, DeviceProvisioningServicesCertificateData data, string ifMatch)
        {
            var uri = new RawRequestUriBuilder();
            uri.Reset(_endpoint);
            uri.AppendPath("/subscriptions/", false);
            uri.AppendPath(subscriptionId, true);
            uri.AppendPath("/resourceGroups/", false);
            uri.AppendPath(resourceGroupName, true);
            uri.AppendPath("/providers/Microsoft.Devices/provisioningServices/", false);
            uri.AppendPath(provisioningServiceName, true);
            uri.AppendPath("/certificates/", false);
            uri.AppendPath(certificateName, true);
            uri.AppendQuery("api-version", _apiVersion, true);
            return uri;
        }

        internal HttpMessage CreateCreateOrUpdateRequest(string subscriptionId, string resourceGroupName, string provisioningServiceName, string certificateName, DeviceProvisioningServicesCertificateData data, string ifMatch)
        {
            var message = _pipeline.CreateMessage();
            var request = message.Request;
            request.Method = RequestMethod.Put;
            var uri = new RawRequestUriBuilder();
            uri.Reset(_endpoint);
            uri.AppendPath("/subscriptions/", false);
            uri.AppendPath(subscriptionId, true);
            uri.AppendPath("/resourceGroups/", false);
            uri.AppendPath(resourceGroupName, true);
            uri.AppendPath("/providers/Microsoft.Devices/provisioningServices/", false);
            uri.AppendPath(provisioningServiceName, true);
            uri.AppendPath("/certificates/", false);
            uri.AppendPath(certificateName, true);
            uri.AppendQuery("api-version", _apiVersion, true);
            request.Uri = uri;
            if (ifMatch != null)
            {
                request.Headers.Add("If-Match", ifMatch);
            }
            request.Headers.Add("Accept", "application/json");
            request.Headers.Add("Content-Type", "application/json");
            var content = new Utf8JsonRequestContent();
            content.JsonWriter.WriteObjectValue(data, ModelSerializationExtensions.WireOptions);
            request.Content = content;
            _userAgent.Apply(message);
            return message;
        }

        /// <summary> Add new certificate or update an existing certificate. </summary>
        /// <param name="subscriptionId"> The subscription identifier. </param>
        /// <param name="resourceGroupName"> Resource group identifier. </param>
        /// <param name="provisioningServiceName"> The name of the provisioning service. </param>
        /// <param name="certificateName"> The name of the certificate create or update. </param>
        /// <param name="data"> The certificate body. </param>
        /// <param name="ifMatch"> ETag of the certificate. This is required to update an existing certificate, and ignored while creating a brand new certificate. </param>
        /// <param name="cancellationToken"> The cancellation token to use. </param>
        /// <exception cref="ArgumentNullException"> <paramref name="subscriptionId"/>, <paramref name="resourceGroupName"/>, <paramref name="provisioningServiceName"/>, <paramref name="certificateName"/> or <paramref name="data"/> is null. </exception>
        /// <exception cref="ArgumentException"> <paramref name="subscriptionId"/>, <paramref name="resourceGroupName"/>, <paramref name="provisioningServiceName"/> or <paramref name="certificateName"/> is an empty string, and was expected to be non-empty. </exception>
        public async Task<Response<DeviceProvisioningServicesCertificateData>> CreateOrUpdateAsync(string subscriptionId, string resourceGroupName, string provisioningServiceName, string certificateName, DeviceProvisioningServicesCertificateData data, string ifMatch = null, CancellationToken cancellationToken = default)
        {
            Argument.AssertNotNullOrEmpty(subscriptionId, nameof(subscriptionId));
            Argument.AssertNotNullOrEmpty(resourceGroupName, nameof(resourceGroupName));
            Argument.AssertNotNullOrEmpty(provisioningServiceName, nameof(provisioningServiceName));
            Argument.AssertNotNullOrEmpty(certificateName, nameof(certificateName));
            Argument.AssertNotNull(data, nameof(data));

            using var message = CreateCreateOrUpdateRequest(subscriptionId, resourceGroupName, provisioningServiceName, certificateName, data, ifMatch);
            await _pipeline.SendAsync(message, cancellationToken).ConfigureAwait(false);
            switch (message.Response.Status)
            {
                case 200:
                    {
                        DeviceProvisioningServicesCertificateData value = default;
                        using var document = await JsonDocument.ParseAsync(message.Response.ContentStream, default, cancellationToken).ConfigureAwait(false);
                        value = DeviceProvisioningServicesCertificateData.DeserializeDeviceProvisioningServicesCertificateData(document.RootElement);
                        return Response.FromValue(value, message.Response);
                    }
                default:
                    throw new RequestFailedException(message.Response);
            }
        }

        /// <summary> Add new certificate or update an existing certificate. </summary>
        /// <param name="subscriptionId"> The subscription identifier. </param>
        /// <param name="resourceGroupName"> Resource group identifier. </param>
        /// <param name="provisioningServiceName"> The name of the provisioning service. </param>
        /// <param name="certificateName"> The name of the certificate create or update. </param>
        /// <param name="data"> The certificate body. </param>
        /// <param name="ifMatch"> ETag of the certificate. This is required to update an existing certificate, and ignored while creating a brand new certificate. </param>
        /// <param name="cancellationToken"> The cancellation token to use. </param>
        /// <exception cref="ArgumentNullException"> <paramref name="subscriptionId"/>, <paramref name="resourceGroupName"/>, <paramref name="provisioningServiceName"/>, <paramref name="certificateName"/> or <paramref name="data"/> is null. </exception>
        /// <exception cref="ArgumentException"> <paramref name="subscriptionId"/>, <paramref name="resourceGroupName"/>, <paramref name="provisioningServiceName"/> or <paramref name="certificateName"/> is an empty string, and was expected to be non-empty. </exception>
        public Response<DeviceProvisioningServicesCertificateData> CreateOrUpdate(string subscriptionId, string resourceGroupName, string provisioningServiceName, string certificateName, DeviceProvisioningServicesCertificateData data, string ifMatch = null, CancellationToken cancellationToken = default)
        {
            Argument.AssertNotNullOrEmpty(subscriptionId, nameof(subscriptionId));
            Argument.AssertNotNullOrEmpty(resourceGroupName, nameof(resourceGroupName));
            Argument.AssertNotNullOrEmpty(provisioningServiceName, nameof(provisioningServiceName));
            Argument.AssertNotNullOrEmpty(certificateName, nameof(certificateName));
            Argument.AssertNotNull(data, nameof(data));

            using var message = CreateCreateOrUpdateRequest(subscriptionId, resourceGroupName, provisioningServiceName, certificateName, data, ifMatch);
            _pipeline.Send(message, cancellationToken);
            switch (message.Response.Status)
            {
                case 200:
                    {
                        DeviceProvisioningServicesCertificateData value = default;
                        using var document = JsonDocument.Parse(message.Response.ContentStream);
                        value = DeviceProvisioningServicesCertificateData.DeserializeDeviceProvisioningServicesCertificateData(document.RootElement);
                        return Response.FromValue(value, message.Response);
                    }
                default:
                    throw new RequestFailedException(message.Response);
            }
        }

        internal RequestUriBuilder CreateDeleteRequestUri(string subscriptionId, string resourceGroupName, string provisioningServiceName, string certificateName, string ifMatch, string certificateCommonName, byte[] certificateRawBytes, bool? certificateIsVerified, DeviceProvisioningServicesCertificatePurpose? certificatePurpose, DateTimeOffset? certificateCreatedOn, DateTimeOffset? certificateLastUpdatedOn, bool? certificateHasPrivateKey, string certificateNonce)
        {
            var uri = new RawRequestUriBuilder();
            uri.Reset(_endpoint);
            uri.AppendPath("/subscriptions/", false);
            uri.AppendPath(subscriptionId, true);
            uri.AppendPath("/resourceGroups/", false);
            uri.AppendPath(resourceGroupName, true);
            uri.AppendPath("/providers/Microsoft.Devices/provisioningServices/", false);
            uri.AppendPath(provisioningServiceName, true);
            uri.AppendPath("/certificates/", false);
            uri.AppendPath(certificateName, true);
            if (certificateCommonName != null)
            {
                uri.AppendQuery("certificateCommonName", certificateCommonName, true);
            }
            if (certificateRawBytes != null)
            {
                uri.AppendQuery("certificate.rawBytes", certificateRawBytes, "D", true);
            }
            if (certificateIsVerified != null)
            {
                uri.AppendQuery("certificate.isVerified", certificateIsVerified.Value, true);
            }
            if (certificatePurpose != null)
            {
                uri.AppendQuery("certificate.purpose", certificatePurpose.Value.ToString(), true);
            }
            if (certificateCreatedOn != null)
            {
                uri.AppendQuery("certificateCreatedOn", certificateCreatedOn.Value, "O", true);
            }
            if (certificateLastUpdatedOn != null)
            {
                uri.AppendQuery("certificateLastUpdatedOn", certificateLastUpdatedOn.Value, "O", true);
            }
            if (certificateHasPrivateKey != null)
            {
                uri.AppendQuery("certificate.hasPrivateKey", certificateHasPrivateKey.Value, true);
            }
            if (certificateNonce != null)
            {
                uri.AppendQuery("certificate.nonce", certificateNonce, true);
            }
            uri.AppendQuery("api-version", _apiVersion, true);
            return uri;
        }

        internal HttpMessage CreateDeleteRequest(string subscriptionId, string resourceGroupName, string provisioningServiceName, string certificateName, string ifMatch, string certificateCommonName, byte[] certificateRawBytes, bool? certificateIsVerified, DeviceProvisioningServicesCertificatePurpose? certificatePurpose, DateTimeOffset? certificateCreatedOn, DateTimeOffset? certificateLastUpdatedOn, bool? certificateHasPrivateKey, string certificateNonce)
        {
            var message = _pipeline.CreateMessage();
            var request = message.Request;
            request.Method = RequestMethod.Delete;
            var uri = new RawRequestUriBuilder();
            uri.Reset(_endpoint);
            uri.AppendPath("/subscriptions/", false);
            uri.AppendPath(subscriptionId, true);
            uri.AppendPath("/resourceGroups/", false);
            uri.AppendPath(resourceGroupName, true);
            uri.AppendPath("/providers/Microsoft.Devices/provisioningServices/", false);
            uri.AppendPath(provisioningServiceName, true);
            uri.AppendPath("/certificates/", false);
            uri.AppendPath(certificateName, true);
            if (certificateCommonName != null)
            {
                uri.AppendQuery("certificateCommonName", certificateCommonName, true);
            }
            if (certificateRawBytes != null)
            {
                uri.AppendQuery("certificate.rawBytes", certificateRawBytes, "D", true);
            }
            if (certificateIsVerified != null)
            {
                uri.AppendQuery("certificate.isVerified", certificateIsVerified.Value, true);
            }
            if (certificatePurpose != null)
            {
                uri.AppendQuery("certificate.purpose", certificatePurpose.Value.ToString(), true);
            }
            if (certificateCreatedOn != null)
            {
                uri.AppendQuery("certificateCreatedOn", certificateCreatedOn.Value, "O", true);
            }
            if (certificateLastUpdatedOn != null)
            {
                uri.AppendQuery("certificateLastUpdatedOn", certificateLastUpdatedOn.Value, "O", true);
            }
            if (certificateHasPrivateKey != null)
            {
                uri.AppendQuery("certificate.hasPrivateKey", certificateHasPrivateKey.Value, true);
            }
            if (certificateNonce != null)
            {
                uri.AppendQuery("certificate.nonce", certificateNonce, true);
            }
            uri.AppendQuery("api-version", _apiVersion, true);
            request.Uri = uri;
            request.Headers.Add("If-Match", ifMatch);
            request.Headers.Add("Accept", "application/json");
            _userAgent.Apply(message);
            return message;
        }

        /// <summary> Deletes the specified certificate associated with the Provisioning Service. </summary>
        /// <param name="subscriptionId"> The subscription identifier. </param>
        /// <param name="resourceGroupName"> Resource group identifier. </param>
        /// <param name="provisioningServiceName"> The name of the provisioning service. </param>
        /// <param name="certificateName"> This is a mandatory field, and is the logical name of the certificate that the provisioning service will access by. </param>
        /// <param name="ifMatch"> ETag of the certificate. </param>
        /// <param name="certificateCommonName"> This is optional, and it is the Common Name of the certificate. </param>
        /// <param name="certificateRawBytes"> Raw data within the certificate. </param>
        /// <param name="certificateIsVerified"> Indicates if certificate has been verified by owner of the private key. </param>
        /// <param name="certificatePurpose"> A description that mentions the purpose of the certificate. </param>
        /// <param name="certificateCreatedOn"> Time the certificate is created. </param>
        /// <param name="certificateLastUpdatedOn"> Time the certificate is last updated. </param>
        /// <param name="certificateHasPrivateKey"> Indicates if the certificate contains a private key. </param>
        /// <param name="certificateNonce"> Random number generated to indicate Proof of Possession. </param>
        /// <param name="cancellationToken"> The cancellation token to use. </param>
        /// <exception cref="ArgumentNullException"> <paramref name="subscriptionId"/>, <paramref name="resourceGroupName"/>, <paramref name="provisioningServiceName"/>, <paramref name="certificateName"/> or <paramref name="ifMatch"/> is null. </exception>
        /// <exception cref="ArgumentException"> <paramref name="subscriptionId"/>, <paramref name="resourceGroupName"/>, <paramref name="provisioningServiceName"/> or <paramref name="certificateName"/> is an empty string, and was expected to be non-empty. </exception>
        public async Task<Response> DeleteAsync(string subscriptionId, string resourceGroupName, string provisioningServiceName, string certificateName, string ifMatch, string certificateCommonName = null, byte[] certificateRawBytes = null, bool? certificateIsVerified = null, DeviceProvisioningServicesCertificatePurpose? certificatePurpose = null, DateTimeOffset? certificateCreatedOn = null, DateTimeOffset? certificateLastUpdatedOn = null, bool? certificateHasPrivateKey = null, string certificateNonce = null, CancellationToken cancellationToken = default)
        {
            Argument.AssertNotNullOrEmpty(subscriptionId, nameof(subscriptionId));
            Argument.AssertNotNullOrEmpty(resourceGroupName, nameof(resourceGroupName));
            Argument.AssertNotNullOrEmpty(provisioningServiceName, nameof(provisioningServiceName));
            Argument.AssertNotNullOrEmpty(certificateName, nameof(certificateName));
            Argument.AssertNotNull(ifMatch, nameof(ifMatch));

            using var message = CreateDeleteRequest(subscriptionId, resourceGroupName, provisioningServiceName, certificateName, ifMatch, certificateCommonName, certificateRawBytes, certificateIsVerified, certificatePurpose, certificateCreatedOn, certificateLastUpdatedOn, certificateHasPrivateKey, certificateNonce);
            await _pipeline.SendAsync(message, cancellationToken).ConfigureAwait(false);
            switch (message.Response.Status)
            {
                case 200:
                case 204:
                    return message.Response;
                default:
                    throw new RequestFailedException(message.Response);
            }
        }

        /// <summary> Deletes the specified certificate associated with the Provisioning Service. </summary>
        /// <param name="subscriptionId"> The subscription identifier. </param>
        /// <param name="resourceGroupName"> Resource group identifier. </param>
        /// <param name="provisioningServiceName"> The name of the provisioning service. </param>
        /// <param name="certificateName"> This is a mandatory field, and is the logical name of the certificate that the provisioning service will access by. </param>
        /// <param name="ifMatch"> ETag of the certificate. </param>
        /// <param name="certificateCommonName"> This is optional, and it is the Common Name of the certificate. </param>
        /// <param name="certificateRawBytes"> Raw data within the certificate. </param>
        /// <param name="certificateIsVerified"> Indicates if certificate has been verified by owner of the private key. </param>
        /// <param name="certificatePurpose"> A description that mentions the purpose of the certificate. </param>
        /// <param name="certificateCreatedOn"> Time the certificate is created. </param>
        /// <param name="certificateLastUpdatedOn"> Time the certificate is last updated. </param>
        /// <param name="certificateHasPrivateKey"> Indicates if the certificate contains a private key. </param>
        /// <param name="certificateNonce"> Random number generated to indicate Proof of Possession. </param>
        /// <param name="cancellationToken"> The cancellation token to use. </param>
        /// <exception cref="ArgumentNullException"> <paramref name="subscriptionId"/>, <paramref name="resourceGroupName"/>, <paramref name="provisioningServiceName"/>, <paramref name="certificateName"/> or <paramref name="ifMatch"/> is null. </exception>
        /// <exception cref="ArgumentException"> <paramref name="subscriptionId"/>, <paramref name="resourceGroupName"/>, <paramref name="provisioningServiceName"/> or <paramref name="certificateName"/> is an empty string, and was expected to be non-empty. </exception>
        public Response Delete(string subscriptionId, string resourceGroupName, string provisioningServiceName, string certificateName, string ifMatch, string certificateCommonName = null, byte[] certificateRawBytes = null, bool? certificateIsVerified = null, DeviceProvisioningServicesCertificatePurpose? certificatePurpose = null, DateTimeOffset? certificateCreatedOn = null, DateTimeOffset? certificateLastUpdatedOn = null, bool? certificateHasPrivateKey = null, string certificateNonce = null, CancellationToken cancellationToken = default)
        {
            Argument.AssertNotNullOrEmpty(subscriptionId, nameof(subscriptionId));
            Argument.AssertNotNullOrEmpty(resourceGroupName, nameof(resourceGroupName));
            Argument.AssertNotNullOrEmpty(provisioningServiceName, nameof(provisioningServiceName));
            Argument.AssertNotNullOrEmpty(certificateName, nameof(certificateName));
            Argument.AssertNotNull(ifMatch, nameof(ifMatch));

            using var message = CreateDeleteRequest(subscriptionId, resourceGroupName, provisioningServiceName, certificateName, ifMatch, certificateCommonName, certificateRawBytes, certificateIsVerified, certificatePurpose, certificateCreatedOn, certificateLastUpdatedOn, certificateHasPrivateKey, certificateNonce);
            _pipeline.Send(message, cancellationToken);
            switch (message.Response.Status)
            {
                case 200:
                case 204:
                    return message.Response;
                default:
                    throw new RequestFailedException(message.Response);
            }
        }

        internal RequestUriBuilder CreateListRequestUri(string subscriptionId, string resourceGroupName, string provisioningServiceName)
        {
            var uri = new RawRequestUriBuilder();
            uri.Reset(_endpoint);
            uri.AppendPath("/subscriptions/", false);
            uri.AppendPath(subscriptionId, true);
            uri.AppendPath("/resourceGroups/", false);
            uri.AppendPath(resourceGroupName, true);
            uri.AppendPath("/providers/Microsoft.Devices/provisioningServices/", false);
            uri.AppendPath(provisioningServiceName, true);
            uri.AppendPath("/certificates", false);
            uri.AppendQuery("api-version", _apiVersion, true);
            return uri;
        }

        internal HttpMessage CreateListRequest(string subscriptionId, string resourceGroupName, string provisioningServiceName)
        {
            var message = _pipeline.CreateMessage();
            var request = message.Request;
            request.Method = RequestMethod.Get;
            var uri = new RawRequestUriBuilder();
            uri.Reset(_endpoint);
            uri.AppendPath("/subscriptions/", false);
            uri.AppendPath(subscriptionId, true);
            uri.AppendPath("/resourceGroups/", false);
            uri.AppendPath(resourceGroupName, true);
            uri.AppendPath("/providers/Microsoft.Devices/provisioningServices/", false);
            uri.AppendPath(provisioningServiceName, true);
            uri.AppendPath("/certificates", false);
            uri.AppendQuery("api-version", _apiVersion, true);
            request.Uri = uri;
            request.Headers.Add("Accept", "application/json");
            _userAgent.Apply(message);
            return message;
        }

        /// <summary> Get all the certificates tied to the provisioning service. </summary>
        /// <param name="subscriptionId"> The subscription identifier. </param>
        /// <param name="resourceGroupName"> Name of resource group. </param>
        /// <param name="provisioningServiceName"> Name of provisioning service to retrieve certificates for. </param>
        /// <param name="cancellationToken"> The cancellation token to use. </param>
        /// <exception cref="ArgumentNullException"> <paramref name="subscriptionId"/>, <paramref name="resourceGroupName"/> or <paramref name="provisioningServiceName"/> is null. </exception>
        /// <exception cref="ArgumentException"> <paramref name="subscriptionId"/>, <paramref name="resourceGroupName"/> or <paramref name="provisioningServiceName"/> is an empty string, and was expected to be non-empty. </exception>
        public async Task<Response<CertificateListDescription>> ListAsync(string subscriptionId, string resourceGroupName, string provisioningServiceName, CancellationToken cancellationToken = default)
        {
            Argument.AssertNotNullOrEmpty(subscriptionId, nameof(subscriptionId));
            Argument.AssertNotNullOrEmpty(resourceGroupName, nameof(resourceGroupName));
            Argument.AssertNotNullOrEmpty(provisioningServiceName, nameof(provisioningServiceName));

            using var message = CreateListRequest(subscriptionId, resourceGroupName, provisioningServiceName);
            await _pipeline.SendAsync(message, cancellationToken).ConfigureAwait(false);
            switch (message.Response.Status)
            {
                case 200:
                    {
                        CertificateListDescription value = default;
                        using var document = await JsonDocument.ParseAsync(message.Response.ContentStream, default, cancellationToken).ConfigureAwait(false);
                        value = CertificateListDescription.DeserializeCertificateListDescription(document.RootElement);
                        return Response.FromValue(value, message.Response);
                    }
                default:
                    throw new RequestFailedException(message.Response);
            }
        }

        /// <summary> Get all the certificates tied to the provisioning service. </summary>
        /// <param name="subscriptionId"> The subscription identifier. </param>
        /// <param name="resourceGroupName"> Name of resource group. </param>
        /// <param name="provisioningServiceName"> Name of provisioning service to retrieve certificates for. </param>
        /// <param name="cancellationToken"> The cancellation token to use. </param>
        /// <exception cref="ArgumentNullException"> <paramref name="subscriptionId"/>, <paramref name="resourceGroupName"/> or <paramref name="provisioningServiceName"/> is null. </exception>
        /// <exception cref="ArgumentException"> <paramref name="subscriptionId"/>, <paramref name="resourceGroupName"/> or <paramref name="provisioningServiceName"/> is an empty string, and was expected to be non-empty. </exception>
        public Response<CertificateListDescription> List(string subscriptionId, string resourceGroupName, string provisioningServiceName, CancellationToken cancellationToken = default)
        {
            Argument.AssertNotNullOrEmpty(subscriptionId, nameof(subscriptionId));
            Argument.AssertNotNullOrEmpty(resourceGroupName, nameof(resourceGroupName));
            Argument.AssertNotNullOrEmpty(provisioningServiceName, nameof(provisioningServiceName));

            using var message = CreateListRequest(subscriptionId, resourceGroupName, provisioningServiceName);
            _pipeline.Send(message, cancellationToken);
            switch (message.Response.Status)
            {
                case 200:
                    {
                        CertificateListDescription value = default;
                        using var document = JsonDocument.Parse(message.Response.ContentStream);
                        value = CertificateListDescription.DeserializeCertificateListDescription(document.RootElement);
                        return Response.FromValue(value, message.Response);
                    }
                default:
                    throw new RequestFailedException(message.Response);
            }
        }

        internal RequestUriBuilder CreateGenerateVerificationCodeRequestUri(string subscriptionId, string resourceGroupName, string provisioningServiceName, string certificateName, string ifMatch, string certificateCommonName, byte[] certificateRawBytes, bool? certificateIsVerified, DeviceProvisioningServicesCertificatePurpose? certificatePurpose, DateTimeOffset? certificateCreatedOn, DateTimeOffset? certificateLastUpdatedOn, bool? certificateHasPrivateKey, string certificateNonce)
        {
            var uri = new RawRequestUriBuilder();
            uri.Reset(_endpoint);
            uri.AppendPath("/subscriptions/", false);
            uri.AppendPath(subscriptionId, true);
            uri.AppendPath("/resourceGroups/", false);
            uri.AppendPath(resourceGroupName, true);
            uri.AppendPath("/providers/Microsoft.Devices/provisioningServices/", false);
            uri.AppendPath(provisioningServiceName, true);
            uri.AppendPath("/certificates/", false);
            uri.AppendPath(certificateName, true);
            uri.AppendPath("/generateVerificationCode", false);
            if (certificateCommonName != null)
            {
                uri.AppendQuery("certificateCommonName", certificateCommonName, true);
            }
            if (certificateRawBytes != null)
            {
                uri.AppendQuery("certificate.rawBytes", certificateRawBytes, "D", true);
            }
            if (certificateIsVerified != null)
            {
                uri.AppendQuery("certificate.isVerified", certificateIsVerified.Value, true);
            }
            if (certificatePurpose != null)
            {
                uri.AppendQuery("certificate.purpose", certificatePurpose.Value.ToString(), true);
            }
            if (certificateCreatedOn != null)
            {
                uri.AppendQuery("certificateCreatedOn", certificateCreatedOn.Value, "O", true);
            }
            if (certificateLastUpdatedOn != null)
            {
                uri.AppendQuery("certificateLastUpdatedOn", certificateLastUpdatedOn.Value, "O", true);
            }
            if (certificateHasPrivateKey != null)
            {
                uri.AppendQuery("certificate.hasPrivateKey", certificateHasPrivateKey.Value, true);
            }
            if (certificateNonce != null)
            {
                uri.AppendQuery("certificate.nonce", certificateNonce, true);
            }
            uri.AppendQuery("api-version", _apiVersion, true);
            return uri;
        }

        internal HttpMessage CreateGenerateVerificationCodeRequest(string subscriptionId, string resourceGroupName, string provisioningServiceName, string certificateName, string ifMatch, string certificateCommonName, byte[] certificateRawBytes, bool? certificateIsVerified, DeviceProvisioningServicesCertificatePurpose? certificatePurpose, DateTimeOffset? certificateCreatedOn, DateTimeOffset? certificateLastUpdatedOn, bool? certificateHasPrivateKey, string certificateNonce)
        {
            var message = _pipeline.CreateMessage();
            var request = message.Request;
            request.Method = RequestMethod.Post;
            var uri = new RawRequestUriBuilder();
            uri.Reset(_endpoint);
            uri.AppendPath("/subscriptions/", false);
            uri.AppendPath(subscriptionId, true);
            uri.AppendPath("/resourceGroups/", false);
            uri.AppendPath(resourceGroupName, true);
            uri.AppendPath("/providers/Microsoft.Devices/provisioningServices/", false);
            uri.AppendPath(provisioningServiceName, true);
            uri.AppendPath("/certificates/", false);
            uri.AppendPath(certificateName, true);
            uri.AppendPath("/generateVerificationCode", false);
            if (certificateCommonName != null)
            {
                uri.AppendQuery("certificateCommonName", certificateCommonName, true);
            }
            if (certificateRawBytes != null)
            {
                uri.AppendQuery("certificate.rawBytes", certificateRawBytes, "D", true);
            }
            if (certificateIsVerified != null)
            {
                uri.AppendQuery("certificate.isVerified", certificateIsVerified.Value, true);
            }
            if (certificatePurpose != null)
            {
                uri.AppendQuery("certificate.purpose", certificatePurpose.Value.ToString(), true);
            }
            if (certificateCreatedOn != null)
            {
                uri.AppendQuery("certificateCreatedOn", certificateCreatedOn.Value, "O", true);
            }
            if (certificateLastUpdatedOn != null)
            {
                uri.AppendQuery("certificateLastUpdatedOn", certificateLastUpdatedOn.Value, "O", true);
            }
            if (certificateHasPrivateKey != null)
            {
                uri.AppendQuery("certificate.hasPrivateKey", certificateHasPrivateKey.Value, true);
            }
            if (certificateNonce != null)
            {
                uri.AppendQuery("certificate.nonce", certificateNonce, true);
            }
            uri.AppendQuery("api-version", _apiVersion, true);
            request.Uri = uri;
            request.Headers.Add("If-Match", ifMatch);
            request.Headers.Add("Accept", "application/json");
            _userAgent.Apply(message);
            return message;
        }

        /// <summary> Generate verification code for Proof of Possession. </summary>
        /// <param name="subscriptionId"> The subscription identifier. </param>
        /// <param name="resourceGroupName"> name of resource group. </param>
        /// <param name="provisioningServiceName"> Name of provisioning service. </param>
        /// <param name="certificateName"> The mandatory logical name of the certificate, that the provisioning service uses to access. </param>
        /// <param name="ifMatch"> ETag of the certificate. This is required to update an existing certificate, and ignored while creating a brand new certificate. </param>
        /// <param name="certificateCommonName"> Common Name for the certificate. </param>
        /// <param name="certificateRawBytes"> Raw data of certificate. </param>
        /// <param name="certificateIsVerified"> Indicates if the certificate has been verified by owner of the private key. </param>
        /// <param name="certificatePurpose"> Description mentioning the purpose of the certificate. </param>
        /// <param name="certificateCreatedOn"> Certificate creation time. </param>
        /// <param name="certificateLastUpdatedOn"> Certificate last updated time. </param>
        /// <param name="certificateHasPrivateKey"> Indicates if the certificate contains private key. </param>
        /// <param name="certificateNonce"> Random number generated to indicate Proof of Possession. </param>
        /// <param name="cancellationToken"> The cancellation token to use. </param>
        /// <exception cref="ArgumentNullException"> <paramref name="subscriptionId"/>, <paramref name="resourceGroupName"/>, <paramref name="provisioningServiceName"/>, <paramref name="certificateName"/> or <paramref name="ifMatch"/> is null. </exception>
        /// <exception cref="ArgumentException"> <paramref name="subscriptionId"/>, <paramref name="resourceGroupName"/>, <paramref name="provisioningServiceName"/> or <paramref name="certificateName"/> is an empty string, and was expected to be non-empty. </exception>
        public async Task<Response<CertificateVerificationCodeResult>> GenerateVerificationCodeAsync(string subscriptionId, string resourceGroupName, string provisioningServiceName, string certificateName, string ifMatch, string certificateCommonName = null, byte[] certificateRawBytes = null, bool? certificateIsVerified = null, DeviceProvisioningServicesCertificatePurpose? certificatePurpose = null, DateTimeOffset? certificateCreatedOn = null, DateTimeOffset? certificateLastUpdatedOn = null, bool? certificateHasPrivateKey = null, string certificateNonce = null, CancellationToken cancellationToken = default)
        {
            Argument.AssertNotNullOrEmpty(subscriptionId, nameof(subscriptionId));
            Argument.AssertNotNullOrEmpty(resourceGroupName, nameof(resourceGroupName));
            Argument.AssertNotNullOrEmpty(provisioningServiceName, nameof(provisioningServiceName));
            Argument.AssertNotNullOrEmpty(certificateName, nameof(certificateName));
            Argument.AssertNotNull(ifMatch, nameof(ifMatch));

            using var message = CreateGenerateVerificationCodeRequest(subscriptionId, resourceGroupName, provisioningServiceName, certificateName, ifMatch, certificateCommonName, certificateRawBytes, certificateIsVerified, certificatePurpose, certificateCreatedOn, certificateLastUpdatedOn, certificateHasPrivateKey, certificateNonce);
            await _pipeline.SendAsync(message, cancellationToken).ConfigureAwait(false);
            switch (message.Response.Status)
            {
                case 200:
                    {
                        CertificateVerificationCodeResult value = default;
                        using var document = await JsonDocument.ParseAsync(message.Response.ContentStream, default, cancellationToken).ConfigureAwait(false);
                        value = CertificateVerificationCodeResult.DeserializeCertificateVerificationCodeResult(document.RootElement);
                        return Response.FromValue(value, message.Response);
                    }
                default:
                    throw new RequestFailedException(message.Response);
            }
        }

        /// <summary> Generate verification code for Proof of Possession. </summary>
        /// <param name="subscriptionId"> The subscription identifier. </param>
        /// <param name="resourceGroupName"> name of resource group. </param>
        /// <param name="provisioningServiceName"> Name of provisioning service. </param>
        /// <param name="certificateName"> The mandatory logical name of the certificate, that the provisioning service uses to access. </param>
        /// <param name="ifMatch"> ETag of the certificate. This is required to update an existing certificate, and ignored while creating a brand new certificate. </param>
        /// <param name="certificateCommonName"> Common Name for the certificate. </param>
        /// <param name="certificateRawBytes"> Raw data of certificate. </param>
        /// <param name="certificateIsVerified"> Indicates if the certificate has been verified by owner of the private key. </param>
        /// <param name="certificatePurpose"> Description mentioning the purpose of the certificate. </param>
        /// <param name="certificateCreatedOn"> Certificate creation time. </param>
        /// <param name="certificateLastUpdatedOn"> Certificate last updated time. </param>
        /// <param name="certificateHasPrivateKey"> Indicates if the certificate contains private key. </param>
        /// <param name="certificateNonce"> Random number generated to indicate Proof of Possession. </param>
        /// <param name="cancellationToken"> The cancellation token to use. </param>
        /// <exception cref="ArgumentNullException"> <paramref name="subscriptionId"/>, <paramref name="resourceGroupName"/>, <paramref name="provisioningServiceName"/>, <paramref name="certificateName"/> or <paramref name="ifMatch"/> is null. </exception>
        /// <exception cref="ArgumentException"> <paramref name="subscriptionId"/>, <paramref name="resourceGroupName"/>, <paramref name="provisioningServiceName"/> or <paramref name="certificateName"/> is an empty string, and was expected to be non-empty. </exception>
        public Response<CertificateVerificationCodeResult> GenerateVerificationCode(string subscriptionId, string resourceGroupName, string provisioningServiceName, string certificateName, string ifMatch, string certificateCommonName = null, byte[] certificateRawBytes = null, bool? certificateIsVerified = null, DeviceProvisioningServicesCertificatePurpose? certificatePurpose = null, DateTimeOffset? certificateCreatedOn = null, DateTimeOffset? certificateLastUpdatedOn = null, bool? certificateHasPrivateKey = null, string certificateNonce = null, CancellationToken cancellationToken = default)
        {
            Argument.AssertNotNullOrEmpty(subscriptionId, nameof(subscriptionId));
            Argument.AssertNotNullOrEmpty(resourceGroupName, nameof(resourceGroupName));
            Argument.AssertNotNullOrEmpty(provisioningServiceName, nameof(provisioningServiceName));
            Argument.AssertNotNullOrEmpty(certificateName, nameof(certificateName));
            Argument.AssertNotNull(ifMatch, nameof(ifMatch));

            using var message = CreateGenerateVerificationCodeRequest(subscriptionId, resourceGroupName, provisioningServiceName, certificateName, ifMatch, certificateCommonName, certificateRawBytes, certificateIsVerified, certificatePurpose, certificateCreatedOn, certificateLastUpdatedOn, certificateHasPrivateKey, certificateNonce);
            _pipeline.Send(message, cancellationToken);
            switch (message.Response.Status)
            {
                case 200:
                    {
                        CertificateVerificationCodeResult value = default;
                        using var document = JsonDocument.Parse(message.Response.ContentStream);
                        value = CertificateVerificationCodeResult.DeserializeCertificateVerificationCodeResult(document.RootElement);
                        return Response.FromValue(value, message.Response);
                    }
                default:
                    throw new RequestFailedException(message.Response);
            }
        }

        internal RequestUriBuilder CreateVerifyCertificateRequestUri(string subscriptionId, string resourceGroupName, string provisioningServiceName, string certificateName, string ifMatch, CertificateVerificationCodeContent content, string certificateCommonName, byte[] certificateRawBytes, bool? certificateIsVerified, DeviceProvisioningServicesCertificatePurpose? certificatePurpose, DateTimeOffset? certificateCreatedOn, DateTimeOffset? certificateLastUpdatedOn, bool? certificateHasPrivateKey, string certificateNonce)
        {
            var uri = new RawRequestUriBuilder();
            uri.Reset(_endpoint);
            uri.AppendPath("/subscriptions/", false);
            uri.AppendPath(subscriptionId, true);
            uri.AppendPath("/resourceGroups/", false);
            uri.AppendPath(resourceGroupName, true);
            uri.AppendPath("/providers/Microsoft.Devices/provisioningServices/", false);
            uri.AppendPath(provisioningServiceName, true);
            uri.AppendPath("/certificates/", false);
            uri.AppendPath(certificateName, true);
            uri.AppendPath("/verify", false);
            if (certificateCommonName != null)
            {
                uri.AppendQuery("certificateCommonName", certificateCommonName, true);
            }
            if (certificateRawBytes != null)
            {
                uri.AppendQuery("certificate.rawBytes", certificateRawBytes, "D", true);
            }
            if (certificateIsVerified != null)
            {
                uri.AppendQuery("certificate.isVerified", certificateIsVerified.Value, true);
            }
            if (certificatePurpose != null)
            {
                uri.AppendQuery("certificate.purpose", certificatePurpose.Value.ToString(), true);
            }
            if (certificateCreatedOn != null)
            {
                uri.AppendQuery("certificateCreatedOn", certificateCreatedOn.Value, "O", true);
            }
            if (certificateLastUpdatedOn != null)
            {
                uri.AppendQuery("certificateLastUpdatedOn", certificateLastUpdatedOn.Value, "O", true);
            }
            if (certificateHasPrivateKey != null)
            {
                uri.AppendQuery("certificate.hasPrivateKey", certificateHasPrivateKey.Value, true);
            }
            if (certificateNonce != null)
            {
                uri.AppendQuery("certificate.nonce", certificateNonce, true);
            }
            uri.AppendQuery("api-version", _apiVersion, true);
            return uri;
        }

        internal HttpMessage CreateVerifyCertificateRequest(string subscriptionId, string resourceGroupName, string provisioningServiceName, string certificateName, string ifMatch, CertificateVerificationCodeContent content, string certificateCommonName, byte[] certificateRawBytes, bool? certificateIsVerified, DeviceProvisioningServicesCertificatePurpose? certificatePurpose, DateTimeOffset? certificateCreatedOn, DateTimeOffset? certificateLastUpdatedOn, bool? certificateHasPrivateKey, string certificateNonce)
        {
            var message = _pipeline.CreateMessage();
            var request = message.Request;
            request.Method = RequestMethod.Post;
            var uri = new RawRequestUriBuilder();
            uri.Reset(_endpoint);
            uri.AppendPath("/subscriptions/", false);
            uri.AppendPath(subscriptionId, true);
            uri.AppendPath("/resourceGroups/", false);
            uri.AppendPath(resourceGroupName, true);
            uri.AppendPath("/providers/Microsoft.Devices/provisioningServices/", false);
            uri.AppendPath(provisioningServiceName, true);
            uri.AppendPath("/certificates/", false);
            uri.AppendPath(certificateName, true);
            uri.AppendPath("/verify", false);
            if (certificateCommonName != null)
            {
                uri.AppendQuery("certificateCommonName", certificateCommonName, true);
            }
            if (certificateRawBytes != null)
            {
                uri.AppendQuery("certificate.rawBytes", certificateRawBytes, "D", true);
            }
            if (certificateIsVerified != null)
            {
                uri.AppendQuery("certificate.isVerified", certificateIsVerified.Value, true);
            }
            if (certificatePurpose != null)
            {
                uri.AppendQuery("certificate.purpose", certificatePurpose.Value.ToString(), true);
            }
            if (certificateCreatedOn != null)
            {
                uri.AppendQuery("certificateCreatedOn", certificateCreatedOn.Value, "O", true);
            }
            if (certificateLastUpdatedOn != null)
            {
                uri.AppendQuery("certificateLastUpdatedOn", certificateLastUpdatedOn.Value, "O", true);
            }
            if (certificateHasPrivateKey != null)
            {
                uri.AppendQuery("certificate.hasPrivateKey", certificateHasPrivateKey.Value, true);
            }
            if (certificateNonce != null)
            {
                uri.AppendQuery("certificate.nonce", certificateNonce, true);
            }
            uri.AppendQuery("api-version", _apiVersion, true);
            request.Uri = uri;
            request.Headers.Add("If-Match", ifMatch);
            request.Headers.Add("Accept", "application/json");
            request.Headers.Add("Content-Type", "application/json");
            var content0 = new Utf8JsonRequestContent();
            content0.JsonWriter.WriteObjectValue(content, ModelSerializationExtensions.WireOptions);
            request.Content = content0;
            _userAgent.Apply(message);
            return message;
        }

        /// <summary> Verifies the certificate's private key possession by providing the leaf cert issued by the verifying pre uploaded certificate. </summary>
        /// <param name="subscriptionId"> The subscription identifier. </param>
        /// <param name="resourceGroupName"> Resource group name. </param>
        /// <param name="provisioningServiceName"> Provisioning service name. </param>
        /// <param name="certificateName"> The mandatory logical name of the certificate, that the provisioning service uses to access. </param>
        /// <param name="ifMatch"> ETag of the certificate. </param>
        /// <param name="content"> The name of the certificate. </param>
        /// <param name="certificateCommonName"> Common Name for the certificate. </param>
        /// <param name="certificateRawBytes"> Raw data of certificate. </param>
        /// <param name="certificateIsVerified"> Indicates if the certificate has been verified by owner of the private key. </param>
        /// <param name="certificatePurpose"> Describe the purpose of the certificate. </param>
        /// <param name="certificateCreatedOn"> Certificate creation time. </param>
        /// <param name="certificateLastUpdatedOn"> Certificate last updated time. </param>
        /// <param name="certificateHasPrivateKey"> Indicates if the certificate contains private key. </param>
        /// <param name="certificateNonce"> Random number generated to indicate Proof of Possession. </param>
        /// <param name="cancellationToken"> The cancellation token to use. </param>
        /// <exception cref="ArgumentNullException"> <paramref name="subscriptionId"/>, <paramref name="resourceGroupName"/>, <paramref name="provisioningServiceName"/>, <paramref name="certificateName"/>, <paramref name="ifMatch"/> or <paramref name="content"/> is null. </exception>
        /// <exception cref="ArgumentException"> <paramref name="subscriptionId"/>, <paramref name="resourceGroupName"/>, <paramref name="provisioningServiceName"/> or <paramref name="certificateName"/> is an empty string, and was expected to be non-empty. </exception>
        public async Task<Response<DeviceProvisioningServicesCertificateData>> VerifyCertificateAsync(string subscriptionId, string resourceGroupName, string provisioningServiceName, string certificateName, string ifMatch, CertificateVerificationCodeContent content, string certificateCommonName = null, byte[] certificateRawBytes = null, bool? certificateIsVerified = null, DeviceProvisioningServicesCertificatePurpose? certificatePurpose = null, DateTimeOffset? certificateCreatedOn = null, DateTimeOffset? certificateLastUpdatedOn = null, bool? certificateHasPrivateKey = null, string certificateNonce = null, CancellationToken cancellationToken = default)
        {
            Argument.AssertNotNullOrEmpty(subscriptionId, nameof(subscriptionId));
            Argument.AssertNotNullOrEmpty(resourceGroupName, nameof(resourceGroupName));
            Argument.AssertNotNullOrEmpty(provisioningServiceName, nameof(provisioningServiceName));
            Argument.AssertNotNullOrEmpty(certificateName, nameof(certificateName));
            Argument.AssertNotNull(ifMatch, nameof(ifMatch));
            Argument.AssertNotNull(content, nameof(content));

            using var message = CreateVerifyCertificateRequest(subscriptionId, resourceGroupName, provisioningServiceName, certificateName, ifMatch, content, certificateCommonName, certificateRawBytes, certificateIsVerified, certificatePurpose, certificateCreatedOn, certificateLastUpdatedOn, certificateHasPrivateKey, certificateNonce);
            await _pipeline.SendAsync(message, cancellationToken).ConfigureAwait(false);
            switch (message.Response.Status)
            {
                case 200:
                    {
                        DeviceProvisioningServicesCertificateData value = default;
                        using var document = await JsonDocument.ParseAsync(message.Response.ContentStream, default, cancellationToken).ConfigureAwait(false);
                        value = DeviceProvisioningServicesCertificateData.DeserializeDeviceProvisioningServicesCertificateData(document.RootElement);
                        return Response.FromValue(value, message.Response);
                    }
                default:
                    throw new RequestFailedException(message.Response);
            }
        }

        /// <summary> Verifies the certificate's private key possession by providing the leaf cert issued by the verifying pre uploaded certificate. </summary>
        /// <param name="subscriptionId"> The subscription identifier. </param>
        /// <param name="resourceGroupName"> Resource group name. </param>
        /// <param name="provisioningServiceName"> Provisioning service name. </param>
        /// <param name="certificateName"> The mandatory logical name of the certificate, that the provisioning service uses to access. </param>
        /// <param name="ifMatch"> ETag of the certificate. </param>
        /// <param name="content"> The name of the certificate. </param>
        /// <param name="certificateCommonName"> Common Name for the certificate. </param>
        /// <param name="certificateRawBytes"> Raw data of certificate. </param>
        /// <param name="certificateIsVerified"> Indicates if the certificate has been verified by owner of the private key. </param>
        /// <param name="certificatePurpose"> Describe the purpose of the certificate. </param>
        /// <param name="certificateCreatedOn"> Certificate creation time. </param>
        /// <param name="certificateLastUpdatedOn"> Certificate last updated time. </param>
        /// <param name="certificateHasPrivateKey"> Indicates if the certificate contains private key. </param>
        /// <param name="certificateNonce"> Random number generated to indicate Proof of Possession. </param>
        /// <param name="cancellationToken"> The cancellation token to use. </param>
        /// <exception cref="ArgumentNullException"> <paramref name="subscriptionId"/>, <paramref name="resourceGroupName"/>, <paramref name="provisioningServiceName"/>, <paramref name="certificateName"/>, <paramref name="ifMatch"/> or <paramref name="content"/> is null. </exception>
        /// <exception cref="ArgumentException"> <paramref name="subscriptionId"/>, <paramref name="resourceGroupName"/>, <paramref name="provisioningServiceName"/> or <paramref name="certificateName"/> is an empty string, and was expected to be non-empty. </exception>
        public Response<DeviceProvisioningServicesCertificateData> VerifyCertificate(string subscriptionId, string resourceGroupName, string provisioningServiceName, string certificateName, string ifMatch, CertificateVerificationCodeContent content, string certificateCommonName = null, byte[] certificateRawBytes = null, bool? certificateIsVerified = null, DeviceProvisioningServicesCertificatePurpose? certificatePurpose = null, DateTimeOffset? certificateCreatedOn = null, DateTimeOffset? certificateLastUpdatedOn = null, bool? certificateHasPrivateKey = null, string certificateNonce = null, CancellationToken cancellationToken = default)
        {
            Argument.AssertNotNullOrEmpty(subscriptionId, nameof(subscriptionId));
            Argument.AssertNotNullOrEmpty(resourceGroupName, nameof(resourceGroupName));
            Argument.AssertNotNullOrEmpty(provisioningServiceName, nameof(provisioningServiceName));
            Argument.AssertNotNullOrEmpty(certificateName, nameof(certificateName));
            Argument.AssertNotNull(ifMatch, nameof(ifMatch));
            Argument.AssertNotNull(content, nameof(content));

            using var message = CreateVerifyCertificateRequest(subscriptionId, resourceGroupName, provisioningServiceName, certificateName, ifMatch, content, certificateCommonName, certificateRawBytes, certificateIsVerified, certificatePurpose, certificateCreatedOn, certificateLastUpdatedOn, certificateHasPrivateKey, certificateNonce);
            _pipeline.Send(message, cancellationToken);
            switch (message.Response.Status)
            {
                case 200:
                    {
                        DeviceProvisioningServicesCertificateData value = default;
                        using var document = JsonDocument.Parse(message.Response.ContentStream);
                        value = DeviceProvisioningServicesCertificateData.DeserializeDeviceProvisioningServicesCertificateData(document.RootElement);
                        return Response.FromValue(value, message.Response);
                    }
                default:
                    throw new RequestFailedException(message.Response);
            }
        }
    }
}
