// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.

// <auto-generated/>

#nullable disable

using System;
using System.ComponentModel;

namespace Azure.ResourceManager.DeviceProvisioningServices.Models
{
    /// <summary> Sku name. </summary>
    public readonly partial struct DeviceProvisioningServicesSku : IEquatable<DeviceProvisioningServicesSku>
    {
        private readonly string _value;

        /// <summary> Initializes a new instance of <see cref="DeviceProvisioningServicesSku"/>. </summary>
        /// <exception cref="ArgumentNullException"> <paramref name="value"/> is null. </exception>
        public DeviceProvisioningServicesSku(string value)
        {
            _value = value ?? throw new ArgumentNullException(nameof(value));
        }

        private const string S1Value = "S1";

        /// <summary> S1. </summary>
        public static DeviceProvisioningServicesSku S1 { get; } = new DeviceProvisioningServicesSku(S1Value);
        /// <summary> Determines if two <see cref="DeviceProvisioningServicesSku"/> values are the same. </summary>
        public static bool operator ==(DeviceProvisioningServicesSku left, DeviceProvisioningServicesSku right) => left.Equals(right);
        /// <summary> Determines if two <see cref="DeviceProvisioningServicesSku"/> values are not the same. </summary>
        public static bool operator !=(DeviceProvisioningServicesSku left, DeviceProvisioningServicesSku right) => !left.Equals(right);
        /// <summary> Converts a <see cref="string"/> to a <see cref="DeviceProvisioningServicesSku"/>. </summary>
        public static implicit operator DeviceProvisioningServicesSku(string value) => new DeviceProvisioningServicesSku(value);

        /// <inheritdoc />
        [EditorBrowsable(EditorBrowsableState.Never)]
        public override bool Equals(object obj) => obj is DeviceProvisioningServicesSku other && Equals(other);
        /// <inheritdoc />
        public bool Equals(DeviceProvisioningServicesSku other) => string.Equals(_value, other._value, StringComparison.InvariantCultureIgnoreCase);

        /// <inheritdoc />
        [EditorBrowsable(EditorBrowsableState.Never)]
        public override int GetHashCode() => _value != null ? StringComparer.InvariantCultureIgnoreCase.GetHashCode(_value) : 0;
        /// <inheritdoc />
        public override string ToString() => _value;
    }
}
