// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.

// <auto-generated/>

#nullable disable

using System;
using System.Collections.Generic;

namespace Azure.ResourceManager.DeviceProvisioningServices.Models
{
    /// <summary> Description of the shared access key. </summary>
    public partial class DeviceProvisioningServicesSharedAccessKey
    {
        /// <summary>
        /// Keeps track of any properties unknown to the library.
        /// <para>
        /// To assign an object to the value of this property use <see cref="BinaryData.FromObjectAsJson{T}(T, System.Text.Json.JsonSerializerOptions?)"/>.
        /// </para>
        /// <para>
        /// To assign an already formatted json string to this property use <see cref="BinaryData.FromString(string)"/>.
        /// </para>
        /// <para>
        /// Examples:
        /// <list type="bullet">
        /// <item>
        /// <term>BinaryData.FromObjectAsJson("foo")</term>
        /// <description>Creates a payload of "foo".</description>
        /// </item>
        /// <item>
        /// <term>BinaryData.FromString("\"foo\"")</term>
        /// <description>Creates a payload of "foo".</description>
        /// </item>
        /// <item>
        /// <term>BinaryData.FromObjectAsJson(new { key = "value" })</term>
        /// <description>Creates a payload of { "key": "value" }.</description>
        /// </item>
        /// <item>
        /// <term>BinaryData.FromString("{\"key\": \"value\"}")</term>
        /// <description>Creates a payload of { "key": "value" }.</description>
        /// </item>
        /// </list>
        /// </para>
        /// </summary>
        private IDictionary<string, BinaryData> _serializedAdditionalRawData;

        /// <summary> Initializes a new instance of <see cref="DeviceProvisioningServicesSharedAccessKey"/>. </summary>
        /// <param name="keyName"> Name of the key. </param>
        /// <param name="rights"> Rights that this key has. </param>
        /// <exception cref="ArgumentNullException"> <paramref name="keyName"/> is null. </exception>
        public DeviceProvisioningServicesSharedAccessKey(string keyName, DeviceProvisioningServicesAccessKeyRight rights)
        {
            Argument.AssertNotNull(keyName, nameof(keyName));

            KeyName = keyName;
            Rights = rights;
        }

        /// <summary> Initializes a new instance of <see cref="DeviceProvisioningServicesSharedAccessKey"/>. </summary>
        /// <param name="keyName"> Name of the key. </param>
        /// <param name="primaryKey"> Primary SAS key value. </param>
        /// <param name="secondaryKey"> Secondary SAS key value. </param>
        /// <param name="rights"> Rights that this key has. </param>
        /// <param name="serializedAdditionalRawData"> Keeps track of any properties unknown to the library. </param>
        internal DeviceProvisioningServicesSharedAccessKey(string keyName, string primaryKey, string secondaryKey, DeviceProvisioningServicesAccessKeyRight rights, IDictionary<string, BinaryData> serializedAdditionalRawData)
        {
            KeyName = keyName;
            PrimaryKey = primaryKey;
            SecondaryKey = secondaryKey;
            Rights = rights;
            _serializedAdditionalRawData = serializedAdditionalRawData;
        }

        /// <summary> Initializes a new instance of <see cref="DeviceProvisioningServicesSharedAccessKey"/> for deserialization. </summary>
        internal DeviceProvisioningServicesSharedAccessKey()
        {
        }

        /// <summary> Name of the key. </summary>
        public string KeyName { get; set; }
        /// <summary> Primary SAS key value. </summary>
        public string PrimaryKey { get; set; }
        /// <summary> Secondary SAS key value. </summary>
        public string SecondaryKey { get; set; }
        /// <summary> Rights that this key has. </summary>
        public DeviceProvisioningServicesAccessKeyRight Rights { get; set; }
    }
}
