// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.

// <auto-generated/>

#nullable disable

using System;
using System.ComponentModel;

namespace Azure.ResourceManager.DeviceProvisioningServices.Models
{
    /// <summary> Whether requests from Public Network are allowed. </summary>
    public readonly partial struct DeviceProvisioningServicesPublicNetworkAccess : IEquatable<DeviceProvisioningServicesPublicNetworkAccess>
    {
        private readonly string _value;

        /// <summary> Initializes a new instance of <see cref="DeviceProvisioningServicesPublicNetworkAccess"/>. </summary>
        /// <exception cref="ArgumentNullException"> <paramref name="value"/> is null. </exception>
        public DeviceProvisioningServicesPublicNetworkAccess(string value)
        {
            _value = value ?? throw new ArgumentNullException(nameof(value));
        }

        private const string EnabledValue = "Enabled";
        private const string DisabledValue = "Disabled";

        /// <summary> Enabled. </summary>
        public static DeviceProvisioningServicesPublicNetworkAccess Enabled { get; } = new DeviceProvisioningServicesPublicNetworkAccess(EnabledValue);
        /// <summary> Disabled. </summary>
        public static DeviceProvisioningServicesPublicNetworkAccess Disabled { get; } = new DeviceProvisioningServicesPublicNetworkAccess(DisabledValue);
        /// <summary> Determines if two <see cref="DeviceProvisioningServicesPublicNetworkAccess"/> values are the same. </summary>
        public static bool operator ==(DeviceProvisioningServicesPublicNetworkAccess left, DeviceProvisioningServicesPublicNetworkAccess right) => left.Equals(right);
        /// <summary> Determines if two <see cref="DeviceProvisioningServicesPublicNetworkAccess"/> values are not the same. </summary>
        public static bool operator !=(DeviceProvisioningServicesPublicNetworkAccess left, DeviceProvisioningServicesPublicNetworkAccess right) => !left.Equals(right);
        /// <summary> Converts a <see cref="string"/> to a <see cref="DeviceProvisioningServicesPublicNetworkAccess"/>. </summary>
        public static implicit operator DeviceProvisioningServicesPublicNetworkAccess(string value) => new DeviceProvisioningServicesPublicNetworkAccess(value);

        /// <inheritdoc />
        [EditorBrowsable(EditorBrowsableState.Never)]
        public override bool Equals(object obj) => obj is DeviceProvisioningServicesPublicNetworkAccess other && Equals(other);
        /// <inheritdoc />
        public bool Equals(DeviceProvisioningServicesPublicNetworkAccess other) => string.Equals(_value, other._value, StringComparison.InvariantCultureIgnoreCase);

        /// <inheritdoc />
        [EditorBrowsable(EditorBrowsableState.Never)]
        public override int GetHashCode() => _value != null ? StringComparer.InvariantCultureIgnoreCase.GetHashCode(_value) : 0;
        /// <inheritdoc />
        public override string ToString() => _value;
    }
}
