// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.

// <auto-generated/>

#nullable disable

using System;
using System.ComponentModel;

namespace Azure.ResourceManager.DeviceProvisioningServices.Models
{
    /// <summary> specifies the reason a name is unavailable. </summary>
    public readonly partial struct DeviceProvisioningServicesNameUnavailableReason : IEquatable<DeviceProvisioningServicesNameUnavailableReason>
    {
        private readonly string _value;

        /// <summary> Initializes a new instance of <see cref="DeviceProvisioningServicesNameUnavailableReason"/>. </summary>
        /// <exception cref="ArgumentNullException"> <paramref name="value"/> is null. </exception>
        public DeviceProvisioningServicesNameUnavailableReason(string value)
        {
            _value = value ?? throw new ArgumentNullException(nameof(value));
        }

        private const string InvalidValue = "Invalid";
        private const string AlreadyExistsValue = "AlreadyExists";

        /// <summary> Invalid. </summary>
        public static DeviceProvisioningServicesNameUnavailableReason Invalid { get; } = new DeviceProvisioningServicesNameUnavailableReason(InvalidValue);
        /// <summary> AlreadyExists. </summary>
        public static DeviceProvisioningServicesNameUnavailableReason AlreadyExists { get; } = new DeviceProvisioningServicesNameUnavailableReason(AlreadyExistsValue);
        /// <summary> Determines if two <see cref="DeviceProvisioningServicesNameUnavailableReason"/> values are the same. </summary>
        public static bool operator ==(DeviceProvisioningServicesNameUnavailableReason left, DeviceProvisioningServicesNameUnavailableReason right) => left.Equals(right);
        /// <summary> Determines if two <see cref="DeviceProvisioningServicesNameUnavailableReason"/> values are not the same. </summary>
        public static bool operator !=(DeviceProvisioningServicesNameUnavailableReason left, DeviceProvisioningServicesNameUnavailableReason right) => !left.Equals(right);
        /// <summary> Converts a <see cref="string"/> to a <see cref="DeviceProvisioningServicesNameUnavailableReason"/>. </summary>
        public static implicit operator DeviceProvisioningServicesNameUnavailableReason(string value) => new DeviceProvisioningServicesNameUnavailableReason(value);

        /// <inheritdoc />
        [EditorBrowsable(EditorBrowsableState.Never)]
        public override bool Equals(object obj) => obj is DeviceProvisioningServicesNameUnavailableReason other && Equals(other);
        /// <inheritdoc />
        public bool Equals(DeviceProvisioningServicesNameUnavailableReason other) => string.Equals(_value, other._value, StringComparison.InvariantCultureIgnoreCase);

        /// <inheritdoc />
        [EditorBrowsable(EditorBrowsableState.Never)]
        public override int GetHashCode() => _value != null ? StringComparer.InvariantCultureIgnoreCase.GetHashCode(_value) : 0;
        /// <inheritdoc />
        public override string ToString() => _value;
    }
}
