// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.

// <auto-generated/>

#nullable disable

using System;

namespace Azure.ResourceManager.DeviceProvisioningServices.Models
{
    internal static partial class DeviceProvisioningServicesIPFilterTargetTypeExtensions
    {
        public static string ToSerialString(this DeviceProvisioningServicesIPFilterTargetType value) => value switch
        {
            DeviceProvisioningServicesIPFilterTargetType.All => "all",
            DeviceProvisioningServicesIPFilterTargetType.ServiceApi => "serviceApi",
            DeviceProvisioningServicesIPFilterTargetType.DeviceApi => "deviceApi",
            _ => throw new ArgumentOutOfRangeException(nameof(value), value, "Unknown DeviceProvisioningServicesIPFilterTargetType value.")
        };

        public static DeviceProvisioningServicesIPFilterTargetType ToDeviceProvisioningServicesIPFilterTargetType(this string value)
        {
            if (StringComparer.OrdinalIgnoreCase.Equals(value, "all")) return DeviceProvisioningServicesIPFilterTargetType.All;
            if (StringComparer.OrdinalIgnoreCase.Equals(value, "serviceApi")) return DeviceProvisioningServicesIPFilterTargetType.ServiceApi;
            if (StringComparer.OrdinalIgnoreCase.Equals(value, "deviceApi")) return DeviceProvisioningServicesIPFilterTargetType.DeviceApi;
            throw new ArgumentOutOfRangeException(nameof(value), value, "Unknown DeviceProvisioningServicesIPFilterTargetType value.");
        }
    }
}
