// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.

// <auto-generated/>

#nullable disable

using System;
using System.Collections.Generic;

namespace Azure.ResourceManager.DeviceProvisioningServices.Models
{
    /// <summary> The IP filter rules for a provisioning Service. </summary>
    public partial class DeviceProvisioningServicesIPFilterRule
    {
        /// <summary>
        /// Keeps track of any properties unknown to the library.
        /// <para>
        /// To assign an object to the value of this property use <see cref="BinaryData.FromObjectAsJson{T}(T, System.Text.Json.JsonSerializerOptions?)"/>.
        /// </para>
        /// <para>
        /// To assign an already formatted json string to this property use <see cref="BinaryData.FromString(string)"/>.
        /// </para>
        /// <para>
        /// Examples:
        /// <list type="bullet">
        /// <item>
        /// <term>BinaryData.FromObjectAsJson("foo")</term>
        /// <description>Creates a payload of "foo".</description>
        /// </item>
        /// <item>
        /// <term>BinaryData.FromString("\"foo\"")</term>
        /// <description>Creates a payload of "foo".</description>
        /// </item>
        /// <item>
        /// <term>BinaryData.FromObjectAsJson(new { key = "value" })</term>
        /// <description>Creates a payload of { "key": "value" }.</description>
        /// </item>
        /// <item>
        /// <term>BinaryData.FromString("{\"key\": \"value\"}")</term>
        /// <description>Creates a payload of { "key": "value" }.</description>
        /// </item>
        /// </list>
        /// </para>
        /// </summary>
        private IDictionary<string, BinaryData> _serializedAdditionalRawData;

        /// <summary> Initializes a new instance of <see cref="DeviceProvisioningServicesIPFilterRule"/>. </summary>
        /// <param name="filterName"> The name of the IP filter rule. </param>
        /// <param name="action"> The desired action for requests captured by this rule. </param>
        /// <param name="ipMask"> A string that contains the IP address range in CIDR notation for the rule. </param>
        /// <exception cref="ArgumentNullException"> <paramref name="filterName"/> or <paramref name="ipMask"/> is null. </exception>
        public DeviceProvisioningServicesIPFilterRule(string filterName, DeviceProvisioningServicesIPFilterActionType action, string ipMask)
        {
            Argument.AssertNotNull(filterName, nameof(filterName));
            Argument.AssertNotNull(ipMask, nameof(ipMask));

            FilterName = filterName;
            Action = action;
            IPMask = ipMask;
        }

        /// <summary> Initializes a new instance of <see cref="DeviceProvisioningServicesIPFilterRule"/>. </summary>
        /// <param name="filterName"> The name of the IP filter rule. </param>
        /// <param name="action"> The desired action for requests captured by this rule. </param>
        /// <param name="ipMask"> A string that contains the IP address range in CIDR notation for the rule. </param>
        /// <param name="target"> Target for requests captured by this rule. </param>
        /// <param name="serializedAdditionalRawData"> Keeps track of any properties unknown to the library. </param>
        internal DeviceProvisioningServicesIPFilterRule(string filterName, DeviceProvisioningServicesIPFilterActionType action, string ipMask, DeviceProvisioningServicesIPFilterTargetType? target, IDictionary<string, BinaryData> serializedAdditionalRawData)
        {
            FilterName = filterName;
            Action = action;
            IPMask = ipMask;
            Target = target;
            _serializedAdditionalRawData = serializedAdditionalRawData;
        }

        /// <summary> Initializes a new instance of <see cref="DeviceProvisioningServicesIPFilterRule"/> for deserialization. </summary>
        internal DeviceProvisioningServicesIPFilterRule()
        {
        }

        /// <summary> The name of the IP filter rule. </summary>
        public string FilterName { get; set; }
        /// <summary> The desired action for requests captured by this rule. </summary>
        public DeviceProvisioningServicesIPFilterActionType Action { get; set; }
        /// <summary> A string that contains the IP address range in CIDR notation for the rule. </summary>
        public string IPMask { get; set; }
        /// <summary> Target for requests captured by this rule. </summary>
        public DeviceProvisioningServicesIPFilterTargetType? Target { get; set; }
    }
}
