// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.

// <auto-generated/>

#nullable disable

using System;
using System.ComponentModel;

namespace Azure.ResourceManager.DeviceProvisioningServices.Models
{
    /// <summary> The DeviceProvisioningServicesCertificatePurpose. </summary>
    public readonly partial struct DeviceProvisioningServicesCertificatePurpose : IEquatable<DeviceProvisioningServicesCertificatePurpose>
    {
        private readonly string _value;

        /// <summary> Initializes a new instance of <see cref="DeviceProvisioningServicesCertificatePurpose"/>. </summary>
        /// <exception cref="ArgumentNullException"> <paramref name="value"/> is null. </exception>
        public DeviceProvisioningServicesCertificatePurpose(string value)
        {
            _value = value ?? throw new ArgumentNullException(nameof(value));
        }

        private const string ClientAuthenticationValue = "clientAuthentication";
        private const string ServerAuthenticationValue = "serverAuthentication";

        /// <summary> clientAuthentication. </summary>
        public static DeviceProvisioningServicesCertificatePurpose ClientAuthentication { get; } = new DeviceProvisioningServicesCertificatePurpose(ClientAuthenticationValue);
        /// <summary> serverAuthentication. </summary>
        public static DeviceProvisioningServicesCertificatePurpose ServerAuthentication { get; } = new DeviceProvisioningServicesCertificatePurpose(ServerAuthenticationValue);
        /// <summary> Determines if two <see cref="DeviceProvisioningServicesCertificatePurpose"/> values are the same. </summary>
        public static bool operator ==(DeviceProvisioningServicesCertificatePurpose left, DeviceProvisioningServicesCertificatePurpose right) => left.Equals(right);
        /// <summary> Determines if two <see cref="DeviceProvisioningServicesCertificatePurpose"/> values are not the same. </summary>
        public static bool operator !=(DeviceProvisioningServicesCertificatePurpose left, DeviceProvisioningServicesCertificatePurpose right) => !left.Equals(right);
        /// <summary> Converts a <see cref="string"/> to a <see cref="DeviceProvisioningServicesCertificatePurpose"/>. </summary>
        public static implicit operator DeviceProvisioningServicesCertificatePurpose(string value) => new DeviceProvisioningServicesCertificatePurpose(value);

        /// <inheritdoc />
        [EditorBrowsable(EditorBrowsableState.Never)]
        public override bool Equals(object obj) => obj is DeviceProvisioningServicesCertificatePurpose other && Equals(other);
        /// <inheritdoc />
        public bool Equals(DeviceProvisioningServicesCertificatePurpose other) => string.Equals(_value, other._value, StringComparison.InvariantCultureIgnoreCase);

        /// <inheritdoc />
        [EditorBrowsable(EditorBrowsableState.Never)]
        public override int GetHashCode() => _value != null ? StringComparer.InvariantCultureIgnoreCase.GetHashCode(_value) : 0;
        /// <inheritdoc />
        public override string ToString() => _value;
    }
}
