// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.

// <auto-generated/>

#nullable disable

using System;
using System.ComponentModel;

namespace Azure.ResourceManager.DeviceProvisioningServices.Models
{
    /// <summary> Allocation policy to be used by this provisioning service. </summary>
    public readonly partial struct DeviceProvisioningServicesAllocationPolicy : IEquatable<DeviceProvisioningServicesAllocationPolicy>
    {
        private readonly string _value;

        /// <summary> Initializes a new instance of <see cref="DeviceProvisioningServicesAllocationPolicy"/>. </summary>
        /// <exception cref="ArgumentNullException"> <paramref name="value"/> is null. </exception>
        public DeviceProvisioningServicesAllocationPolicy(string value)
        {
            _value = value ?? throw new ArgumentNullException(nameof(value));
        }

        private const string HashedValue = "Hashed";
        private const string GeoLatencyValue = "GeoLatency";
        private const string StaticValue = "Static";

        /// <summary> Hashed. </summary>
        public static DeviceProvisioningServicesAllocationPolicy Hashed { get; } = new DeviceProvisioningServicesAllocationPolicy(HashedValue);
        /// <summary> GeoLatency. </summary>
        public static DeviceProvisioningServicesAllocationPolicy GeoLatency { get; } = new DeviceProvisioningServicesAllocationPolicy(GeoLatencyValue);
        /// <summary> Static. </summary>
        public static DeviceProvisioningServicesAllocationPolicy Static { get; } = new DeviceProvisioningServicesAllocationPolicy(StaticValue);
        /// <summary> Determines if two <see cref="DeviceProvisioningServicesAllocationPolicy"/> values are the same. </summary>
        public static bool operator ==(DeviceProvisioningServicesAllocationPolicy left, DeviceProvisioningServicesAllocationPolicy right) => left.Equals(right);
        /// <summary> Determines if two <see cref="DeviceProvisioningServicesAllocationPolicy"/> values are not the same. </summary>
        public static bool operator !=(DeviceProvisioningServicesAllocationPolicy left, DeviceProvisioningServicesAllocationPolicy right) => !left.Equals(right);
        /// <summary> Converts a <see cref="string"/> to a <see cref="DeviceProvisioningServicesAllocationPolicy"/>. </summary>
        public static implicit operator DeviceProvisioningServicesAllocationPolicy(string value) => new DeviceProvisioningServicesAllocationPolicy(value);

        /// <inheritdoc />
        [EditorBrowsable(EditorBrowsableState.Never)]
        public override bool Equals(object obj) => obj is DeviceProvisioningServicesAllocationPolicy other && Equals(other);
        /// <inheritdoc />
        public bool Equals(DeviceProvisioningServicesAllocationPolicy other) => string.Equals(_value, other._value, StringComparison.InvariantCultureIgnoreCase);

        /// <inheritdoc />
        [EditorBrowsable(EditorBrowsableState.Never)]
        public override int GetHashCode() => _value != null ? StringComparer.InvariantCultureIgnoreCase.GetHashCode(_value) : 0;
        /// <inheritdoc />
        public override string ToString() => _value;
    }
}
