// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.

// <auto-generated/>

#nullable disable

using System.Text.Json;
using System.Threading;
using System.Threading.Tasks;
using Azure.Core;

namespace Azure.ResourceManager.DeviceProvisioningServices
{
    internal class DeviceProvisioningServicesPrivateEndpointConnectionOperationSource : IOperationSource<DeviceProvisioningServicesPrivateEndpointConnectionResource>
    {
        private readonly ArmClient _client;

        internal DeviceProvisioningServicesPrivateEndpointConnectionOperationSource(ArmClient client)
        {
            _client = client;
        }

        DeviceProvisioningServicesPrivateEndpointConnectionResource IOperationSource<DeviceProvisioningServicesPrivateEndpointConnectionResource>.CreateResult(Response response, CancellationToken cancellationToken)
        {
            using var document = JsonDocument.Parse(response.ContentStream);
            var data = DeviceProvisioningServicesPrivateEndpointConnectionData.DeserializeDeviceProvisioningServicesPrivateEndpointConnectionData(document.RootElement);
            return new DeviceProvisioningServicesPrivateEndpointConnectionResource(_client, data);
        }

        async ValueTask<DeviceProvisioningServicesPrivateEndpointConnectionResource> IOperationSource<DeviceProvisioningServicesPrivateEndpointConnectionResource>.CreateResultAsync(Response response, CancellationToken cancellationToken)
        {
            using var document = await JsonDocument.ParseAsync(response.ContentStream, default, cancellationToken).ConfigureAwait(false);
            var data = DeviceProvisioningServicesPrivateEndpointConnectionData.DeserializeDeviceProvisioningServicesPrivateEndpointConnectionData(document.RootElement);
            return new DeviceProvisioningServicesPrivateEndpointConnectionResource(_client, data);
        }
    }
}
