// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.

// <auto-generated/>

#nullable disable

using System.Text.Json;
using System.Threading;
using System.Threading.Tasks;
using Azure.Core;

namespace Azure.ResourceManager.DeviceProvisioningServices
{
    internal class DeviceProvisioningServiceOperationSource : IOperationSource<DeviceProvisioningServiceResource>
    {
        private readonly ArmClient _client;

        internal DeviceProvisioningServiceOperationSource(ArmClient client)
        {
            _client = client;
        }

        DeviceProvisioningServiceResource IOperationSource<DeviceProvisioningServiceResource>.CreateResult(Response response, CancellationToken cancellationToken)
        {
            using var document = JsonDocument.Parse(response.ContentStream);
            var data = DeviceProvisioningServiceData.DeserializeDeviceProvisioningServiceData(document.RootElement);
            return new DeviceProvisioningServiceResource(_client, data);
        }

        async ValueTask<DeviceProvisioningServiceResource> IOperationSource<DeviceProvisioningServiceResource>.CreateResultAsync(Response response, CancellationToken cancellationToken)
        {
            using var document = await JsonDocument.ParseAsync(response.ContentStream, default, cancellationToken).ConfigureAwait(false);
            var data = DeviceProvisioningServiceData.DeserializeDeviceProvisioningServiceData(document.RootElement);
            return new DeviceProvisioningServiceResource(_client, data);
        }
    }
}
