// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.

// <auto-generated/>

#nullable disable

using System;
using System.ComponentModel;

namespace Azure.ResourceManager.DevCenter.Models
{
    /// <summary> Stop on disconnect enable or disable status. Indicates whether stop on disconnect to is either enabled or disabled. </summary>
    public readonly partial struct StopOnDisconnectEnableStatus : IEquatable<StopOnDisconnectEnableStatus>
    {
        private readonly string _value;

        /// <summary> Initializes a new instance of <see cref="StopOnDisconnectEnableStatus"/>. </summary>
        /// <exception cref="ArgumentNullException"> <paramref name="value"/> is null. </exception>
        public StopOnDisconnectEnableStatus(string value)
        {
            _value = value ?? throw new ArgumentNullException(nameof(value));
        }

        private const string IsEnabledValue = "Enabled";
        private const string IsDisabledValue = "Disabled";

        /// <summary> Enabled. </summary>
        public static StopOnDisconnectEnableStatus IsEnabled { get; } = new StopOnDisconnectEnableStatus(IsEnabledValue);
        /// <summary> Disabled. </summary>
        public static StopOnDisconnectEnableStatus IsDisabled { get; } = new StopOnDisconnectEnableStatus(IsDisabledValue);
        /// <summary> Determines if two <see cref="StopOnDisconnectEnableStatus"/> values are the same. </summary>
        public static bool operator ==(StopOnDisconnectEnableStatus left, StopOnDisconnectEnableStatus right) => left.Equals(right);
        /// <summary> Determines if two <see cref="StopOnDisconnectEnableStatus"/> values are not the same. </summary>
        public static bool operator !=(StopOnDisconnectEnableStatus left, StopOnDisconnectEnableStatus right) => !left.Equals(right);
        /// <summary> Converts a <see cref="string"/> to a <see cref="StopOnDisconnectEnableStatus"/>. </summary>
        public static implicit operator StopOnDisconnectEnableStatus(string value) => new StopOnDisconnectEnableStatus(value);

        /// <inheritdoc />
        [EditorBrowsable(EditorBrowsableState.Never)]
        public override bool Equals(object obj) => obj is StopOnDisconnectEnableStatus other && Equals(other);
        /// <inheritdoc />
        public bool Equals(StopOnDisconnectEnableStatus other) => string.Equals(_value, other._value, StringComparison.InvariantCultureIgnoreCase);

        /// <inheritdoc />
        [EditorBrowsable(EditorBrowsableState.Never)]
        public override int GetHashCode() => _value != null ? StringComparer.InvariantCultureIgnoreCase.GetHashCode(_value) : 0;
        /// <inheritdoc />
        public override string ToString() => _value;
    }
}
