// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.

// <auto-generated/>

#nullable disable

using System;
using System.Collections.Generic;

namespace Azure.ResourceManager.DevCenter.Models
{
    /// <summary> Properties for a recommended machine configuration. </summary>
    public partial class RecommendedMachineConfiguration
    {
        /// <summary>
        /// Keeps track of any properties unknown to the library.
        /// <para>
        /// To assign an object to the value of this property use <see cref="BinaryData.FromObjectAsJson{T}(T, System.Text.Json.JsonSerializerOptions?)"/>.
        /// </para>
        /// <para>
        /// To assign an already formatted json string to this property use <see cref="BinaryData.FromString(string)"/>.
        /// </para>
        /// <para>
        /// Examples:
        /// <list type="bullet">
        /// <item>
        /// <term>BinaryData.FromObjectAsJson("foo")</term>
        /// <description>Creates a payload of "foo".</description>
        /// </item>
        /// <item>
        /// <term>BinaryData.FromString("\"foo\"")</term>
        /// <description>Creates a payload of "foo".</description>
        /// </item>
        /// <item>
        /// <term>BinaryData.FromObjectAsJson(new { key = "value" })</term>
        /// <description>Creates a payload of { "key": "value" }.</description>
        /// </item>
        /// <item>
        /// <term>BinaryData.FromString("{\"key\": \"value\"}")</term>
        /// <description>Creates a payload of { "key": "value" }.</description>
        /// </item>
        /// </list>
        /// </para>
        /// </summary>
        private IDictionary<string, BinaryData> _serializedAdditionalRawData;

        /// <summary> Initializes a new instance of <see cref="RecommendedMachineConfiguration"/>. </summary>
        internal RecommendedMachineConfiguration()
        {
        }

        /// <summary> Initializes a new instance of <see cref="RecommendedMachineConfiguration"/>. </summary>
        /// <param name="memory"> Recommended memory range. </param>
        /// <param name="vCpus"> Recommended vCPU range. </param>
        /// <param name="serializedAdditionalRawData"> Keeps track of any properties unknown to the library. </param>
        internal RecommendedMachineConfiguration(DevCenterResourceRange memory, DevCenterResourceRange vCpus, IDictionary<string, BinaryData> serializedAdditionalRawData)
        {
            Memory = memory;
            VCpus = vCpus;
            _serializedAdditionalRawData = serializedAdditionalRawData;
        }

        /// <summary> Recommended memory range. </summary>
        public DevCenterResourceRange Memory { get; }
        /// <summary> Recommended vCPU range. </summary>
        public DevCenterResourceRange VCpus { get; }
    }
}
