// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.

// <auto-generated/>

#nullable disable

using System;
using System.ComponentModel;

namespace Azure.ResourceManager.DevCenter.Models
{
    /// <summary> The LocalAdminStatus. </summary>
    public readonly partial struct LocalAdminStatus : IEquatable<LocalAdminStatus>
    {
        private readonly string _value;

        /// <summary> Initializes a new instance of <see cref="LocalAdminStatus"/>. </summary>
        /// <exception cref="ArgumentNullException"> <paramref name="value"/> is null. </exception>
        public LocalAdminStatus(string value)
        {
            _value = value ?? throw new ArgumentNullException(nameof(value));
        }

        private const string IsDisabledValue = "Disabled";
        private const string IsEnabledValue = "Enabled";

        /// <summary> Disabled. </summary>
        public static LocalAdminStatus IsDisabled { get; } = new LocalAdminStatus(IsDisabledValue);
        /// <summary> Enabled. </summary>
        public static LocalAdminStatus IsEnabled { get; } = new LocalAdminStatus(IsEnabledValue);
        /// <summary> Determines if two <see cref="LocalAdminStatus"/> values are the same. </summary>
        public static bool operator ==(LocalAdminStatus left, LocalAdminStatus right) => left.Equals(right);
        /// <summary> Determines if two <see cref="LocalAdminStatus"/> values are not the same. </summary>
        public static bool operator !=(LocalAdminStatus left, LocalAdminStatus right) => !left.Equals(right);
        /// <summary> Converts a <see cref="string"/> to a <see cref="LocalAdminStatus"/>. </summary>
        public static implicit operator LocalAdminStatus(string value) => new LocalAdminStatus(value);

        /// <inheritdoc />
        [EditorBrowsable(EditorBrowsableState.Never)]
        public override bool Equals(object obj) => obj is LocalAdminStatus other && Equals(other);
        /// <inheritdoc />
        public bool Equals(LocalAdminStatus other) => string.Equals(_value, other._value, StringComparison.InvariantCultureIgnoreCase);

        /// <inheritdoc />
        [EditorBrowsable(EditorBrowsableState.Never)]
        public override int GetHashCode() => _value != null ? StringComparer.InvariantCultureIgnoreCase.GetHashCode(_value) : 0;
        /// <inheritdoc />
        public override string ToString() => _value;
    }
}
