// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.

// <auto-generated/>

#nullable disable

using System;
using System.ComponentModel;

namespace Azure.ResourceManager.DevCenter.Models
{
    /// <summary> Image validation status. </summary>
    public readonly partial struct ImageValidationStatus : IEquatable<ImageValidationStatus>
    {
        private readonly string _value;

        /// <summary> Initializes a new instance of <see cref="ImageValidationStatus"/>. </summary>
        /// <exception cref="ArgumentNullException"> <paramref name="value"/> is null. </exception>
        public ImageValidationStatus(string value)
        {
            _value = value ?? throw new ArgumentNullException(nameof(value));
        }

        private const string UnknownValue = "Unknown";
        private const string PendingValue = "Pending";
        private const string SucceededValue = "Succeeded";
        private const string FailedValue = "Failed";
        private const string TimedOutValue = "TimedOut";

        /// <summary> Unknown. </summary>
        public static ImageValidationStatus Unknown { get; } = new ImageValidationStatus(UnknownValue);
        /// <summary> Pending. </summary>
        public static ImageValidationStatus Pending { get; } = new ImageValidationStatus(PendingValue);
        /// <summary> Succeeded. </summary>
        public static ImageValidationStatus Succeeded { get; } = new ImageValidationStatus(SucceededValue);
        /// <summary> Failed. </summary>
        public static ImageValidationStatus Failed { get; } = new ImageValidationStatus(FailedValue);
        /// <summary> TimedOut. </summary>
        public static ImageValidationStatus TimedOut { get; } = new ImageValidationStatus(TimedOutValue);
        /// <summary> Determines if two <see cref="ImageValidationStatus"/> values are the same. </summary>
        public static bool operator ==(ImageValidationStatus left, ImageValidationStatus right) => left.Equals(right);
        /// <summary> Determines if two <see cref="ImageValidationStatus"/> values are not the same. </summary>
        public static bool operator !=(ImageValidationStatus left, ImageValidationStatus right) => !left.Equals(right);
        /// <summary> Converts a <see cref="string"/> to a <see cref="ImageValidationStatus"/>. </summary>
        public static implicit operator ImageValidationStatus(string value) => new ImageValidationStatus(value);

        /// <inheritdoc />
        [EditorBrowsable(EditorBrowsableState.Never)]
        public override bool Equals(object obj) => obj is ImageValidationStatus other && Equals(other);
        /// <inheritdoc />
        public bool Equals(ImageValidationStatus other) => string.Equals(_value, other._value, StringComparison.InvariantCultureIgnoreCase);

        /// <inheritdoc />
        [EditorBrowsable(EditorBrowsableState.Never)]
        public override int GetHashCode() => _value != null ? StringComparer.InvariantCultureIgnoreCase.GetHashCode(_value) : 0;
        /// <inheritdoc />
        public override string ToString() => _value;
    }
}
